/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.gradle.service.project;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.externalSystem.model.ExternalSystemException;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.util.text.StringUtil;
import java.io.FileNotFoundException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.net.ConnectException;
import java.net.UnknownHostException;
import org.gradle.cli.CommandLineArgumentException;
import org.gradle.tooling.UnsupportedVersionException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.gradle.service.execution.GradleExecutionErrorHandler;
import org.jetbrains.plugins.gradle.service.project.AbstractProjectImportErrorHandler;

public class BaseProjectImportErrorHandler
extends AbstractProjectImportErrorHandler {
    private static final Logger LOG = Logger.getInstance(BaseProjectImportErrorHandler.class);

    @Override
    @NotNull
    public ExternalSystemException getUserFriendlyError(@NotNull Throwable error, @NotNull String projectPath, @Nullable String buildFilePath) {
        String errMessage;
        Throwable errorCause;
        String msg;
        if (error == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "error", "org/jetbrains/plugins/gradle/service/project/BaseProjectImportErrorHandler", "getUserFriendlyError"));
        }
        if (projectPath == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "projectPath", "org/jetbrains/plugins/gradle/service/project/BaseProjectImportErrorHandler", "getUserFriendlyError"));
        }
        GradleExecutionErrorHandler executionErrorHandler = new GradleExecutionErrorHandler(error, projectPath, buildFilePath);
        ExternalSystemException friendlyError = executionErrorHandler.getUserFriendlyError();
        if (friendlyError != null) {
            ExternalSystemException externalSystemException = friendlyError;
            if (externalSystemException == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/gradle/service/project/BaseProjectImportErrorHandler", "getUserFriendlyError"));
            }
            return externalSystemException;
        }
        LOG.info(String.format("Failed to import Gradle project at '%1$s'", projectPath), error);
        if (error instanceof ProcessCanceledException) {
            ExternalSystemException externalSystemException = new ExternalSystemException("Project import was cancelled");
            if (externalSystemException == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/gradle/service/project/BaseProjectImportErrorHandler", "getUserFriendlyError"));
            }
            return externalSystemException;
        }
        Throwable rootCause = executionErrorHandler.getRootCause();
        String location = executionErrorHandler.getLocation();
        if (location == null && !StringUtil.isEmpty((String)buildFilePath)) {
            location = String.format("Build file: '%1$s'", buildFilePath);
        }
        if (rootCause instanceof UnsupportedVersionException) {
            String msg2 = "You are using unsupported version of Gradle.";
            msg2 = msg2 + "\nPlease point to a supported Gradle version in the project's Gradle settings or in the project's Gradle wrapper (if applicable.)";
            ExternalSystemException externalSystemException = this.createUserFriendlyError(msg2, null, new String[0]);
            if (externalSystemException == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/gradle/service/project/BaseProjectImportErrorHandler", "getUserFriendlyError"));
            }
            return externalSystemException;
        }
        String rootCauseMessage = rootCause.getMessage();
        if (rootCause.getClass().getName().equals(CommandLineArgumentException.class.getName()) && StringUtil.contains((CharSequence)rootCauseMessage, (CharSequence)"Unknown command-line option '--include-build'")) {
            String msg3 = String.format("Gradle composite build support available for Gradle 3.1 or better version (<a href=\"%s\">Fix Gradle settings</a>)", "open_gradle_settings");
            ExternalSystemException externalSystemException = this.createUserFriendlyError(msg3, location, "open_gradle_settings");
            if (externalSystemException == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/gradle/service/project/BaseProjectImportErrorHandler", "getUserFriendlyError"));
            }
            return externalSystemException;
        }
        String rootCauseText = rootCause.toString();
        if (StringUtil.startsWith((CharSequence)rootCauseText, (CharSequence)"org.gradle.api.internal.MissingMethodException")) {
            String method = this.parseMissingMethod(rootCauseText);
            String msg4 = "Build script error, unsupported Gradle DSL method found: '" + method + "'!";
            msg4 = msg4 + "\n\nPossible causes could be:  ";
            msg4 = msg4 + String.format("%s  - you are using Gradle version where the method is absent (<a href=\"%s\">Fix Gradle settings</a>)", Character.valueOf('\n'), "open_gradle_settings");
            msg4 = msg4 + String.format("%s  - you didn't apply Gradle plugin which provides the method (<a href=\"%s\">Apply Gradle plugin</a>)", Character.valueOf('\n'), "apply_gradle_plugin");
            msg4 = msg4 + String.format("%s  - or there is a mistake in a build script (<a href=\"%s\">Goto source</a>)", Character.valueOf('\n'), "goto_source");
            ExternalSystemException externalSystemException = this.createUserFriendlyError(msg4, location, "open_gradle_settings", "apply_gradle_plugin", "goto_source");
            if (externalSystemException == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/gradle/service/project/BaseProjectImportErrorHandler", "getUserFriendlyError"));
            }
            return externalSystemException;
        }
        if (rootCause instanceof OutOfMemoryError) {
            String msg5 = "Out of memory";
            if (rootCauseMessage != null && !rootCauseMessage.isEmpty()) {
                msg5 = msg5 + ": " + rootCauseMessage;
            }
            if (msg5.endsWith("Java heap space")) {
                msg5 = msg5 + ". Configure Gradle memory settings using '-Xmx' JVM option (e.g. '-Xmx2048m'.)";
            } else if (!msg5.endsWith(".")) {
                msg5 = msg5 + ".";
            }
            msg5 = msg5 + "\n\nPlease fix the project's Gradle settings.";
            ExternalSystemException externalSystemException = this.createUserFriendlyError(msg5, null, new String[0]);
            if (externalSystemException == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/gradle/service/project/BaseProjectImportErrorHandler", "getUserFriendlyError"));
            }
            return externalSystemException;
        }
        if (rootCause instanceof ClassNotFoundException) {
            String msg6 = String.format("Unable to load class '%1$s'.", rootCauseMessage) + "\n\n" + "This is an unexpected error. Please file a bug containing the idea.log file.";
            ExternalSystemException externalSystemException = this.createUserFriendlyError(msg6, null, new String[0]);
            if (externalSystemException == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/gradle/service/project/BaseProjectImportErrorHandler", "getUserFriendlyError"));
            }
            return externalSystemException;
        }
        if (rootCause instanceof UnknownHostException) {
            String msg7 = String.format("Unknown host '%1$s'.", rootCauseMessage) + "\n\n" + "Please ensure the host name is correct. " + "If you are behind an HTTP proxy, please configure the proxy settings either in IDE or Gradle.";
            ExternalSystemException externalSystemException = this.createUserFriendlyError(msg7, null, new String[0]);
            if (externalSystemException == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/gradle/service/project/BaseProjectImportErrorHandler", "getUserFriendlyError"));
            }
            return externalSystemException;
        }
        if (rootCause instanceof ConnectException && (msg = rootCauseMessage) != null && msg.contains("timed out")) {
            msg = msg + (msg.endsWith(".") ? " " : ". ");
            msg = msg + "If you are behind an HTTP proxy, please configure the proxy settings either in IDE or Gradle.";
            ExternalSystemException externalSystemException = this.createUserFriendlyError(msg, null, new String[0]);
            if (externalSystemException == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/gradle/service/project/BaseProjectImportErrorHandler", "getUserFriendlyError"));
            }
            return externalSystemException;
        }
        if (rootCause instanceof FileNotFoundException && (errorCause = error.getCause()) instanceof IllegalArgumentException && GradleExecutionErrorHandler.DOWNLOAD_GRADLE_DISTIBUTION_ERROR_PATTERN.matcher(errorCause.getMessage()).matches()) {
            ExternalSystemException externalSystemException = this.createUserFriendlyError(errorCause.getMessage(), null, new String[0]);
            if (externalSystemException == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/gradle/service/project/BaseProjectImportErrorHandler", "getUserFriendlyError"));
            }
            return externalSystemException;
        }
        if (rootCause instanceof RuntimeException && (msg = rootCauseMessage) != null && GradleExecutionErrorHandler.UNSUPPORTED_GRADLE_VERSION_ERROR_PATTERN.matcher(msg).matches()) {
            if (!msg.endsWith(".")) {
                msg = msg + ".";
            }
            msg = msg + "\n\nPlease fix the project's Gradle settings.";
            ExternalSystemException externalSystemException = this.createUserFriendlyError(msg, null, new String[0]);
            if (externalSystemException == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/gradle/service/project/BaseProjectImportErrorHandler", "getUserFriendlyError"));
            }
            return externalSystemException;
        }
        if (rootCauseMessage == null || ApplicationManager.getApplication().isUnitTestMode()) {
            StringWriter writer = new StringWriter();
            if (rootCauseMessage != null) {
                writer.write(rootCauseMessage + "\n");
            }
            rootCause.printStackTrace(new PrintWriter(writer));
            errMessage = writer.toString();
        } else {
            errMessage = rootCauseMessage;
        }
        ExternalSystemException externalSystemException = this.createUserFriendlyError(errMessage, location, new String[0]);
        if (externalSystemException == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/gradle/service/project/BaseProjectImportErrorHandler", "getUserFriendlyError"));
        }
        return externalSystemException;
    }
}

