/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ws.rest.references;

import com.intellij.psi.PsiReferenceContributor;
import com.intellij.psi.PsiReferenceRegistrar;
import com.intellij.ws.references.WSReferenceProvider;
import com.intellij.ws.rest.references.MimeReferenceProvider;
import com.intellij.ws.rest.references.PathParamReferenceProvider;
import com.intellij.ws.rest.references.RestPathReferenceProvider;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class RSReferenceContributor
extends PsiReferenceContributor {
    public static final List<WSReferenceProvider> PROVIDERS = new ArrayList<WSReferenceProvider>();

    public void registerReferenceProviders(@NotNull PsiReferenceRegistrar registrar) {
        if (registrar == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "registrar", "com/intellij/ws/rest/references/RSReferenceContributor", "registerReferenceProviders"));
        }
        for (WSReferenceProvider provider : PROVIDERS) {
            provider.register(registrar);
        }
    }

    static {
        PROVIDERS.add(new PathParamReferenceProvider());
        PROVIDERS.add(new RestPathReferenceProvider());
        PROVIDERS.add(new MimeReferenceProvider());
    }
}

