/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.stylus.formatter;

import com.intellij.formatting.ASTBlock;
import com.intellij.formatting.Block;
import com.intellij.formatting.ChildAttributes;
import com.intellij.formatting.Indent;
import com.intellij.formatting.Spacing;
import com.intellij.lang.ASTNode;
import com.intellij.psi.css.codeStyle.CssCodeStyleSettings;
import com.intellij.psi.css.impl.util.editor.CssFormattingModelBuilder;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.TokenSet;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.stylus.psi.StylusElementTypes;

public class StylusSelectorBlock
extends CssFormattingModelBuilder.CssSelectorBlock {
    private static TokenSet TOKENS_WITH_FLEXIBLE_SPACING = TokenSet.create((IElementType[])new IElementType[]{StylusElementTypes.REFERENCE_EXPRESSION});

    public StylusSelectorBlock(ASTNode _node, CssCodeStyleSettings settings, Indent indent, int maxPropertyLength, CssFormattingModelBuilder.CssFormattingExtension extension) {
        super(_node, settings, indent, maxPropertyLength, extension);
    }

    @NotNull
    public ChildAttributes getChildAttributes(int newChildIndex) {
        Block previousBlock;
        if (newChildIndex > 0 && (previousBlock = (Block)this.mySubBlocks.get(newChildIndex - 1)) instanceof CssFormattingModelBuilder.CssFormatterBlock) {
            ASTNode nextNode = ((CssFormattingModelBuilder.CssFormatterBlock)previousBlock).getNode().getTreeNext();
            boolean processWithIndent = true;
            for (int i = 0; i < 3; ++i) {
                if (nextNode == null) {
                    processWithIndent = false;
                    break;
                }
                if (!nextNode.getText().equals("\n")) {
                    processWithIndent = false;
                }
                nextNode = nextNode.getTreeNext();
            }
            if (processWithIndent) {
                ChildAttributes childAttributes = new ChildAttributes(Indent.getNormalIndent(), null);
                if (childAttributes == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/stylus/formatter/StylusSelectorBlock", "getChildAttributes"));
                }
                return childAttributes;
            }
        }
        ChildAttributes childAttributes = super.getChildAttributes(newChildIndex);
        if (childAttributes == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/stylus/formatter/StylusSelectorBlock", "getChildAttributes"));
        }
        return childAttributes;
    }

    @Nullable
    public Spacing getSpacing(Block child1, @NotNull Block child2) {
        if (child2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "child2", "org/jetbrains/plugins/stylus/formatter/StylusSelectorBlock", "getSpacing"));
        }
        if (StylusSelectorBlock.isBlockWithFlexibleSpacing(child1) || StylusSelectorBlock.isBlockWithFlexibleSpacing(child2)) {
            return Spacing.createSpacing((int)0, (int)1, (int)0, (boolean)false, (int)0);
        }
        return super.getSpacing(child1, child2);
    }

    private static boolean isBlockWithFlexibleSpacing(Block block) {
        if (block instanceof ASTBlock) {
            return TOKENS_WITH_FLEXIBLE_SPACING.contains(((ASTBlock)block).getNode().getElementType());
        }
        return false;
    }
}

