/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.stylus.psi.impl;

import com.intellij.css.util.CssPsiUtil;
import com.intellij.lang.ASTNode;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.TokenType;
import com.intellij.psi.css.CssBlock;
import com.intellij.psi.css.CssDeclaration;
import com.intellij.psi.css.CssElementVisitor;
import com.intellij.psi.css.impl.CssElementTypes;
import com.intellij.psi.impl.source.tree.CompositePsiElement;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.TokenSet;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.IncorrectOperationException;
import java.util.Arrays;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.stylus.psi.StylusElementTypes;
import org.jetbrains.plugins.stylus.psi.StylusTokenTypes;

public class StylusDeclarationBlockImpl
extends CompositePsiElement
implements CssBlock {
    private static final TokenSet DECLARATION_FILTER = TokenSet.create((IElementType[])new IElementType[]{CssElementTypes.CSS_DECLARATION});

    public StylusDeclarationBlockImpl() {
        super(StylusElementTypes.DECLARATION_BLOCK);
    }

    @NotNull
    public CssDeclaration[] getDeclarations() {
        CssDeclaration[] cssDeclarationArray = (CssDeclaration[])this.getChildrenAsPsiElements(DECLARATION_FILTER, CssDeclaration.ARRAY_FACTORY);
        if (cssDeclarationArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/stylus/psi/impl/StylusDeclarationBlockImpl", "getDeclarations"));
        }
        return cssDeclarationArray;
    }

    @Nullable
    public PsiElement getLBrace() {
        ASTNode node;
        PsiElement firstChild = PsiTreeUtil.getDeepestFirst((PsiElement)this);
        if (firstChild instanceof PsiWhiteSpace) {
            firstChild = PsiTreeUtil.nextVisibleLeaf((PsiElement)firstChild);
        }
        if (firstChild != null && (node = firstChild.getNode()) != null && node.getElementType() == CssElementTypes.CSS_LBRACE) {
            return firstChild;
        }
        return null;
    }

    @Nullable
    public PsiElement getRBrace() {
        ASTNode node;
        PsiElement lastChild = PsiTreeUtil.getDeepestLast((PsiElement)this);
        if (lastChild instanceof PsiWhiteSpace) {
            lastChild = PsiTreeUtil.prevVisibleLeaf((PsiElement)lastChild);
        }
        if (lastChild != null && (node = lastChild.getNode()) != null && node.getElementType() == CssElementTypes.CSS_RBRACE) {
            return lastChild;
        }
        return null;
    }

    public boolean isEqualTo(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        StylusDeclarationBlockImpl block = (StylusDeclarationBlockImpl)((Object)o);
        return Arrays.equals(this.getDeclarations(), block.getDeclarations());
    }

    public void accept(@NotNull PsiElementVisitor visitor) {
        if (visitor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "visitor", "org/jetbrains/plugins/stylus/psi/impl/StylusDeclarationBlockImpl", "accept"));
        }
        if (visitor instanceof CssElementVisitor) {
            ((CssElementVisitor)visitor).visitCssBlock((CssBlock)this);
        } else {
            visitor.visitElement((PsiElement)this);
        }
    }

    public CssDeclaration addDeclaration(@NotNull String name, @NotNull String value, @Nullable CssDeclaration anchor) {
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "org/jetbrains/plugins/stylus/psi/impl/StylusDeclarationBlockImpl", "addDeclaration"));
        }
        if (value == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "value", "org/jetbrains/plugins/stylus/psi/impl/StylusDeclarationBlockImpl", "addDeclaration"));
        }
        throw new IncorrectOperationException();
    }

    public void removeDeclaration(@NotNull CssDeclaration declaration) throws IncorrectOperationException {
        if (declaration == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "declaration", "org/jetbrains/plugins/stylus/psi/impl/StylusDeclarationBlockImpl", "removeDeclaration"));
        }
        assert (declaration.getParent() == this);
        PsiElement nextSibling = declaration.getNextSibling();
        if (nextSibling != null && TokenSet.create((IElementType[])new IElementType[]{StylusTokenTypes.EOL, TokenType.WHITE_SPACE}).contains(nextSibling.getNode().getElementType())) {
            nextSibling.delete();
        }
        declaration.delete();
    }

    @Nullable
    public CssDeclaration findDeclaration(@NotNull String propertyName) {
        if (propertyName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "propertyName", "org/jetbrains/plugins/stylus/psi/impl/StylusDeclarationBlockImpl", "findDeclaration"));
        }
        return this.findDeclaration(propertyName, true);
    }

    @Nullable
    public CssDeclaration findDeclaration(@NotNull String propertyName, boolean searchInShorthand) {
        if (propertyName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "propertyName", "org/jetbrains/plugins/stylus/psi/impl/StylusDeclarationBlockImpl", "findDeclaration"));
        }
        return CssPsiUtil.findDeclaration((CssBlock)this, (String)propertyName, (boolean)searchInShorthand);
    }
}

