/*
 * Copyright 2000-2007 JetBrains s.r.o.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package com.intellij.persistence.model.helpers;

import com.intellij.persistence.model.PersistenceListener;
import com.intellij.persistence.model.PersistenceMappings;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiPackage;
import com.intellij.util.xml.GenericValue;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

import java.util.Collection;
import java.util.List;
import java.util.Properties;

/**
 * @author Gregory.Shrago
*/
public interface PersistenceUnitModelHelper extends PersistenceModelHelper {

  GenericValue<Boolean> getExcludeUnlistedClasses();

  @Nullable
  String getPersistenceProviderName();

  @Nullable
  PersistenceMappings getAdditionalMapping();

  @NotNull
  <V extends PersistenceMappings> List<? extends GenericValue<V>> getMappingFiles(final Class<V> mappingsClass);

  @NotNull
  List<? extends PersistenceListener> getPersistentListeners();

  @NotNull
  List<? extends GenericValue<PsiFile>> getJarFiles();

  @NotNull
  List<? extends GenericValue<PsiClass>> getClasses();

  @NotNull
  List<? extends GenericValue<PsiPackage>> getPackages();

  @Nullable
  GenericValue<String> getDataSourceName();

  @NotNull
  Properties getPersistenceUnitProperties();

  Collection<Object> getCacheDependencies();

  @Nullable
  default String getNamingStrategy() {return null;}
}
