/*
 * Copyright 2000-2017 JetBrains s.r.o.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package com.intellij.spring.contexts.model;

import com.intellij.openapi.util.Key;
import com.intellij.psi.xml.XmlFile;
import com.intellij.spring.facet.beans.CustomSetting;
import com.intellij.spring.model.xml.beans.Beans;
import com.intellij.util.xml.DomFileElement;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

import java.util.Set;

/**
 * @author Yann C&eacute;bron
 */
public abstract class LocalXmlModel extends AbstractSimpleLocalModel<XmlFile> {

  /**
   * @since 2017.2
   */
  @SuppressWarnings("deprecation")
  public static final Key<CustomSetting.BOOLEAN> PROCESS_EXPLICITLY_ANNOTATED = Key.create(CustomSetting.PROCESS_EXPLICITLY_ANNOTATED);

  @Nullable
  public abstract DomFileElement<Beans> getRoot();

  public abstract void setActiveProfiles(@NotNull Set<String> activeProfiles);
}