/*
 * Copyright 2000-2017 JetBrains s.r.o.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package com.intellij.spring.settings;

import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.project.Project;
import org.jetbrains.annotations.NotNull;

/**
 * Provides access to Project-level Spring settings.
 *
 * @since 2017.2
 */
public abstract class SpringGeneralSettings {

  public abstract boolean isShowProfilesPanel();

  public abstract void setShowProfilesPanel(boolean showProfilesPanel);

  public abstract boolean isShowMultipleContextsPanel();

  public abstract void setShowMultipleContextsPanel(boolean showMultipleContextsPanel);

  public static SpringGeneralSettings getInstance(@NotNull Project project) {
    return ServiceManager.getService(project, SpringGeneralSettings.class);
  }
}
