/*
 * Copyright 2000-2007 JetBrains s.r.o.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package com.intellij.debugger.engine;

import com.intellij.javaee.deployment.JspDeploymentManager;
import com.intellij.javaee.facet.JavaeeFacet;
import com.intellij.javaee.facet.JavaeeFacetUtil;
import com.intellij.openapi.fileTypes.FileNameMatcher;
import com.intellij.openapi.fileTypes.FileTypeManager;
import com.intellij.openapi.fileTypes.LanguageFileType;
import com.intellij.openapi.fileTypes.StdFileTypes;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiFile;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.Nullable;

/*
 * Copyright 2000-2017 JetBrains s.r.o.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
public abstract class DefaultJSPPositionManager extends JSR45PositionManager<JavaeeFacet[]> {
  private static final @NonNls String JSP_STRATUM = "JSP";

  /**
   * @deprecated
   * Use DefaultJSPPositionManager(DebugProcess debugProcess, WebFacet[] scope) and explicitly specify facets to be used when searching for sources
   */
  public DefaultJSPPositionManager(DebugProcess debugProcess) {
    this(debugProcess, JavaeeFacetUtil.getInstance().getAllJavaeeFacets(debugProcess.getProject()));
  }

  public DefaultJSPPositionManager(DebugProcess debugProcess, JavaeeFacet[] scope) {
    super(debugProcess, scope, JSP_STRATUM, new LanguageFileType[] {StdFileTypes.JSP, StdFileTypes.JSPX}, new SourceFinderAdapter());
  }

  private static final class SourceFinderAdapter implements SourcesFinder<JavaeeFacet[]> {
    private final JspDeploymentManager myJspDeploymentManager;

    public SourceFinderAdapter() {
      myJspDeploymentManager = JspDeploymentManager.getInstance();
    }

    @Nullable
    public PsiFile findSourceFile(String relPath, Project project, JavaeeFacet[] scope) {
      if (isJava(relPath)) {
        // optimization
        return null;
      }
      return myJspDeploymentManager.getDeployedJspSource(relPath, project, scope);
    }

    private boolean isJava(String relPath) {
      for (FileNameMatcher matcher : FileTypeManager.getInstance().getAssociations(StdFileTypes.JAVA)) {
        if (matcher.accept(relPath)) {
          return true;
        }
      }
      return false;
    }
  }

}
