package com.intellij.sql.dialects;

import com.intellij.database.dialects.DatabaseDialect;
import com.intellij.database.model.ObjectKind;
import com.intellij.lang.Language;
import com.intellij.psi.PsiElement;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.TokenSet;
import com.intellij.sql.psi.SqlLanguage;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

import java.util.Collections;
import java.util.Set;

/**
 * @author Gregory.Shrago
 */
public abstract class SqlLanguageDialect extends Language {

  public SqlLanguageDialect(@NonNls @NotNull String id) {
    super(SqlLanguage.INSTANCE, id);
  }

  @NotNull
  public abstract DatabaseDialect getDatabaseDialect();

  public abstract boolean isReservedKeyword(IElementType tokenType);

  public boolean isReservedKeywordPL(IElementType tokenType) {
    return isReservedKeyword(tokenType);
  }

  public abstract boolean isOperatorSupported(IElementType tokenType);

  @NotNull
  public abstract Set<String> getKeywords();

  @NotNull
  public abstract Set<String> getSystemVariables();

  @NotNull
  public Set<String> getExceptionNames() {
    return Collections.emptySet();
  }

  public boolean isResolveTargetAccepted(@NotNull PsiElement element, ObjectKind type, @NotNull Set<ObjectKind> expectedTypes) {
    return false;
  }

  public abstract TokenSet getStatementSeparators();

  @NotNull
  public abstract String asStringLiteral(@NotNull String s);
}
