/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.klint.client.api;

import com.android.SdkConstants;
import com.android.annotations.NonNull;
import com.android.annotations.Nullable;
import com.android.tools.klint.client.api.Configuration;
import com.android.tools.klint.client.api.IssueRegistry;
import com.android.tools.klint.client.api.LintClient;
import com.android.tools.klint.client.api.LintDriver;
import com.android.tools.klint.detector.api.Context;
import com.android.tools.klint.detector.api.Issue;
import com.android.tools.klint.detector.api.Location;
import com.android.tools.klint.detector.api.Project;
import com.android.tools.klint.detector.api.Severity;
import com.android.tools.klint.detector.api.TextFormat;
import com.android.utils.XmlUtils;
import com.google.common.annotations.Beta;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Splitter;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXParseException;

@Beta
public class DefaultConfiguration
extends Configuration {
    private final LintClient mClient;
    public static final String CONFIG_FILE_NAME = "lint.xml";
    @NonNull
    private static final String TAG_ISSUE = "issue";
    @NonNull
    private static final String ATTR_ID = "id";
    @NonNull
    private static final String ATTR_SEVERITY = "severity";
    @NonNull
    private static final String ATTR_PATH = "path";
    @NonNull
    private static final String ATTR_REGEXP = "regexp";
    @NonNull
    private static final String TAG_IGNORE = "ignore";
    @NonNull
    private static final String VALUE_ALL = "all";
    private final Configuration mParent;
    private final Project mProject;
    private final File mConfigFile;
    private boolean mBulkEditing;
    private Map<String, List<String>> mSuppressed;
    @Nullable
    private Map<String, List<Pattern>> mRegexps;
    private Map<String, Severity> mSeverity;

    protected DefaultConfiguration(@NonNull LintClient client, @Nullable Project project, @Nullable Configuration parent, @NonNull File configFile) {
        this.mClient = client;
        this.mProject = project;
        this.mParent = parent;
        this.mConfigFile = configFile;
    }

    protected DefaultConfiguration(@NonNull LintClient client, @NonNull Project project, @Nullable Configuration parent) {
        this(client, project, parent, new File(project.getDir(), CONFIG_FILE_NAME));
    }

    @NonNull
    public static DefaultConfiguration create(@NonNull LintClient client, @NonNull Project project, @Nullable Configuration parent) {
        return new DefaultConfiguration(client, project, parent);
    }

    @NonNull
    public static DefaultConfiguration create(@NonNull LintClient client, @NonNull File lintFile) {
        return new DefaultConfiguration(client, null, null, lintFile);
    }

    @Override
    public boolean isIgnored(@NonNull Context context, @NonNull Issue issue, @Nullable Location location, @NonNull String message) {
        this.ensureInitialized();
        String id = issue.getId();
        List<String> paths = this.mSuppressed.get(id);
        if (paths == null) {
            paths = this.mSuppressed.get(VALUE_ALL);
        }
        if (paths != null && location != null) {
            File file = location.getFile();
            String relativePath = context.getProject().getRelativePath(file);
            for (String suppressedPath : paths) {
                if (suppressedPath.equals(relativePath)) {
                    return true;
                }
                if (!relativePath.startsWith(suppressedPath)) continue;
                return true;
            }
        }
        if (this.mRegexps != null) {
            List<Pattern> regexps = this.mRegexps.get(id);
            if (regexps == null) {
                regexps = this.mRegexps.get(VALUE_ALL);
            }
            if (regexps != null && location != null) {
                Matcher matcher;
                for (Pattern regexp : regexps) {
                    Matcher matcher2 = regexp.matcher(message);
                    if (!matcher2.find()) continue;
                    return true;
                }
                File file = location.getFile();
                String relativePath = context.getProject().getRelativePath(file);
                boolean checkUnixPath = false;
                for (Pattern regexp : regexps) {
                    matcher = regexp.matcher(relativePath);
                    if (matcher.find()) {
                        return true;
                    }
                    if (regexp.pattern().indexOf(47) == -1) continue;
                    checkUnixPath = true;
                }
                if (checkUnixPath && SdkConstants.CURRENT_PLATFORM == 2) {
                    relativePath = relativePath.replace('\\', '/');
                    for (Pattern regexp : regexps) {
                        matcher = regexp.matcher(relativePath);
                        if (!matcher.find()) continue;
                        return true;
                    }
                }
            }
        }
        return this.mParent != null && this.mParent.isIgnored(context, issue, location, message);
    }

    @NonNull
    protected Severity getDefaultSeverity(@NonNull Issue issue) {
        if (!issue.isEnabledByDefault()) {
            return Severity.IGNORE;
        }
        return issue.getDefaultSeverity();
    }

    @Override
    @NonNull
    public Severity getSeverity(@NonNull Issue issue) {
        this.ensureInitialized();
        Severity severity = this.mSeverity.get(issue.getId());
        if (severity == null) {
            severity = this.mSeverity.get(VALUE_ALL);
        }
        if (severity != null) {
            return severity;
        }
        if (this.mParent != null) {
            return this.mParent.getSeverity(issue);
        }
        return this.getDefaultSeverity(issue);
    }

    private void ensureInitialized() {
        if (this.mSuppressed == null) {
            this.readConfig();
        }
    }

    private void formatError(String message, Object ... args) {
        if (args != null && args.length > 0) {
            message = String.format(message, args);
        }
        message = "Failed to parse `lint.xml` configuration file: " + message;
        LintDriver driver = new LintDriver(new IssueRegistry(){

            @Override
            @NonNull
            public List<Issue> getIssues() {
                return Collections.emptyList();
            }
        }, this.mClient);
        this.mClient.report(new Context(driver, this.mProject, this.mProject, this.mConfigFile), IssueRegistry.LINT_ERROR, this.mProject.getConfiguration(driver).getSeverity(IssueRegistry.LINT_ERROR), Location.create(this.mConfigFile), message, TextFormat.RAW);
    }

    private void readConfig() {
        this.mSuppressed = new HashMap<String, List<String>>();
        this.mSeverity = new HashMap<String, Severity>();
        if (!this.mConfigFile.exists()) {
            return;
        }
        try {
            Document document = XmlUtils.parseUtfXmlFile((File)this.mConfigFile, (boolean)false);
            NodeList issues = document.getElementsByTagName(TAG_ISSUE);
            Splitter splitter = Splitter.on((char)',').trimResults().omitEmptyStrings();
            int count = issues.getLength();
            for (int i = 0; i < count; ++i) {
                Node node = issues.item(i);
                Element element = (Element)node;
                String idList = element.getAttribute(ATTR_ID);
                if (idList.isEmpty()) {
                    this.formatError("Invalid lint config file: Missing required issue id attribute", new Object[0]);
                    continue;
                }
                Iterable ids = splitter.split((CharSequence)idList);
                NamedNodeMap attributes = node.getAttributes();
                int n = attributes.getLength();
                block4: for (int j = 0; j < n; ++j) {
                    Node attribute = attributes.item(j);
                    String name = attribute.getNodeName();
                    String value2 = attribute.getNodeValue();
                    if (ATTR_ID.equals(name)) continue;
                    if (ATTR_SEVERITY.equals(name)) {
                        for (Severity severity : Severity.values()) {
                            if (!value2.equalsIgnoreCase(severity.name())) continue;
                            for (String id : ids) {
                                this.mSeverity.put(id, severity);
                            }
                            continue block4;
                        }
                        continue;
                    }
                    this.formatError("Unexpected attribute \"%1$s\"", name);
                }
                NodeList childNodes = element.getChildNodes();
                if (childNodes.getLength() <= 0) continue;
                int n2 = childNodes.getLength();
                for (int j = 0; j < n2; ++j) {
                    String regexp;
                    Node child = childNodes.item(j);
                    if (child.getNodeType() != 1) continue;
                    Element ignore = (Element)child;
                    String path = ignore.getAttribute(ATTR_PATH);
                    if (path.isEmpty()) {
                        regexp = ignore.getAttribute(ATTR_REGEXP);
                        if (regexp.isEmpty()) {
                            this.formatError("Missing required attribute %1$s or %2$s under %3$s", ATTR_PATH, ATTR_REGEXP, idList);
                            continue;
                        }
                        this.addRegexp(idList, ids, n2, regexp, false);
                        continue;
                    }
                    path = File.separatorChar == '/' ? path.replace('\\', '/') : path.replace('/', File.separatorChar);
                    if (path.indexOf(42) != -1) {
                        regexp = DefaultConfiguration.globToRegexp(path);
                        this.addRegexp(idList, ids, n2, regexp, false);
                        continue;
                    }
                    for (String id : ids) {
                        List<String> paths = this.mSuppressed.get(id);
                        if (paths == null) {
                            paths = new ArrayList<String>(n2 / 2 + 1);
                            this.mSuppressed.put(id, paths);
                        }
                        paths.add(path);
                    }
                }
            }
        }
        catch (SAXParseException e) {
            this.formatError(e.getMessage(), new Object[0]);
        }
        catch (Exception e) {
            this.mClient.log(e, null, new Object[0]);
        }
    }

    @NonNull
    public static String globToRegexp(@NonNull String glob) {
        StringBuilder sb = new StringBuilder(glob.length() * 2);
        int begin = 0;
        sb.append('^');
        int n = glob.length();
        for (int i = 0; i < n; ++i) {
            char c = glob.charAt(i);
            if (c == '*') {
                begin = DefaultConfiguration.appendQuoted(sb, glob, begin, i) + 1;
                if (i < n - 1 && glob.charAt(i + 1) == '*') {
                    ++i;
                    ++begin;
                }
                sb.append(".*?");
                continue;
            }
            if (c != '?') continue;
            begin = DefaultConfiguration.appendQuoted(sb, glob, begin, i) + 1;
            sb.append(".?");
        }
        DefaultConfiguration.appendQuoted(sb, glob, begin, glob.length());
        sb.append('$');
        return sb.toString();
    }

    private static int appendQuoted(StringBuilder sb, String s, int from, int to) {
        if (to > from) {
            int i;
            boolean isSimple = true;
            for (i = from; i < to; ++i) {
                char c = s.charAt(i);
                if (Character.isLetterOrDigit(c) || c == '/' || c == ' ') continue;
                isSimple = false;
                break;
            }
            if (isSimple) {
                for (i = from; i < to; ++i) {
                    sb.append(s.charAt(i));
                }
                return to;
            }
            sb.append(Pattern.quote(s.substring(from, to)));
        }
        return to;
    }

    private void addRegexp(@NonNull String idList, @NonNull Iterable<String> ids, int n, @NonNull String regexp, boolean silent) {
        block5: {
            try {
                if (this.mRegexps == null) {
                    this.mRegexps = new HashMap<String, List<Pattern>>();
                }
                Pattern pattern = Pattern.compile(regexp);
                for (String id : ids) {
                    List<Pattern> paths = this.mRegexps.get(id);
                    if (paths == null) {
                        paths = new ArrayList<Pattern>(n / 2 + 1);
                        this.mRegexps.put(id, paths);
                    }
                    paths.add(pattern);
                }
            }
            catch (PatternSyntaxException e) {
                if (silent) break block5;
                this.formatError("Invalid pattern %1$s under %2$s: %3$s", regexp, idList, e.getDescription());
            }
        }
    }

    private void writeConfig() {
        try {
            boolean ok;
            File file = new File(this.mConfigFile.getParentFile(), this.mConfigFile.getName() + ".new");
            BufferedWriter writer = new BufferedWriter(new FileWriter(file));
            writer.write("<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n<lint>\n");
            if (!this.mSuppressed.isEmpty() || !this.mSeverity.isEmpty()) {
                HashSet<String> idSet = new HashSet<String>();
                for (String id : this.mSuppressed.keySet()) {
                    idSet.add(id);
                }
                for (String id : this.mSeverity.keySet()) {
                    idSet.add(id);
                }
                ArrayList ids = new ArrayList(idSet);
                Collections.sort(ids);
                for (String id : ids) {
                    writer.write("    <");
                    writer.write(TAG_ISSUE);
                    DefaultConfiguration.writeAttribute(writer, ATTR_ID, id);
                    Severity severity = this.mSeverity.get(id);
                    if (severity != null) {
                        DefaultConfiguration.writeAttribute(writer, ATTR_SEVERITY, severity.name().toLowerCase(Locale.US));
                    }
                    List<Pattern> regexps = this.mRegexps != null ? this.mRegexps.get(id) : null;
                    List<String> paths = this.mSuppressed.get(id);
                    if (paths != null && !paths.isEmpty() || regexps != null && !regexps.isEmpty()) {
                        ((Writer)writer).write(62);
                        ((Writer)writer).write(10);
                        if (paths != null) {
                            for (String path : paths) {
                                writer.write("        <");
                                writer.write(TAG_IGNORE);
                                DefaultConfiguration.writeAttribute(writer, ATTR_PATH, path.replace('\\', '/'));
                                writer.write(" />\n");
                            }
                        }
                        if (regexps != null) {
                            for (Pattern regexp : regexps) {
                                writer.write("        <");
                                writer.write(TAG_IGNORE);
                                DefaultConfiguration.writeAttribute(writer, ATTR_REGEXP, regexp.pattern());
                                writer.write(" />\n");
                            }
                        }
                        writer.write("    </");
                        writer.write(TAG_ISSUE);
                        ((Writer)writer).write(62);
                        ((Writer)writer).write(10);
                        continue;
                    }
                    writer.write(" />\n");
                }
            }
            writer.write("</lint>");
            ((Writer)writer).close();
            File oldFile = new File(this.mConfigFile.getParentFile(), this.mConfigFile.getName() + '~');
            if (oldFile.exists()) {
                oldFile.delete();
            }
            if (this.mConfigFile.exists()) {
                this.mConfigFile.renameTo(oldFile);
            }
            if ((ok = file.renameTo(this.mConfigFile)) && oldFile.exists()) {
                oldFile.delete();
            }
        }
        catch (Exception e) {
            this.mClient.log(e, null, new Object[0]);
        }
    }

    private static void writeAttribute(@NonNull Writer writer, @NonNull String name, @NonNull String value2) throws IOException {
        writer.write(32);
        writer.write(name);
        writer.write(61);
        writer.write(34);
        writer.write(value2);
        writer.write(34);
    }

    @Override
    public void ignore(@NonNull Context context, @NonNull Issue issue, @Nullable Location location, @NonNull String message) {
        if (location != null) {
            this.ignore(issue, location.getFile());
        }
    }

    public void ignore(@NonNull Issue issue, @NonNull File file) {
        this.ensureInitialized();
        String path = this.mProject != null ? this.mProject.getRelativePath(file) : file.getPath();
        List<String> paths = this.mSuppressed.get(issue.getId());
        if (paths == null) {
            paths = new ArrayList<String>();
            this.mSuppressed.put(issue.getId(), paths);
        }
        paths.add(path);
        Collections.sort(paths);
        if (!this.mBulkEditing) {
            this.writeConfig();
        }
    }

    @Override
    public void setSeverity(@NonNull Issue issue, @Nullable Severity severity) {
        this.ensureInitialized();
        String id = issue.getId();
        if (severity == null) {
            this.mSeverity.remove(id);
        } else {
            this.mSeverity.put(id, severity);
        }
        if (!this.mBulkEditing) {
            this.writeConfig();
        }
    }

    @Override
    public void startBulkEditing() {
        this.mBulkEditing = true;
    }

    @Override
    public void finishBulkEditing() {
        this.mBulkEditing = false;
        this.writeConfig();
    }

    @VisibleForTesting
    File getConfigFile() {
        return this.mConfigFile;
    }
}

