/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javaee.weblogic.admin;

import com.intellij.javaee.artifact.JavaeeArtifactUtil;
import com.intellij.javaee.deployment.DeploymentModel;
import com.intellij.javaee.deployment.DeploymentStatus;
import com.intellij.javaee.ejb.facet.EjbFacet;
import com.intellij.javaee.model.common.ejb.EntityBean;
import com.intellij.javaee.oss.admin.JavaeeAdminDeployCallback;
import com.intellij.javaee.oss.admin.JavaeeAdminDeployCallbackWrapper;
import com.intellij.javaee.oss.admin.JavaeeAdminStartCallback;
import com.intellij.javaee.oss.admin.JavaeeAgentAdminServerBase;
import com.intellij.javaee.oss.agent.AgentExtension;
import com.intellij.javaee.oss.agent.AgentProxyFactory;
import com.intellij.javaee.oss.agent.ParametersMap;
import com.intellij.javaee.oss.server.JavaeeDeploymentProvider;
import com.intellij.javaee.oss.server.JavaeeServerExtension;
import com.intellij.javaee.run.configuration.CommonModel;
import com.intellij.javaee.util.DeployStateChecker;
import com.intellij.javaee.util.IDeployStateChecker;
import com.intellij.javaee.util.ServerInstancePoller;
import com.intellij.javaee.weblogic.WeblogicBundle;
import com.intellij.javaee.weblogic.actions.WeblogicCreateDatasourceDialog;
import com.intellij.javaee.weblogic.actions.WeblogicMissingDatasourcesDialog;
import com.intellij.javaee.weblogic.agent.WebLogicAgentExtension;
import com.intellij.javaee.weblogic.agent.WebLogicTargetType;
import com.intellij.javaee.weblogic.beaInstallation.WeblogicUtil;
import com.intellij.javaee.weblogic.model.persistence.WeblogicRdbmsBean;
import com.intellij.javaee.weblogic.module.WeblogicEjbFacetUtil;
import com.intellij.javaee.weblogic.runDebug.configuration.WeblogicModel;
import com.intellij.javaee.weblogic.runDebug.deployment.WLDeploymentModel;
import com.intellij.javaee.weblogic.runDebug.deployment.WeblogicDeploymentProvider;
import com.intellij.javaee.weblogic.runDebug.weblogicServerInstances.AutoDeployUtil;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.packaging.artifacts.Artifact;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class WebLogicAdminServerBase
extends JavaeeAgentAdminServerBase {
    private static final Logger LOG = Logger.getInstance(WebLogicAdminServerBase.class);
    private final WeblogicModel myWeblogicModel;
    private final boolean myLocal;
    private ServerInstancePoller myPoller = new ServerInstancePoller();

    protected WebLogicAdminServerBase(AgentProxyFactory agentProxyFactory, List<File> instanceLibraries, WeblogicModel weblogicModel, boolean local, String specificsRuntimeModuleName, String specificsBuildJarPath, String agentClassName) throws Exception {
        super(agentProxyFactory, instanceLibraries, Collections.singletonList(WebLogicTargetType.class), specificsRuntimeModuleName, specificsBuildJarPath, agentClassName);
        this.myWeblogicModel = weblogicModel;
        this.myLocal = local;
    }

    public JavaeeServerExtension getExtension() {
        return new JavaeeServerExtension(){

            public AgentExtension getAgentExtension() {
                return WebLogicAdminServerBase.this.getAgentExtension();
            }
        };
    }

    protected final boolean isLocal() {
        return this.myLocal;
    }

    @NotNull
    protected String getDeploymentName(DeploymentModel deployment, File source) throws Exception {
        String string = ((WLDeploymentModel)deployment).getDeploymentMethod().createDeploymentName(deployment, source);
        if (string == null) {
            WebLogicAdminServerBase.$$$reportNull$$$0(0);
        }
        return string;
    }

    public void start(String host, int port, String username, String password, JavaeeAdminStartCallback callback) throws Exception {
        super.start(this.myWeblogicModel.getAdminServerHost(), this.myWeblogicModel.getAdminServerPort(), username, password, callback);
        this.myPoller.onInstanceStart();
    }

    public void shutdown() {
        if (this.myPoller != null) {
            this.myPoller.onInstanceShutdown();
        }
        super.shutdown();
    }

    public void startDeploy(final DeploymentModel deployment, final File source, final JavaeeAdminDeployCallback callback) {
        DeploymentJob deploymentJob = new DeploymentJob(){

            @Override
            protected void doAgent() {
                WebLogicAdminServerBase.super.startDeploy(deployment, source, callback);
            }

            @Override
            protected void doAuto() {
                try {
                    WebLogicAdminServerBase.this.myPoller.removeDeployStateChecker((Object)deployment);
                    AutoDeployUtil.autoDeploy(deployment.getCommonModel(), source);
                    WebLogicAdminServerBase.this.myPoller.putDeployStateChecker((IDeployStateChecker)new AutoDeployStateChecker(deployment, source, callback){

                        @Override
                        @Nullable
                        protected DeploymentStatus doCheck(DeploymentStatus status) {
                            return status == DeploymentStatus.DEPLOYED || status == DeploymentStatus.FAILED ? status : null;
                        }
                    });
                }
                catch (IOException e) {
                    callback.setDeploymentStatus(deployment, DeploymentStatus.FAILED, (Exception)e);
                }
            }
        };
        if (((WLDeploymentModel)deployment).CHECK_EJB_CMP_DATASOURCES && !this.checkAndConfigureDatasources(deployment, deploymentJob)) {
            return;
        }
        deploymentJob.perform(deployment);
    }

    public void startUndeploy(final DeploymentModel deployment, final File source, final JavaeeAdminDeployCallback callback) {
        new DeploymentJob(){

            @Override
            protected void doAgent() {
                WebLogicAdminServerBase.super.startUndeploy(deployment, source, callback);
            }

            @Override
            protected void doAuto() {
                AutoDeployUtil.autoUndeploy(deployment.getCommonModel(), source);
                WebLogicAdminServerBase.this.myPoller.putDeployStateChecker((IDeployStateChecker)new AutoDeployStateChecker(deployment, source, callback){

                    @Override
                    @Nullable
                    protected DeploymentStatus doCheck(DeploymentStatus status) {
                        return status == DeploymentStatus.DEPLOYED ? null : (status == DeploymentStatus.NOT_DEPLOYED ? DeploymentStatus.NOT_DEPLOYED : DeploymentStatus.UNKNOWN);
                    }
                });
            }
        }.perform(deployment);
    }

    protected void setupInitParameters(ParametersMap initParameters) {
        String adminServerName;
        initParameters.put((Object)"target.type", (Object)this.myWeblogicModel.getTargetType().name());
        String serverName = this.myWeblogicModel.SERVER_NAME;
        if (this.isLocal() && !this.myWeblogicModel.CONNECT_TO_MANAGED_SERVER && !StringUtil.equals((CharSequence)(adminServerName = this.myWeblogicModel.getAdminServerConfiguration().getName()), (CharSequence)serverName)) {
            serverName = adminServerName;
        }
        initParameters.put((Object)"server.name", (Object)serverName);
        initParameters.put((Object)"cluster.name", (Object)this.myWeblogicModel.CLUSTER_NAME);
        initParameters.put((Object)"domain.name", (Object)this.myWeblogicModel.DOMAIN_NAME);
        initParameters.put((Object)"major.version", (Object)String.valueOf(this.myWeblogicModel.getParsedVersion().getMajor()));
        initParameters.put((Object)"is.local", (Object)Boolean.toString(this.isLocal()));
        initParameters.put((Object)"test.domain.only", (Object)Boolean.toString(this.myWeblogicModel.isTestDomainOnly()));
    }

    protected void setupDeployParameters(DeploymentModel deployment, File source, ParametersMap deployParameters) throws Exception {
    }

    @Nullable
    protected WebLogicAgentExtension getWebLogicAgentExtension() {
        JavaeeServerExtension serverExtension = this.myWeblogicModel.getExtensionForDataSourceImport();
        return serverExtension == null ? null : (WebLogicAgentExtension)serverExtension.getAgentExtension();
    }

    private boolean checkAndConfigureDatasources(DeploymentModel model, DeploymentJob deploymentJob) {
        if (!this.myWeblogicModel.isDatasourcesImportSupported()) {
            return true;
        }
        Project project = model.getCommonModel().getProject();
        Artifact artifact = model.getArtifact();
        if (artifact == null) {
            return true;
        }
        ArrayList ejbFacets = new ArrayList(JavaeeArtifactUtil.getInstance().getFacetsIncludedInArtifact(project, artifact, EjbFacet.ID));
        if (ejbFacets.isEmpty()) {
            return true;
        }
        ArrayList<EntityBean> missingDatasourceEjbs = new ArrayList<EntityBean>();
        ArrayList<EjbFacet> ejbFacetsAffected = new ArrayList<EjbFacet>();
        for (EjbFacet ejbFacet : ejbFacets) {
            for (EntityBean ejb : ejbFacet.getMergedRoot().getEnterpriseBeans().getEntities()) {
                String dataSourceName;
                WeblogicRdbmsBean rdbmsBean = WeblogicUtil.findRdbmsBean(WeblogicEjbFacetUtil.getRdbmsRoot(ejbFacet), (String)ejb.getEjbName().getValue());
                if (rdbmsBean == null || StringUtil.isEmpty((String)(dataSourceName = (String)rdbmsBean.getDataSourceName().getValue())) || this.isDatasourceConfigured(dataSourceName)) continue;
                missingDatasourceEjbs.add(ejb);
                ejbFacetsAffected.add(ejbFacet);
            }
        }
        if (missingDatasourceEjbs.size() != 0) {
            ApplicationManager.getApplication().invokeLater(() -> {
                WeblogicMissingDatasourcesDialog dialog = new WeblogicMissingDatasourcesDialog(project, missingDatasourceEjbs, this.getWebLogicAgentExtension(), ejbFacetsAffected){

                    @Override
                    protected WeblogicCreateDatasourceDialog createDataSourceDialog(Project project1, String dsName) {
                        return WebLogicAdminServerBase.this.createDataSourceDialog(project1, dsName);
                    }
                };
                if (dialog.showAndGet()) {
                    deploymentJob.perform(model);
                }
            });
            return false;
        }
        return true;
    }

    private boolean isDatasourceConfigured(String dataSourceName) {
        WebLogicAgentExtension agentExtension = this.getWebLogicAgentExtension();
        if (agentExtension != null) {
            String[] dataSourceNames;
            for (String name : dataSourceNames = agentExtension.getConfiguredDataSourceNames()) {
                if (!Comparing.strEqual((String)name, (String)dataSourceName)) continue;
                return true;
            }
        }
        return false;
    }

    public void updateChangedFiles(List<String> changedFilesPaths) {
        String stagingDir;
        WebLogicAgentExtension agentExtension = this.getWebLogicAgentExtension();
        if (agentExtension != null && (stagingDir = agentExtension.getStagingDir()) != null) {
            CommonModel commonModel = this.myWeblogicModel.getCommonModel();
            for (Artifact artifact : commonModel.getDeployedArtifacts()) {
                DeploymentModel deploymentModel;
                String outputPath = artifact.getOutputPath();
                if (JavaeeArtifactUtil.getInstance().isArchive(artifact.getArtifactType()) || outputPath == null || (deploymentModel = commonModel.getDeploymentModel(artifact)) == null || deploymentModel.getDeploymentMethod() == WeblogicDeploymentProvider.AUTODEPLOY) continue;
                String appName = JavaeeDeploymentProvider.getDefaultDeploymentNameWithMinuses((DeploymentModel)deploymentModel);
                File appDirectory = new File(stagingDir, appName);
                String artifactOutputPath = FileUtil.toSystemDependentName((String)outputPath);
                if (!appDirectory.exists() || !appDirectory.isDirectory()) continue;
                for (String path : changedFilesPaths) {
                    try {
                        if (!FileUtil.startsWith((String)path, (String)artifactOutputPath)) continue;
                        String relativePath = FileUtil.getRelativePath((String)artifactOutputPath, (String)path, (char)File.separatorChar);
                        FileUtil.copy((File)new File(path), (File)new File(appDirectory.getAbsolutePath() + File.separator + appName + File.separator + relativePath));
                    }
                    catch (IOException e) {
                        LOG.info((Throwable)e);
                    }
                }
            }
        }
    }

    protected abstract WeblogicCreateDatasourceDialog createDataSourceDialog(Project var1, String var2);

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/javaee/weblogic/admin/WebLogicAdminServerBase", "getDeploymentName"));
    }

    private abstract class DeploymentJob {
        private DeploymentJob() {
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public void perform(DeploymentModel deployment) {
            if (deployment.getDeploymentMethod() == WeblogicDeploymentProvider.AUTODEPLOY) {
                if (!WebLogicAdminServerBase.this.isLocal()) throw new IllegalArgumentException(WeblogicBundle.message("exception.text.remote.auto.deploy.not.supported", new Object[0]));
                this.doAuto();
                return;
            } else {
                this.doAgent();
            }
        }

        protected abstract void doAgent();

        protected abstract void doAuto();
    }

    private abstract class AutoDeployStateChecker
    implements DeployStateChecker {
        private final DeploymentModel myModel;
        private final File mySource;
        private final JavaeeAdminDeployCallback myCallback;
        private boolean myUpdating;

        public AutoDeployStateChecker(DeploymentModel model, File source, JavaeeAdminDeployCallback callback) {
            this.myModel = model;
            this.mySource = source;
            this.myCallback = callback;
            this.myUpdating = false;
        }

        public DeploymentModel getDeploymentModel() {
            return this.myModel;
        }

        public boolean check() {
            if (!this.myUpdating) {
                WebLogicAdminServerBase.this.startUpdateDeploymentStatus(this.myModel, this.mySource, (JavaeeAdminDeployCallback)new JavaeeAdminDeployCallbackWrapper(this.myCallback){

                    protected boolean checkStatus(DeploymentModel deployment, DeploymentStatus status) {
                        boolean statusResult = AutoDeployStateChecker.this.doCheck(status) != null;
                        AutoDeployStateChecker.this.myUpdating = statusResult;
                        return statusResult;
                    }
                });
            }
            return false;
        }

        @Nullable
        protected abstract DeploymentStatus doCheck(DeploymentStatus var1);
    }
}

