/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.maven.wizards;

import com.intellij.ide.util.projectWizard.NamePathComponent;
import com.intellij.ide.util.projectWizard.WizardContext;
import com.intellij.openapi.options.Configurable;
import com.intellij.openapi.options.ConfigurationException;
import com.intellij.openapi.options.ShowSettingsUtil;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.projectImport.ProjectImportWizardStep;
import com.intellij.util.ui.JBUI;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JPanel;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.idea.maven.project.MavenEnvironmentForm;
import org.jetbrains.idea.maven.project.MavenGeneralSettings;
import org.jetbrains.idea.maven.project.MavenImportingSettings;
import org.jetbrains.idea.maven.project.MavenImportingSettingsForm;
import org.jetbrains.idea.maven.project.ProjectBundle;
import org.jetbrains.idea.maven.wizards.MavenProjectBuilder;

public class MavenProjectImportStep
extends ProjectImportWizardStep {
    private final JPanel myPanel;
    private final NamePathComponent myRootPathComponent;
    private final MavenImportingSettingsForm myImportingSettingsForm;

    public MavenProjectImportStep(WizardContext wizardContext) {
        super(wizardContext);
        this.myImportingSettingsForm = new MavenImportingSettingsForm(true, wizardContext.isCreatingNewProject()){

            @Override
            public String getDefaultModuleDir() {
                return MavenProjectImportStep.this.myRootPathComponent.getPath();
            }
        };
        this.myRootPathComponent = new NamePathComponent("", ProjectBundle.message("maven.import.label.select.root", new Object[0]), ProjectBundle.message("maven.import.title.select.root", new Object[0]), "", false, false);
        JButton envSettingsButton = new JButton(ProjectBundle.message("maven.import.environment.settings", new Object[0]));
        envSettingsButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ShowSettingsUtil.getInstance().editConfigurable((Component)MavenProjectImportStep.this.myPanel, (Configurable)new MavenEnvironmentConfigurable());
            }
        });
        this.myPanel = new JPanel(new GridBagLayout());
        this.myPanel.setBorder(BorderFactory.createEtchedBorder());
        GridBagConstraints c = new GridBagConstraints();
        c.gridx = 0;
        c.gridy = 0;
        c.weightx = 1.0;
        c.fill = 2;
        c.insets = JBUI.insets((int)4, (int)4, (int)0, (int)4);
        this.myPanel.add((Component)this.myRootPathComponent, c);
        c.gridy = 1;
        c.insets = JBUI.insets((int)4, (int)4, (int)0, (int)4);
        this.myPanel.add((Component)this.myImportingSettingsForm.createComponent(), c);
        c.gridy = 2;
        c.fill = 0;
        c.anchor = 12;
        c.weighty = 1.0;
        c.insets = JBUI.insets((int)(4 + envSettingsButton.getPreferredSize().height), (int)4, (int)4, (int)4);
        this.myPanel.add((Component)envSettingsButton, c);
        this.myRootPathComponent.setNameComponentVisible(false);
    }

    public JComponent getComponent() {
        return this.myPanel;
    }

    public void updateDataModel() {
        MavenImportingSettings settings = this.getImportingSettings();
        this.myImportingSettingsForm.getData(settings);
        if (this.getWizardContext().isCreatingNewProject()) {
            this.myImportingSettingsForm.updateData(this.getWizardContext());
        }
        this.suggestProjectNameAndPath(settings.getDedicatedModuleDir(), this.myRootPathComponent.getPath());
    }

    public boolean validate() throws ConfigurationException {
        this.updateDataModel();
        return this.getBuilder().setRootDirectory(this.getWizardContext().getProject(), this.myRootPathComponent.getPath());
    }

    public void updateStep() {
        if (!this.myRootPathComponent.isPathChangedByUser()) {
            VirtualFile rootDirectory = this.getBuilder().getRootDirectory();
            String path = rootDirectory != null ? rootDirectory.getPath() : this.getWizardContext().getProjectFileDirectory();
            this.myRootPathComponent.setPath(FileUtil.toSystemDependentName((String)path));
            this.myRootPathComponent.getPathComponent().selectAll();
        }
        this.myImportingSettingsForm.setData(this.getImportingSettings(), null);
    }

    public JComponent getPreferredFocusedComponent() {
        return this.myRootPathComponent.getPathComponent();
    }

    public MavenProjectBuilder getBuilder() {
        return (MavenProjectBuilder)super.getBuilder();
    }

    private MavenGeneralSettings getGeneralSettings() {
        return this.getBuilder().getGeneralSettings();
    }

    private MavenImportingSettings getImportingSettings() {
        return this.getBuilder().getImportingSettings();
    }

    @NonNls
    public String getHelpId() {
        return "reference.dialogs.new.project.import.maven.page1";
    }

    class MavenEnvironmentConfigurable
    implements Configurable {
        MavenEnvironmentForm myForm = new MavenEnvironmentForm();

        MavenEnvironmentConfigurable() {
        }

        @Nls
        public String getDisplayName() {
            return ProjectBundle.message("maven.import.environment.settings.title", new Object[0]);
        }

        @Nullable
        @NonNls
        public String getHelpTopic() {
            return null;
        }

        public JComponent createComponent() {
            return this.myForm.createComponent();
        }

        public boolean isModified() {
            return this.myForm.isModified(MavenProjectImportStep.this.getGeneralSettings());
        }

        public void apply() throws ConfigurationException {
            this.myForm.setData(MavenProjectImportStep.this.getGeneralSettings());
        }

        public void reset() {
            this.myForm.getData(MavenProjectImportStep.this.getGeneralSettings());
        }

        public void disposeUIResources() {
        }
    }
}

