/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.editors.hierarchyview.ui;

import com.android.tools.idea.editors.hierarchyview.model.ViewNode;
import com.android.tools.idea.editors.hierarchyview.model.ViewProperty;
import com.google.common.collect.Lists;
import java.util.List;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.TableModel;
import org.jetbrains.annotations.NotNull;

public class ViewNodeTableModel
implements TableModel {
    private final List<TableModelListener> mListeners = Lists.newArrayList();
    private final List<ViewProperty> mEntries = Lists.newArrayList();

    public void setNode(@NotNull ViewNode node) {
        if (node == null) {
            ViewNodeTableModel.$$$reportNull$$$0(0);
        }
        this.mEntries.clear();
        this.mEntries.addAll(node.properties);
        this.notifyChange(new TableModelEvent(this));
    }

    @Override
    public int getRowCount() {
        return this.mEntries.size();
    }

    @Override
    public int getColumnCount() {
        return 2;
    }

    @Override
    public String getColumnName(int columnIndex) {
        return columnIndex == 0 ? "Property" : "Value";
    }

    @Override
    public Class<?> getColumnClass(int columnIndex) {
        return String.class;
    }

    @Override
    public boolean isCellEditable(int rowIndex, int columnIndex) {
        return false;
    }

    @Override
    public Object getValueAt(int rowIndex, int columnIndex) {
        ViewProperty p = this.mEntries.get(rowIndex);
        return columnIndex == 0 ? p.name : p.getValue();
    }

    @Override
    public void setValueAt(Object aValue, int rowIndex, int columnIndex) {
    }

    @Override
    public void addTableModelListener(TableModelListener l) {
        this.mListeners.add(l);
    }

    @Override
    public void removeTableModelListener(TableModelListener l) {
        this.mListeners.remove(l);
    }

    private void notifyChange(TableModelEvent event) {
        for (TableModelListener l : this.mListeners) {
            l.tableChanged(event);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "node", "com/android/tools/idea/editors/hierarchyview/ui/ViewNodeTableModel", "setNode"));
    }
}

