/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.model.java;

import com.intellij.openapi.util.io.FileUtil;
import java.io.File;
import java.io.Serializable;
import org.gradle.tooling.model.GradleModuleVersion;
import org.gradle.tooling.model.idea.IdeaDependencyScope;
import org.gradle.tooling.model.idea.IdeaSingleEntryLibraryDependency;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JarLibraryDependency
implements Serializable {
    private static final long serialVersionUID = 1L;
    @NotNull
    @NonNls
    private static final String UNRESOLVED_DEPENDENCY_PREFIX = "unresolved dependency - ";
    @NotNull
    private final String myName;
    @Nullable
    private final File myBinaryPath;
    @Nullable
    private final File mySourcePath;
    @Nullable
    private final File myJavadocPath;
    @Nullable
    private final String myScope;
    @Nullable
    private final GradleModuleVersion myModuleVersion;
    private final boolean myResolved;

    @Nullable
    public static JarLibraryDependency copy(@NotNull IdeaSingleEntryLibraryDependency original) {
        File binaryPath;
        if (original == null) {
            JarLibraryDependency.$$$reportNull$$$0(0);
        }
        if ((binaryPath = original.getFile()) != null) {
            String name;
            boolean resolved;
            String scope = null;
            IdeaDependencyScope originalScope = original.getScope();
            if (originalScope != null) {
                scope = originalScope.getScope();
            }
            if (resolved = JarLibraryDependency.isResolved(original)) {
                name = binaryPath.isFile() ? FileUtil.getNameWithoutExtension((File)binaryPath) : FileUtil.sanitizeFileName((String)binaryPath.getPath());
            } else {
                name = JarLibraryDependency.getUnresolvedDependencyName(original);
                if (name == null) {
                    return null;
                }
            }
            return new JarLibraryDependency(name, binaryPath, original.getSource(), original.getJavadoc(), scope, original.getGradleModuleVersion(), resolved);
        }
        return null;
    }

    private static boolean isResolved(@NotNull IdeaSingleEntryLibraryDependency dependency) {
        String libraryName;
        if (dependency == null) {
            JarLibraryDependency.$$$reportNull$$$0(1);
        }
        return (libraryName = JarLibraryDependency.getFileName(dependency)) != null && !libraryName.startsWith(UNRESOLVED_DEPENDENCY_PREFIX);
    }

    @Nullable
    private static String getUnresolvedDependencyName(@NotNull IdeaSingleEntryLibraryDependency dependency) {
        String libraryName;
        if (dependency == null) {
            JarLibraryDependency.$$$reportNull$$$0(2);
        }
        if ((libraryName = JarLibraryDependency.getFileName(dependency)) == null) {
            return null;
        }
        return libraryName.substring(UNRESOLVED_DEPENDENCY_PREFIX.length()).replace(' ', ':');
    }

    @Nullable
    private static String getFileName(@NotNull IdeaSingleEntryLibraryDependency dependency) {
        File binaryPath;
        if (dependency == null) {
            JarLibraryDependency.$$$reportNull$$$0(3);
        }
        return (binaryPath = dependency.getFile()) != null ? binaryPath.getName() : null;
    }

    public JarLibraryDependency(@NotNull String name, @Nullable File binaryPath, @Nullable File sourcePath, @Nullable File javadocPath, @Nullable String scope, @Nullable GradleModuleVersion moduleVersion, boolean resolved) {
        if (name == null) {
            JarLibraryDependency.$$$reportNull$$$0(4);
        }
        this.myName = name;
        this.myBinaryPath = binaryPath;
        this.mySourcePath = sourcePath;
        this.myJavadocPath = javadocPath;
        this.myScope = scope;
        this.myModuleVersion = moduleVersion;
        this.myResolved = resolved;
    }

    @NotNull
    public String getName() {
        String string = this.myName;
        if (string == null) {
            JarLibraryDependency.$$$reportNull$$$0(5);
        }
        return string;
    }

    @Nullable
    public File getBinaryPath() {
        return this.myBinaryPath;
    }

    @Nullable
    public File getSourcePath() {
        return this.mySourcePath;
    }

    @Nullable
    public File getJavadocPath() {
        return this.myJavadocPath;
    }

    @Nullable
    public String getScope() {
        return this.myScope;
    }

    @Nullable
    public GradleModuleVersion getModuleVersion() {
        return this.myModuleVersion;
    }

    public boolean isResolved() {
        return this.myResolved;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 5: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 5: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "original";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dependency";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/android/tools/idea/gradle/model/java/JarLibraryDependency";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/android/tools/idea/gradle/model/java/JarLibraryDependency";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "copy";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "isResolved";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "getUnresolvedDependencyName";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "getFileName";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 5: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 5: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

