/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.project.sync.hyperlink;

import com.android.tools.idea.gradle.dsl.model.GradleBuildModel;
import com.android.tools.idea.gradle.dsl.model.android.AndroidModel;
import com.android.tools.idea.gradle.project.sync.GradleSyncInvoker;
import com.android.tools.idea.gradle.project.sync.hyperlink.NotificationHyperlink;
import com.intellij.openapi.command.WriteCommandAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import org.jetbrains.annotations.NotNull;

public class FixBuildToolsVersionHyperlink
extends NotificationHyperlink {
    @NotNull
    private final VirtualFile myBuildFile;
    @NotNull
    private final String myVersion;

    public FixBuildToolsVersionHyperlink(@NotNull VirtualFile buildFile, @NotNull String version) {
        if (buildFile == null) {
            FixBuildToolsVersionHyperlink.$$$reportNull$$$0(0);
        }
        if (version == null) {
            FixBuildToolsVersionHyperlink.$$$reportNull$$$0(1);
        }
        super("fix.build.tools.version", "Update Build Tools version and sync project");
        this.myBuildFile = buildFile;
        this.myVersion = version;
    }

    @Override
    protected void execute(@NotNull Project project) {
        if (project == null) {
            FixBuildToolsVersionHyperlink.$$$reportNull$$$0(2);
        }
        FixBuildToolsVersionHyperlink.setBuildToolsVersion(project, this.myBuildFile, this.myVersion, true);
    }

    static void setBuildToolsVersion(@NotNull Project project, @NotNull VirtualFile buildFile, @NotNull String version, boolean requestSync) {
        GradleBuildModel buildModel;
        AndroidModel android;
        if (project == null) {
            FixBuildToolsVersionHyperlink.$$$reportNull$$$0(3);
        }
        if (buildFile == null) {
            FixBuildToolsVersionHyperlink.$$$reportNull$$$0(4);
        }
        if (version == null) {
            FixBuildToolsVersionHyperlink.$$$reportNull$$$0(5);
        }
        if ((android = (buildModel = GradleBuildModel.parseBuildFile(buildFile, project)).android()) == null) {
            return;
        }
        if (version.equals(android.buildToolsVersion())) {
            return;
        }
        android.setBuildToolsVersion(version);
        WriteCommandAction.runWriteCommandAction((Project)project, buildModel::applyChanges);
        if (requestSync) {
            GradleSyncInvoker.getInstance().requestProjectSyncAndSourceGeneration(project, null);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "buildFile";
                break;
            }
            case 1: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "version";
                break;
            }
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
        }
        objectArray2[1] = "com/android/tools/idea/gradle/project/sync/hyperlink/FixBuildToolsVersionHyperlink";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "execute";
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "setBuildToolsVersion";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

