/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.structure.configurables.ui.treeview;

import com.android.tools.idea.gradle.structure.configurables.ui.treeview.AbstractBaseTreeStructure;
import com.android.tools.idea.gradle.structure.configurables.ui.treeview.AbstractPsNode;
import com.google.common.collect.Lists;
import com.intellij.ide.util.treeView.AbstractTreeBuilder;
import com.intellij.ide.util.treeView.AbstractTreeStructure;
import com.intellij.ide.util.treeView.IndexComparator;
import com.intellij.ide.util.treeView.NodeDescriptor;
import com.intellij.ui.treeStructure.SimpleNode;
import com.intellij.util.ui.tree.TreeUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import javax.swing.JTree;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreePath;
import org.jetbrains.annotations.NotNull;

public abstract class AbstractBaseTreeBuilder
extends AbstractTreeBuilder {
    private static final TreePath[] EMPTY_TREE_PATH = new TreePath[0];

    public AbstractBaseTreeBuilder(@NotNull JTree tree, @NotNull DefaultTreeModel treeModel, @NotNull AbstractBaseTreeStructure treeStructure) {
        if (tree == null) {
            AbstractBaseTreeBuilder.$$$reportNull$$$0(0);
        }
        if (treeModel == null) {
            AbstractBaseTreeBuilder.$$$reportNull$$$0(1);
        }
        if (treeStructure == null) {
            AbstractBaseTreeBuilder.$$$reportNull$$$0(2);
        }
        super(tree, treeModel, (AbstractTreeStructure)treeStructure, (Comparator)IndexComparator.INSTANCE);
    }

    public boolean isToEnsureSelectionOnFocusGained() {
        return false;
    }

    protected boolean isAutoExpandNode(NodeDescriptor nodeDescriptor) {
        if (nodeDescriptor instanceof AbstractPsNode) {
            return ((AbstractPsNode)nodeDescriptor).isAutoExpandNode();
        }
        return super.isAutoExpandNode(nodeDescriptor);
    }

    protected boolean isSmartExpand() {
        return true;
    }

    public void expandAllNodes() {
        JTree tree = this.getTree();
        if (tree != null) {
            this.clearSelection();
            TreeUtil.expandAll((JTree)tree);
            this.onAllNodesExpanded();
        }
    }

    protected void onAllNodesExpanded() {
    }

    public void collapseAllNodes() {
        JTree tree = this.getTree();
        if (tree != null) {
            TreeUtil.collapseAll((JTree)tree, (int)1);
            AbstractBaseTreeBuilder.clearSelection(tree);
        }
    }

    public void clearSelection() {
        JTree tree = this.getTree();
        if (tree != null) {
            AbstractBaseTreeBuilder.clearSelection(tree);
        }
    }

    public void expandParents(@NotNull List<? extends SimpleNode> nodes) {
        if (nodes == null) {
            AbstractBaseTreeBuilder.$$$reportNull$$$0(3);
        }
        ArrayList toExpand = Lists.newArrayList();
        for (SimpleNode simpleNode : nodes) {
            SimpleNode parent = simpleNode.getParent();
            if (parent == null) continue;
            toExpand.add(parent);
        }
        this.expand(toExpand.toArray(), null);
    }

    public void scrollToFirstSelectedRow() {
        int[] selectionRows;
        JTree tree = this.getTree();
        if (tree != null && (selectionRows = tree.getSelectionRows()) != null && selectionRows.length > 0) {
            if (selectionRows.length > 1) {
                Arrays.sort(selectionRows);
            }
            int firstRow = selectionRows[0];
            TreeUtil.showRowCentered((JTree)tree, (int)firstRow, (boolean)false, (boolean)true);
        }
    }

    private static void clearSelection(@NotNull JTree tree) {
        if (tree == null) {
            AbstractBaseTreeBuilder.$$$reportNull$$$0(4);
        }
        tree.setSelectionPaths(EMPTY_TREE_PATH);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "tree";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "treeModel";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "treeStructure";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "nodes";
                break;
            }
        }
        objectArray2[1] = "com/android/tools/idea/gradle/structure/configurables/ui/treeview/AbstractBaseTreeBuilder";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "expandParents";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "clearSelection";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

