/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.npw.deprecated;

import com.android.builder.model.SourceProvider;
import com.android.tools.idea.npw.ActivityGalleryStep;
import com.android.tools.idea.npw.AddAndroidActivityPath;
import com.android.tools.idea.npw.ConfigureFormFactorStep;
import com.android.tools.idea.npw.FormFactor;
import com.android.tools.idea.npw.FormFactorUtils;
import com.android.tools.idea.npw.TemplateEntry;
import com.android.tools.idea.npw.TemplateParameterStep2;
import com.android.tools.idea.npw.deprecated.ConfigureAndroidModuleStepDynamic;
import com.android.tools.idea.npw.instantapp.ConfigureInstantModuleStep;
import com.android.tools.idea.templates.Parameter;
import com.android.tools.idea.templates.Template;
import com.android.tools.idea.templates.TemplateManager;
import com.android.tools.idea.templates.TemplateMetadata;
import com.android.tools.idea.templates.TemplateUtils;
import com.android.tools.idea.templates.recipe.RenderingContext;
import com.android.tools.idea.wizard.WizardConstants;
import com.android.tools.idea.wizard.dynamic.DynamicWizardPath;
import com.android.tools.idea.wizard.dynamic.ScopedStateStore;
import com.android.tools.idea.wizard.template.TemplateWizard;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jetbrains.android.sdk.AndroidSdkUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class NewFormFactorModulePath
extends DynamicWizardPath {
    private static final String WH_SDK_ENV_VAR = "WH_SDK";
    private static final Logger LOG = Logger.getInstance(NewFormFactorModulePath.class);
    private static final ScopedStateStore.Key<Boolean> CREATE_ACTIVITY_KEY = ScopedStateStore.createKey("createActivity", ScopedStateStore.Scope.PATH, Boolean.class);
    private static final ScopedStateStore.Key<String> MODULE_LOCATION_KEY = ScopedStateStore.createKey("projectOut", ScopedStateStore.Scope.PATH, String.class);
    private static final ScopedStateStore.Key<String> RES_DIR_KEY = ScopedStateStore.createKey("resDir", ScopedStateStore.Scope.PATH, String.class);
    private static final ScopedStateStore.Key<String> SRC_DIR_KEY = ScopedStateStore.createKey("srcDir", ScopedStateStore.Scope.PATH, String.class);
    private static final ScopedStateStore.Key<String> AIDL_DIR_KEY = ScopedStateStore.createKey("aidlDir", ScopedStateStore.Scope.PATH, String.class);
    private static final ScopedStateStore.Key<String> MANIFEST_DIR_KEY = ScopedStateStore.createKey("manifestDir", ScopedStateStore.Scope.PATH, String.class);
    private static final ScopedStateStore.Key<String> TEST_DIR_KEY = ScopedStateStore.createKey("testDir", ScopedStateStore.Scope.PATH, String.class);
    private static final ScopedStateStore.Key<String> RES_OUT_KEY = ScopedStateStore.createKey("resOut", ScopedStateStore.Scope.PATH, String.class);
    private static final ScopedStateStore.Key<String> SRC_OUT_KEY = ScopedStateStore.createKey("srcOut", ScopedStateStore.Scope.PATH, String.class);
    private static final ScopedStateStore.Key<String> AIDL_OUT_KEY = ScopedStateStore.createKey("aidlOut", ScopedStateStore.Scope.PATH, String.class);
    private static final ScopedStateStore.Key<String> MANIFEST_OUT_KEY = ScopedStateStore.createKey("manifestOut", ScopedStateStore.Scope.PATH, String.class);
    private static final ScopedStateStore.Key<String> TEST_OUT_KEY = ScopedStateStore.createKey("testOut", ScopedStateStore.Scope.PATH, String.class);
    private static final String RELATIVE_SRC_ROOT = FileUtil.join((String[])new String[]{TemplateWizard.MAIN_FLAVOR_SOURCE_PATH, "java"});
    private static final String RELATIVE_TEST_ROOT = FileUtil.join((String[])new String[]{TemplateWizard.TEST_SOURCE_PATH, "java"});
    private final FormFactor myFormFactor;
    private final File myTemplateFile;
    private final Disposable myDisposable;
    private final ScopedStateStore.Key<Boolean> myIsIncludedKey;
    private final ScopedStateStore.Key<String> myModuleNameKey;
    private TemplateParameterStep2 myParameterStep;
    private String myDefaultModuleName;
    private boolean myGradleSyncIfNecessary;

    public static List<NewFormFactorModulePath> getAvailableFormFactorModulePaths(@NotNull Disposable disposable) {
        if (disposable == null) {
            NewFormFactorModulePath.$$$reportNull$$$0(0);
        }
        TemplateManager manager = TemplateManager.getInstance();
        List<File> applicationTemplates = manager.getTemplatesInCategory("Application");
        ArrayList toReturn = Lists.newArrayList();
        for (File templateFile : applicationTemplates) {
            FormFactor formFactor;
            TemplateMetadata metadata = manager.getTemplateMetadata(templateFile);
            if (metadata == null || metadata.getFormFactor() == null || (formFactor = FormFactor.get(metadata.getFormFactor())) == FormFactor.GLASS && !AndroidSdkUtils.isGlassInstalled()) continue;
            NewFormFactorModulePath path = new NewFormFactorModulePath(formFactor, templateFile, disposable);
            toReturn.add(path);
        }
        Collections.sort(toReturn, (p1, p2) -> p1.myFormFactor.compareTo(p2.myFormFactor));
        return toReturn;
    }

    public NewFormFactorModulePath(@NotNull FormFactor formFactor, @NotNull File templateFile, @NotNull Disposable disposable) {
        if (formFactor == null) {
            NewFormFactorModulePath.$$$reportNull$$$0(1);
        }
        if (templateFile == null) {
            NewFormFactorModulePath.$$$reportNull$$$0(2);
        }
        if (disposable == null) {
            NewFormFactorModulePath.$$$reportNull$$$0(3);
        }
        this.myDefaultModuleName = null;
        this.myGradleSyncIfNecessary = true;
        this.myFormFactor = formFactor;
        this.myTemplateFile = templateFile;
        this.myDisposable = disposable;
        this.myIsIncludedKey = FormFactorUtils.getInclusionKey(formFactor);
        this.myModuleNameKey = FormFactorUtils.getModuleNameKey(formFactor);
    }

    @Override
    protected void init() {
        this.myState.put(WizardConstants.IS_LIBRARY_KEY, false);
        this.myState.put(SRC_DIR_KEY, this.calculateSrcDir());
        this.myState.put(RES_DIR_KEY, "src/main/res");
        this.myState.put(AIDL_DIR_KEY, "src/main/aidl");
        this.myState.put(MANIFEST_DIR_KEY, "src/main");
        this.myState.put(TEST_DIR_KEY, "src/androidTest");
        this.myState.put(CREATE_ACTIVITY_KEY, false);
        this.myState.put(WizardConstants.IS_INSTANT_APP_KEY, false);
        String whSdkLocation = System.getenv(WH_SDK_ENV_VAR);
        this.myState.put(WizardConstants.WH_SDK_KEY, whSdkLocation + "/tools/resources/shared-libs");
        this.myState.put(WizardConstants.WH_SDK_ENABLED_KEY, StringUtil.isNotEmpty((String)whSdkLocation));
        this.addStep(new ConfigureAndroidModuleStepDynamic(this.myDisposable, this.myFormFactor));
        this.addStep(new ConfigureInstantModuleStep(this.myDisposable, this.myFormFactor));
        this.addStep(new ActivityGalleryStep(this.myFormFactor, true, AddAndroidActivityPath.KEY_SELECTED_TEMPLATE, null, this.myDisposable));
        String packageName = this.myState.get(WizardConstants.PACKAGE_NAME_KEY);
        if (packageName == null) {
            packageName = "";
        }
        ImmutableMap presetsMap = ImmutableMap.of((Object)WizardConstants.PACKAGE_NAME_KEY.name, (Object)packageName, (Object)"isLauncher", (Object)true, (Object)"parentActivityClass", (Object)"");
        this.myParameterStep = new TemplateParameterStep2(this.myFormFactor, (Map<String, Object>)presetsMap, this.myDisposable, WizardConstants.PACKAGE_NAME_KEY, new SourceProvider[0], "Customize the Activity");
        this.addStep(this.myParameterStep);
    }

    @Override
    public void onPathStarted(boolean fromBeginning) {
        super.onPathStarted(fromBeginning);
        this.updatePackageDerivedValues();
    }

    public void updatePackageDerivedValues() {
        this.myParameterStep.setPresetValue(WizardConstants.PACKAGE_NAME_KEY.name, this.myState.get(WizardConstants.PACKAGE_NAME_KEY));
        HashSet keys = Sets.newHashSetWithExpectedSize((int)5);
        keys.add(WizardConstants.PACKAGE_NAME_KEY);
        keys.add(SRC_DIR_KEY);
        keys.add(TEST_DIR_KEY);
        keys.add(WizardConstants.PROJECT_LOCATION_KEY);
        keys.add(ConfigureFormFactorStep.NUM_ENABLED_FORM_FACTORS_KEY);
        this.deriveValues(keys);
    }

    @NotNull
    private String calculateSrcDir() {
        String packageSegment = this.myState.get(WizardConstants.PACKAGE_NAME_KEY);
        packageSegment = packageSegment == null ? "" : packageSegment.replace('.', File.separatorChar);
        String string = FileUtil.join((String[])new String[]{RELATIVE_SRC_ROOT, packageSegment});
        if (string == null) {
            NewFormFactorModulePath.$$$reportNull$$$0(4);
        }
        return string;
    }

    @NotNull
    private String calculateTestDir() {
        String packageSegment = this.myState.get(WizardConstants.PACKAGE_NAME_KEY);
        packageSegment = packageSegment == null ? "" : packageSegment.replace('.', File.separatorChar);
        String string = FileUtil.join((String[])new String[]{RELATIVE_TEST_ROOT, packageSegment});
        if (string == null) {
            NewFormFactorModulePath.$$$reportNull$$$0(5);
        }
        return string;
    }

    @Override
    public void deriveValues(Set<ScopedStateStore.Key> modified) {
        boolean basePathModified;
        if (modified.contains(ConfigureFormFactorStep.NUM_ENABLED_FORM_FACTORS_KEY)) {
            String moduleName = this.updateDefaultModuleName(this.myState.getNotNull(ConfigureFormFactorStep.NUM_ENABLED_FORM_FACTORS_KEY, 0), this.myState.get(this.myModuleNameKey));
            this.myState.put(this.myModuleNameKey, moduleName);
        }
        boolean bl = basePathModified = modified.contains(WizardConstants.PROJECT_LOCATION_KEY) || modified.contains(this.myModuleNameKey);
        if (basePathModified) {
            this.myState.put(MODULE_LOCATION_KEY, FileUtil.join((String[])new String[]{this.myState.get(WizardConstants.PROJECT_LOCATION_KEY), this.myState.get(this.myModuleNameKey)}));
        }
        if (modified.contains(SRC_DIR_KEY) || modified.contains(WizardConstants.PACKAGE_NAME_KEY)) {
            this.myState.put(SRC_DIR_KEY, this.calculateSrcDir());
        }
        if (modified.contains(TEST_DIR_KEY) || modified.contains(WizardConstants.PACKAGE_NAME_KEY)) {
            this.myState.put(TEST_DIR_KEY, this.calculateTestDir());
        }
        if (modified.contains(SRC_DIR_KEY) || basePathModified) {
            this.updateOutputPath(SRC_DIR_KEY, SRC_OUT_KEY);
        }
        if (modified.contains(RES_DIR_KEY) || basePathModified) {
            this.updateOutputPath(RES_DIR_KEY, RES_OUT_KEY);
        }
        if (modified.contains(AIDL_DIR_KEY) || basePathModified) {
            this.updateOutputPath(AIDL_DIR_KEY, AIDL_OUT_KEY);
        }
        if (modified.contains(MANIFEST_DIR_KEY) || basePathModified) {
            this.updateOutputPath(MANIFEST_DIR_KEY, MANIFEST_OUT_KEY);
        }
        if (modified.contains(TEST_DIR_KEY) || basePathModified) {
            this.updateOutputPath(TEST_DIR_KEY, TEST_OUT_KEY);
        }
        if (this.myState.containsKey(WizardConstants.NEWLY_INSTALLED_API_KEY)) {
            Integer newApiLevel = this.myState.get(WizardConstants.NEWLY_INSTALLED_API_KEY);
            assert (newApiLevel != null);
            ScopedStateStore.Key<Integer> targetApiLevelKey = FormFactorUtils.getTargetApiLevelKey(this.myFormFactor);
            Integer currentTargetLevel = this.myState.get(targetApiLevelKey);
            if (currentTargetLevel == null || newApiLevel > currentTargetLevel) {
                String newApiString = Integer.toString(newApiLevel);
                this.myState.put(targetApiLevelKey, newApiLevel);
                this.myState.put(FormFactorUtils.getTargetApiStringKey(this.myFormFactor), newApiString);
                this.myState.put(FormFactorUtils.getBuildApiLevelKey(this.myFormFactor), newApiLevel);
                this.myState.put(FormFactorUtils.getBuildApiKey(this.myFormFactor), newApiString);
            }
        }
    }

    @NotNull
    private String updateDefaultModuleName(int enabledFormfactorsCount, @Nullable String currentModuleName) {
        if (currentModuleName == null || currentModuleName.equals(this.myDefaultModuleName)) {
            String string = this.myDefaultModuleName = enabledFormfactorsCount == 1 ? "app" : NewFormFactorModulePath.getModuleName(this.myFormFactor);
            if (string == null) {
                NewFormFactorModulePath.$$$reportNull$$$0(6);
            }
            return string;
        }
        String string = currentModuleName;
        if (string == null) {
            NewFormFactorModulePath.$$$reportNull$$$0(7);
        }
        return string;
    }

    private void updateOutputPath(@NotNull ScopedStateStore.Key<String> relativeDirKey, @NotNull ScopedStateStore.Key<String> outputDirKey) {
        if (relativeDirKey == null) {
            NewFormFactorModulePath.$$$reportNull$$$0(8);
        }
        if (outputDirKey == null) {
            NewFormFactorModulePath.$$$reportNull$$$0(9);
        }
        String projectLocation = this.myState.get(WizardConstants.PROJECT_LOCATION_KEY);
        String moduleName = this.myState.get(this.myModuleNameKey);
        String relativeLocation = this.myState.get(relativeDirKey);
        if (relativeLocation == null || projectLocation == null || moduleName == null) {
            return;
        }
        File baseLocation = new File(projectLocation, moduleName);
        relativeLocation = FileUtil.toSystemDependentName((String)relativeLocation);
        this.myState.put(outputDirKey, new File(baseLocation, relativeLocation).getPath());
    }

    @Override
    @NotNull
    public String getPathName() {
        String string = (Object)((Object)this.myFormFactor) + " Module Creation Path";
        if (string == null) {
            NewFormFactorModulePath.$$$reportNull$$$0(10);
        }
        return string;
    }

    @Override
    public boolean isPathVisible() {
        return Boolean.TRUE.equals(this.myState.get(this.myIsIncludedKey));
    }

    @Override
    public boolean canPerformFinishingActions() {
        return this.performFinishingOperation(true);
    }

    @Override
    public boolean performFinishingActions() {
        return this.performFinishingOperation(false);
    }

    @NotNull
    private static String getModuleName(@NotNull FormFactor formFactor) {
        if (formFactor == null) {
            NewFormFactorModulePath.$$$reportNull$$$0(11);
        }
        if (formFactor.baseFormFactor != null) {
            formFactor = formFactor.baseFormFactor;
        }
        String name = formFactor.id.replaceAll("[/\\\\?%*:|\"<>!;]", "");
        name = name.replaceAll("\\s", "_");
        String string = name.toLowerCase();
        if (string == null) {
            NewFormFactorModulePath.$$$reportNull$$$0(12);
        }
        return string;
    }

    private boolean performFinishingOperation(boolean dryRun) {
        String projectLocation;
        ProgressIndicator progress = ProgressManager.getInstance().getProgressIndicator();
        if (progress != null) {
            progress.setText(String.format("Initializing module (%1$s)", new Object[]{this.myFormFactor}));
        }
        if ((projectLocation = this.myState.get(WizardConstants.PROJECT_LOCATION_KEY)) == null) {
            return false;
        }
        String moduleName = this.myState.get(this.myModuleNameKey);
        assert (moduleName != null);
        boolean isInstantApp = this.myState.getNotNull(WizardConstants.IS_INSTANT_APP_KEY, false);
        if (isInstantApp) {
            this.myState.put(WizardConstants.GRADLE_PLUGIN_VERSION_KEY, "2.3.0-dev");
            this.myState.put(WizardConstants.SPLIT_NAME_KEY, moduleName);
        }
        File projectRoot = new File(projectLocation);
        File moduleRoot = new File(projectRoot, moduleName);
        try {
            TemplateUtils.checkedCreateDirectoryIfMissing(moduleRoot);
        }
        catch (IOException e) {
            LOG.error((Throwable)e);
            return false;
        }
        Map<String, Object> moduleTemplateState = FormFactorUtils.scrubFormFactorPrefixes(this.myFormFactor, this.myState.flatten());
        if (isInstantApp && this.myState.getNotNull(WizardConstants.ALSO_CREATE_IAPK_KEY, false).booleanValue()) {
            moduleTemplateState.put("isLibraryProject", true);
            moduleTemplateState.put("isBaseAtom", true);
        }
        if (!this.renderModule(dryRun, moduleTemplateState, projectRoot, moduleRoot)) {
            return false;
        }
        Map<String, Object> activityTemplateState = FormFactorUtils.scrubFormFactorPrefixes(this.myFormFactor, this.myState.flatten());
        if (isInstantApp) {
            activityTemplateState.put("applicationPackage", this.myState.get(WizardConstants.PACKAGE_NAME_KEY) + "." + moduleName);
        }
        if (!this.renderActivity(dryRun, activityTemplateState, projectRoot, moduleRoot)) {
            return false;
        }
        if (isInstantApp && this.myState.getNotNull(WizardConstants.ALSO_CREATE_IAPK_KEY, false).booleanValue()) {
            String iapkName = "instant-" + (this.myState.getNotNull(ConfigureFormFactorStep.NUM_ENABLED_FORM_FACTORS_KEY, 0) == 1 ? "app" : NewFormFactorModulePath.getModuleName(this.myFormFactor));
            Map<String, Object> iapkTemplateState = FormFactorUtils.scrubFormFactorPrefixes(this.myFormFactor, this.myState.flatten());
            iapkTemplateState.put("atomName", moduleName);
            iapkTemplateState.put("projectName", iapkName);
            iapkTemplateState.put("splitName", iapkName);
            File iapkRoot = new File(projectRoot, iapkName);
            try {
                TemplateUtils.checkedCreateDirectoryIfMissing(iapkRoot);
            }
            catch (IOException e) {
                LOG.error((Throwable)e);
                return false;
            }
            iapkTemplateState.put("projectOut", iapkRoot.getPath());
            String relativeLocation = FileUtil.toSystemDependentName((String)this.myState.getNotNull(MANIFEST_DIR_KEY, ""));
            iapkTemplateState.put("manifestOut", new File(iapkRoot, relativeLocation).getPath());
            if (!this.renderModule(dryRun, iapkTemplateState, projectRoot, iapkRoot)) {
                return false;
            }
        }
        return true;
    }

    private boolean renderModule(boolean dryRun, Map<String, Object> templateState, File projectRoot, File moduleRoot) {
        Template template = Template.createFromPath(this.myTemplateFile);
        RenderingContext context = RenderingContext.Builder.newContext(template, this.myWizard.getProject()).withCommandName("New Module").withDryRun(dryRun).withShowErrors(true).withOutputRoot(projectRoot).withModuleRoot(moduleRoot).withParams(templateState).withGradleSync(this.myGradleSyncIfNecessary).intoTargetFiles(this.myState.get(WizardConstants.TARGET_FILES_KEY)).intoOpenFiles((Collection<File>)this.myState.get(WizardConstants.FILES_TO_OPEN_KEY)).intoDependencies(this.myState.get(WizardConstants.DEPENDENCIES_KEY)).build();
        return template.render(context);
    }

    private boolean renderActivity(boolean dryRun, Map<String, Object> templateState, File projectRoot, File moduleRoot) {
        TemplateEntry templateEntry = this.myState.get(AddAndroidActivityPath.KEY_SELECTED_TEMPLATE);
        if (templateEntry == null) {
            return true;
        }
        Template activityTemplate = templateEntry.getTemplate();
        for (Parameter parameter : templateEntry.getMetadata().getParameters()) {
            templateState.put(parameter.id, this.myState.get(this.myParameterStep.getParameterKey(parameter)));
        }
        RenderingContext activityContext = RenderingContext.Builder.newContext(activityTemplate, this.myWizard.getProject()).withCommandName("New Module").withDryRun(dryRun).withShowErrors(true).withOutputRoot(projectRoot).withModuleRoot(moduleRoot).withParams(templateState).withGradleSync(this.myGradleSyncIfNecessary).intoTargetFiles(this.myState.get(WizardConstants.TARGET_FILES_KEY)).intoOpenFiles((Collection<File>)this.myState.get(WizardConstants.FILES_TO_OPEN_KEY)).intoDependencies(this.myState.get(WizardConstants.DEPENDENCIES_KEY)).build();
        return activityTemplate.render(activityContext);
    }

    public void setGradleSyncIfNecessary(boolean value) {
        this.myGradleSyncIfNecessary = value;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 10: 
            case 12: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 10: 
            case 12: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "disposable";
                break;
            }
            case 1: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "formFactor";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "templateFile";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 10: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/android/tools/idea/npw/deprecated/NewFormFactorModulePath";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "relativeDirKey";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "outputDirKey";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/android/tools/idea/npw/deprecated/NewFormFactorModulePath";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "calculateSrcDir";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "calculateTestDir";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "updateDefaultModuleName";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "getPathName";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "getModuleName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getAvailableFormFactorModulePaths";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 10: 
            case 12: {
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "updateOutputPath";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "getModuleName";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 10: 
            case 12: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

