/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.rendering;

import com.android.tools.idea.rendering.AttributeSnapshot;
import com.google.common.base.Charsets;
import com.google.common.collect.Lists;
import com.google.common.hash.HashFunction;
import com.google.common.hash.Hasher;
import com.google.common.hash.Hashing;
import com.intellij.psi.xml.XmlTag;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TagSnapshot {
    @Nullable
    public final String namespace;
    @NotNull
    public final String tagName;
    @Nullable
    public final XmlTag tag;
    @Nullable
    public final String prefix;
    @Nullable
    private TagSnapshot myNext;
    @NotNull
    public List<TagSnapshot> children;
    @NotNull
    public List<AttributeSnapshot> attributes;

    private TagSnapshot(@Nullable XmlTag tag, @Nullable String tagName, @Nullable String prefix, @Nullable String namespace, @NotNull List<AttributeSnapshot> attributes, @NotNull List<TagSnapshot> children) {
        if (attributes == null) {
            TagSnapshot.$$$reportNull$$$0(0);
        }
        if (children == null) {
            TagSnapshot.$$$reportNull$$$0(1);
        }
        this.tagName = tagName != null ? tagName : "?";
        this.prefix = prefix == null || prefix.isEmpty() ? null : prefix;
        this.namespace = namespace;
        this.tag = tag;
        this.attributes = attributes;
        this.children = children;
    }

    public static TagSnapshot createSyntheticTag(@Nullable XmlTag tag, @Nullable String tagName, @Nullable String prefix, @Nullable String namespace, @NotNull List<AttributeSnapshot> attributes, @NotNull List<TagSnapshot> children) {
        if (attributes == null) {
            TagSnapshot.$$$reportNull$$$0(2);
        }
        if (children == null) {
            TagSnapshot.$$$reportNull$$$0(3);
        }
        return new TagSnapshot(tag, tagName, prefix, namespace, attributes, children);
    }

    @NotNull
    public static TagSnapshot createTagSnapshot(@NotNull XmlTag tag) {
        ArrayList children;
        if (tag == null) {
            TagSnapshot.$$$reportNull$$$0(4);
        }
        List<AttributeSnapshot> attributes = AttributeSnapshot.createAttributesForTag(tag);
        XmlTag[] subTags = tag.getSubTags();
        if (subTags.length > 0) {
            TagSnapshot last = null;
            children = Lists.newArrayListWithCapacity((int)subTags.length);
            for (XmlTag subTag : subTags) {
                TagSnapshot child = TagSnapshot.createTagSnapshot(subTag);
                children.add(child);
                if (last != null) {
                    last.myNext = child;
                }
                last = child;
            }
        } else {
            children = Collections.emptyList();
        }
        TagSnapshot tagSnapshot = new TagSnapshot(tag, tag.getName(), tag.getNamespacePrefix(), tag.getNamespace(), attributes, children);
        if (tagSnapshot == null) {
            TagSnapshot.$$$reportNull$$$0(5);
        }
        return tagSnapshot;
    }

    @NotNull
    public static TagSnapshot createTagSnapshotWithoutChildren(@NotNull XmlTag tag) {
        if (tag == null) {
            TagSnapshot.$$$reportNull$$$0(6);
        }
        List<AttributeSnapshot> attributes = AttributeSnapshot.createAttributesForTag(tag);
        List<TagSnapshot> children = Collections.emptyList();
        TagSnapshot tagSnapshot = new TagSnapshot(tag, tag.getName(), tag.getNamespacePrefix(), tag.getNamespace(), attributes, children);
        if (tagSnapshot == null) {
            TagSnapshot.$$$reportNull$$$0(7);
        }
        return tagSnapshot;
    }

    @Nullable
    public String getAttribute(@NotNull String name) {
        if (name == null) {
            TagSnapshot.$$$reportNull$$$0(8);
        }
        return this.getAttribute(name, null);
    }

    @Nullable
    public String getAttribute(@NotNull String name, @Nullable String namespace) {
        if (name == null) {
            TagSnapshot.$$$reportNull$$$0(9);
        }
        int n = this.attributes.size();
        for (int i = 0; i < n; ++i) {
            AttributeSnapshot attribute = this.attributes.get(i);
            if (!name.equals(attribute.name) || namespace != null && !namespace.equals(attribute.namespace)) continue;
            return attribute.value;
        }
        return null;
    }

    public void setAttribute(@NotNull String name, @Nullable String namespace, @Nullable String prefix, @Nullable String value) {
        if (name == null) {
            TagSnapshot.$$$reportNull$$$0(10);
        }
        int n = this.attributes.size();
        for (int i = 0; i < n; ++i) {
            AttributeSnapshot attribute = this.attributes.get(i);
            if (!name.equals(attribute.name) || namespace != null && !namespace.equals(attribute.namespace)) continue;
            this.attributes.remove(i);
            break;
        }
        if (value != null) {
            if (this.attributes.isEmpty()) {
                this.attributes = Lists.newArrayList();
            }
            this.attributes.add(new AttributeSnapshot(namespace, prefix, name, value));
        }
    }

    @Nullable
    public TagSnapshot getNextSibling() {
        return this.myNext;
    }

    public String toString() {
        return "TagSnapshot{" + this.tagName + ", attributes=" + this.attributes + ", children=\n" + this.children + "\n}";
    }

    public long getSignature() {
        HashFunction hashFunction = Hashing.goodFastHash((int)64);
        Hasher hasher = hashFunction.newHasher();
        hasher.putString((CharSequence)this.tagName, Charsets.UTF_8);
        for (AttributeSnapshot attribute : this.attributes) {
            if (attribute.prefix != null) {
                hasher.putString((CharSequence)attribute.prefix, Charsets.UTF_8);
            }
            hasher.putString((CharSequence)attribute.name, Charsets.UTF_8);
            if (attribute.value == null) continue;
            hasher.putString((CharSequence)attribute.value, Charsets.UTF_8);
        }
        return hasher.hash().asLong();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 5: 
            case 7: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 5: 
            case 7: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "attributes";
                break;
            }
            case 1: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "children";
                break;
            }
            case 4: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "tag";
                break;
            }
            case 5: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/android/tools/idea/rendering/TagSnapshot";
                break;
            }
            case 8: 
            case 9: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/android/tools/idea/rendering/TagSnapshot";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "createTagSnapshot";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "createTagSnapshotWithoutChildren";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "createSyntheticTag";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "createTagSnapshot";
                break;
            }
            case 5: 
            case 7: {
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "createTagSnapshotWithoutChildren";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "getAttribute";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "setAttribute";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 5: 
            case 7: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

