/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.res;

import com.android.resources.ResourceFolderType;
import com.android.resources.ResourceType;
import com.android.tools.idea.res.LocalResourceRepository;
import com.android.tools.idea.res.ResourceHelper;
import com.android.utils.SdkUtils;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.ui.InputValidatorEx;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import org.jetbrains.android.util.AndroidResourceUtil;
import org.jetbrains.android.util.AndroidUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ResourceNameValidator
implements InputValidatorEx {
    private static final Logger LOG = Logger.getInstance(ResourceNameValidator.class);
    private Set<String> myExisting;
    private boolean myUnique = true;
    private boolean myExist;
    private boolean myIsFileType;
    private boolean myIsImageType;
    private boolean myAllowXmlExtension;

    private ResourceNameValidator(boolean allowXmlExtension, @Nullable Set<String> existing, boolean isFileType, boolean isImageType) {
        this.myAllowXmlExtension = allowXmlExtension;
        this.myExisting = existing;
        this.myIsFileType = isFileType;
        this.myIsImageType = isImageType;
    }

    public ResourceNameValidator unique() {
        this.myUnique = true;
        this.myExist = false;
        return this;
    }

    public ResourceNameValidator exist() {
        this.myExist = true;
        this.myUnique = false;
        return this;
    }

    @Nullable
    public String getErrorText(String inputString) {
        try {
            if (inputString == null || inputString.trim().length() == 0) {
                return "Enter a new name";
            }
            if (this.myAllowXmlExtension && inputString.endsWith(".xml")) {
                inputString = inputString.substring(0, inputString.length() - ".xml".length());
            }
            if (this.myAllowXmlExtension && this.myIsImageType && SdkUtils.hasImageExtension((String)inputString)) {
                inputString = inputString.substring(0, inputString.lastIndexOf(46));
            }
            if (!this.myIsFileType) {
                inputString = AndroidResourceUtil.getFieldNameByResourceName(inputString);
            }
            if (this.myAllowXmlExtension && inputString.indexOf(46) != -1 && !inputString.endsWith(".xml")) {
                if (this.myIsImageType) {
                    return "The filename must end with .xml or .png";
                }
                return "The filename must end with .xml";
            }
            if (!Character.isJavaIdentifierStart(inputString.charAt(0))) {
                return "The resource name must begin with a character";
            }
            int n = inputString.length();
            for (int i = 1; i < n; ++i) {
                char c = inputString.charAt(i);
                if (Character.isJavaIdentifierPart(c)) continue;
                return String.format("'%1$c' is not a valid resource name character", Character.valueOf(c));
            }
            if (this.myIsFileType) {
                char first = inputString.charAt(0);
                if (first < 'a' || first > 'z') {
                    return "File-based resource names must start with a lowercase letter.";
                }
                int n2 = inputString.length();
                for (int i = 0; i < n2; ++i) {
                    char c = inputString.charAt(i);
                    if (c >= 'a' && c <= 'z' || c >= '0' && c <= '9' || c == '_') continue;
                    return "File-based resource names must contain only lowercase a-z, 0-9, or _.";
                }
            }
            if (!AndroidUtils.isIdentifier(inputString)) {
                return String.format("%1$s is not a valid name (reserved Java keyword)", inputString);
            }
            if (this.myExisting != null && (this.myUnique || this.myExist)) {
                boolean exists = this.myExisting.contains(inputString);
                if (this.myUnique && exists) {
                    return String.format("%1$s already exists", inputString);
                }
                if (this.myExist && !exists) {
                    return String.format("%1$s does not exist", inputString);
                }
            }
            return null;
        }
        catch (Exception e) {
            LOG.error("Validation failed: " + e.toString(), (Throwable)e);
            return "";
        }
    }

    public boolean doesResourceExist(@NotNull String resourceName) {
        if (resourceName == null) {
            ResourceNameValidator.$$$reportNull$$$0(0);
        }
        return this.myExisting != null && this.myExisting.contains(resourceName);
    }

    public static ResourceNameValidator create(boolean allowXmlExtension, @NotNull ResourceFolderType type) {
        if (type == null) {
            ResourceNameValidator.$$$reportNull$$$0(1);
        }
        boolean isFileType = type != ResourceFolderType.VALUES;
        return new ResourceNameValidator(allowXmlExtension, null, isFileType, type == ResourceFolderType.DRAWABLE);
    }

    public static ResourceNameValidator create(boolean allowXmlExtension, @Nullable Set<String> existing, @NotNull ResourceType type) {
        if (type == null) {
            ResourceNameValidator.$$$reportNull$$$0(2);
        }
        boolean isFileType = ResourceHelper.isFileBasedResourceType(type);
        return new ResourceNameValidator(allowXmlExtension, existing, isFileType, type == ResourceType.DRAWABLE).unique();
    }

    public static ResourceNameValidator create(boolean allowXmlExtension, @Nullable LocalResourceRepository appResources, @NotNull ResourceType type) {
        if (type == null) {
            ResourceNameValidator.$$$reportNull$$$0(3);
        }
        return ResourceNameValidator.create(allowXmlExtension, appResources, type, ResourceHelper.isFileBasedResourceType(type));
    }

    public static ResourceNameValidator create(boolean allowXmlExtension, @Nullable LocalResourceRepository appResources, @NotNull ResourceType type, boolean isFileType) {
        if (type == null) {
            ResourceNameValidator.$$$reportNull$$$0(4);
        }
        HashSet<String> existing = null;
        if (appResources != null) {
            existing = new HashSet<String>();
            Collection items = appResources.getItemsOfType(type);
            for (String resourceName : items) {
                existing.add(AndroidResourceUtil.getFieldNameByResourceName(resourceName));
            }
        }
        return new ResourceNameValidator(allowXmlExtension, existing, isFileType, type == ResourceType.DRAWABLE);
    }

    public boolean checkInput(String inputString) {
        return this.getErrorText(inputString) == null;
    }

    public boolean canClose(String inputString) {
        return this.checkInput(inputString);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "resourceName";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
        }
        objectArray2[1] = "com/android/tools/idea/res/ResourceNameValidator";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "doesResourceExist";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "create";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

