/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.run;

import com.android.ddmlib.IDevice;
import com.android.sdklib.internal.avd.AvdInfo;
import com.android.tools.idea.run.AndroidDevice;
import com.android.tools.idea.run.AndroidDeviceComparator;
import com.android.tools.idea.run.ConnectedAndroidDevice;
import com.android.tools.idea.run.DevicePickerEntry;
import com.android.tools.idea.run.LaunchableAndroidDevice;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.swing.AbstractListModel;
import org.jetbrains.annotations.NotNull;

public class DevicePickerListModel
extends AbstractListModel {
    private final List<DevicePickerEntry> myEntries = Lists.newArrayList();
    private boolean myShowSerialNumbers;

    public void reset(@NotNull List<IDevice> connectedDevices, @NotNull List<AvdInfo> avds) {
        if (connectedDevices == null) {
            DevicePickerListModel.$$$reportNull$$$0(0);
        }
        if (avds == null) {
            DevicePickerListModel.$$$reportNull$$$0(1);
        }
        this.clear();
        List<AndroidDevice> connected = DevicePickerListModel.wrapConnectedDevices(connectedDevices, avds);
        this.addEntries(connected, DevicePickerListModel.getLaunchableDevices(avds, DevicePickerListModel.getRunningAvds(connectedDevices)));
        this.myShowSerialNumbers = DevicePickerListModel.shouldShowSerials(connected);
    }

    private static List<AndroidDevice> wrapConnectedDevices(@NotNull List<IDevice> connectedDevices, @NotNull List<AvdInfo> avdInfos) {
        if (connectedDevices == null) {
            DevicePickerListModel.$$$reportNull$$$0(2);
        }
        if (avdInfos == null) {
            DevicePickerListModel.$$$reportNull$$$0(3);
        }
        ArrayList devices = Lists.newArrayList();
        for (IDevice device : connectedDevices) {
            devices.add(new ConnectedAndroidDevice(device, avdInfos));
        }
        return devices;
    }

    @NotNull
    private static List<AndroidDevice> getLaunchableDevices(@NotNull List<AvdInfo> avds, @NotNull Set<String> runningAvds) {
        if (avds == null) {
            DevicePickerListModel.$$$reportNull$$$0(4);
        }
        if (runningAvds == null) {
            DevicePickerListModel.$$$reportNull$$$0(5);
        }
        ArrayList launchable = Lists.newArrayList();
        for (AvdInfo avdInfo : avds) {
            if (runningAvds.contains(avdInfo.getName())) continue;
            launchable.add(new LaunchableAndroidDevice(avdInfo));
        }
        ArrayList arrayList = launchable;
        if (arrayList == null) {
            DevicePickerListModel.$$$reportNull$$$0(6);
        }
        return arrayList;
    }

    private static Set<String> getRunningAvds(@NotNull List<IDevice> connectedDevices) {
        if (connectedDevices == null) {
            DevicePickerListModel.$$$reportNull$$$0(7);
        }
        HashSet runningAvdNames = Sets.newHashSet();
        for (IDevice device : connectedDevices) {
            String avdName;
            if (!device.isEmulator() || (avdName = device.getAvdName()) == null) continue;
            runningAvdNames.add(avdName);
        }
        return runningAvdNames;
    }

    private void addEntries(@NotNull List<AndroidDevice> connected, @NotNull List<AndroidDevice> launchable) {
        int size;
        if (connected == null) {
            DevicePickerListModel.$$$reportNull$$$0(8);
        }
        if (launchable == null) {
            DevicePickerListModel.$$$reportNull$$$0(9);
        }
        AndroidDeviceComparator comparator = new AndroidDeviceComparator();
        Collections.sort(connected, comparator);
        Collections.sort(launchable, comparator);
        this.myEntries.add(DevicePickerEntry.CONNECTED_DEVICES_MARKER);
        if (!connected.isEmpty()) {
            for (AndroidDevice device : connected) {
                this.myEntries.add(DevicePickerEntry.create(device));
            }
        } else {
            this.myEntries.add(DevicePickerEntry.NONE);
        }
        if (!launchable.isEmpty()) {
            this.myEntries.add(DevicePickerEntry.LAUNCHABLE_DEVICES_MARKER);
            for (AndroidDevice device : launchable) {
                this.myEntries.add(DevicePickerEntry.create(device));
            }
        }
        if ((size = this.myEntries.size()) > 0) {
            this.fireIntervalAdded(this, 0, size - 1);
        }
    }

    private void clear() {
        int oldSize = this.getSize();
        this.myEntries.clear();
        if (oldSize > 0) {
            this.fireIntervalRemoved(this, 0, oldSize - 1);
        }
    }

    private static boolean shouldShowSerials(@NotNull List<AndroidDevice> connectedDevices) {
        if (connectedDevices == null) {
            DevicePickerListModel.$$$reportNull$$$0(10);
        }
        HashSet myModelNames = Sets.newHashSet();
        for (AndroidDevice device : connectedDevices) {
            if (device.isVirtual()) continue;
            String name = device.getName();
            if (myModelNames.contains(name)) {
                return true;
            }
            myModelNames.add(name);
        }
        return false;
    }

    @Override
    public int getSize() {
        return this.myEntries.size();
    }

    @Override
    public Object getElementAt(int index) {
        return this.myEntries.get(index);
    }

    @NotNull
    public List<DevicePickerEntry> getItems() {
        List<DevicePickerEntry> list = this.myEntries;
        if (list == null) {
            DevicePickerListModel.$$$reportNull$$$0(11);
        }
        return list;
    }

    public boolean shouldShowSerialNumbers() {
        return this.myShowSerialNumbers;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 6: 
            case 11: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 6: 
            case 11: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "connectedDevices";
                break;
            }
            case 1: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "avds";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "avdInfos";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "runningAvds";
                break;
            }
            case 6: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/android/tools/idea/run/DevicePickerListModel";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "connected";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "launchable";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/android/tools/idea/run/DevicePickerListModel";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getLaunchableDevices";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "getItems";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "reset";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "wrapConnectedDevices";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "getLaunchableDevices";
                break;
            }
            case 6: 
            case 11: {
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "getRunningAvds";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "addEntries";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "shouldShowSerials";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 6: 
            case 11: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

