/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.uibuilder.property;

import com.android.tools.adtui.workbench.ToolContent;
import com.android.tools.idea.uibuilder.api.ViewHandler;
import com.android.tools.idea.uibuilder.model.ModelListener;
import com.android.tools.idea.uibuilder.model.NlComponent;
import com.android.tools.idea.uibuilder.model.NlModel;
import com.android.tools.idea.uibuilder.property.NlProperties;
import com.android.tools.idea.uibuilder.property.NlPropertiesPanel;
import com.android.tools.idea.uibuilder.property.NlProperty;
import com.android.tools.idea.uibuilder.property.NlPropertyItem;
import com.android.tools.idea.uibuilder.property.ViewAllPropertiesAction;
import com.android.tools.idea.uibuilder.property.editors.NlPropertyEditors;
import com.android.tools.idea.uibuilder.surface.DesignSurface;
import com.android.tools.idea.uibuilder.surface.DesignSurfaceListener;
import com.android.tools.idea.uibuilder.surface.ScreenView;
import com.android.util.PropertiesMap;
import com.google.common.collect.ImmutableTable;
import com.google.common.collect.Table;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.project.Project;
import com.intellij.ui.components.JBLoadingPanel;
import com.intellij.util.Alarm;
import com.intellij.util.ui.UIUtil;
import com.intellij.util.ui.update.MergingUpdateQueue;
import com.intellij.util.ui.update.Update;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.LayoutManager;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class NlPropertiesManager
implements ToolContent<DesignSurface>,
DesignSurfaceListener,
ModelListener {
    public static final int UPDATE_DELAY_MSECS = 250;
    private final Project myProject;
    private final JBLoadingPanel myLoadingPanel;
    private final NlPropertiesPanel myPropertiesPanel;
    private final NlPropertyEditors myEditors;
    @Nullable
    private DesignSurface mySurface;
    @Nullable
    private ScreenView myScreenView;
    private MergingUpdateQueue myUpdateQueue;
    private boolean myFirstLoad;
    private boolean myLoading;

    public NlPropertiesManager(@NotNull Project project, @Nullable DesignSurface designSurface) {
        if (project == null) {
            NlPropertiesManager.$$$reportNull$$$0(0);
        }
        this.myFirstLoad = true;
        this.myProject = project;
        this.myLoadingPanel = new JBLoadingPanel((LayoutManager)new BorderLayout(), (Disposable)project, 20);
        this.myEditors = NlPropertyEditors.getInstance(project);
        this.myPropertiesPanel = new NlPropertiesPanel(this, (Disposable)this);
        this.myLoadingPanel.add((Component)this.myPropertiesPanel);
        this.setToolContext(designSurface);
    }

    public void activatePropertySheet() {
        this.myPropertiesPanel.activatePropertySheet();
    }

    public void activateInspector() {
        this.myPropertiesPanel.activateInspector();
    }

    public void setToolContext(@Nullable DesignSurface designSurface) {
        if (designSurface == this.mySurface) {
            return;
        }
        if (this.mySurface != null) {
            this.mySurface.removeListener(this);
        }
        this.mySurface = designSurface;
        if (this.mySurface == null) {
            this.setScreenView(null);
        } else {
            this.mySurface.addListener(this);
            ScreenView screenView = this.mySurface.getCurrentScreenView();
            this.setScreenView(screenView);
            List<NlComponent> selection = screenView != null ? screenView.getSelectionModel().getSelection() : Collections.emptyList();
            this.componentSelectionChanged(this.mySurface, selection);
        }
    }

    @NotNull
    public JComponent getComponent() {
        JBLoadingPanel jBLoadingPanel = this.myLoadingPanel;
        if (jBLoadingPanel == null) {
            NlPropertiesManager.$$$reportNull$$$0(1);
        }
        return jBLoadingPanel;
    }

    @NotNull
    public JComponent getFocusedComponent() {
        NlPropertiesPanel nlPropertiesPanel = this.myPropertiesPanel;
        if (nlPropertiesPanel == null) {
            NlPropertiesManager.$$$reportNull$$$0(2);
        }
        return nlPropertiesPanel;
    }

    @NotNull
    public List<AnAction> getGearActions() {
        List<AnAction> list = Collections.emptyList();
        if (list == null) {
            NlPropertiesManager.$$$reportNull$$$0(3);
        }
        return list;
    }

    @NotNull
    public List<AnAction> getAdditionalActions() {
        List<ViewAllPropertiesAction> list = Collections.singletonList(new ViewAllPropertiesAction(this.myPropertiesPanel));
        if (list == null) {
            NlPropertiesManager.$$$reportNull$$$0(4);
        }
        return list;
    }

    public void registerCloseAutoHideWindow(@NotNull Runnable runnable) {
        if (runnable == null) {
            NlPropertiesManager.$$$reportNull$$$0(5);
        }
    }

    public boolean supportsFiltering() {
        return true;
    }

    public void setFilter(@NotNull String filter) {
        if (filter == null) {
            NlPropertiesManager.$$$reportNull$$$0(6);
        }
        this.myPropertiesPanel.setFilter(filter);
    }

    @Nullable
    public DesignSurface getDesignSurface() {
        return this.mySurface;
    }

    private void setScreenView(@Nullable ScreenView screenView) {
        if (screenView == this.myScreenView) {
            return;
        }
        if (this.myScreenView != null) {
            this.myScreenView.getModel().removeListener(this);
        }
        this.myScreenView = screenView;
        if (this.myScreenView != null) {
            this.myScreenView.getModel().addListener(this);
        }
    }

    @NotNull
    public Project getProject() {
        Project project = this.myProject;
        if (project == null) {
            NlPropertiesManager.$$$reportNull$$$0(7);
        }
        return project;
    }

    @NotNull
    public NlPropertyEditors getPropertyEditors() {
        NlPropertyEditors nlPropertyEditors = this.myEditors;
        if (nlPropertyEditors == null) {
            NlPropertiesManager.$$$reportNull$$$0(8);
        }
        return nlPropertyEditors;
    }

    @Nullable
    private MergingUpdateQueue getUpdateQueue() {
        ApplicationManager.getApplication().assertIsDispatchThread();
        if (this.myUpdateQueue == null) {
            this.myUpdateQueue = new MergingUpdateQueue("android.layout.propertysheet", 250, true, null, (Disposable)this.mySurface, null, Alarm.ThreadToUse.SWING_THREAD);
        }
        return this.myUpdateQueue;
    }

    private void setSelectedComponents(@NotNull List<NlComponent> components, @Nullable Runnable postUpdateRunnable) {
        if (components == null) {
            NlPropertiesManager.$$$reportNull$$$0(9);
        }
        ApplicationManager.getApplication().executeOnPooledThread(() -> {
            if (components == null) {
                NlPropertiesManager.$$$reportNull$$$0(27);
            }
            Table<String, String, NlPropertyItem> properties = !components.isEmpty() ? NlProperties.getInstance().getProperties(components) : ImmutableTable.of();
            UIUtil.invokeLaterIfNeeded(() -> {
                if (components == null) {
                    NlPropertiesManager.$$$reportNull$$$0(28);
                }
                if (this.myProject.isDisposed()) {
                    return;
                }
                this.myPropertiesPanel.setItems(components, properties, this);
                if (postUpdateRunnable != null) {
                    this.myLoading = false;
                    postUpdateRunnable.run();
                }
            });
        });
    }

    @NotNull
    public PropertiesMap getDefaultProperties(@NotNull List<NlComponent> components) {
        if (components == null) {
            NlPropertiesManager.$$$reportNull$$$0(10);
        }
        if (components.isEmpty()) {
            PropertiesMap propertiesMap = PropertiesMap.EMPTY_MAP;
            if (propertiesMap == null) {
                NlPropertiesManager.$$$reportNull$$$0(11);
            }
            return propertiesMap;
        }
        if (this.mySurface == null) {
            PropertiesMap propertiesMap = PropertiesMap.EMPTY_MAP;
            if (propertiesMap == null) {
                NlPropertiesManager.$$$reportNull$$$0(12);
            }
            return propertiesMap;
        }
        ScreenView view = this.mySurface.getCurrentScreenView();
        if (view == null) {
            PropertiesMap propertiesMap = PropertiesMap.EMPTY_MAP;
            if (propertiesMap == null) {
                NlPropertiesManager.$$$reportNull$$$0(13);
            }
            return propertiesMap;
        }
        Map<Object, PropertiesMap> map = view.getModel().getDefaultProperties();
        ArrayList<PropertiesMap> propertiesMaps = new ArrayList<PropertiesMap>(components.size());
        for (NlComponent component : components) {
            PropertiesMap propertiesMap = map.get(component.getSnapshot());
            if (propertiesMap == null) {
                PropertiesMap propertiesMap2 = PropertiesMap.EMPTY_MAP;
                if (propertiesMap2 == null) {
                    NlPropertiesManager.$$$reportNull$$$0(14);
                }
                return propertiesMap2;
            }
            propertiesMaps.add(propertiesMap);
        }
        PropertiesMap first = (PropertiesMap)propertiesMaps.get(0);
        if (propertiesMaps.size() == 1) {
            PropertiesMap propertiesMap = first;
            if (propertiesMap == null) {
                NlPropertiesManager.$$$reportNull$$$0(15);
            }
            return propertiesMap;
        }
        PropertiesMap commonProperties = new PropertiesMap();
        for (Map.Entry property : first.entrySet()) {
            boolean include = true;
            for (int index = 1; index < propertiesMaps.size(); ++index) {
                PropertiesMap other = (PropertiesMap)propertiesMaps.get(index);
                if (((PropertiesMap.Property)property.getValue()).equals(other.get(property.getKey()))) continue;
                include = false;
                break;
            }
            if (!include) continue;
            commonProperties.put(property.getKey(), property.getValue());
        }
        PropertiesMap propertiesMap = commonProperties;
        if (propertiesMap == null) {
            NlPropertiesManager.$$$reportNull$$$0(16);
        }
        return propertiesMap;
    }

    public void setValue(@NotNull NlProperty property, @Nullable String value) {
        if (property == null) {
            NlPropertiesManager.$$$reportNull$$$0(17);
        }
        property.setValue(value);
    }

    public void updateSelection() {
        if (this.mySurface == null || this.myScreenView == null) {
            return;
        }
        List<NlComponent> selection = this.myScreenView.getModel().getSelectionModel().getSelection();
        this.componentSelectionChanged(this.mySurface, selection);
    }

    @Override
    public void componentSelectionChanged(@NotNull DesignSurface surface, final @NotNull List<NlComponent> newSelection) {
        if (surface == null) {
            NlPropertiesManager.$$$reportNull$$$0(18);
        }
        if (newSelection == null) {
            NlPropertiesManager.$$$reportNull$$$0(19);
        }
        if (surface != this.mySurface) {
            return;
        }
        MergingUpdateQueue queue = this.getUpdateQueue();
        if (queue == null) {
            return;
        }
        if (!newSelection.isEmpty() && this.myFirstLoad) {
            this.myFirstLoad = false;
            this.myLoadingPanel.startLoading();
        }
        this.myLoading = true;
        queue.queue(new Update("updateProperties"){

            public void run() {
                NlPropertiesManager.this.setSelectedComponents(newSelection, () -> ((JBLoadingPanel)NlPropertiesManager.this.myLoadingPanel).stopLoading());
            }

            public boolean canEat(Update update) {
                return true;
            }
        });
    }

    @Override
    public void screenChanged(@NotNull DesignSurface surface, @Nullable ScreenView screenView) {
        if (surface == null) {
            NlPropertiesManager.$$$reportNull$$$0(20);
        }
    }

    @Override
    public void modelChanged(@NotNull DesignSurface surface, @Nullable NlModel model) {
        if (surface == null) {
            NlPropertiesManager.$$$reportNull$$$0(21);
        }
    }

    @Override
    public void modelChangedOnLayout(@NotNull NlModel model, boolean animate) {
        if (model == null) {
            NlPropertiesManager.$$$reportNull$$$0(22);
        }
    }

    @Override
    public boolean activatePreferredEditor(@NotNull DesignSurface surface, @NotNull NlComponent component) {
        ViewHandler handler;
        String propertyName;
        if (surface == null) {
            NlPropertiesManager.$$$reportNull$$$0(23);
        }
        if (component == null) {
            NlPropertiesManager.$$$reportNull$$$0(24);
        }
        String string = propertyName = (handler = component.getViewHandler()) != null ? handler.getPreferredProperty() : null;
        if (propertyName == null) {
            return false;
        }
        return this.myPropertiesPanel.activatePreferredEditor(propertyName, this.myLoading);
    }

    @Override
    public void modelChanged(@NotNull NlModel model) {
        if (model == null) {
            NlPropertiesManager.$$$reportNull$$$0(25);
        }
    }

    @Override
    public void modelRendered(@NotNull NlModel model) {
        if (model == null) {
            NlPropertiesManager.$$$reportNull$$$0(26);
        }
        this.myPropertiesPanel.modelRendered(this);
    }

    public void dispose() {
        this.setToolContext(null);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 7: 
            case 8: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 7: 
            case 8: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 7: 
            case 8: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/android/tools/idea/uibuilder/property/NlPropertiesManager";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "runnable";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "filter";
                break;
            }
            case 9: 
            case 10: 
            case 27: 
            case 28: {
                objectArray2 = objectArray3;
                objectArray3[0] = "components";
                break;
            }
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "property";
                break;
            }
            case 18: 
            case 20: 
            case 21: 
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "surface";
                break;
            }
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newSelection";
                break;
            }
            case 22: 
            case 25: 
            case 26: {
                objectArray2 = objectArray3;
                objectArray3[0] = "model";
                break;
            }
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "component";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/android/tools/idea/uibuilder/property/NlPropertiesManager";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getComponent";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getFocusedComponent";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getGearActions";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getAdditionalActions";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getProject";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getPropertyEditors";
                break;
            }
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "getDefaultProperties";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 7: 
            case 8: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: {
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "registerCloseAutoHideWindow";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "setFilter";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "setSelectedComponents";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "getDefaultProperties";
                break;
            }
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "setValue";
                break;
            }
            case 18: 
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "componentSelectionChanged";
                break;
            }
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "screenChanged";
                break;
            }
            case 21: 
            case 25: {
                objectArray = objectArray;
                objectArray[2] = "modelChanged";
                break;
            }
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "modelChangedOnLayout";
                break;
            }
            case 23: 
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "activatePreferredEditor";
                break;
            }
            case 26: {
                objectArray = objectArray;
                objectArray[2] = "modelRendered";
                break;
            }
            case 27: {
                objectArray = objectArray;
                objectArray[2] = "lambda$setSelectedComponents$1";
                break;
            }
            case 28: {
                objectArray = objectArray;
                objectArray[2] = "lambda$null$0";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 7: 
            case 8: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

