/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.uibuilder.property.editors;

import com.android.tools.idea.uibuilder.property.NlFlagPropertyItem;
import com.android.tools.idea.uibuilder.property.NlProperty;
import com.android.tools.idea.uibuilder.property.editors.NlBaseComponentEditor;
import com.android.tools.idea.uibuilder.property.editors.NlComponentEditor;
import com.android.tools.idea.uibuilder.property.editors.NlEditingListener;
import com.android.tools.idea.uibuilder.property.editors.NlFlagEditor;
import com.intellij.icons.AllIcons;
import com.intellij.ide.ui.laf.darcula.ui.DarculaTextBorder;
import com.intellij.ide.ui.laf.darcula.ui.DarculaTextFieldUI;
import com.intellij.openapi.actionSystem.ActionToolbar;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.actionSystem.impl.ActionButton;
import com.intellij.openapi.ui.DialogWrapper;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.WindowEvent;
import java.awt.event.WindowFocusListener;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.border.Border;
import javax.swing.plaf.TextUI;
import javax.swing.text.JTextComponent;
import org.jetbrains.android.dom.attrs.AttributeDefinition;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class NlFlagsEditor
extends NlBaseComponentEditor
implements NlComponentEditor {
    private final JPanel myPanel;
    private final JTextField myValue;
    private NlFlagPropertyItem myProperty;

    public static NlFlagsEditor create() {
        return new NlFlagsEditor();
    }

    private NlFlagsEditor() {
        super(NlEditingListener.DEFAULT_LISTENER);
        AnAction action = this.createDisplayFlagEditorAction();
        ActionButton button = new ActionButton(action, action.getTemplatePresentation().clone(), "unknown", ActionToolbar.NAVBAR_MINIMUM_BUTTON_SIZE);
        this.myValue = new CustomTextField();
        this.myValue.setEditable(false);
        this.myValue.setFocusable(true);
        this.myPanel = new JPanel(new BorderLayout(HORIZONTAL_COMPONENT_GAP, 0));
        this.myPanel.setBorder(BorderFactory.createEmptyBorder(2, 0, 2, 0));
        this.myPanel.add((Component)this.myValue, "Center");
        this.myPanel.add((Component)button, "After");
        this.myValue.addActionListener(event -> this.displayFlagEditor());
        this.myValue.addKeyListener(new KeyAdapter(){

            @Override
            public void keyTyped(KeyEvent e) {
                NlFlagsEditor.this.displayFlagEditor();
            }
        });
        this.myValue.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                NlFlagsEditor.this.displayFlagEditor();
            }
        });
    }

    @Override
    @NotNull
    public JComponent getComponent() {
        JPanel jPanel = this.myPanel;
        if (jPanel == null) {
            NlFlagsEditor.$$$reportNull$$$0(0);
        }
        return jPanel;
    }

    @Override
    @Nullable
    public NlProperty getProperty() {
        return this.myProperty;
    }

    @Override
    public void setProperty(@NotNull NlProperty property) {
        if (property == null) {
            NlFlagsEditor.$$$reportNull$$$0(1);
        }
        assert (property instanceof NlFlagPropertyItem);
        this.myProperty = (NlFlagPropertyItem)property;
        this.myValue.setText(property.getValue());
    }

    private AnAction createDisplayFlagEditorAction() {
        return new AnAction(){

            public void update(AnActionEvent event) {
                Presentation presentation = event.getPresentation();
                if (NlFlagsEditor.this.myProperty != null) {
                    presentation.setIcon(AllIcons.General.Ellipsis);
                    presentation.setText("Click to edit");
                    presentation.setVisible(true);
                    presentation.setEnabled(true);
                } else {
                    presentation.setIcon(null);
                    presentation.setText(null);
                    presentation.setVisible(false);
                    presentation.setEnabled(false);
                }
            }

            public void actionPerformed(AnActionEvent event) {
                NlFlagsEditor.this.displayFlagEditor();
            }
        };
    }

    private void displayFlagEditor() {
        FlagsDialog dialog = new FlagsDialog(this.myProperty);
        dialog.setResizable(false);
        dialog.setInitialLocationCallback(() -> {
            Point location = new Point(0, 0);
            SwingUtilities.convertPointToScreen(location, this.myPanel);
            return location;
        });
        dialog.show();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/android/tools/idea/uibuilder/property/editors/NlFlagsEditor";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "property";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getComponent";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "com/android/tools/idea/uibuilder/property/editors/NlFlagsEditor";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "setProperty";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class CustomTextFieldUI
    extends DarculaTextFieldUI {
        public CustomTextFieldUI(JTextField textField) {
            super(textField);
        }

        protected void paintDarculaBackground(Graphics2D graphics2D, JTextComponent component, Border border) {
            graphics2D.setColor(component.getBackground());
            super.paintDarculaBackground(graphics2D, component, border);
        }
    }

    private static class CustomTextField
    extends JTextField {
        public CustomTextField() {
            this.setBorder((Border)new DarculaTextBorder());
        }

        @Override
        public void setUI(TextUI ui) {
            super.setUI((TextUI)((Object)new CustomTextFieldUI(this)));
        }
    }

    private static class FlagsDialog
    extends DialogWrapper {
        private final NlFlagPropertyItem myProperty;

        protected FlagsDialog(@NotNull NlFlagPropertyItem property) {
            if (property == null) {
                FlagsDialog.$$$reportNull$$$0(0);
            }
            super(property.getModel().getProject(), false, DialogWrapper.IdeModalityType.MODELESS);
            this.myProperty = property;
            this.setTitle(property.getName());
            this.init();
            this.getWindow().addWindowFocusListener(new WindowFocusListener(){

                @Override
                public void windowGainedFocus(WindowEvent e) {
                }

                @Override
                public void windowLostFocus(WindowEvent e) {
                    this.close(0);
                }
            });
        }

        @NotNull
        protected Action[] createActions() {
            Action[] actionArray = new Action[]{this.getOKAction()};
            if (actionArray == null) {
                FlagsDialog.$$$reportNull$$$0(1);
            }
            return actionArray;
        }

        @Nullable
        protected JComponent createCenterPanel() {
            JPanel panel = new JPanel();
            panel.setLayout(new BoxLayout(panel, 3));
            AttributeDefinition definition = this.myProperty.getDefinition();
            assert (definition != null);
            for (String item : definition.getValues()) {
                NlFlagEditor editor = NlFlagEditor.createForInspector(NlEditingListener.DEFAULT_LISTENER);
                editor.setProperty(this.myProperty.getChildProperty(item));
                panel.add(editor.getComponent());
            }
            return panel;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 1: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 1: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "property";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/android/tools/idea/uibuilder/property/editors/NlFlagsEditor$FlagsDialog";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/android/tools/idea/uibuilder/property/editors/NlFlagsEditor$FlagsDialog";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "createActions";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 1: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

