/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.android.actions;

import com.android.ide.common.resources.configuration.FolderConfiguration;
import com.android.resources.ResourceFolderType;
import com.google.common.collect.Maps;
import com.intellij.CommonBundle;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.LangDataKeys;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.fileTypes.StdFileTypes;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.io.FileUtilRt;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiManager;
import com.intellij.psi.xml.XmlFile;
import java.io.File;
import java.util.Collection;
import java.util.Map;
import org.jetbrains.android.actions.CreateResourceActionBase;
import org.jetbrains.android.actions.CreateResourceDialogUtils;
import org.jetbrains.android.actions.CreateResourceFileActionGroup;
import org.jetbrains.android.actions.CreateResourceFileDialogBase;
import org.jetbrains.android.actions.CreateTypedResourceFileAction;
import org.jetbrains.android.actions.ElementCreatingValidator;
import org.jetbrains.android.actions.NewResourceCreationHandler;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.android.util.AndroidBundle;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CreateResourceFileAction
extends CreateResourceActionBase {
    private static final Logger LOG = Logger.getInstance((String)"#org.jetbrains.android.actions.CreateResourceFileAction");
    private final Map<ResourceFolderType, CreateTypedResourceFileAction> mySubactions = Maps.newEnumMap(ResourceFolderType.class);
    private String myRootElement;
    private boolean myNavigate;

    @NotNull
    public static CreateResourceFileAction getInstance() {
        AnAction action = ActionManager.getInstance().getAction("Android.CreateResourcesActionGroup");
        assert (action instanceof CreateResourceFileActionGroup);
        CreateResourceFileAction createResourceFileAction = ((CreateResourceFileActionGroup)action).getCreateResourceFileAction();
        if (createResourceFileAction == null) {
            CreateResourceFileAction.$$$reportNull$$$0(0);
        }
        return createResourceFileAction;
    }

    public CreateResourceFileAction() {
        super(AndroidBundle.message("new.resource.action.title", new Object[0]), AndroidBundle.message("new.resource.action.description", new Object[0]), StdFileTypes.XML.getIcon());
    }

    public void add(CreateTypedResourceFileAction action) {
        this.mySubactions.put(action.getResourceFolderType(), action);
    }

    public Collection<CreateTypedResourceFileAction> getSubactions() {
        return this.mySubactions.values();
    }

    @Override
    protected boolean isAvailable(DataContext context) {
        if (!super.isAvailable(context)) {
            return false;
        }
        return CreateResourceFileAction.isOutsideResourceTypeFolder(context);
    }

    static boolean isOutsideResourceTypeFolder(@NotNull DataContext context) {
        Module module;
        VirtualFile file;
        if (context == null) {
            CreateResourceFileAction.$$$reportNull$$$0(1);
        }
        if ((file = (VirtualFile)CommonDataKeys.VIRTUAL_FILE.getData(context)) != null) {
            if (!file.isDirectory()) {
                file = file.getParent();
            }
            if (file != null && ResourceFolderType.getFolderType((String)file.getName()) != null) {
                return false;
            }
        }
        if ((module = (Module)LangDataKeys.MODULE.getData(context)) != null) {
            return AndroidFacet.getInstance(module) != null;
        }
        PsiElement element = (PsiElement)CommonDataKeys.PSI_ELEMENT.getData(context);
        return element != null && AndroidFacet.getInstance(element) != null;
    }

    @Nullable
    public static XmlFile createFileResource(@NotNull AndroidFacet facet, @NotNull ResourceFolderType resType, @Nullable String resName, @Nullable String rootElement, @Nullable FolderConfiguration config, boolean chooseResName, @Nullable String dialogTitle, @Nullable PsiDirectory resDirectory, @Nullable DataContext dataContext, boolean navigate) {
        PsiElement[] elements;
        if (facet == null) {
            CreateResourceFileAction.$$$reportNull$$$0(2);
        }
        if (resType == null) {
            CreateResourceFileAction.$$$reportNull$$$0(3);
        }
        if ((elements = CreateResourceFileAction.doCreateFileResource(facet, resType, resName, rootElement, config, chooseResName, dialogTitle, resDirectory, dataContext, navigate)).length == 0) {
            return null;
        }
        assert (elements.length == 1 && elements[0] instanceof XmlFile);
        return (XmlFile)elements[0];
    }

    @Nullable
    public static XmlFile createFileResource(@NotNull AndroidFacet facet, @NotNull ResourceFolderType folderType, @Nullable String resName, @Nullable String rootElement, @Nullable FolderConfiguration config, boolean chooseResName, @Nullable String dialogTitle, @Nullable PsiDirectory resDirectory, @Nullable DataContext dataContext) {
        if (facet == null) {
            CreateResourceFileAction.$$$reportNull$$$0(4);
        }
        if (folderType == null) {
            CreateResourceFileAction.$$$reportNull$$$0(5);
        }
        return CreateResourceFileAction.createFileResource(facet, folderType, resName, rootElement, config, chooseResName, dialogTitle, resDirectory, dataContext, true);
    }

    @NotNull
    private static PsiElement[] doCreateFileResource(@NotNull AndroidFacet facet, @NotNull ResourceFolderType resType, @Nullable String resName, @Nullable String rootElement, @Nullable FolderConfiguration config, boolean chooseResName, @Nullable String dialogTitle, @Nullable PsiDirectory resDirectory, @Nullable DataContext dataContext, boolean navigate) {
        if (facet == null) {
            CreateResourceFileAction.$$$reportNull$$$0(6);
        }
        if (resType == null) {
            CreateResourceFileAction.$$$reportNull$$$0(7);
        }
        CreateResourceFileAction action = CreateResourceFileAction.getInstance();
        Project project = facet.getModule().getProject();
        action.myNavigate = navigate;
        CreateResourceFileDialogBase.ValidatorFactory validatorFactory = action.createValidatorFactory(project);
        if (ApplicationManager.getApplication().isUnitTestMode()) {
            String subdirName = resType.getName();
            VirtualFile resDir = facet.getPrimaryResourceDir();
            if (resDir == null) {
                if (PsiElement.EMPTY_ARRAY == null) {
                    CreateResourceFileAction.$$$reportNull$$$0(8);
                }
                return PsiElement.EMPTY_ARRAY;
            }
            PsiDirectory resourceDir = PsiManager.getInstance((Project)project).findDirectory(resDir);
            if (resourceDir == null) {
                if (PsiElement.EMPTY_ARRAY == null) {
                    CreateResourceFileAction.$$$reportNull$$$0(9);
                }
                return PsiElement.EMPTY_ARRAY;
            }
            ElementCreatingValidator inputValidator = validatorFactory.create(resourceDir, subdirName, null);
            PsiElement[] psiElementArray = inputValidator.checkInput(resName) && inputValidator.canClose(resName) ? ((CreateResourceActionBase.MyInputValidator)inputValidator).getCreatedElements() : PsiElement.EMPTY_ARRAY;
            if (psiElementArray == null) {
                CreateResourceFileAction.$$$reportNull$$$0(10);
            }
            return psiElementArray;
        }
        NewResourceCreationHandler newResourceHandler = NewResourceCreationHandler.getInstance(project);
        CreateResourceFileDialogBase dialog = newResourceHandler.createNewResourceFileDialog(facet, action.mySubactions.values(), resType, resName, rootElement, config, chooseResName, true, resDirectory, dataContext, validatorFactory);
        if (dialogTitle != null) {
            dialog.setTitle(dialogTitle);
        }
        if (!dialog.showAndGet()) {
            if (PsiElement.EMPTY_ARRAY == null) {
                CreateResourceFileAction.$$$reportNull$$$0(11);
            }
            return PsiElement.EMPTY_ARRAY;
        }
        PsiElement[] psiElementArray = dialog.getCreatedElements();
        if (psiElementArray == null) {
            CreateResourceFileAction.$$$reportNull$$$0(12);
        }
        return psiElementArray;
    }

    @Override
    @NotNull
    public PsiElement[] invokeDialog(@NotNull Project project, @NotNull DataContext dataContext) {
        Module module;
        if (project == null) {
            CreateResourceFileAction.$$$reportNull$$$0(13);
        }
        if (dataContext == null) {
            CreateResourceFileAction.$$$reportNull$$$0(14);
        }
        if ((module = (Module)LangDataKeys.MODULE.getData(dataContext)) == null) {
            if (PsiElement.EMPTY_ARRAY == null) {
                CreateResourceFileAction.$$$reportNull$$$0(15);
            }
            return PsiElement.EMPTY_ARRAY;
        }
        AndroidFacet facet = AndroidFacet.getInstance(module);
        LOG.assertTrue(facet != null);
        VirtualFile[] files = (VirtualFile[])CommonDataKeys.VIRTUAL_FILE_ARRAY.getData(dataContext);
        ResourceFolderType folderType = CreateResourceFileAction.getUniqueFolderType(files);
        FolderConfiguration config = null;
        if (files != null && files.length > 0) {
            config = files.length == 1 ? FolderConfiguration.getConfigForFolder((String)files[0].getName()) : null;
        }
        this.myNavigate = true;
        NewResourceCreationHandler newResourceHandler = NewResourceCreationHandler.getInstance(project);
        CreateResourceFileDialogBase dialog = newResourceHandler.createNewResourceFileDialog(facet, this.mySubactions.values(), folderType, null, null, config, true, false, CreateResourceDialogUtils.findResourceDirectory(dataContext), dataContext, this.createValidatorFactory(project));
        if (!dialog.showAndGet()) {
            if (PsiElement.EMPTY_ARRAY == null) {
                CreateResourceFileAction.$$$reportNull$$$0(16);
            }
            return PsiElement.EMPTY_ARRAY;
        }
        PsiElement[] psiElementArray = dialog.getCreatedElements();
        if (psiElementArray == null) {
            CreateResourceFileAction.$$$reportNull$$$0(17);
        }
        return psiElementArray;
    }

    @Nullable
    static ResourceFolderType getUniqueFolderType(@Nullable VirtualFile[] files) {
        ResourceFolderType folderType = null;
        if (files != null && files.length > 0) {
            for (VirtualFile file : files) {
                ResourceFolderType type;
                if (!file.isDirectory()) {
                    file = file.getParent();
                }
                if (file == null || (type = ResourceFolderType.getFolderType((String)file.getName())) == null) continue;
                if (type != folderType && folderType != null) {
                    folderType = null;
                    break;
                }
                folderType = type;
            }
        }
        return folderType;
    }

    @NotNull
    private CreateResourceFileDialogBase.ValidatorFactory createValidatorFactory(final @NotNull Project project) {
        if (project == null) {
            CreateResourceFileAction.$$$reportNull$$$0(18);
        }
        CreateResourceFileDialogBase.ValidatorFactory validatorFactory = new CreateResourceFileDialogBase.ValidatorFactory(){

            @Override
            @NotNull
            public ElementCreatingValidator create(@NotNull PsiDirectory resourceDirectory, @NotNull String subdirName, @Nullable String rootElement) {
                PsiDirectory resSubdir;
                if (resourceDirectory == null) {
                    1.$$$reportNull$$$0(0);
                }
                if (subdirName == null) {
                    1.$$$reportNull$$$0(1);
                }
                if ((resSubdir = resourceDirectory.findSubdirectory(subdirName)) == null) {
                    resSubdir = (PsiDirectory)ApplicationManager.getApplication().runWriteAction(() -> {
                        if (resourceDirectory == null) {
                            1.$$$reportNull$$$0(3);
                        }
                        if (subdirName == null) {
                            1.$$$reportNull$$$0(4);
                        }
                        return resourceDirectory.createSubdirectory(subdirName);
                    });
                }
                CreateResourceFileAction.this.myRootElement = rootElement;
                CreateResourceActionBase.MyInputValidator myInputValidator = new CreateResourceActionBase.MyInputValidator(project, resSubdir);
                if (myInputValidator == null) {
                    1.$$$reportNull$$$0(2);
                }
                return myInputValidator;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                RuntimeException runtimeException;
                Object[] objectArray;
                Object[] objectArray2;
                int n2;
                String string;
                switch (n) {
                    default: {
                        string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                        break;
                    }
                    case 2: {
                        string = "@NotNull method %s.%s must not return null";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        n2 = 3;
                        break;
                    }
                    case 2: {
                        n2 = 2;
                        break;
                    }
                }
                Object[] objectArray3 = new Object[n2];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "resourceDirectory";
                        break;
                    }
                    case 1: 
                    case 4: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "subdirName";
                        break;
                    }
                    case 2: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "org/jetbrains/android/actions/CreateResourceFileAction$1";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "org/jetbrains/android/actions/CreateResourceFileAction$1";
                        break;
                    }
                    case 2: {
                        objectArray = objectArray2;
                        objectArray2[1] = "create";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray;
                        objectArray[2] = "create";
                        break;
                    }
                    case 2: {
                        break;
                    }
                    case 3: 
                    case 4: {
                        objectArray = objectArray;
                        objectArray[2] = "lambda$create$0";
                        break;
                    }
                }
                String string2 = String.format(string, objectArray);
                switch (n) {
                    default: {
                        runtimeException = new IllegalArgumentException(string2);
                        break;
                    }
                    case 2: {
                        runtimeException = new IllegalStateException(string2);
                        break;
                    }
                }
                throw runtimeException;
            }
        };
        if (validatorFactory == null) {
            CreateResourceFileAction.$$$reportNull$$$0(19);
        }
        return validatorFactory;
    }

    @Override
    @NotNull
    protected PsiElement[] create(String newName, PsiDirectory directory) throws Exception {
        CreateTypedResourceFileAction action = this.getActionByDir(directory);
        if (action == null) {
            throw new IllegalArgumentException("Incorrect directory");
        }
        if (this.myRootElement != null && this.myRootElement.length() > 0) {
            PsiElement[] psiElementArray = action.doCreateAndNavigate(newName, directory, this.myRootElement, false, this.myNavigate);
            if (psiElementArray == null) {
                CreateResourceFileAction.$$$reportNull$$$0(20);
            }
            return psiElementArray;
        }
        PsiElement[] psiElementArray = action.create(newName, directory);
        if (psiElementArray == null) {
            CreateResourceFileAction.$$$reportNull$$$0(21);
        }
        return psiElementArray;
    }

    private CreateTypedResourceFileAction getActionByDir(PsiDirectory directory) {
        String baseDirName = directory.getName();
        ResourceFolderType folderType = ResourceFolderType.getFolderType((String)baseDirName);
        if (folderType == null) {
            return null;
        }
        return this.mySubactions.get(folderType);
    }

    @Override
    protected String getErrorTitle() {
        return CommonBundle.getErrorTitle();
    }

    @Override
    protected String getCommandName() {
        return AndroidBundle.message("new.resource.command.name", new Object[0]);
    }

    @Override
    @Nullable
    protected String getActionName(PsiDirectory directory, String newName) {
        return CreateResourceFileAction.doGetActionName(directory, newName);
    }

    static String doGetActionName(PsiDirectory directory, String newName) {
        if (FileUtilRt.getExtension((String)newName).length() == 0) {
            newName = newName + ".xml";
        }
        return AndroidBundle.message("new.resource.action.name", directory.getName() + File.separator + newName);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 13: 
            case 14: 
            case 18: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 13: 
            case 14: 
            case 18: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/android/actions/CreateResourceFileAction";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 2: 
            case 4: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "facet";
                break;
            }
            case 3: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "resType";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "folderType";
                break;
            }
            case 13: 
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dataContext";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getInstance";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 13: 
            case 14: 
            case 18: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/android/actions/CreateResourceFileAction";
                break;
            }
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "doCreateFileResource";
                break;
            }
            case 15: 
            case 16: 
            case 17: {
                objectArray = objectArray2;
                objectArray2[1] = "invokeDialog";
                break;
            }
            case 19: {
                objectArray = objectArray2;
                objectArray2[1] = "createValidatorFactory";
                break;
            }
            case 20: 
            case 21: {
                objectArray = objectArray2;
                objectArray2[1] = "create";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "isOutsideResourceTypeFolder";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "createFileResource";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "doCreateFileResource";
                break;
            }
            case 13: 
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "invokeDialog";
                break;
            }
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "createValidatorFactory";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 13: 
            case 14: 
            case 18: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

