/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ws.http.request;

import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.impl.source.resolve.reference.impl.providers.FileReferenceUtil;
import com.intellij.util.LineSeparator;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.ws.http.request.HttpRequestVariableSubstitutor;
import com.intellij.ws.http.request.psi.HttpFilePath;
import com.intellij.ws.http.request.psi.HttpHeaderField;
import com.intellij.ws.http.request.psi.HttpHeaderFieldName;
import com.intellij.ws.http.request.psi.HttpHeaderFieldValue;
import com.intellij.ws.http.request.psi.HttpInputFile;
import com.intellij.ws.http.request.psi.HttpMessageBody;
import com.intellij.ws.http.request.psi.HttpMultipartField;
import com.intellij.ws.http.request.psi.HttpMultipartMessage;
import com.intellij.ws.http.request.psi.HttpQuery;
import com.intellij.ws.http.request.psi.HttpQueryParameter;
import com.intellij.ws.http.request.psi.HttpRequest;
import com.intellij.ws.http.request.psi.HttpRequestBody;
import com.intellij.ws.http.request.psi.HttpRequestMessage;
import com.intellij.ws.http.request.psi.HttpRequestMessagesGroup;
import com.intellij.ws.http.request.psi.HttpRequestTarget;
import com.intellij.ws.http.request.run.HttpRequestValidationException;
import com.intellij.ws.rest.client.RestClientBundle;
import com.intellij.ws.rest.client.RestClientFormBodyPart;
import com.intellij.ws.rest.client.RestClientRequest;
import java.io.File;
import java.io.IOException;
import java.util.List;
import one.util.streamex.StreamEx;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class HttpRequestPsiConverter {
    private static final String DEFAULT_TMP_INPUT_FILE_NAME = "http_request_input_file";
    private static final String INPUT_SIGN = "< ";
    private static final String REQUEST_SEPARATOR = "###";

    @NotNull
    public static String getSeparator() {
        if (REQUEST_SEPARATOR == null) {
            HttpRequestPsiConverter.$$$reportNull$$$0(0);
        }
        return REQUEST_SEPARATOR;
    }

    @NotNull
    public static String toPsiHttpRequest(@NotNull RestClientRequest request) {
        if (request == null) {
            HttpRequestPsiConverter.$$$reportNull$$$0(1);
        }
        String string = HttpRequestPsiConverter.toPsiHttpRequest(request, null);
        if (string == null) {
            HttpRequestPsiConverter.$$$reportNull$$$0(2);
        }
        return string;
    }

    @NotNull
    public static String toPsiHttpRequest(@NotNull RestClientRequest request, @Nullable String responseFileName) {
        if (request == null) {
            HttpRequestPsiConverter.$$$reportNull$$$0(3);
        }
        StringBuilder result = new StringBuilder(StringUtil.notNullize((String)request.httpMethod));
        result.append(" ");
        result.append(StringUtil.trimEnd((String)request.getURL(), (String)"/"));
        if (request.parametersEnabled && !request.parameters.isEmpty()) {
            result.append("?");
            result.append(StringUtil.join(request.parameters, pair -> pair.getKey() + "=" + pair.getValue(), (String)"&"));
        }
        if (!request.headers.isEmpty()) {
            result.append("\n");
            result.append(StringUtil.join(request.headers, pair -> pair.getKey() + ":" + pair.getValue(), (String)"\n"));
        }
        if (request.haveFileToSend && StringUtil.isNotEmpty((String)request.filesToSend)) {
            String inputFiles = StreamEx.of((Object[])request.filesToSend.split(File.pathSeparator)).map(path -> INPUT_SIGN + path).joining((CharSequence)"\n");
            result.append("\n\n");
            result.append(inputFiles);
        } else if (request.haveTextToSend && StringUtil.isNotEmpty((String)request.textToSend)) {
            result.append("\n\n");
            result.append(request.textToSend);
        }
        if (StringUtil.isNotEmpty((String)responseFileName)) {
            result.append("\n\n");
            result.append("<> ").append(responseFileName);
        }
        result.append("\n\n").append(REQUEST_SEPARATOR).append("\n\n");
        String string = result.toString();
        if (string == null) {
            HttpRequestPsiConverter.$$$reportNull$$$0(4);
        }
        return string;
    }

    @NotNull
    public static RestClientRequest toRestClientRequest(@NotNull HttpRequest element, @NotNull HttpRequestVariableSubstitutor substitutor) throws HttpRequestValidationException {
        HttpQuery query;
        if (element == null) {
            HttpRequestPsiConverter.$$$reportNull$$$0(5);
        }
        if (substitutor == null) {
            HttpRequestPsiConverter.$$$reportNull$$$0(6);
        }
        HttpRequestTarget target = element.getRequestTarget();
        String url = element.getHttpUrl(substitutor);
        if (StringUtil.isEmpty((String)url)) {
            throw new HttpRequestValidationException(RestClientBundle.message("rest.client.request.url.is.invalid", new Object[0]));
        }
        RestClientRequest request = new RestClientRequest();
        request.urlBase = url;
        request.httpMethod = element.getHttpMethod();
        request.urlPath = "";
        HttpQuery httpQuery = query = target != null ? target.getQuery() : null;
        if (query != null) {
            for (HttpQueryParameter parameter : query.getQueryParameterList()) {
                String key = parameter.getKey(substitutor);
                String value = parameter.getValue(substitutor);
                if (StringUtil.isNotEmpty((String)key)) {
                    request.parameters.add(new RestClientRequest.KeyValuePair(key, StringUtil.notNullize((String)value)));
                    continue;
                }
                throw new HttpRequestValidationException(RestClientBundle.message("rest.client.request.query.is.invalid", parameter.getText()));
            }
        }
        request.parametersEnabled = !request.parameters.isEmpty();
        for (HttpHeaderField field : element.getHeaderFieldList()) {
            HttpHeaderFieldName name = field.getHeaderFieldName();
            request.headers.add(new RestClientRequest.KeyValuePair(name.getText(), field.getValue(substitutor)));
        }
        request.textToSend = "";
        request.filesToSend = "";
        HttpRequestBody body = element.getRequestBody();
        if (body instanceof HttpRequestMessagesGroup) {
            List<HttpRequestMessage> messages = ((HttpRequestMessagesGroup)body).getRequestMessageList();
            if (!messages.isEmpty()) {
                if (messages.size() == 1 && messages.get(0) instanceof HttpInputFile) {
                    request.filesToSend = HttpRequestPsiConverter.getFileToSend((HttpInputFile)messages.get(0)).getVirtualFile().getPath();
                    request.haveFileToSend = StringUtil.isNotEmpty((String)request.filesToSend);
                } else {
                    request.textToSend = HttpRequestPsiConverter.getTextToSend(element.getContainingFile(), messages);
                    request.haveTextToSend = StringUtil.isNotEmpty((String)request.textToSend);
                }
            }
        } else if (body instanceof HttpMultipartMessage) {
            request.isFileUpload = true;
            request.multipartBoundary = HttpRequestPsiConverter.getMultipartBoundary(element);
            request.formBodyPart = ContainerUtil.newArrayList();
            List<HttpMultipartField> fields = ((HttpMultipartMessage)body).getMultipartFieldList();
            for (int i = 0; i < fields.size(); ++i) {
                HttpMultipartField field = fields.get(i);
                RestClientFormBodyPart bodyPart = HttpRequestPsiConverter.newBodyPartBuilder(field, substitutor, i);
                for (HttpHeaderField header : field.getHeaderFieldList()) {
                    bodyPart.addHeader(header.getName(), header.getValue(substitutor));
                }
                request.formBodyPart.add(bodyPart);
            }
        }
        RestClientRequest restClientRequest = request;
        if (restClientRequest == null) {
            HttpRequestPsiConverter.$$$reportNull$$$0(7);
        }
        return restClientRequest;
    }

    @Nullable
    private static String getMultipartBoundary(@NotNull HttpRequest request) {
        HttpHeaderField field;
        if (request == null) {
            HttpRequestPsiConverter.$$$reportNull$$$0(8);
        }
        if ((field = request.getHeaderField("Content-Type")) != null) {
            HttpHeaderFieldValue contentType = field.getHeaderFieldValue();
            return contentType != null ? contentType.getHeaderFieldOption("boundary") : null;
        }
        return null;
    }

    @NotNull
    public static RestClientFormBodyPart newBodyPartBuilder(@NotNull HttpMultipartField field, @NotNull HttpRequestVariableSubstitutor substitutor, int index) throws HttpRequestValidationException {
        String filename;
        HttpHeaderFieldValue description;
        String name;
        if (field == null) {
            HttpRequestPsiConverter.$$$reportNull$$$0(9);
        }
        if (substitutor == null) {
            HttpRequestPsiConverter.$$$reportNull$$$0(10);
        }
        String string = name = (description = field.getMultipartFieldDescription()) != null ? description.getHeaderFieldOption("name") : String.valueOf(index);
        if (StringUtil.isEmpty((String)name)) {
            name = String.valueOf(index);
        }
        String string2 = filename = description != null ? description.getHeaderFieldOption("filename") : null;
        if (StringUtil.isNotEmpty((String)filename)) {
            File toUpload = HttpRequestPsiConverter.getFileToUpload(field, filename);
            RestClientFormBodyPart restClientFormBodyPart = RestClientFormBodyPart.create(name, filename, toUpload, field.getContentType(substitutor));
            if (restClientFormBodyPart == null) {
                HttpRequestPsiConverter.$$$reportNull$$$0(11);
            }
            return restClientFormBodyPart;
        }
        String text = HttpRequestPsiConverter.getTextToSend(field.getContainingFile(), field.getRequestMessages());
        RestClientFormBodyPart restClientFormBodyPart = RestClientFormBodyPart.create(name, text, field.getContentType(substitutor));
        if (restClientFormBodyPart == null) {
            HttpRequestPsiConverter.$$$reportNull$$$0(12);
        }
        return restClientFormBodyPart;
    }

    @NotNull
    private static File getFileToUpload(@NotNull HttpMultipartField field, @NotNull String fieldName) throws HttpRequestValidationException {
        File file;
        List<HttpRequestMessage> messages;
        if (field == null) {
            HttpRequestPsiConverter.$$$reportNull$$$0(13);
        }
        if (fieldName == null) {
            HttpRequestPsiConverter.$$$reportNull$$$0(14);
        }
        if ((messages = field.getRequestMessages()).size() == 1 && messages.get(0) instanceof HttpInputFile) {
            File file2 = new File(HttpRequestPsiConverter.getFileToSend((HttpInputFile)messages.get(0)).getVirtualFile().getPath());
            if (file2 == null) {
                HttpRequestPsiConverter.$$$reportNull$$$0(15);
            }
            return file2;
        }
        try {
            File file3 = FileUtil.createTempFile((String)DEFAULT_TMP_INPUT_FILE_NAME, (String)".txt");
            FileUtil.writeToFile((File)file3, (String)HttpRequestPsiConverter.getTextToSend(field.getContainingFile(), messages));
            file = file3;
        }
        catch (IOException e) {
            throw new HttpRequestValidationException(RestClientBundle.message("rest.client.request.cannot.create.file", fieldName));
        }
        if (file == null) {
            HttpRequestPsiConverter.$$$reportNull$$$0(16);
        }
        return file;
    }

    @NotNull
    private static String getTextToSend(@Nullable PsiFile file, @NotNull List<HttpRequestMessage> messages) throws HttpRequestValidationException {
        if (messages == null) {
            HttpRequestPsiConverter.$$$reportNull$$$0(17);
        }
        String lineSeparator = file == null || messages.size() < 2 ? LineSeparator.getSystemLineSeparator().getSeparatorString() : FileDocumentManager.getInstance().getLineSeparator(file.getVirtualFile(), file.getProject());
        StringBuilder result = new StringBuilder();
        for (int i = 0; i < messages.size(); ++i) {
            HttpRequestMessage message = messages.get(i);
            if (message instanceof HttpMessageBody) {
                result.append(message.getText());
            } else if (message instanceof HttpInputFile) {
                result.append(HttpRequestPsiConverter.getFileToSend((HttpInputFile)message).getText());
            }
            if (i == messages.size() - 1) continue;
            result.append(lineSeparator);
        }
        String string = result.toString();
        if (string == null) {
            HttpRequestPsiConverter.$$$reportNull$$$0(18);
        }
        return string;
    }

    @NotNull
    private static PsiFile getFileToSend(@NotNull HttpInputFile message) throws HttpRequestValidationException {
        HttpFilePath filePath;
        if (message == null) {
            HttpRequestPsiConverter.$$$reportNull$$$0(19);
        }
        if ((filePath = message.getFilePath()) == null) {
            throw new HttpRequestValidationException(RestClientBundle.message("rest.client.request.file.path.is.empty", new Object[0]));
        }
        PsiFile file = FileReferenceUtil.findFile((PsiElement)filePath);
        if (file == null) {
            String path = filePath.getPresentablePath();
            throw new HttpRequestValidationException(RestClientBundle.message("rest.client.request.file.path.is.invalid", path));
        }
        PsiFile psiFile = file;
        if (psiFile == null) {
            HttpRequestPsiConverter.$$$reportNull$$$0(20);
        }
        return psiFile;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: 
            case 3: 
            case 5: 
            case 6: 
            case 8: 
            case 9: 
            case 10: 
            case 13: 
            case 14: 
            case 17: 
            case 19: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: 
            case 3: 
            case 5: 
            case 6: 
            case 8: 
            case 9: 
            case 10: 
            case 13: 
            case 14: 
            case 17: 
            case 19: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/ws/http/request/HttpRequestPsiConverter";
                break;
            }
            case 1: 
            case 3: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "request";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 6: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "substitutor";
                break;
            }
            case 9: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "field";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fieldName";
                break;
            }
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "messages";
                break;
            }
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "message";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getSeparator";
                break;
            }
            case 1: 
            case 3: 
            case 5: 
            case 6: 
            case 8: 
            case 9: 
            case 10: 
            case 13: 
            case 14: 
            case 17: 
            case 19: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/ws/http/request/HttpRequestPsiConverter";
                break;
            }
            case 2: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "toPsiHttpRequest";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "toRestClientRequest";
                break;
            }
            case 11: 
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "newBodyPartBuilder";
                break;
            }
            case 15: 
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "getFileToUpload";
                break;
            }
            case 18: {
                objectArray = objectArray2;
                objectArray2[1] = "getTextToSend";
                break;
            }
            case 20: {
                objectArray = objectArray2;
                objectArray2[1] = "getFileToSend";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "toPsiHttpRequest";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "toRestClientRequest";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "getMultipartBoundary";
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "newBodyPartBuilder";
                break;
            }
            case 13: 
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "getFileToUpload";
                break;
            }
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "getTextToSend";
                break;
            }
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "getFileToSend";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: 
            case 3: 
            case 5: 
            case 6: 
            case 8: 
            case 9: 
            case 10: 
            case 13: 
            case 14: 
            case 17: 
            case 19: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

