/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.j2meplugin.codeInspection;

import com.intellij.codeInsight.daemon.GroupNames;
import com.intellij.codeInspection.AbstractBaseJavaLocalInspectionTool;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.j2meplugin.J2MEBundle;
import com.intellij.j2meplugin.module.J2MEModuleProperties;
import com.intellij.j2meplugin.module.MobileModuleUtil;
import com.intellij.j2meplugin.module.settings.MobileApplicationType;
import com.intellij.j2meplugin.module.settings.MobileModuleSettings;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtil;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.JavaElementVisitor;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiFile;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class MissedExecutableInspection
extends AbstractBaseJavaLocalInspectionTool {
    private static final Logger LOG = Logger.getInstance(MissedExecutableInspection.class);

    @Nls
    @NotNull
    public String getGroupDisplayName() {
        String string = GroupNames.J2ME_GROUP_NAME;
        if (string == null) {
            MissedExecutableInspection.$$$reportNull$$$0(0);
        }
        return string;
    }

    @Nls
    @NotNull
    public String getDisplayName() {
        String string = J2MEBundle.message("executable.class.misconfiguration.display.name", new Object[0]);
        if (string == null) {
            MissedExecutableInspection.$$$reportNull$$$0(1);
        }
        return string;
    }

    @NonNls
    @NotNull
    public String getShortName() {
        if ("MissedExecutable" == null) {
            MissedExecutableInspection.$$$reportNull$$$0(2);
        }
        return "MissedExecutable";
    }

    public boolean isEnabledByDefault() {
        return true;
    }

    @NotNull
    public PsiElementVisitor buildVisitor(final @NotNull ProblemsHolder holder, boolean isOnTheFly) {
        if (holder == null) {
            MissedExecutableInspection.$$$reportNull$$$0(3);
        }
        JavaElementVisitor javaElementVisitor = new JavaElementVisitor(){

            public void visitClass(PsiClass aClass) {
                super.visitClass(aClass);
                Module module = ModuleUtil.findModuleForPsiElement((PsiElement)aClass);
                if (module != null && MobileModuleUtil.isExecutable(aClass, module)) {
                    String fqName = aClass.getQualifiedName();
                    J2MEModuleProperties moduleProperties = J2MEModuleProperties.getInstance(module);
                    if (moduleProperties != null) {
                        MobileModuleSettings moduleSettings = MobileModuleSettings.getInstance(module);
                        LOG.assertTrue(moduleSettings != null);
                        if (!moduleSettings.containsMidlet(fqName)) {
                            MobileApplicationType applicationType = moduleProperties.getMobileApplicationType();
                            holder.registerProblem((PsiElement)aClass.getNameIdentifier(), J2MEBundle.message("midlet.undefined.problem.description", applicationType.getPresentableClassName()), new LocalQuickFix[]{new AddExecutable2Configuration(aClass)});
                        }
                    }
                }
            }
        };
        if (javaElementVisitor == null) {
            MissedExecutableInspection.$$$reportNull$$$0(4);
        }
        return javaElementVisitor;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 3: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 3: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/j2meplugin/codeInspection/MissedExecutableInspection";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "holder";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getGroupDisplayName";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getDisplayName";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getShortName";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/j2meplugin/codeInspection/MissedExecutableInspection";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "buildVisitor";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "buildVisitor";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 3: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class AddExecutable2Configuration
    implements LocalQuickFix {
        private final String myClassFQN;
        private final Module myModule;

        public AddExecutable2Configuration(PsiClass aClass) {
            this.myClassFQN = aClass.getQualifiedName();
            this.myModule = ModuleUtil.findModuleForPsiElement((PsiElement)aClass);
        }

        @Nls
        @NotNull
        public String getFamilyName() {
            if ("Append midlet to suite" == null) {
                AddExecutable2Configuration.$$$reportNull$$$0(0);
            }
            return "Append midlet to suite";
        }

        @Nullable
        public PsiElement getElementToMakeWritable(@NotNull PsiFile file) {
            if (file == null) {
                AddExecutable2Configuration.$$$reportNull$$$0(1);
            }
            return null;
        }

        @Nls
        @NotNull
        public String getName() {
            String string = J2MEBundle.message("append.to.suite.quickfix.text", StringUtil.getShortName((String)this.myClassFQN), this.myModule.getName());
            if (string == null) {
                AddExecutable2Configuration.$$$reportNull$$$0(2);
            }
            return string;
        }

        public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor) {
            if (project == null) {
                AddExecutable2Configuration.$$$reportNull$$$0(3);
            }
            if (descriptor == null) {
                AddExecutable2Configuration.$$$reportNull$$$0(4);
            }
            MobileModuleSettings moduleSettings = MobileModuleSettings.getInstance(this.myModule);
            LOG.assertTrue(moduleSettings != null);
            moduleSettings.addMidlet(this.myClassFQN);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
                case 1: 
                case 3: 
                case 4: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 2;
                    break;
                }
                case 1: 
                case 3: 
                case 4: {
                    n2 = 3;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/j2meplugin/codeInspection/MissedExecutableInspection$AddExecutable2Configuration";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "file";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "descriptor";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFamilyName";
                    break;
                }
                case 1: 
                case 3: 
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/j2meplugin/codeInspection/MissedExecutableInspection$AddExecutable2Configuration";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getName";
                    break;
                }
            }
            switch (n) {
                default: {
                    break;
                }
                case 1: {
                    objectArray = objectArray;
                    objectArray[2] = "getElementToMakeWritable";
                    break;
                }
                case 3: 
                case 4: {
                    objectArray = objectArray;
                    objectArray[2] = "applyFix";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
                case 1: 
                case 3: 
                case 4: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

