/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.j2meplugin.run.ui;

import com.intellij.concurrency.JobScheduler;
import com.intellij.execution.ExecutionException;
import com.intellij.execution.configurations.GeneralCommandLine;
import com.intellij.execution.process.OSProcessHandler;
import com.intellij.execution.process.ProcessAdapter;
import com.intellij.execution.process.ProcessEvent;
import com.intellij.execution.process.ProcessListener;
import com.intellij.j2meplugin.J2MEBundle;
import com.intellij.j2meplugin.emulator.MobileSdk;
import com.intellij.j2meplugin.run.J2MERunConfiguration;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.options.ConfigurationException;
import com.intellij.openapi.options.SettingsEditor;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.util.ArrayUtil;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.util.HashSet;
import java.util.ResourceBundle;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import javax.swing.AbstractButton;
import javax.swing.ButtonGroup;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.jetbrains.annotations.NotNull;

public class OTASettingsConfigurable
extends SettingsEditor<J2MERunConfiguration> {
    private JTextField myInstallUrl;
    private JPanel myWholePanel;
    private JRadioButton myInstall;
    private JTextField myTransientUrl;
    private JRadioButton myRun;
    private JComboBox myExistAppToRun;
    private final DefaultComboBoxModel myExistSuitsToRun;
    private JRadioButton myRunRemove;
    private JComboBox myExistAppToRemove;
    private final DefaultComboBoxModel myExistSuitsToRunAndRemove;
    private JRadioButton myTransient;
    private String[] myCommands;
    private final Sdk myProjectJdk;
    private final Module myModule;
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.j2meplugin");
    private JCheckBox myForce;
    private JButton myUpdate;
    private HandlingProcessHandler myRetrievingProcess;
    private String[] myInstalledSuits;
    public static final int _INSTALL = 1;
    public static final int _REMOVE = 2;
    public static final int _RUN = 3;
    public static final int _TRANSIENT = 4;

    public OTASettingsConfigurable(Sdk projectJdk, Module module) {
        this.$$$setupUI$$$();
        this.myExistSuitsToRun = new DefaultComboBoxModel();
        this.myExistSuitsToRunAndRemove = new DefaultComboBoxModel();
        this.myProjectJdk = projectJdk;
        this.myModule = module;
        ButtonGroup myStart = new ButtonGroup();
        myStart.add(this.myInstall);
        myStart.add(this.myRun);
        myStart.add(this.myRunRemove);
        myStart.add(this.myTransient);
        this.myInstall.setSelected(true);
        this.myExistAppToRemove.setModel(this.myExistSuitsToRunAndRemove);
        this.myExistAppToRun.setModel(this.myExistSuitsToRun);
        this.myUpdate.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                OTASettingsConfigurable.this.refreshInstalledSuits();
            }
        });
        this.myInstall.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                if (OTASettingsConfigurable.this.myInstall.isSelected() && OTASettingsConfigurable.this.canForce()) {
                    OTASettingsConfigurable.this.myForce.setEnabled(true);
                } else {
                    OTASettingsConfigurable.this.myForce.setEnabled(false);
                }
            }
        });
    }

    public void setCommands(String[] commands) {
        this.myCommands = commands;
        this.myInstall.setEnabled(false);
        this.myInstallUrl.setEnabled(false);
        this.myExistAppToRun.setEnabled(false);
        this.myRun.setEnabled(false);
        this.myExistAppToRemove.setEnabled(false);
        this.myRunRemove.setEnabled(false);
        this.myTransient.setEnabled(false);
        this.myTransientUrl.setEnabled(false);
        this.myUpdate.setEnabled(false);
        for (int i = 0; commands != null && i < commands.length; ++i) {
            if (commands[i].indexOf("install") != -1) {
                this.myInstall.setEnabled(true);
                this.myInstallUrl.setEnabled(true);
            }
            if (commands[i].indexOf("run") != -1) {
                this.myExistAppToRun.setEnabled(true);
                this.myRun.setEnabled(true);
            }
            if (commands[i].indexOf("remove") != -1) {
                this.myExistAppToRemove.setEnabled(true);
                this.myRunRemove.setEnabled(true);
            }
            if (commands[i].indexOf("transient") == -1) continue;
            this.myTransient.setEnabled(true);
            this.myTransientUrl.setEnabled(true);
        }
        if (this.myExistAppToRun.isEnabled() || this.myExistAppToRemove.isEnabled()) {
            this.myUpdate.setEnabled(true);
        }
    }

    private boolean canForce() {
        for (int i = 0; this.myCommands != null && i < this.myCommands.length; ++i) {
            if (this.myCommands[i].indexOf("force") == -1) continue;
            return true;
        }
        return false;
    }

    public void refreshInstalledSuits() {
        ProgressManager.getInstance().runProcessWithProgressSynchronously(new Runnable(){

            @Override
            public void run() {
                final ProgressIndicator progressIndicator = ProgressManager.getInstance().getProgressIndicator();
                if (progressIndicator != null) {
                    progressIndicator.setText(J2MEBundle.message("run.configuration.ota.retrieving.progress.title", new Object[0]));
                    progressIndicator.setIndeterminate(true);
                }
                Future getterFuture = ApplicationManager.getApplication().executeOnPooledThread(() -> OTASettingsConfigurable.access$502(OTASettingsConfigurable.this, OTASettingsConfigurable.this.getInstalledSuits(OTASettingsConfigurable.this.myCommands)));
                JobScheduler.getScheduler().schedule(new Runnable(){

                    @Override
                    public void run() {
                        if (progressIndicator == null || progressIndicator.isCanceled()) {
                            OTASettingsConfigurable.this.cancelRetrieval();
                        } else {
                            progressIndicator.setText2("");
                            JobScheduler.getScheduler().schedule(this, 50L, TimeUnit.MILLISECONDS);
                        }
                    }
                }, 10L, TimeUnit.MILLISECONDS);
                try {
                    getterFuture.get();
                }
                catch (Exception e) {
                    LOG.error((Throwable)e);
                    OTASettingsConfigurable.this.cancelRetrieval();
                }
                SwingUtilities.invokeLater(() -> {
                    OTASettingsConfigurable.this.myExistSuitsToRun.removeAllElements();
                    OTASettingsConfigurable.this.myExistSuitsToRunAndRemove.removeAllElements();
                    if (OTASettingsConfigurable.this.myInstalledSuits.length > 0 && OTASettingsConfigurable.this.myInstalledSuits[0].compareToIgnoreCase(J2MEBundle.message("run.configuration.ota.no.suites.installed", new Object[0])) == 0) {
                        OTASettingsConfigurable.this.myExistSuitsToRun.addElement(OTASettingsConfigurable.this.myInstalledSuits[0]);
                        OTASettingsConfigurable.this.myExistSuitsToRunAndRemove.addElement(OTASettingsConfigurable.this.myInstalledSuits[0]);
                    } else {
                        for (int i = 1; OTASettingsConfigurable.this.myInstalledSuits != null && i < OTASettingsConfigurable.this.myInstalledSuits.length; ++i) {
                            if (OTASettingsConfigurable.this.myInstalledSuits[i].indexOf(J2MEBundle.message("run.configuration.ota.exclusion.suits.filter", new Object[0])) > -1) continue;
                            OTASettingsConfigurable.this.myExistSuitsToRun.addElement(OTASettingsConfigurable.this.myInstalledSuits[i]);
                            OTASettingsConfigurable.this.myExistSuitsToRunAndRemove.addElement(OTASettingsConfigurable.this.myInstalledSuits[i]);
                        }
                    }
                });
                if (OTASettingsConfigurable.this.myInstalledSuits == null || OTASettingsConfigurable.this.myInstalledSuits.length == 0) {
                    Messages.showInfoMessage((String)J2MEBundle.message("run.configuration.ota.no.suites.installed", new Object[0]), (String)J2MEBundle.message("run.configuration.ota.no.suites.installed", new Object[0]));
                }
            }
        }, J2MEBundle.message("run.configuration.ota.retrieving.progress.title", new Object[0]), true, this.myModule.getProject());
        this.cancelRetrieval();
    }

    private void cancelRetrieval() {
        if (this.myRetrievingProcess != null) {
            this.myRetrievingProcess.terminate();
        }
    }

    @NotNull
    public JComponent createEditor() {
        JPanel jPanel = this.myWholePanel;
        if (jPanel == null) {
            OTASettingsConfigurable.$$$reportNull$$$0(0);
        }
        return jPanel;
    }

    public void resetEditorFrom(@NotNull J2MERunConfiguration jdomExternalizable) {
        if (jdomExternalizable == null) {
            OTASettingsConfigurable.$$$reportNull$$$0(1);
        }
        J2MERunConfiguration specificConfiguration = jdomExternalizable;
        this.myExistAppToRun.setSelectedItem(specificConfiguration.RUN);
        this.myExistAppToRemove.setSelectedItem(specificConfiguration.REMOVE);
        this.myTransientUrl.setText(specificConfiguration.TRANSIENT);
        if (specificConfiguration.INSTALL != null) {
            String jam = " -Xjam:force";
            int forceIndex = specificConfiguration.INSTALL.indexOf(" -Xjam:force");
            if (forceIndex > -1) {
                this.myForce.setSelected(true);
                this.myInstallUrl.setText(specificConfiguration.INSTALL.substring(0, forceIndex));
            } else {
                this.myInstallUrl.setText(specificConfiguration.INSTALL);
            }
        }
        if (specificConfiguration.SELECTION == 4) {
            this.myTransient.setSelected(true);
        } else if (specificConfiguration.SELECTION == 3) {
            this.myRun.setSelected(true);
        } else if (specificConfiguration.SELECTION == 2) {
            this.myRunRemove.setSelected(true);
        } else {
            this.myInstall.setSelected(true);
        }
    }

    public void applyEditorTo(@NotNull J2MERunConfiguration jdomExternalizable) throws ConfigurationException {
        if (jdomExternalizable == null) {
            OTASettingsConfigurable.$$$reportNull$$$0(2);
        }
        String jam = " -Xjam:";
        jdomExternalizable.INSTALL = this.myInstallUrl.getText() + (this.myForce.isSelected() ? " -Xjam:force" : "");
        jdomExternalizable.RUN = (String)this.myExistAppToRun.getSelectedItem();
        jdomExternalizable.REMOVE = (String)this.myExistAppToRemove.getSelectedItem();
        jdomExternalizable.TRANSIENT = this.myTransientUrl.getText();
        if (this.myInstall.isSelected()) {
            jdomExternalizable.TO_START = jdomExternalizable.INSTALL;
            jdomExternalizable.SELECTION = 1;
        } else if (this.myRun.isSelected()) {
            jdomExternalizable.TO_START = jdomExternalizable.RUN;
            jdomExternalizable.SELECTION = 3;
        } else if (this.myRunRemove.isSelected()) {
            jdomExternalizable.TO_START = jdomExternalizable.REMOVE;
            jdomExternalizable.SELECTION = 2;
        } else {
            jdomExternalizable.TO_START = jdomExternalizable.TRANSIENT;
            jdomExternalizable.SELECTION = 4;
        }
    }

    private String[] getInstalledSuits(String[] commands) {
        final HashSet installed = new HashSet();
        if (this.myProjectJdk != null && MobileSdk.checkCorrectness(this.myProjectJdk, this.myModule)) {
            boolean canRunPreviouslyInstalled = false;
            for (int i = 0; commands != null && i < commands.length; ++i) {
                if (commands[i].indexOf("storageNames") <= -1) continue;
                canRunPreviouslyInstalled = true;
            }
            if (!canRunPreviouslyInstalled) {
                return null;
            }
            GeneralCommandLine generalCommandLine = new GeneralCommandLine();
            generalCommandLine.setExePath(this.myProjectJdk.getHomePath() + File.separatorChar + "bin" + File.separatorChar + "emulator");
            generalCommandLine.addParameter("-Xjam:storageNames");
            try {
                this.myRetrievingProcess = new HandlingProcessHandler(generalCommandLine);
            }
            catch (ExecutionException e) {
                LOG.error((Throwable)e);
            }
            this.myRetrievingProcess.addProcessListener((ProcessListener)new ProcessAdapter(){

                public void onTextAvailable(@NotNull ProcessEvent event, @NotNull Key outputType) {
                    if (event == null) {
                        4.$$$reportNull$$$0(0);
                    }
                    if (outputType == null) {
                        4.$$$reportNull$$$0(1);
                    }
                    String name = event.getText();
                    name = StringUtil.convertLineSeparators((String)name);
                    installed.add(name);
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    Object[] objectArray;
                    Object[] objectArray2 = new Object[3];
                    switch (n) {
                        default: {
                            objectArray = objectArray2;
                            objectArray2[0] = "event";
                            break;
                        }
                        case 1: {
                            objectArray = objectArray2;
                            objectArray2[0] = "outputType";
                            break;
                        }
                    }
                    objectArray[1] = "com/intellij/j2meplugin/run/ui/OTASettingsConfigurable$4";
                    objectArray[2] = "onTextAvailable";
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
                }
            });
            this.myRetrievingProcess.startNotify();
            this.myRetrievingProcess.waitFor();
            return ArrayUtil.toStringArray(installed);
        }
        return null;
    }

    static /* synthetic */ String[] access$502(OTASettingsConfigurable x0, String[] x1) {
        x0.myInstalledSuits = x1;
        return x1;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: 
            case 2: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: 
            case 2: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/j2meplugin/run/ui/OTASettingsConfigurable";
                break;
            }
            case 1: 
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "jdomExternalizable";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "createEditor";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/j2meplugin/run/ui/OTASettingsConfigurable";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "resetEditorFrom";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "applyEditorTo";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: 
            case 2: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private /* synthetic */ void $$$setupUI$$$() {
        JComboBox jComboBox;
        JComboBox jComboBox2;
        JTextField jTextField;
        JButton jButton;
        JRadioButton jRadioButton;
        JRadioButton jRadioButton2;
        JRadioButton jRadioButton3;
        JCheckBox jCheckBox;
        JTextField jTextField2;
        JRadioButton jRadioButton4;
        JPanel jPanel;
        this.myWholePanel = jPanel = new JPanel();
        jPanel.setLayout((LayoutManager)new GridLayoutManager(5, 4, new Insets(0, 0, 0, 0), -1, -1, false, false));
        this.myInstall = jRadioButton4 = new JRadioButton();
        this.$$$loadButtonText$$$(jRadioButton4, ResourceBundle.getBundle("com/intellij/j2meplugin/J2MEBundle").getString("run.configuration.ota.install"));
        jPanel.add((Component)jRadioButton4, new GridConstraints(0, 0, 1, 2, 8, 0, 3, 0, null, null, null));
        this.myInstallUrl = jTextField2 = new JTextField();
        jPanel.add((Component)jTextField2, new GridConstraints(0, 2, 1, 2, 8, 1, 6, 0, null, new Dimension(150, -1), null));
        this.myForce = jCheckBox = new JCheckBox();
        jCheckBox.setMargin(new Insets(0, 20, 2, 2));
        this.$$$loadButtonText$$$(jCheckBox, ResourceBundle.getBundle("com/intellij/j2meplugin/J2MEBundle").getString("run.configuration.ota.force.installation"));
        jPanel.add((Component)jCheckBox, new GridConstraints(1, 1, 1, 1, 8, 0, 3, 0, null, null, null));
        this.myTransient = jRadioButton3 = new JRadioButton();
        this.$$$loadButtonText$$$(jRadioButton3, ResourceBundle.getBundle("com/intellij/j2meplugin/J2MEBundle").getString("run.configuration.ota.install.run.remove"));
        jPanel.add((Component)jRadioButton3, new GridConstraints(2, 0, 1, 2, 8, 0, 3, 0, null, null, null));
        this.myRunRemove = jRadioButton2 = new JRadioButton();
        this.$$$loadButtonText$$$(jRadioButton2, ResourceBundle.getBundle("com/intellij/j2meplugin/J2MEBundle").getString("run.configuration.ota.run.remove"));
        jPanel.add((Component)jRadioButton2, new GridConstraints(4, 0, 1, 2, 8, 0, 3, 0, null, null, null));
        this.myRun = jRadioButton = new JRadioButton();
        this.$$$loadButtonText$$$(jRadioButton, ResourceBundle.getBundle("com/intellij/j2meplugin/J2MEBundle").getString("run.configuration.ota.run"));
        jPanel.add((Component)jRadioButton, new GridConstraints(3, 0, 1, 2, 8, 0, 3, 0, null, null, null));
        this.myUpdate = jButton = new JButton();
        this.$$$loadButtonText$$$(jButton, ResourceBundle.getBundle("com/intellij/j2meplugin/J2MEBundle").getString("run.configuration.ota.update.suites"));
        jPanel.add((Component)jButton, new GridConstraints(3, 3, 2, 1, 0, 1, 3, 0, null, null, null));
        this.myTransientUrl = jTextField = new JTextField();
        jTextField.setMargin(new Insets(0, 0, 0, 0));
        jPanel.add((Component)jTextField, new GridConstraints(2, 2, 1, 2, 8, 1, 6, 0, null, new Dimension(150, -1), null));
        this.myExistAppToRun = jComboBox2 = new JComboBox();
        jComboBox2.setEditable(true);
        jPanel.add(jComboBox2, new GridConstraints(3, 2, 1, 1, 8, 1, 6, 0, null, null, null));
        this.myExistAppToRemove = jComboBox = new JComboBox();
        jComboBox.setEditable(true);
        jPanel.add(jComboBox, new GridConstraints(4, 2, 1, 1, 8, 1, 2, 0, null, null, null));
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.myWholePanel;
    }

    private /* synthetic */ void $$$loadButtonText$$$(AbstractButton abstractButton, String string) {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = false;
        char c = '\u0000';
        int n = -1;
        for (int i = 0; i < string.length(); ++i) {
            if (string.charAt(i) == '&') {
                if (++i == string.length()) break;
                if (!bl && string.charAt(i) != '&') {
                    bl = true;
                    c = string.charAt(i);
                    n = stringBuffer.length();
                }
            }
            stringBuffer.append(string.charAt(i));
        }
        abstractButton.setText(stringBuffer.toString());
        if (bl) {
            abstractButton.setMnemonic(c);
            abstractButton.setDisplayedMnemonicIndex(n);
        }
    }

    private static class HandlingProcessHandler
    extends OSProcessHandler {
        private HandlingProcessHandler(@NotNull GeneralCommandLine commandLine) throws ExecutionException {
            if (commandLine == null) {
                HandlingProcessHandler.$$$reportNull$$$0(0);
            }
            super(commandLine);
        }

        public void terminate() {
            this.notifyProcessDetached();
            if (this.detachIsDefault()) {
                this.detachProcess();
            } else {
                this.destroyProcess();
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "commandLine", "com/intellij/j2meplugin/run/ui/OTASettingsConfigurable$HandlingProcessHandler", "<init>"));
        }
    }
}

