/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.buildTools;

import com.intellij.lang.javascript.psi.JSArgumentList;
import com.intellij.lang.javascript.psi.JSCallExpression;
import com.intellij.lang.javascript.psi.JSExpression;
import com.intellij.lang.javascript.psi.JSExpressionStatement;
import com.intellij.lang.javascript.psi.JSLiteralExpression;
import com.intellij.lang.javascript.psi.JSObjectLiteralExpression;
import com.intellij.lang.javascript.psi.JSProperty;
import com.intellij.lang.javascript.psi.JSReferenceExpression;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.util.ObjectUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JSPsiUtil {
    private JSPsiUtil() {
    }

    @Nullable
    public static JSCallExpression getCallExpression(@Nullable PsiElement statement) {
        if (statement instanceof JSExpressionStatement) {
            JSExpression expression = ((JSExpressionStatement)statement).getExpression();
            return (JSCallExpression)ObjectUtils.tryCast((Object)expression, JSCallExpression.class);
        }
        return null;
    }

    @Nullable
    public static String getSingleArgumentAsString(@Nullable JSArgumentList argList) {
        JSExpression[] args;
        if (argList != null && (args = argList.getArguments()).length == 1) {
            return JSPsiUtil.getStringLiteralValue(args[0]);
        }
        return null;
    }

    @Nullable
    public static String getFirstArgumentAsString(@Nullable JSArgumentList argList) {
        JSExpression[] args;
        if (argList != null && (args = argList.getArguments()).length > 0) {
            return JSPsiUtil.getStringLiteralValue(args[0]);
        }
        return null;
    }

    @Nullable
    public static JSLiteralExpression getFirstArgumentAsStringLiteral(@Nullable JSArgumentList argList) {
        JSExpression[] args;
        if (argList != null && (args = argList.getArguments()).length > 0) {
            return JSPsiUtil.asStringLiteral(args[0]);
        }
        return null;
    }

    @Nullable
    public static JSObjectLiteralExpression getFirstArgumentAsObjectLiteral(@Nullable JSArgumentList argList) {
        JSExpression[] args;
        if (argList != null && (args = argList.getArguments()).length > 0) {
            return (JSObjectLiteralExpression)ObjectUtils.tryCast((Object)args[0], JSObjectLiteralExpression.class);
        }
        return null;
    }

    @Nullable
    public static String getStringLiteralValue(@Nullable JSExpression expr) {
        JSLiteralExpression literalExpression = JSPsiUtil.asStringLiteral(expr);
        if (literalExpression != null) {
            return JSPsiUtil.getStringLiteralValue(literalExpression);
        }
        return null;
    }

    @NotNull
    public static String getStringLiteralValue(@NotNull JSLiteralExpression literalExpression) {
        if (literalExpression == null) {
            JSPsiUtil.$$$reportNull$$$0(0);
        }
        String string = StringUtil.unquoteString((String)literalExpression.getText());
        if (string == null) {
            JSPsiUtil.$$$reportNull$$$0(1);
        }
        return string;
    }

    @Nullable
    public static JSLiteralExpression asStringLiteral(@Nullable JSExpression expr) {
        JSLiteralExpression literalExpression = (JSLiteralExpression)ObjectUtils.tryCast((Object)expr, JSLiteralExpression.class);
        if (literalExpression != null && literalExpression.isQuotedLiteral()) {
            return literalExpression;
        }
        return null;
    }

    public static boolean isRequireCall(@NotNull JSCallExpression expr) {
        JSReferenceExpression refExpr;
        if (expr == null) {
            JSPsiUtil.$$$reportNull$$$0(2);
        }
        return (refExpr = (JSReferenceExpression)ObjectUtils.tryCast((Object)expr.getMethodExpression(), JSReferenceExpression.class)) != null && "require".equals(refExpr.getReferenceName()) && refExpr.getQualifier() == null;
    }

    @Nullable
    public static JSProperty findPropertyByName(@Nullable JSObjectLiteralExpression objectLiteral, @NotNull String propertyName) {
        if (propertyName == null) {
            JSPsiUtil.$$$reportNull$$$0(3);
        }
        if (objectLiteral == null) {
            return null;
        }
        for (JSProperty property : objectLiteral.getProperties()) {
            if (!propertyName.equals(property.getName())) continue;
            return property;
        }
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "literalExpression";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/javascript/buildTools/JSPsiUtil";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "expr";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "propertyName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/javascript/buildTools/JSPsiUtil";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getStringLiteralValue";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getStringLiteralValue";
                break;
            }
            case 1: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "isRequireCall";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "findPropertyByName";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

