/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.modules;

import com.intellij.codeInsight.daemon.DaemonCodeAnalyzer;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.lang.javascript.JSBundle;
import com.intellij.lang.javascript.library.JSLibraryManager;
import com.intellij.lang.javascript.library.download.TypeScriptAllStubsFile;
import com.intellij.lang.javascript.library.download.TypeScriptDefinitionFilesRootsProvider;
import com.intellij.openapi.application.WriteAction;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.libraries.Library;
import com.intellij.openapi.roots.libraries.LibraryTable;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.util.PsiEditorUtil;
import com.intellij.refactoring.util.CommonRefactoringUtil;
import com.intellij.util.download.DownloadableFileSetDescription;
import com.intellij.webcore.libraries.ScriptingLibraryMappings;
import com.intellij.webcore.libraries.ScriptingLibraryModel;
import com.intellij.webcore.libraries.ui.download.DownloadableFileSetDescriptionWithUrl;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;

public class TypeScriptInstallGlobalTypesFix
implements LocalQuickFix {
    private final String myModuleName;

    public TypeScriptInstallGlobalTypesFix(@NotNull String moduleName) {
        if (moduleName == null) {
            TypeScriptInstallGlobalTypesFix.$$$reportNull$$$0(0);
        }
        this.myModuleName = moduleName;
    }

    @Nls
    @NotNull
    public String getFamilyName() {
        String string = JSBundle.message((String)"npm.modules.install.global.types.fix.name", (Object[])new Object[0]);
        if (string == null) {
            TypeScriptInstallGlobalTypesFix.$$$reportNull$$$0(1);
        }
        return string;
    }

    public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor2) {
        PsiElement element;
        if (project == null) {
            TypeScriptInstallGlobalTypesFix.$$$reportNull$$$0(2);
        }
        if (descriptor2 == null) {
            TypeScriptInstallGlobalTypesFix.$$$reportNull$$$0(3);
        }
        if ((element = descriptor2.getPsiElement()) == null || !element.isValid()) {
            return;
        }
        PsiFile file = element.getContainingFile();
        JSLibraryManager libraryManager = JSLibraryManager.getInstance(project);
        LibraryTable table = libraryManager.getLibraryTable(ScriptingLibraryModel.LibraryLevel.GLOBAL);
        ScriptingLibraryMappings mappings = libraryManager.getLibraryMappings();
        String name = "@types/" + this.myModuleName;
        Library library = table.getLibraryByName(name);
        if (library != null && !mappings.isAssociatedWithProject(name)) {
            WriteAction.run(() -> {
                if (project == null) {
                    TypeScriptInstallGlobalTypesFix.$$$reportNull$$$0(5);
                }
                mappings.associateWithProject(name);
                libraryManager.commitChanges();
                DaemonCodeAnalyzer.getInstance((Project)project).restart(file);
            });
            return;
        }
        DownloadableFileSetDescriptionWithUrl description = TypeScriptAllStubsFile.INSTANCE.getDownloadableFileSetDescription(this.myModuleName);
        if (description == null) {
            Editor editor = PsiEditorUtil.Service.getInstance().findEditorByPsiElement(element);
            if (editor != null) {
                CommonRefactoringUtil.showErrorHint((Project)element.getProject(), (Editor)editor, (String)("Cannot find global module @types/" + this.myModuleName), (String)this.getName(), null);
            }
            return;
        }
        TypeScriptDefinitionFilesRootsProvider.LibraryCreator.downloadTypesLibrary(project, (DownloadableFileSetDescription)description, null, () -> {
            if (project == null) {
                TypeScriptInstallGlobalTypesFix.$$$reportNull$$$0(4);
            }
            if (project.isDisposed()) {
                return;
            }
            if (!file.isValid()) {
                DaemonCodeAnalyzer.getInstance((Project)project).restart();
            } else {
                DaemonCodeAnalyzer.getInstance((Project)project).restart(file);
            }
        });
    }

    public boolean startInWriteAction() {
        return false;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "moduleName";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/javascript/modules/TypeScriptInstallGlobalTypesFix";
                break;
            }
            case 2: 
            case 4: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "descriptor";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/javascript/modules/TypeScriptInstallGlobalTypesFix";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getFamilyName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "applyFix";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "lambda$applyFix$1";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "lambda$applyFix$0";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

