/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.psi.resolve;

import com.intellij.json.psi.JsonArray;
import com.intellij.json.psi.JsonElement;
import com.intellij.json.psi.JsonFile;
import com.intellij.lang.ASTNode;
import com.intellij.lang.ecmascript6.psi.ES6ExportDefaultAssignment;
import com.intellij.lang.ecmascript6.psi.ES6FunctionProperty;
import com.intellij.lang.ecmascript6.psi.ES6ImportCall;
import com.intellij.lang.ecmascript6.resolve.ES6PsiUtil;
import com.intellij.lang.ecmascript6.resolve.JSFileReferencesUtil;
import com.intellij.lang.javascript.DialectDetector;
import com.intellij.lang.javascript.DialectOptionHolder;
import com.intellij.lang.javascript.JSExtendedLanguagesTokenSetProvider;
import com.intellij.lang.javascript.JSNumberParser;
import com.intellij.lang.javascript.JSTokenTypes;
import com.intellij.lang.javascript.dialects.JSDialectSpecificHandlersFactory;
import com.intellij.lang.javascript.dialects.JSLanguageFeature;
import com.intellij.lang.javascript.documentation.JSDocumentationUtils;
import com.intellij.lang.javascript.frameworks.amd.JSAmdPsiUtil;
import com.intellij.lang.javascript.frameworks.commonjs.CommonJSUtil;
import com.intellij.lang.javascript.frameworks.gcl.JSGclModuleReference;
import com.intellij.lang.javascript.frameworks.gcl.JSGclReferenceContributor;
import com.intellij.lang.javascript.index.FrameworkIndexingHandler;
import com.intellij.lang.javascript.index.JSImplicitElementsIndex;
import com.intellij.lang.javascript.index.JSIndexContent;
import com.intellij.lang.javascript.index.JSNamespaceEvaluationResult;
import com.intellij.lang.javascript.index.JSSymbolUtil;
import com.intellij.lang.javascript.library.JSCorePredefinedLibrariesProvider;
import com.intellij.lang.javascript.psi.JSArgumentList;
import com.intellij.lang.javascript.psi.JSArrayLiteralExpression;
import com.intellij.lang.javascript.psi.JSBinaryExpression;
import com.intellij.lang.javascript.psi.JSCallExpression;
import com.intellij.lang.javascript.psi.JSConditionalExpression;
import com.intellij.lang.javascript.psi.JSContextTypeEvaluator;
import com.intellij.lang.javascript.psi.JSDefinitionExpression;
import com.intellij.lang.javascript.psi.JSDestructuringContainer;
import com.intellij.lang.javascript.psi.JSDestructuringProperty;
import com.intellij.lang.javascript.psi.JSElement;
import com.intellij.lang.javascript.psi.JSElementBase;
import com.intellij.lang.javascript.psi.JSExpectedTypeKind;
import com.intellij.lang.javascript.psi.JSExpression;
import com.intellij.lang.javascript.psi.JSExpressionStatement;
import com.intellij.lang.javascript.psi.JSFieldVariable;
import com.intellij.lang.javascript.psi.JSFile;
import com.intellij.lang.javascript.psi.JSForInStatement;
import com.intellij.lang.javascript.psi.JSFunction;
import com.intellij.lang.javascript.psi.JSFunctionExpression;
import com.intellij.lang.javascript.psi.JSFunctionItem;
import com.intellij.lang.javascript.psi.JSIndexedPropertyAccessExpression;
import com.intellij.lang.javascript.psi.JSInitializerOwner;
import com.intellij.lang.javascript.psi.JSLiteralExpression;
import com.intellij.lang.javascript.psi.JSNamedElement;
import com.intellij.lang.javascript.psi.JSNamespace;
import com.intellij.lang.javascript.psi.JSNamespaceImpl;
import com.intellij.lang.javascript.psi.JSNewExpression;
import com.intellij.lang.javascript.psi.JSObjectLiteralExpression;
import com.intellij.lang.javascript.psi.JSParameter;
import com.intellij.lang.javascript.psi.JSParameterListElement;
import com.intellij.lang.javascript.psi.JSParameterTypeDecorator;
import com.intellij.lang.javascript.psi.JSParenthesizedExpression;
import com.intellij.lang.javascript.psi.JSPostfixExpression;
import com.intellij.lang.javascript.psi.JSPrefixExpression;
import com.intellij.lang.javascript.psi.JSProperty;
import com.intellij.lang.javascript.psi.JSPsiElementBase;
import com.intellij.lang.javascript.psi.JSPsiNamedElementBase;
import com.intellij.lang.javascript.psi.JSQualifiedNameImpl;
import com.intellij.lang.javascript.psi.JSRecordType;
import com.intellij.lang.javascript.psi.JSReferenceExpression;
import com.intellij.lang.javascript.psi.JSSpreadExpression;
import com.intellij.lang.javascript.psi.JSSymbolNamespace;
import com.intellij.lang.javascript.psi.JSSymbolNamespaceImpl;
import com.intellij.lang.javascript.psi.JSThisExpression;
import com.intellij.lang.javascript.psi.JSType;
import com.intellij.lang.javascript.psi.JSTypeDeclarationOwner;
import com.intellij.lang.javascript.psi.JSTypeEvaluationResult;
import com.intellij.lang.javascript.psi.JSTypeUtils;
import com.intellij.lang.javascript.psi.JSVariable;
import com.intellij.lang.javascript.psi.ecma6.JSComputedPropertyNameOwner;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptClass;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptFunction;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptInterface;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptModule;
import com.intellij.lang.javascript.psi.ecma6.impl.JSLocalImplicitElementImpl;
import com.intellij.lang.javascript.psi.ecmal4.JSClass;
import com.intellij.lang.javascript.psi.ecmal4.JSQualifiedNamedElement;
import com.intellij.lang.javascript.psi.ecmal4.JSSuperExpression;
import com.intellij.lang.javascript.psi.impl.JSFunctionImpl;
import com.intellij.lang.javascript.psi.impl.JSPsiImplUtils;
import com.intellij.lang.javascript.psi.jsdoc.JSDocComment;
import com.intellij.lang.javascript.psi.resolve.BaseJSSymbolProcessor;
import com.intellij.lang.javascript.psi.resolve.JSContextResolver;
import com.intellij.lang.javascript.psi.resolve.JSEvaluateContext;
import com.intellij.lang.javascript.psi.resolve.JSEvaluationResultContext;
import com.intellij.lang.javascript.psi.resolve.JSImportHandlingUtil;
import com.intellij.lang.javascript.psi.resolve.JSRecursionGuard;
import com.intellij.lang.javascript.psi.resolve.JSResolveProcessorBase;
import com.intellij.lang.javascript.psi.resolve.JSResolveUtil;
import com.intellij.lang.javascript.psi.resolve.JSSimpleTypeProcessor;
import com.intellij.lang.javascript.psi.resolve.JSTagContextBuilder;
import com.intellij.lang.javascript.psi.resolve.JSTypeFromResolveResultProcessor;
import com.intellij.lang.javascript.psi.resolve.JSTypeProcessor;
import com.intellij.lang.javascript.psi.resolve.QualifiedItemProcessor;
import com.intellij.lang.javascript.psi.resolve.ResolveProcessor;
import com.intellij.lang.javascript.psi.resolve.ResolveResultSink;
import com.intellij.lang.javascript.psi.resolve.SinkResolveProcessor;
import com.intellij.lang.javascript.psi.resolve.context.JSApplyCallElement;
import com.intellij.lang.javascript.psi.resolve.context.JSApplyContextElement;
import com.intellij.lang.javascript.psi.resolve.context.JSApplyContextUtil;
import com.intellij.lang.javascript.psi.resolve.context.JSApplyIndexedAccessElement;
import com.intellij.lang.javascript.psi.resolve.context.JSApplyInstanceContextElement;
import com.intellij.lang.javascript.psi.resolve.context.JSApplyPromiseTypeElement;
import com.intellij.lang.javascript.psi.resolve.context.JSApplyPropertyElement;
import com.intellij.lang.javascript.psi.resolve.context.JSApplyStaticContextElement;
import com.intellij.lang.javascript.psi.stubs.JSImplicitElement;
import com.intellij.lang.javascript.psi.types.JSAnyType;
import com.intellij.lang.javascript.psi.types.JSArrayTypeImpl;
import com.intellij.lang.javascript.psi.types.JSBooleanLiteralTypeImpl;
import com.intellij.lang.javascript.psi.types.JSCompositeTypeImpl;
import com.intellij.lang.javascript.psi.types.JSContext;
import com.intellij.lang.javascript.psi.types.JSDestructuringTypeImpl;
import com.intellij.lang.javascript.psi.types.JSEvaluableType;
import com.intellij.lang.javascript.psi.types.JSForInStringType;
import com.intellij.lang.javascript.psi.types.JSFreshObjectLiteralType;
import com.intellij.lang.javascript.psi.types.JSFreshObjectLiteralTypeImpl;
import com.intellij.lang.javascript.psi.types.JSFunctionTypeImpl;
import com.intellij.lang.javascript.psi.types.JSNamedType;
import com.intellij.lang.javascript.psi.types.JSNumberLiteralTypeImpl;
import com.intellij.lang.javascript.psi.types.JSRecordTypeImpl;
import com.intellij.lang.javascript.psi.types.JSReferenceType;
import com.intellij.lang.javascript.psi.types.JSRequireCallExpressionType;
import com.intellij.lang.javascript.psi.types.JSResolvableType;
import com.intellij.lang.javascript.psi.types.JSResolvedTypeInfo;
import com.intellij.lang.javascript.psi.types.JSStringLiteralTypeImpl;
import com.intellij.lang.javascript.psi.types.JSTupleTypeImpl;
import com.intellij.lang.javascript.psi.types.JSTypeContext;
import com.intellij.lang.javascript.psi.types.JSTypeSource;
import com.intellij.lang.javascript.psi.types.JSTypeSourceFactory;
import com.intellij.lang.javascript.psi.types.JSTypeofTypeImpl;
import com.intellij.lang.javascript.psi.types.TypeScriptTypeParser;
import com.intellij.lang.javascript.psi.types.guard.JSTypeGuardChecker;
import com.intellij.lang.javascript.psi.types.primitives.JSBooleanType;
import com.intellij.lang.javascript.psi.types.primitives.JSIntType;
import com.intellij.lang.javascript.psi.types.primitives.JSNumberType;
import com.intellij.lang.javascript.psi.types.primitives.JSObjectType;
import com.intellij.lang.javascript.psi.types.primitives.JSPrimitiveType;
import com.intellij.lang.javascript.psi.types.primitives.JSStringType;
import com.intellij.lang.javascript.psi.types.primitives.JSUintType;
import com.intellij.lang.javascript.psi.types.primitives.JSUndefinedType;
import com.intellij.lang.javascript.psi.util.JSDestructuringUtil;
import com.intellij.lang.javascript.psi.util.JSStubBasedPsiTreeUtil;
import com.intellij.lang.javascript.psi.util.JSUtils;
import com.intellij.lang.typescript.library.TypeScriptLibraryProvider;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiQualifiedReference;
import com.intellij.psi.PsiReference;
import com.intellij.psi.ResolveResult;
import com.intellij.psi.ResolveState;
import com.intellij.psi.css.StylesheetFile;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.psi.util.ParameterizedCachedValue;
import com.intellij.psi.util.ParameterizedCachedValueProvider;
import com.intellij.psi.util.PsiModificationTracker;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.psi.xml.XmlTag;
import com.intellij.util.Processor;
import com.intellij.util.SmartList;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JSTypeEvaluator {
    protected static final PsiElement EXPLICIT_TYPE_MARKER_ELEMENT = PsiUtilCore.NULL_PSI_ELEMENT;
    private static final ThreadLocal<JSRecursionGuard> recursionGuardHolder = new ThreadLocal();
    public static final int MAX_RESOLVE_RESULT_COUNT_TO_EVALUATE = 20;
    private static final Key<ParameterizedCachedValue<JSTypeEvaluationResult, JSExpression>> CACHE_KEY_EXPRESSION_TYPE = Key.create((String)"js.evaluator.expression.type");
    private static final ParameterizedCachedValueProvider<JSTypeEvaluationResult, JSExpression> CACHE_PROVIDER_EXPRESSION_TYPE = new ParameterizedCachedValueProvider<JSTypeEvaluationResult, JSExpression>(){

        public CachedValueProvider.Result<JSTypeEvaluationResult> compute(JSExpression param) {
            JSTypeFromResolveResultProcessor typeProcessor = new JSTypeFromResolveResultProcessor(new JSSimpleTypeProcessor());
            PsiFile targetFile = param.getContainingFile();
            JSTypeEvaluator typeEvaluator = JSDialectSpecificHandlersFactory.forElement((PsiElement)param).newTypeEvaluator(new JSEvaluateContext(targetFile), typeProcessor);
            typeEvaluator.doEvaluateTypes(param, JSEvaluateContext.JSEvaluationPlace.DEFAULT);
            JSTypeEvaluationResult type = typeProcessor.getResult();
            return CachedValueProvider.Result.create((Object)type, (Object[])new Object[]{PsiModificationTracker.MODIFICATION_COUNT});
        }
    };
    protected final JSEvaluateContext myContext;
    protected final JSTypeProcessor myTypeProcessor;

    protected JSTypeEvaluator(JSEvaluateContext context, JSTypeProcessor processor) {
        this.myContext = context;
        this.myTypeProcessor = processor;
    }

    @Nullable
    public static JSType forceEvaluateType(PsiElement target, JSExpression expr, PsiFile targetFile) {
        JSTypeFromResolveResultProcessor typeProcessor = new JSTypeFromResolveResultProcessor(new JSSimpleTypeProcessor(target));
        JSTypeEvaluator.evaluateTypes(expr, targetFile, typeProcessor, JSEvaluateContext.JSEvaluationPlace.FORCE_EVALUATE_TYPE);
        JSTypeEvaluationResult result = typeProcessor.getResult();
        return result != null ? result.getType() : null;
    }

    public static void evaluateTypes(@NotNull JSExpression expr, JSTypeProcessor typeProcessor) {
        if (expr == null) {
            JSTypeEvaluator.$$$reportNull$$$0(0);
        }
        JSTypeEvaluator.evaluateTypes(expr, expr.getContainingFile(), typeProcessor, JSEvaluateContext.JSEvaluationPlace.DEFAULT);
    }

    public static void evaluateTypes(JSExpression expr, PsiFile targetFile, JSTypeProcessor typeProcessor) {
        JSTypeEvaluator.evaluateTypes(expr, targetFile, typeProcessor, JSEvaluateContext.JSEvaluationPlace.DEFAULT);
    }

    public static void evaluateTypes(JSExpression expr, @NotNull PsiFile targetFile, JSTypeProcessor typeProcessor, @NotNull JSEvaluateContext.JSEvaluationPlace place) {
        if (targetFile == null) {
            JSTypeEvaluator.$$$reportNull$$$0(1);
        }
        if (place == null) {
            JSTypeEvaluator.$$$reportNull$$$0(2);
        }
        JSTypeEvaluator.evaluateExpressionOrElementTypes(targetFile, typeProcessor, (PsiElement)expr, place);
    }

    public static void evaluateExpressionOrElementTypes(@NotNull PsiFile targetFile, @NotNull JSTypeProcessor typeProcessor, @NotNull PsiElement element, @NotNull JSEvaluateContext.JSEvaluationPlace place) {
        if (targetFile == null) {
            JSTypeEvaluator.$$$reportNull$$$0(3);
        }
        if (typeProcessor == null) {
            JSTypeEvaluator.$$$reportNull$$$0(4);
        }
        if (element == null) {
            JSTypeEvaluator.$$$reportNull$$$0(5);
        }
        if (place == null) {
            JSTypeEvaluator.$$$reportNull$$$0(6);
        }
        JSTypeEvaluator typeEvaluator = JSDialectSpecificHandlersFactory.forElement((PsiElement)targetFile).newTypeEvaluator(new JSEvaluateContext(targetFile), typeProcessor);
        if (element instanceof JSExpression) {
            typeEvaluator.evaluateTypes((JSExpression)element, place);
        } else if (element instanceof JSDestructuringContainer) {
            typeEvaluator.evaluateDestructuringContainer((JSDestructuringContainer)element);
        } else {
            typeEvaluator.addTypeFromResolveResult(element, false);
        }
    }

    @Nullable
    public static JSTypeEvaluationResult getExpressionType(@NotNull JSExpression expression) {
        if (expression == null) {
            JSTypeEvaluator.$$$reportNull$$$0(7);
        }
        if (!JSTypeEvaluator.canProcessWithEvaluationGuard((PsiElement)expression, JSEvaluateContext.JSEvaluationPlace.DEFAULT)) {
            return null;
        }
        return (JSTypeEvaluationResult)CachedValuesManager.getManager((Project)expression.getProject()).getParameterizedCachedValue((UserDataHolder)expression, CACHE_KEY_EXPRESSION_TYPE, CACHE_PROVIDER_EXPRESSION_TYPE, false, (Object)expression);
    }

    @Nullable
    public static JSTypeEvaluationResult getElementType(@NotNull PsiElement element) {
        if (element == null) {
            JSTypeEvaluator.$$$reportNull$$$0(8);
        }
        PsiFile targetFile = element.getContainingFile();
        JSTypeFromResolveResultProcessor typeProcessor = new JSTypeFromResolveResultProcessor(new JSSimpleTypeProcessor());
        JSTypeEvaluator.evaluateExpressionOrElementTypes(targetFile, typeProcessor, element, JSEvaluateContext.JSEvaluationPlace.DEFAULT);
        return typeProcessor.getResult();
    }

    private void addTypeEvaluationResultElement(@NotNull JSTypeEvaluationResult.JSTypeEvaluationResultElement element) {
        if (element == null) {
            JSTypeEvaluator.$$$reportNull$$$0(9);
        }
        JSType type = element.getType();
        JSSymbolNamespace namespace = element.getNamespace();
        PsiElement source = element.getSource();
        this.myContext.withCombinedContext(element.getEvaluationContext(), () -> {
            if (type != null) {
                JSTypeEvaluator.applyContextAndProcess(type, this.myContext, source, this.myTypeProcessor);
            } else if (namespace != null) {
                JSTypeEvaluator.applyContextAndProcessNamespace((JSNamespace)namespace, this.myContext, source, this.myTypeProcessor);
            } else {
                assert (source != null);
                this.applyContextAndProcessResolvedElement(source);
            }
        });
    }

    public void addType(@Nullable JSType type, @Nullable PsiElement source) {
        PsiElement sourceElement;
        if (type == null) {
            return;
        }
        if (type instanceof JSRequireCallExpressionType) {
            Collection<PsiElement> elements;
            String referencedModule = ((JSRequireCallExpressionType)type).getReferencedModule();
            PsiFile scope = ((JSRequireCallExpressionType)type).getScope();
            if (scope != null && !(elements = JSFileReferencesUtil.resolveModuleReference(scope, referencedModule)).isEmpty()) {
                for (PsiElement element : elements) {
                    JSTypeEvaluator.processWithEvaluationGuard(element, JSEvaluateContext.JSEvaluationPlace.EXTERNAL_MODULE, module -> this.addTypeFromExternalModuleReferenceResolveResult((PsiElement)module));
                }
                return;
            }
        } else if (type instanceof JSReferenceType && (sourceElement = type.getSource().getSourceElement()) != null) {
            String referencedName = ((JSReferenceType)type).getReferencedName();
            this.processItem(sourceElement, JSEvaluateContext.JSEvaluationPlace.DEFAULT, e -> this.addNamespace(new JSNamespaceImpl(JSQualifiedNameImpl.create(referencedName, null), JSContext.STATIC, false, true), (PsiElement)e));
            return;
        }
        JSTypeEvaluator.applyContextAndProcess(type, this.myContext, source, this.myTypeProcessor);
    }

    public static void applyContextAndProcess(@NotNull JSType _type, @NotNull JSEvaluateContext context, @Nullable PsiElement source, @NotNull JSTypeProcessor processor) {
        if (_type == null) {
            JSTypeEvaluator.$$$reportNull$$$0(10);
        }
        if (context == null) {
            JSTypeEvaluator.$$$reportNull$$$0(11);
        }
        if (processor == null) {
            JSTypeEvaluator.$$$reportNull$$$0(12);
        }
        if (_type instanceof JSEvaluableType) {
            _type = _type.substitute();
        }
        _type = JSDialectSpecificHandlersFactory.forElement((PsiElement)context.getProcessedExpression()).getGenericTypeEvaluator().evaluateGenerics(_type, (JSExpression)context.getProcessedExpression(), null);
        if (!context.isJSElementsToApplyEmpty()) {
            JSApplyContextElement pop = context.popJSElementToApply();
            if (pop instanceof JSApplyCallElement) {
                JSType returnType = JSTypeUtils.tryGetReturnType(_type, (JSApplyCallElement)pop);
                if (returnType == null) {
                    returnType = JSAnyType.get((PsiElement)((JSApplyCallElement)pop).getCallExpression(), false);
                }
                JSTypeEvaluator.applyContextAndProcess(returnType, context, null, processor);
            } else if (pop instanceof JSApplyPropertyElement) {
                JSApplyContextUtil.processDestructuringProperty((JSApplyPropertyElement)pop, _type, (newType, element) -> {
                    if (context == null) {
                        JSTypeEvaluator.$$$reportNull$$$0(114);
                    }
                    if (processor == null) {
                        JSTypeEvaluator.$$$reportNull$$$0(115);
                    }
                    JSTypeEvaluator.applyContextAndProcess(newType, context, element, processor);
                });
            } else if (pop instanceof JSApplyIndexedAccessElement) {
                JSApplyContextUtil.processDestructuringArray((JSApplyIndexedAccessElement)pop, _type, type -> {
                    if (context == null) {
                        JSTypeEvaluator.$$$reportNull$$$0(112);
                    }
                    if (processor == null) {
                        JSTypeEvaluator.$$$reportNull$$$0(113);
                    }
                    JSTypeEvaluator.applyContextAndProcess(type, context, null, processor);
                });
            } else if (pop instanceof JSApplyInstanceContextElement) {
                JSType returnType;
                JSNewExpression newExpression = ((JSApplyInstanceContextElement)pop).getNewExpression();
                boolean processed = false;
                if (newExpression != null && (returnType = JSTypeUtils.tryGetReturnType(_type, (JSApplyInstanceContextElement)pop)) != null) {
                    processed = true;
                    JSTypeEvaluator.applyContextAndProcess(returnType, context, source, processor);
                }
                if (!processed && _type instanceof JSNamedType && ((JSNamedType)_type).isStaticOrInstance() != JSContext.INSTANCE) {
                    _type = ((JSNamedType)_type).copyWithJSContext(JSContext.INSTANCE);
                    JSTypeEvaluator.applyContextAndProcess(_type, context, source, processor);
                }
            } else if (pop instanceof JSApplyStaticContextElement) {
                if (_type instanceof JSNamedType && ((JSNamedType)_type).isStaticOrInstance() != JSContext.STATIC) {
                    _type = ((JSNamedType)_type).copyWithJSContext(JSContext.STATIC);
                    JSTypeEvaluator.applyContextAndProcess(_type, context, source, processor);
                }
            } else if (pop instanceof JSApplyPromiseTypeElement) {
                JSTypeEvaluator.applyContextAndProcess(JSTypeUtils.wrapInPromiseType(_type), context, source, processor);
            }
            context.pushJSElementToApply(pop);
            return;
        }
        if (CommonJSUtil.isModuleType(_type)) {
            JSContext jsContext = _type instanceof JSNamedType ? ((JSNamedType)_type).isStaticOrInstance() : JSContext.UNKNOWN;
            PsiFile scope = _type.getSource().getScope();
            if (scope != null) {
                JSTypeEvaluator.addDefaultExportNamespaces((PsiElement)scope, jsContext, context, processor);
            }
        }
        JSType type2 = context.isTypeGuessed() && _type.getSource().isStrict() ? JSTypeUtils.copyWithStrictRecursive(_type, false) : _type;
        if ((type2 = JSCompositeTypeImpl.optimizeTypeIfComposite(type2, false)) instanceof JSFreshObjectLiteralType && context.getSource() instanceof JSVariable) {
            type2 = ((JSFreshObjectLiteralType)type2).removeFreshness();
        }
        processor.process(type2, context, source);
    }

    protected void addType(@NotNull String type, PsiElement source) {
        PsiElement scope;
        if (type == null) {
            JSTypeEvaluator.$$$reportNull$$$0(13);
        }
        if ((scope = source) == null) {
            scope = this.myTypeProcessor.getTarget();
        }
        if (scope == null) {
            scope = this.myContext.targetFile;
        }
        this.addType(JSNamedType.createType(type, JSTypeSourceFactory.createTypeSource(scope, false), JSContext.UNKNOWN), source);
    }

    protected void addNamespace(@NotNull JSNamespace namespace, @Nullable PsiElement source) {
        if (namespace == null) {
            JSTypeEvaluator.$$$reportNull$$$0(14);
        }
        JSTypeEvaluator.applyContextAndProcessNamespace(namespace, this.myContext, source, this.myTypeProcessor);
    }

    static void applyContextAndProcessNamespace(@NotNull JSNamespace namespace, @NotNull JSEvaluateContext context, @Nullable PsiElement source, @NotNull JSTypeProcessor processor) {
        List elementsToApply;
        if (namespace == null) {
            JSTypeEvaluator.$$$reportNull$$$0(15);
        }
        if (context == null) {
            JSTypeEvaluator.$$$reportNull$$$0(16);
        }
        if (processor == null) {
            JSTypeEvaluator.$$$reportNull$$$0(17);
        }
        List list = elementsToApply = context.isJSElementsToApplyEmpty() ? ContainerUtil.emptyList() : new SmartList();
        while (!context.isJSElementsToApplyEmpty()) {
            JSApplyContextElement peek = context.peekJSElementToApply();
            if (peek instanceof JSApplyInstanceContextElement) {
                namespace = JSNamespaceImpl.withContext(namespace, JSContext.INSTANCE);
            } else if (peek instanceof JSApplyStaticContextElement) {
                namespace = JSNamespaceImpl.withContext(namespace, JSContext.STATIC);
            } else {
                if (!(peek instanceof JSApplyPropertyElement)) break;
                String name = ((JSApplyPropertyElement)peek).getName();
                source = null;
                namespace = new JSNamespaceImpl(JSQualifiedNameImpl.create(name, namespace.getQualifiedName()), JSContext.STATIC, namespace.isExplicitlyDeclared());
            }
            elementsToApply.add(context.popJSElementToApply());
        }
        if (context.isJSElementsToApplyEmpty()) {
            JSSymbolNamespaceImpl symbolNamespace = new JSSymbolNamespaceImpl(namespace.getQualifiedName(), namespace.getJSContext(), namespace.isExplicitlyDeclared(), false, namespace.isLocal());
            processor.processNamespace(symbolNamespace, context, source);
        }
        for (int i = elementsToApply.size() - 1; i >= 0; --i) {
            context.pushJSElementToApply((JSApplyContextElement)elementsToApply.get(i));
        }
    }

    protected void evaluateTypes(JSExpression rawqualifier) {
        this.evaluateTypes(rawqualifier, JSEvaluateContext.JSEvaluationPlace.DEFAULT);
    }

    protected void evaluateTypes(JSExpression rawqualifier, @NotNull JSEvaluateContext.JSEvaluationPlace place) {
        if (place == null) {
            JSTypeEvaluator.$$$reportNull$$$0(18);
        }
        if (this.myTypeProcessor instanceof ResolveProcessor) {
            this.doEvaluateTypes(rawqualifier, place);
        } else {
            this.evaluateCachedTypes(rawqualifier);
        }
    }

    protected void doEvaluateTypes(JSExpression rawqualifier, @NotNull JSEvaluateContext.JSEvaluationPlace place) {
        JSPrefixExpression prefixExpression;
        JSType typecast;
        if (place == null) {
            JSTypeEvaluator.$$$reportNull$$$0(19);
        }
        if (rawqualifier != null && (typecast = JSDocumentationUtils.findTypeFromInlineComment((PsiElement)rawqualifier)) != null) {
            this.addType(typecast, null);
            return;
        }
        if (rawqualifier instanceof JSDefinitionExpression) {
            rawqualifier = ((JSDefinitionExpression)rawqualifier).getExpression();
        }
        if (rawqualifier instanceof JSReferenceExpression) {
            if (((JSReferenceExpression)rawqualifier).getQualifier() == null && rawqualifier.getNode().findChildByType(JSTokenTypes.UNDEFINED_KEYWORD) != null) {
                this.addType(new JSUndefinedType(JSTypeSourceFactory.createTypeSource((PsiElement)rawqualifier, true)), (PsiElement)rawqualifier);
                return;
            }
            this.processItem((JSReferenceExpression)rawqualifier, place, expression -> {
                JSReferenceExpression oldQualifier = this.myContext.getProcessedExpression();
                try {
                    this.myContext.setProcessedExpression((JSReferenceExpression)expression);
                    this.processRefExpr((JSReferenceExpression)expression);
                }
                finally {
                    this.myContext.setProcessedExpression(oldQualifier);
                }
            });
        } else if (rawqualifier instanceof JSNewExpression) {
            this.evaluateNewExpressionTypes((JSNewExpression)rawqualifier, place);
        } else if (rawqualifier instanceof JSCallExpression) {
            this.evaluateCallExpressionTypes((JSCallExpression)rawqualifier, place);
        } else if (rawqualifier instanceof ES6ImportCall) {
            this.evaluateES6ImportCall((ES6ImportCall)rawqualifier);
        } else if (rawqualifier instanceof JSPrefixExpression) {
            JSType promiseComponentType;
            JSType type;
            prefixExpression = (JSPrefixExpression)rawqualifier;
            IElementType sign = prefixExpression.getOperationSign();
            String evaluatedType = null;
            if (JSTokenTypes.EXCL == sign || JSTokenTypes.DELETE_KEYWORD == sign) {
                evaluatedType = "boolean";
            } else if (JSTokenTypes.PLUS == sign || JSTokenTypes.PLUSPLUS == sign || JSTokenTypes.TILDE == sign || JSTokenTypes.MINUSMINUS == sign || JSTokenTypes.MINUS == sign) {
                if (DialectDetector.isActionScript((PsiElement)rawqualifier)) {
                    type = JSResolveUtil.getExpressionJSType(prefixExpression.getExpression());
                    if (type != null) {
                        evaluatedType = type.getTypeText();
                    }
                } else {
                    evaluatedType = "number";
                }
            } else if (JSTokenTypes.TYPEOF_KEYWORD == sign) {
                evaluatedType = "string";
            } else if (JSTokenTypes.AWAIT_KEYWORD == sign && (type = JSResolveUtil.getExpressionJSType(prefixExpression.getExpression())) != null && (promiseComponentType = JSTypeUtils.getPromiseComponentTypeOrNull(type)) != null) {
                this.addType(promiseComponentType, (PsiElement)rawqualifier);
                return;
            }
            if (evaluatedType != null) {
                JSTypeSource source = JSTypeSourceFactory.createTypeSource((PsiElement)rawqualifier, true);
                JSType type2 = JSNamedType.createType(evaluatedType, source, JSContext.INSTANCE);
                this.addType(type2, (PsiElement)rawqualifier);
            } else {
                this.myTypeProcessor.setUnknownElement((PsiElement)rawqualifier);
            }
        } else if (rawqualifier instanceof JSPostfixExpression) {
            prefixExpression = (JSPostfixExpression)rawqualifier;
            IElementType sign = prefixExpression.getOperationSign();
            if (JSTokenTypes.PLUSPLUS == sign || JSTokenTypes.MINUSMINUS == sign) {
                if (DialectDetector.isActionScript((PsiElement)rawqualifier)) {
                    this.simpleEvalType(rawqualifier, prefixExpression.getExpression());
                } else {
                    JSTypeSource typeSource = JSTypeSourceFactory.createTypeSource((PsiElement)rawqualifier, false);
                    this.addType(new JSNumberType(true, typeSource, JSTypeContext.INSTANCE), (PsiElement)rawqualifier);
                }
            }
        } else if (rawqualifier instanceof JSBinaryExpression) {
            JSBinaryExpression binaryExpression = (JSBinaryExpression)rawqualifier;
            IElementType sign = binaryExpression.getOperationSign();
            JSExpression rOperand = binaryExpression.getROperand();
            JSExpression lOperand = binaryExpression.getLOperand();
            if (lOperand != null && rOperand != null) {
                if (sign == JSTokenTypes.AS_KEYWORD) {
                    this.resolveAsBinaryOperationExpression(rawqualifier, rOperand);
                } else if (JSTokenTypes.RELATIONAL_OPERATIONS.contains(sign) || JSTokenTypes.EQUALITY_OPERATIONS.contains(sign) || sign == JSTokenTypes.IS_KEYWORD) {
                    this.addType(new JSBooleanType(true, JSTypeSourceFactory.createTypeSource((PsiElement)rawqualifier, false), JSTypeContext.INSTANCE), null);
                } else if (JSTokenTypes.ADDITIVE_OPERATIONS.contains(sign) || JSTokenTypes.MULTIPLICATIVE_OPERATIONS.contains(sign) || sign == JSTokenTypes.ANDAND || sign == JSTokenTypes.OR || sign == JSTokenTypes.AND || sign == JSTokenTypes.XOR || sign == JSTokenTypes.OROR) {
                    if (sign == JSTokenTypes.DIV || (sign == JSTokenTypes.OR || sign == JSTokenTypes.AND || sign == JSTokenTypes.XOR || sign == JSTokenTypes.MINUS || JSTokenTypes.MULTIPLICATIVE_OPERATIONS.contains(sign)) && !DialectDetector.isActionScript((PsiElement)rawqualifier)) {
                        JSTypeSource typeSource = JSTypeSourceFactory.createTypeSource((PsiElement)rawqualifier, false);
                        this.addType(new JSNumberType(true, typeSource, JSTypeContext.INSTANCE), (PsiElement)rawqualifier);
                    } else {
                        JSType lProcType = JSTypeUtils.getValuableType(JSResolveUtil.getExpressionJSType(lOperand));
                        JSType rProcType = JSTypeUtils.getValuableType(JSResolveUtil.getExpressionJSType(rOperand));
                        if (sign == JSTokenTypes.OROR || sign == JSTokenTypes.ANDAND) {
                            if (lProcType != null) {
                                this.addType(lProcType, (PsiElement)rawqualifier);
                            }
                            if (rProcType != null) {
                                this.addType(rProcType, (PsiElement)rawqualifier);
                            }
                            if (lProcType == null && rProcType == null) {
                                this.myTypeProcessor.setUnknownElement((PsiElement)rawqualifier);
                            }
                        } else {
                            JSPrimitiveType evaluatedType = null;
                            JSTypeSource typeSource = JSTypeSourceFactory.createTypeSource((PsiElement)binaryExpression);
                            if (lProcType instanceof JSStringType || rProcType instanceof JSStringType) {
                                evaluatedType = new JSStringType(true, typeSource, JSTypeContext.INSTANCE);
                            } else if ((lProcType instanceof JSIntType || lProcType instanceof JSUintType) && (rProcType instanceof JSIntType || rProcType instanceof JSUintType)) {
                                evaluatedType = new JSIntType(true, typeSource, JSTypeContext.INSTANCE);
                            } else if ((lProcType instanceof JSNumberType || lProcType instanceof JSIntType || lProcType instanceof JSUintType) && (rProcType instanceof JSNumberType || rProcType instanceof JSIntType || rProcType instanceof JSUintType)) {
                                evaluatedType = new JSNumberType(true, typeSource, JSTypeContext.INSTANCE);
                            }
                            if (evaluatedType != null) {
                                this.addType(evaluatedType, (PsiElement)rawqualifier);
                            } else {
                                this.myTypeProcessor.setUnknownElement((PsiElement)rawqualifier);
                            }
                        }
                    }
                } else if (JSExtendedLanguagesTokenSetProvider.ASSIGNMENT_OPERATIONS.contains(sign)) {
                    JSTypeEvaluationResult result = null;
                    if (DialectDetector.isActionScript((PsiElement)rawqualifier)) {
                        result = JSTypeEvaluator.getExpressionType(lOperand);
                    }
                    if (result == null) {
                        result = JSTypeEvaluator.getExpressionType(rOperand);
                    }
                    if (result != null) {
                        for (JSTypeEvaluationResult.JSTypeEvaluationResultElement element : result.getResults()) {
                            this.addTypeEvaluationResultElement(element);
                        }
                    } else {
                        this.myTypeProcessor.setUnknownElement((PsiElement)rawqualifier);
                    }
                } else if (JSTokenTypes.SHIFT_OPERATIONS.contains(sign)) {
                    this.simpleEvalType(rawqualifier, lOperand);
                }
            }
        } else if (rawqualifier instanceof JSLiteralExpression) {
            this.addTypeFromLiteralExpression(rawqualifier);
        } else if (rawqualifier instanceof JSArrayLiteralExpression) {
            JSType type;
            JSExpression[] expressions = ((JSArrayLiteralExpression)rawqualifier).getExpressions();
            if (expressions.length > 0) {
                type = this.getArrayTypeFromExpressions(rawqualifier, expressions);
            } else {
                JSTypeSource typeSource = JSTypeSourceFactory.createTypeSource((PsiElement)rawqualifier, true);
                type = DialectDetector.isTypeScript((PsiElement)rawqualifier) ? new JSArrayTypeImpl(JSAnyType.get((PsiElement)rawqualifier, true), typeSource) : JSNamedType.createType("Array", typeSource, JSContext.INSTANCE);
            }
            this.addType(type, (PsiElement)rawqualifier);
            if (this.myTypeProcessor instanceof ResolveProcessor) {
                ((ResolveProcessor)((Object)this.myTypeProcessor)).execute((PsiElement)rawqualifier, ResolveState.initial());
            }
        } else if (rawqualifier instanceof JSIndexedPropertyAccessExpression) {
            this.addType(this.getIndexedPropertyAccessType((JSIndexedPropertyAccessExpression)rawqualifier), (PsiElement)rawqualifier);
        } else if (rawqualifier instanceof JSObjectLiteralExpression) {
            this.addTypeFromObjectLiteralExpression((JSObjectLiteralExpression)rawqualifier, this.isFromCurrentFile((PsiElement)rawqualifier));
        } else if (rawqualifier instanceof JSParenthesizedExpression) {
            this.evaluateTypes(((JSParenthesizedExpression)rawqualifier).getInnerExpression(), place);
        } else if (rawqualifier instanceof JSThisExpression) {
            this.processThisQualifierExpression((JSThisExpression)rawqualifier);
        } else if (rawqualifier instanceof JSSuperExpression) {
            JSClass jsClass = JSResolveUtil.getClassOfContext((PsiElement)rawqualifier);
            this.processSuperQualifierExpression((JSSuperExpression)rawqualifier, jsClass);
        } else if (rawqualifier instanceof JSFunctionExpression) {
            this.processFunction((JSFunction)((JSFunctionExpression)rawqualifier));
        } else if (rawqualifier instanceof JSConditionalExpression) {
            JSConditionalExpression conditionalExpression = (JSConditionalExpression)rawqualifier;
            JSExpression thenPart = conditionalExpression.getThen();
            JSExpression elsePart = conditionalExpression.getElse();
            JSType thenType = JSTypeEvaluator.getConditionalPartTypeOrAny((JSExpression)conditionalExpression, thenPart);
            JSType elseType = JSTypeEvaluator.getConditionalPartTypeOrAny((JSExpression)conditionalExpression, elsePart);
            if (thenType != null || elseType != null) {
                JSType common = null;
                if (elseType == null) {
                    common = thenType;
                }
                if (thenType == null) {
                    common = elseType;
                }
                if (common == null) {
                    common = thenType instanceof JSAnyType ? JSTypeEvaluator.replaceTypeSourceByNotStrict((JSExpression)conditionalExpression, elseType) : (elseType instanceof JSAnyType ? JSTypeEvaluator.replaceTypeSourceByNotStrict((JSExpression)conditionalExpression, thenType) : JSTypeUtils.getCommonType(thenType, elseType, DialectDetector.dialectOfElement((PsiElement)conditionalExpression), true));
                }
                this.addType(common, (PsiElement)conditionalExpression);
            }
        } else if (!this.evaluateDialectSpecificTypes(rawqualifier) && rawqualifier != null) {
            this.myTypeProcessor.setUnknownElement((PsiElement)rawqualifier);
        }
    }

    protected JSType getIndexedPropertyAccessType(@NotNull JSIndexedPropertyAccessExpression rawqualifier) {
        if (rawqualifier == null) {
            JSTypeEvaluator.$$$reportNull$$$0(20);
        }
        return this.addComponentTypeFromArrayExpression((JSExpression)rawqualifier, rawqualifier.getQualifier());
    }

    private void evaluateES6ImportCall(@NotNull ES6ImportCall importCall) {
        if (importCall == null) {
            JSTypeEvaluator.$$$reportNull$$$0(21);
        }
        this.myContext.pushJSElementToApply(JSApplyPromiseTypeElement.INSTANCE);
        for (PsiElement module : importCall.resolveReferencedElements()) {
            if (!(module instanceof JSFile)) continue;
            this.myTypeProcessor.processResolvedElement(module, this.myContext);
        }
    }

    private void processThisQualifierExpression(@NotNull JSThisExpression rawqualifier) {
        JSClass jsClass;
        if (rawqualifier == null) {
            JSTypeEvaluator.$$$reportNull$$$0(22);
        }
        if ((jsClass = JSResolveUtil.getClassOfContext((PsiElement)rawqualifier, true)) != null) {
            JSContext staticOrInstance = JSResolveUtil.calculateStaticFromContext((PsiElement)rawqualifier) ? JSContext.STATIC : JSContext.INSTANCE;
            this.processThisQualifierExpression(rawqualifier, jsClass, staticOrInstance);
        } else {
            PsiElement thisScope = JSPsiImplUtils.getExecutionScope((PsiElement)rawqualifier);
            this.processThisQualifierInExecutionScope(rawqualifier, thisScope);
        }
    }

    protected void processThisQualifierExpression(@NotNull JSThisExpression rawqualifier, @NotNull JSClass jsClass, @NotNull JSContext staticOrInstance) {
        String name;
        if (rawqualifier == null) {
            JSTypeEvaluator.$$$reportNull$$$0(23);
        }
        if (jsClass == null) {
            JSTypeEvaluator.$$$reportNull$$$0(24);
        }
        if (staticOrInstance == null) {
            JSTypeEvaluator.$$$reportNull$$$0(25);
        }
        if ((name = jsClass.getQualifiedName()) != null) {
            JSTypeSource typeSource = JSTypeSourceFactory.createTypeSource((PsiElement)rawqualifier, true);
            this.addType(this.createTypeForThisExpression(staticOrInstance, name, typeSource, DialectDetector.isTypeScript((PsiElement)rawqualifier)), (PsiElement)jsClass);
        }
    }

    @NotNull
    protected JSType createTypeForThisExpression(@NotNull JSContext staticOrInstance, @NotNull String name, @NotNull JSTypeSource typeSource, boolean isTypeScript) {
        if (staticOrInstance == null) {
            JSTypeEvaluator.$$$reportNull$$$0(26);
        }
        if (name == null) {
            JSTypeEvaluator.$$$reportNull$$$0(27);
        }
        if (typeSource == null) {
            JSTypeEvaluator.$$$reportNull$$$0(28);
        }
        JSType jSType = JSNamedType.createType(name, typeSource, staticOrInstance);
        if (jSType == null) {
            JSTypeEvaluator.$$$reportNull$$$0(29);
        }
        return jSType;
    }

    protected void processThisQualifierInExecutionScope(@NotNull JSThisExpression thisQualifier, PsiElement thisScope) {
        JSType type;
        if (thisQualifier == null) {
            JSTypeEvaluator.$$$reportNull$$$0(30);
        }
        if ((type = JSDocumentationUtils.findContextType(thisScope)) != null) {
            this.addType(type, null);
        } else {
            JSType thisType;
            JSNamespaceEvaluationResult thisNs = JSContextResolver.resolveContext((PsiElement)thisQualifier);
            JSType jSType = thisType = thisNs != null ? thisNs.toType((PsiElement)thisQualifier) : null;
            if (thisType != null) {
                this.addType(thisType, (PsiElement)thisQualifier);
            } else if (thisScope instanceof JSFunctionExpression && thisScope.getParent() instanceof JSArgumentList) {
                JSType funcType = JSTypeEvaluator.canEvaluateTypeOfType(thisScope) ? JSDialectSpecificHandlersFactory.findExpectedType((JSExpression)((JSFunctionExpression)thisScope), JSExpectedTypeKind.CONTEXTUAL) : null;
                if ((funcType = JSTypeUtils.getValuableType(funcType)) instanceof JSFunctionTypeImpl && (thisType = ((JSFunctionTypeImpl)funcType).getThisType()) != null) {
                    this.addType(thisType, (PsiElement)thisQualifier);
                }
            }
            if (thisType == null) {
                this.myTypeProcessor.setUnknownElement((PsiElement)thisQualifier);
            }
        }
    }

    private void resolveAsBinaryOperationExpression(JSExpression rawqualifier, JSExpression rOperand) {
        PsiElement resolve;
        boolean isClassCast = false;
        if (rOperand instanceof JSReferenceExpression && (resolve = ((JSReferenceExpression)rOperand).resolve()) instanceof JSVariable && "Class".equals(((JSVariable)resolve).getTypeString())) {
            isClassCast = true;
        }
        if (isClassCast) {
            this.addType("*", (PsiElement)rawqualifier);
        } else {
            JSTypeSource source = JSTypeSourceFactory.createTypeSource((PsiElement)rOperand);
            this.addType(JSTypeUtils.createType(JSImportHandlingUtil.resolveTypeName(rOperand.getText(), (PsiElement)rOperand), source), null);
        }
    }

    protected void processSuperQualifierExpression(JSSuperExpression rawqualifier, JSClass jsClass) {
        JSClass[] classes;
        if (jsClass != null && (classes = jsClass.getSuperClasses()).length > 0) {
            JSClass aClass = classes[0];
            this.addType(aClass.getQualifiedName(), (PsiElement)aClass);
        }
    }

    @NotNull
    private static JSType replaceTypeSourceByNotStrict(JSExpression conditionalExpression, JSType partType) {
        JSType jSType = JSTypeUtils.copyWithStrictRecursive(partType, false);
        if (jSType == null) {
            JSTypeEvaluator.$$$reportNull$$$0(31);
        }
        return jSType;
    }

    @Nullable
    private static JSType getConditionalPartTypeOrAny(JSExpression conditionalExpression, JSExpression part) {
        JSType partType = null;
        if (part != null && (partType = JSResolveUtil.getExpressionJSType(part)) == null) {
            partType = JSAnyType.get((PsiElement)conditionalExpression, false);
        }
        return partType;
    }

    @NotNull
    protected JSType getArrayTypeFromExpressions(JSExpression rawQualifier, JSExpression[] expressions) {
        DialectOptionHolder holder = DialectDetector.dialectOfElement((PsiElement)rawQualifier);
        List<JSTypeUtils.TypeProvider> providers = Arrays.stream(expressions).map(el -> () -> this.getExpressionTypeForArrayLiteral(rawQualifier, (JSExpression)el, holder)).collect(Collectors.toList());
        JSType commonType = JSTypeUtils.getCommonType(providers, (PsiElement)rawQualifier, true);
        JSArrayTypeImpl jSArrayTypeImpl = new JSArrayTypeImpl(commonType, JSTypeSourceFactory.createTypeSource((PsiElement)rawQualifier, true));
        if (jSArrayTypeImpl == null) {
            JSTypeEvaluator.$$$reportNull$$$0(32);
        }
        return jSArrayTypeImpl;
    }

    @Nullable
    protected JSType getExpressionTypeForArrayLiteral(JSExpression rawqualifier, JSExpression expression, DialectOptionHolder holder) {
        JSType exprType;
        boolean isTypeScript = holder != null && holder.isTypeScript;
        JSType jSType = exprType = expression != null ? JSTypeEvaluator.getTypeFromConstant(expression) : this.createNullType(rawqualifier);
        if (exprType != null && !isTypeScript) {
            exprType = JSTypeUtils.getNonValueType(exprType);
        }
        if (exprType == null && isTypeScript) {
            if (expression instanceof JSObjectLiteralExpression) {
                exprType = this.getObjectLiteralType((JSObjectLiteralExpression)expression, true);
            }
            if (exprType == null) {
                exprType = new JSTypeofTypeImpl(expression, JSTypeSourceFactory.createTypeSource((PsiElement)expression, true));
            }
        }
        return this.widenExpressionTypeByContextualType(expression, isTypeScript, exprType);
    }

    @Nullable
    protected JSType widenExpressionTypeByContextualType(JSExpression expression, boolean isTypeScript, JSType exprType) {
        return JSTypeUtils.expandEnumLiteralIfNeeded(JSTypeUtils.widenLiteralTypes(exprType));
    }

    @NotNull
    protected JSType createNullType(JSExpression rawqualifier) {
        JSType jSType = JSNamedType.createType("null", JSTypeSourceFactory.createTypeSource((PsiElement)rawqualifier, true), JSContext.INSTANCE);
        if (jSType == null) {
            JSTypeEvaluator.$$$reportNull$$$0(33);
        }
        return jSType;
    }

    protected boolean evaluateDialectSpecificTypes(JSExpression rawqualifier) {
        return false;
    }

    protected void evaluateNewExpressionTypes(JSNewExpression newExpression, @NotNull JSEvaluateContext.JSEvaluationPlace place) {
        if (place == null) {
            JSTypeEvaluator.$$$reportNull$$$0(34);
        }
        JSExpression methodExpr = newExpression.getMethodExpression();
        this.myContext.processWithJSElementToApply(new JSApplyInstanceContextElement(newExpression), () -> {
            if (place == null) {
                JSTypeEvaluator.$$$reportNull$$$0(111);
            }
            this.evaluateTypes(methodExpr, place);
        });
    }

    protected void evaluateCallExpressionTypes(@NotNull JSCallExpression callExpression, @NotNull JSEvaluateContext.JSEvaluationPlace place) {
        JSExpression methodExpression;
        if (callExpression == null) {
            JSTypeEvaluator.$$$reportNull$$$0(35);
        }
        if (place == null) {
            JSTypeEvaluator.$$$reportNull$$$0(36);
        }
        if ((methodExpression = callExpression.getMethodExpression()) instanceof JSReferenceExpression) {
            boolean isTypeScript;
            JSReferenceExpression invoked = (JSReferenceExpression)methodExpression;
            String referencedName = invoked.getReferenceName();
            DialectOptionHolder dialect = DialectDetector.dialectOfFile(callExpression.getContainingFile());
            boolean bl = isTypeScript = dialect != null && dialect.isTypeScript;
            if ("create".equals(referencedName) && dialect != null && dialect.isJavaScript()) {
                boolean processed = this.processCreateMethodCall(callExpression, invoked);
                if (processed) {
                    return;
                }
            } else if (!isTypeScript && ("apply".equals(referencedName) || "call".equals(referencedName))) {
                methodExpression = this.processApplyOrCallMethodCall(methodExpression, invoked);
            } else if (!isTypeScript && ("reduce".equals(referencedName) || "reduceRight".equals(referencedName))) {
                methodExpression = JSTypeEvaluator.processReduceMethodCall(methodExpression, invoked);
            } else {
                if (this.processRequireMethodCall(callExpression, invoked, isTypeScript)) {
                    return;
                }
                if (JSGclReferenceContributor.isGoogRequireCall(methodExpression)) {
                    this.addTypeFromGclRequireCall(callExpression);
                    return;
                }
            }
        }
        JSApplyContextElement elementToApply = callExpression instanceof JSNewExpression ? new JSApplyInstanceContextElement((JSNewExpression)callExpression) : new JSApplyCallElement(callExpression);
        JSExpression finalMethodExpression = methodExpression;
        this.myContext.processWithJSElementToApply(elementToApply, () -> {
            if (place == null) {
                JSTypeEvaluator.$$$reportNull$$$0(110);
            }
            this.evaluateTypes(finalMethodExpression, place);
        });
    }

    private void addTypeFromGclRequireCall(@NotNull JSCallExpression callExpression) {
        JSExpression[] arguments;
        boolean typeGuessed;
        if (callExpression == null) {
            JSTypeEvaluator.$$$reportNull$$$0(37);
        }
        if (!(typeGuessed = this.myContext.isTypeGuessed()) && DialectDetector.isTypeScript((PsiElement)callExpression)) {
            this.myContext.setTypeIsGuessed(true);
        }
        if ((arguments = callExpression.getArguments()).length > 0 && arguments[0] instanceof JSLiteralExpression) {
            for (PsiReference reference : arguments[0].getReferences()) {
                ResolveResult[] results;
                if (!(reference instanceof JSGclModuleReference)) continue;
                for (ResolveResult result : results = ((JSGclModuleReference)reference).multiResolve(false)) {
                    PsiFile file;
                    PsiElement element = result.getElement();
                    if (element == null || !((file = element.getContainingFile()) instanceof JSFile)) continue;
                    this.addTypeFromModuleFile((JSFile)file);
                }
            }
        }
        this.myContext.setTypeIsGuessed(typeGuessed);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean processRequireMethodCall(@NotNull JSCallExpression callExpression, @Nullable JSReferenceExpression invoked, boolean isTypeScript) {
        Collection<PsiElement> modules;
        if (callExpression == null) {
            JSTypeEvaluator.$$$reportNull$$$0(38);
        }
        if (!(modules = CommonJSUtil.findReferencedModulesIfRequireCall(callExpression)).isEmpty()) {
            JSReferenceExpression previousProcessedExpression = this.myContext.getProcessedExpression();
            try {
                boolean oldIsTypeGuessed = this.myContext.isTypeGuessed();
                if (isTypeScript) {
                    this.myContext.setTypeIsGuessed(true);
                }
                this.myContext.setProcessedExpression(invoked);
                for (PsiElement module : modules) {
                    this.addModuleFromRequire(module, callExpression);
                }
                if (isTypeScript) {
                    this.myContext.setTypeIsGuessed(oldIsTypeGuessed);
                }
            }
            finally {
                this.myContext.setProcessedExpression(previousProcessedExpression);
            }
            return true;
        }
        return false;
    }

    private static JSExpression processReduceMethodCall(JSExpression methodExpression, JSReferenceExpression invoked) {
        JSExpression[] expressions;
        JSExpression qualifier = invoked.getQualifier();
        if (qualifier instanceof JSArrayLiteralExpression && (expressions = ((JSArrayLiteralExpression)qualifier).getExpressions()).length > 0 && expressions[0] != null) {
            return expressions[0];
        }
        return methodExpression;
    }

    private JSExpression processApplyOrCallMethodCall(@NotNull JSExpression methodExpression, @NotNull JSReferenceExpression invoked) {
        JSExpression qualifier;
        if (methodExpression == null) {
            JSTypeEvaluator.$$$reportNull$$$0(39);
        }
        if (invoked == null) {
            JSTypeEvaluator.$$$reportNull$$$0(40);
        }
        if ((qualifier = invoked.getQualifier()) != null) {
            Ref referencesLib = Ref.create((Object)false);
            this.processItem(qualifier, JSEvaluateContext.JSEvaluationPlace.CALL_FUNCTION, ref -> {
                ResolveResult[] results;
                if (invoked == null) {
                    JSTypeEvaluator.$$$reportNull$$$0(109);
                }
                for (ResolveResult result : results = invoked.multiResolve(false)) {
                    String fileName;
                    PsiElement element = result.getElement();
                    if (element == null || !"ECMAScript.js2".equals(fileName = element.getContainingFile().getName()) && !JSCorePredefinedLibrariesProvider.isECMAScriptLibraryFileName(fileName) && !TypeScriptLibraryProvider.LIBS_D_TS.contains(fileName)) continue;
                    referencesLib.set((Object)true);
                    return;
                }
            });
            if (((Boolean)referencesLib.get()).booleanValue()) {
                return qualifier;
            }
        }
        return methodExpression;
    }

    private boolean processCreateMethodCall(@NotNull JSCallExpression callExpression, @NotNull JSReferenceExpression invoked) {
        if (callExpression == null) {
            JSTypeEvaluator.$$$reportNull$$$0(41);
        }
        if (invoked == null) {
            JSTypeEvaluator.$$$reportNull$$$0(42);
        }
        Ref processed = Ref.create((Object)false);
        this.processItem(invoked, JSEvaluateContext.JSEvaluationPlace.REFERENCE_EXPRESSION, ref -> {
            JSExpression[] arguments;
            JSExpression firstArgument;
            JSType type;
            JSFunctionItem functionItem;
            if (callExpression == null) {
                JSTypeEvaluator.$$$reportNull$$$0(108);
            }
            boolean hasExplicitReturnType = false;
            PsiElement resolve = ref.resolve();
            if (resolve != null && (functionItem = JSPsiImplUtils.calculatePossibleFunction(resolve, (PsiElement)ref)) != null && JSTypeUtils.isStrictType(type = functionItem.getReturnType())) {
                hasExplicitReturnType = true;
            }
            JSExpression jSExpression = firstArgument = (arguments = callExpression.getArguments()).length > 0 ? arguments[0] : null;
            if (!hasExplicitReturnType && (firstArgument instanceof JSLiteralExpression && ((JSLiteralExpression)firstArgument).isQuotedLiteral() || firstArgument instanceof JSReferenceExpression)) {
                String typeString;
                String string = typeString = firstArgument instanceof JSReferenceExpression ? JSQualifiedNameImpl.toString(JSSymbolUtil.getAccurateReferenceName((PsiQualifiedReference)((JSReferenceExpression)firstArgument))) : (String)((JSLiteralExpression)firstArgument).getValue();
                if (typeString != null) {
                    JSType type2 = JSNamedType.createType(typeString, JSTypeSourceFactory.createTypeSource((PsiElement)firstArgument), JSTypeContext.UNKNOWN);
                    this.addType(type2, (PsiElement)firstArgument);
                }
                processed.set((Object)true);
            }
        });
        return Boolean.TRUE.equals(processed.get());
    }

    protected void addModuleFromRequire(PsiElement element, JSCallExpression callExpression) {
        JSTypeEvaluator.processWithEvaluationGuard(element, JSEvaluateContext.JSEvaluationPlace.EXTERNAL_MODULE, module -> this.addTypeFromExternalModuleReferenceResolveResult((PsiElement)module));
    }

    protected void addTypeFromExternalModuleReferenceResolveResult(@Nullable PsiElement resolve) {
        if (resolve == null) {
            return;
        }
        if (resolve instanceof JSFile) {
            this.addTypeFromModuleFile((JSFile)resolve);
        } else if (resolve instanceof JsonFile) {
            this.applyContextAndProcessResolvedElement(resolve);
        } else if (resolve instanceof StylesheetFile) {
            this.myTypeProcessor.processResolvedElement(resolve, this.myContext);
        } else {
            this.addTypeFromResolveResult(resolve, false);
        }
    }

    private void addTypeFromModuleFile(@NotNull JSFile jsFile) {
        JSType innerAlias;
        PsiFile placeFile;
        if (jsFile == null) {
            JSTypeEvaluator.$$$reportNull$$$0(43);
        }
        this.applyContextAndProcessResolvedElement((PsiElement)jsFile);
        JSPsiElementBase exportedElement = JSResolveUtil.getExportedElement(jsFile);
        JSReferenceExpression place = this.myContext.getProcessedExpression();
        PsiFile psiFile = placeFile = place != null ? place.getContainingFile() : null;
        if (exportedElement == null && jsFile.hasES6Syntax() && placeFile instanceof JSFile && DialectDetector.isJavaScript((PsiElement)placeFile) && !((JSFile)placeFile).hasES6Syntax()) {
            JSElement defaultExport = ES6PsiUtil.findDefaultExport((PsiElement)jsFile);
            if (defaultExport instanceof ES6ExportDefaultAssignment) {
                String reference = ((ES6ExportDefaultAssignment)defaultExport).getInitializerReference();
                if (reference != null) {
                    PsiElement localResolve = JSStubBasedPsiTreeUtil.resolveLocally(reference, (PsiElement)defaultExport);
                    if (localResolve != null) {
                        exportedElement = localResolve;
                    }
                } else {
                    JSElement element2 = ((ES6ExportDefaultAssignment)defaultExport).getStubSafeElement();
                    if (element2 != null) {
                        exportedElement = element2;
                    }
                }
            } else if (defaultExport != null) {
                exportedElement = defaultExport;
            }
        }
        if (exportedElement != null) {
            JSTypeEvaluator.processWithEvaluationGuard(exportedElement, JSEvaluateContext.JSEvaluationPlace.EXPORTED_ELEMENT, element -> {
                if (jsFile == null) {
                    JSTypeEvaluator.$$$reportNull$$$0(107);
                }
                this.myContext.withLocalScope((PsiElement)jsFile, () -> this.addTypeFromResolveResult((PsiElement)element, false));
            });
        }
        if ((innerAlias = jsFile.getExportsInnerAlias()) != null) {
            JSPsiElementBase finalExportedElement = exportedElement;
            JSApplyContextUtil.applyTypeToContext(innerAlias, this.myContext, (arg_0, arg_1) -> this.lambda$addTypeFromModuleFile$17((PsiElement)finalExportedElement, jsFile, arg_0, arg_1));
        }
    }

    private static void addDefaultExportNamespaces(@NotNull PsiElement source, @NotNull JSContext jsContext, @NotNull JSEvaluateContext context, @NotNull JSTypeProcessor processor) {
        if (source == null) {
            JSTypeEvaluator.$$$reportNull$$$0(44);
        }
        if (jsContext == null) {
            JSTypeEvaluator.$$$reportNull$$$0(45);
        }
        if (context == null) {
            JSTypeEvaluator.$$$reportNull$$$0(46);
        }
        if (processor == null) {
            JSTypeEvaluator.$$$reportNull$$$0(47);
        }
        JSNamespaceImpl moduleExports = new JSNamespaceImpl(JSQualifiedNameImpl.fromComponents("module", "exports"), jsContext, true);
        JSTypeEvaluator.applyContextAndProcessNamespace(moduleExports, context, source, processor);
        JSNamespaceImpl exports = new JSNamespaceImpl(JSQualifiedNameImpl.create("exports", null), jsContext, true);
        JSTypeEvaluator.applyContextAndProcessNamespace(exports, context, source, processor);
    }

    protected boolean processFunction(@NotNull JSFunction function) {
        boolean hasSomeType;
        JSApplyContextElement elementToApply;
        boolean inCall;
        if (function == null) {
            JSTypeEvaluator.$$$reportNull$$$0(48);
        }
        boolean bl = inCall = (elementToApply = this.myContext.peekJSElementToApply()) instanceof JSApplyCallElement || elementToApply instanceof JSApplyInstanceContextElement && ((JSApplyInstanceContextElement)elementToApply).getNewExpression() != null;
        if (function.isGetProperty()) {
            JSType returnType = JSFunctionImpl.getReturnTypeInContext(function, (PsiElement)this.myContext.getProcessedExpression());
            if (returnType != null) {
                this.addType(returnType, null);
            }
            hasSomeType = returnType != null;
        } else if (function.isSetProperty()) {
            JSType parameterType = JSResolveUtil.getTypeFromSetAccessor((JSFunctionItem)function);
            if (parameterType != null) {
                this.addType(parameterType, null);
            }
            hasSomeType = parameterType != null;
        } else if (!inCall) {
            JSTypeSource source = JSTypeSourceFactory.createTypeSource((PsiElement)function);
            if (source.getLanguage() == JSTypeSource.SourceLanguage.TS) {
                this.addType(TypeScriptTypeParser.buildFunctionType(function), (PsiElement)function);
            } else if (this.isFromCurrentFile((PsiElement)function) && JSPsiImplUtils.isArrowFunction(function)) {
                JSExpression returned = JSPsiImplUtils.tryGetArrowFunctionReturnExpression(function);
                SmartList parameterTypes = new SmartList();
                for (JSParameterListElement parameter : function.getParameters()) {
                    parameterTypes.add(parameter.getTypeDecorator());
                }
                JSTypeSource explicitlyDeclaredSource = JSTypeSourceFactory.createTypeSource((PsiElement)function, true);
                JSFunctionTypeImpl type = new JSFunctionTypeImpl(explicitlyDeclaredSource, (List<JSParameterTypeDecorator>)parameterTypes, JSResolveUtil.getExpressionJSType(returned));
                this.addType(type, (PsiElement)function);
            } else {
                String name;
                JSType functionType = source.getLanguage() == JSTypeSource.SourceLanguage.JS ? ((name = function.getQualifiedName()) != null ? JSNamedType.createType(name, source, JSContext.STATIC) : JSNamedType.createType("Function", source, JSContext.INSTANCE)) : JSNamedType.createType("Function", source, JSContext.INSTANCE);
                this.addType(functionType, (PsiElement)function);
                if (this.myContext.peekJSElementToApply() instanceof JSApplyInstanceContextElement) {
                    this.addType(JSNamedType.createType("Object", source, JSContext.STATIC), (PsiElement)function);
                }
            }
            hasSomeType = true;
        } else {
            hasSomeType = this.myContext.processWithoutTopJSElementToApply((Processor<JSApplyContextElement>)((Processor)pop -> {
                if (function == null) {
                    JSTypeEvaluator.$$$reportNull$$$0(104);
                }
                boolean hasSomeTypeInner = false;
                JSType jsType = null;
                Object callExpression = pop instanceof JSApplyCallElement ? ((JSApplyCallElement)pop).getCallExpression() : ((JSApplyInstanceContextElement)pop).getNewExpression();
                boolean isNewCall = callExpression instanceof JSNewExpression;
                if (isNewCall) {
                    JSClass parentClass;
                    if (function.isConstructor() && (parentClass = JSUtils.getMemberContainingClass((PsiElement)function)) != null) {
                        String qName = parentClass.getQualifiedName();
                        if (qName != null) {
                            JSType type = JSNamedType.createType(qName, JSTypeSourceFactory.createTypeSource((PsiElement)parentClass, false), JSContext.INSTANCE);
                            this.addType(type, (PsiElement)parentClass);
                            hasSomeTypeInner = true;
                        }
                    } else if (function instanceof JSFunctionExpression && function.getName() == null && function.getParent() instanceof ES6ExportDefaultAssignment) {
                        jsType = JSNamedType.createExplicitlyDeclaredType("\"default\"", (PsiElement)function);
                    } else {
                        String name = JSTypeEvaluator.getElementQName((JSNamedElement)function);
                        if (name != null) {
                            jsType = JSNamedType.createType(name, JSTypeSourceFactory.createTypeSource((PsiElement)function), JSTypeContext.INSTANCE);
                        }
                    }
                } else {
                    jsType = JSFunctionImpl.getReturnTypeInContext(function, (PsiElement)this.myContext.getProcessedExpression());
                    if (!JSTypeUtils.isRestrictiveType(jsType) && !DialectDetector.isTypeScript((PsiElement)function)) {
                        Collection<JSObjectLiteralExpression> objectLiterals = JSStubBasedPsiTreeUtil.findReturnedExpressions(function, JSObjectLiteralExpression.class);
                        for (JSObjectLiteralExpression objectLiteral : objectLiterals) {
                            this.addTypeFromObjectLiteralExpression(objectLiteral, false);
                        }
                        if (!objectLiterals.isEmpty()) {
                            jsType = null;
                        }
                    }
                }
                if (jsType != null) {
                    JSExpression methodExpression = callExpression != null ? callExpression.getMethodExpression() : null;
                    jsType = JSDialectSpecificHandlersFactory.forElement((PsiElement)methodExpression).getGenericTypeEvaluator().evaluateGenerics(jsType, methodExpression, (PsiElement)function);
                    this.addType(jsType, null);
                    hasSomeTypeInner = true;
                }
                return hasSomeTypeInner;
            }));
        }
        return hasSomeType;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processRefExpr(@NotNull JSReferenceExpression expression) {
        JSNamespaceEvaluationResult ns;
        JSExpression qualifier;
        JSExpression exprQualifier;
        String referenceName;
        if (expression == null) {
            JSTypeEvaluator.$$$reportNull$$$0(49);
        }
        if ("prototype".equals(referenceName = expression.getReferenceName()) && !DialectDetector.isTypeScript((PsiElement)expression) && (exprQualifier = expression.getQualifier()) instanceof JSReferenceExpression) {
            this.myContext.processWithJSElementToApply(JSApplyInstanceContextElement.INSTANCE, () -> this.processRefExpr((JSReferenceExpression)exprQualifier));
            return;
        }
        if ("constructor".equals(referenceName) && DialectDetector.isJavaScript((PsiElement)expression) && (qualifier = expression.getQualifier()) != null) {
            this.myContext.processWithJSElementToApply(JSApplyStaticContextElement.INSTANCE, () -> this.evaluateTypes(qualifier));
            return;
        }
        if (JSSymbolUtil.isExplicitExportReference(expression) && DialectDetector.isJavaScript((PsiElement)expression)) {
            JSTypeEvaluator.addDefaultExportNamespaces((PsiElement)expression, JSContext.STATIC, this.myContext, this.myTypeProcessor);
            return;
        }
        boolean unqualified = expression.getQualifier() == null;
        ResolveResult[] resolveResults = this.getResolveResultsFromQualifier(expression);
        boolean hasSomeType = false;
        if (unqualified && (ns = this.evaluateNamespaceLocally(expression)) != null) {
            ns = ns.withExplicitlyDeclared(false);
            this.addNamespace(ns, (PsiElement)expression);
            JSElement exprForClassExtending = ns.getSource();
            if (exprForClassExtending instanceof JSReferenceExpression) {
                this.addAdditionalTypes((JSReferenceExpression)exprForClassExtending, (JSReferenceExpression)exprForClassExtending);
            }
            hasSomeType = true;
        }
        if (resolveResults.length > 0 && !JSTypeEvaluator.shouldSkipProcessing(resolveResults)) {
            boolean wasGuessed = this.myContext.isTypeGuessed();
            JSReferenceExpression previousProcessedExpression = this.myContext.getProcessedExpression();
            try {
                this.myContext.setTypeIsGuessed(wasGuessed || !JSResolveUtil.isResolveStrict(expression) || resolveResults.length > 1 && !JSTypeEvaluator.isTypeScriptDeclarationMerging(resolveResults));
                this.myContext.setProcessedExpression(expression);
                for (ResolveResult r : resolveResults) {
                    PsiElement element = r.getElement();
                    if (element == null) continue;
                    hasSomeType &= this.addTypeFromResolveResult(element, hasSomeType);
                }
            }
            finally {
                this.myContext.setTypeIsGuessed(wasGuessed);
                this.myContext.setProcessedExpression(previousProcessedExpression);
            }
        }
        if (!DialectDetector.isActionScript((PsiElement)expression)) {
            JSReferenceExpression localQualifier = JSUtils.findRefExprThatStartCallChaining(expression);
            JSNamespaceEvaluationResult ns2 = JSSymbolUtil.evaluateNamespaceLocally(localQualifier);
            if (ns2 != null && ns2.getSource() instanceof JSReferenceExpression) {
                localQualifier = (JSReferenceExpression)ns2.getSource();
            }
            hasSomeType |= this.addAdditionalTypes(localQualifier, expression);
        }
        if (resolveResults.length == 0 && !hasSomeType) {
            JSType typeFromReferenceExpression = JSSymbolUtil.createTypeFromReferenceExpression(expression, JSTypeContext.STATIC);
            if (typeFromReferenceExpression != null && this.myContext.peekJSElementToApply() instanceof JSApplyInstanceContextElement) {
                this.addType(typeFromReferenceExpression, (PsiElement)expression);
            } else {
                this.myTypeProcessor.setUnknownElement((PsiElement)expression);
            }
        }
    }

    @NotNull
    protected ResolveResult[] getResolveResultsFromQualifier(@NotNull JSReferenceExpression qualifier) {
        if (qualifier == null) {
            JSTypeEvaluator.$$$reportNull$$$0(50);
        }
        ResolveResult[] resolveResultArray = qualifier.multiResolve(false);
        if (resolveResultArray == null) {
            JSTypeEvaluator.$$$reportNull$$$0(51);
        }
        return resolveResultArray;
    }

    @Nullable
    protected JSNamespaceEvaluationResult evaluateNamespaceLocally(@NotNull JSReferenceExpression expression) {
        if (expression == null) {
            JSTypeEvaluator.$$$reportNull$$$0(52);
        }
        return DialectDetector.isTypeScript((PsiElement)expression) ? null : JSSymbolUtil.evaluateNamespaceLocally(expression);
    }

    private static boolean shouldSkipProcessing(@NotNull ResolveResult[] resolveResults) {
        if (resolveResults == null) {
            JSTypeEvaluator.$$$reportNull$$$0(53);
        }
        if (resolveResults.length < 20) {
            return false;
        }
        return !JSTypeEvaluator.isTypeScriptDeclarationMerging(resolveResults);
    }

    private static boolean isTypeScriptDeclarationMerging(@NotNull ResolveResult[] resolveResults) {
        if (resolveResults == null) {
            JSTypeEvaluator.$$$reportNull$$$0(54);
        }
        for (ResolveResult result : resolveResults) {
            PsiElement element = result.getElement();
            if (element instanceof TypeScriptModule || element instanceof TypeScriptInterface || element instanceof TypeScriptFunction || element instanceof TypeScriptClass || element instanceof JSLocalImplicitElementImpl) continue;
            return false;
        }
        return true;
    }

    protected boolean addTypeFromResolveResult(@NotNull PsiElement resolveResult, boolean hasSomeType) {
        if (resolveResult == null) {
            JSTypeEvaluator.$$$reportNull$$$0(55);
        }
        this.myContext.setSource(resolveResult);
        for (FrameworkIndexingHandler handler : (FrameworkIndexingHandler[])FrameworkIndexingHandler.EP_NAME.getExtensions()) {
            if (!handler.addTypeFromResolveResult(this, resolveResult, hasSomeType)) continue;
            return true;
        }
        if (resolveResult instanceof JSFieldVariable) {
            this.addTypeFromVariableResolveResult((JSFieldVariable)resolveResult);
        } else {
            hasSomeType = this.addTypeFromElementResolveResult(resolveResult, hasSomeType);
        }
        return hasSomeType;
    }

    private void addVariableTypeWithTypeGuard(@Nullable PsiElement resolvedElement, @Nullable JSReferenceExpression expression, @Nullable JSType variableType, @Nullable PsiElement source) {
        if (resolvedElement instanceof JSFieldVariable && expression != null) {
            variableType = this.getTypeFromTypeGuard((JSFieldVariable)resolvedElement, expression, variableType);
        }
        this.addType(variableType, source);
    }

    protected void addTypeFromVariableResolveResult(@NotNull JSFieldVariable jsVariable) {
        boolean haveExplicitType;
        JSResolvedTypeInfo resolvedType;
        if (jsVariable == null) {
            JSTypeEvaluator.$$$reportNull$$$0(56);
        }
        JSReferenceExpression expression = this.myContext.getProcessedExpression();
        boolean wasGuessed = this.myContext.isTypeGuessed();
        int jsElementsToApplySize = this.myContext.getJSElementsToApply().size();
        JSType variableType = jsVariable.getType();
        boolean isDestructuringType = variableType instanceof JSDestructuringTypeImpl;
        if (isDestructuringType) {
            variableType = null;
        }
        if (variableType == null && jsVariable instanceof JSParameter && this.isFromCurrentFile((PsiElement)jsVariable)) {
            if (this.addTypeFromAmdModuleReference((JSParameter)jsVariable)) {
                return;
            }
            JSType jSType = variableType = JSTypeEvaluator.canEvaluateTypeOfType((PsiElement)jsVariable) ? JSContextTypeEvaluator.getParameterType((JSParameter)jsVariable, this.myContext, JSExpectedTypeKind.CONTEXTUAL) : null;
        }
        if (jsVariable instanceof JSParameter && ((JSParameter)jsVariable).isRest()) {
            JSTypeSource typeSource = variableType != null ? variableType.getSource() : JSTypeSourceFactory.createTypeSource((PsiElement)jsVariable, ((JSParameter)jsVariable).getTypeDecorator().isExplicitlyDeclared());
            variableType = new JSArrayTypeImpl(variableType, typeSource);
        }
        if ((variableType = this.substituteThisType(variableType, jsVariable)) instanceof JSResolvableType && (resolvedType = ((JSResolvableType)variableType).resolveType()) != null && resolvedType.isEnum()) {
            variableType = this.modifyTypeForEnumType((JSResolvableType)variableType, jsVariable);
        }
        if (haveExplicitType = this.useVariableType(variableType)) {
            this.addVariableTypeWithTypeGuard((PsiElement)jsVariable, expression, variableType, EXPLICIT_TYPE_MARKER_ELEMENT);
        }
        if (!haveExplicitType) {
            JSFunctionExpression functionExpression;
            JSFunctionExpression jSFunctionExpression = functionExpression = jsVariable instanceof JSVariable ? ((JSVariable)jsVariable).tryGetFunctionExpressionInitializer() : null;
            if (functionExpression != null) {
                this.processFunction((JSFunction)functionExpression);
            } else if (this.isFromCurrentFile((PsiElement)jsVariable)) {
                JSExpression initializer;
                boolean isTypeScript = DialectDetector.isTypeScript((PsiElement)jsVariable);
                int sizeBefore = this.myContext.getJSElementsToApply().size();
                Condition condition = owner -> {
                    if (isTypeScript) {
                        if (JSDestructuringUtil.isDestructuring(owner.getParent())) {
                            return false;
                        }
                        if (owner instanceof JSTypeDeclarationOwner && ((JSTypeDeclarationOwner)owner).getTypeElement() != null) {
                            return true;
                        }
                    }
                    return owner.getInitializer() != null;
                };
                JSInitializerOwner initializerOwner = JSDestructuringUtil.findDestructuringParent((JSElement)jsVariable, this.myContext, (Condition<JSInitializerOwner>)condition);
                JSExpression jSExpression = initializer = initializerOwner != null ? initializerOwner.getInitializer() : null;
                if (isTypeScript && initializerOwner instanceof JSTypeDeclarationOwner && ((JSTypeDeclarationOwner)initializerOwner).getTypeElement() != null) {
                    this.myContext.setTypeIsGuessed(!isDestructuringType);
                    this.addVariableTypeWithTypeGuard((PsiElement)jsVariable, expression, ((JSTypeDeclarationOwner)initializerOwner).getType(), (PsiElement)initializerOwner);
                } else if (initializer != null) {
                    if (!isTypeScript && expression != null) {
                        this.addVariableTypeWithTypeGuard((PsiElement)jsVariable, expression, null, EXPLICIT_TYPE_MARKER_ELEMENT);
                    }
                    this.addTypeFromInitializer(initializer, isDestructuringType);
                } else if (variableType == null && jsVariable instanceof JSVariable && JSPsiImplUtils.isForStatementDeclaration((JSVariable)jsVariable)) {
                    PsiElement forOf = JSResolveUtil.findParent((PsiElement)jsVariable);
                    variableType = this.addLoopVariable(expression, (PsiElement)jsVariable, (JSForInStatement)forOf);
                } else if (expression != null) {
                    boolean hasSomeInfoAboutVar = false;
                    if (expression.getQualifier() == null && !DialectDetector.isTypeScript((PsiElement)expression)) {
                        SinkResolveProcessor<ResolveResultSink> processor = new SinkResolveProcessor<ResolveResultSink>(expression.getText(), true, new ResolveResultSink(null, expression.getText()));
                        hasSomeInfoAboutVar = this.findDef(expression, processor);
                    }
                    if (!hasSomeInfoAboutVar && variableType == null) {
                        JSType guardType = this.getTypeFromTypeGuard(jsVariable, expression, null);
                        if (guardType != null) {
                            this.addType(guardType, EXPLICIT_TYPE_MARKER_ELEMENT);
                        } else {
                            this.myTypeProcessor.setUnknownElement((PsiElement)jsVariable);
                        }
                    }
                }
                while (this.myContext.getJSElementsToApply().size() > sizeBefore) {
                    this.myContext.popJSElementToApply();
                }
            }
        }
        if (!(isDestructuringType || haveExplicitType && JSTypeUtils.isStrictType(variableType))) {
            this.addNamespaceFromQualifiedNamedElement((JSQualifiedNamedElement)jsVariable);
        }
        this.myContext.setTypeIsGuessed(wasGuessed);
        while (this.myContext.getJSElementsToApply().size() > jsElementsToApplySize) {
            this.myContext.popJSElementToApply();
        }
    }

    protected JSType modifyTypeForEnumType(@NotNull JSResolvableType type, @NotNull JSFieldVariable jsVariable) {
        if (type == null) {
            JSTypeEvaluator.$$$reportNull$$$0(57);
        }
        if (jsVariable == null) {
            JSTypeEvaluator.$$$reportNull$$$0(58);
        }
        return type;
    }

    @Nullable
    private JSType getTypeFromTypeGuard(@NotNull JSFieldVariable jsVariable, @Nullable JSReferenceExpression expression, @Nullable JSType variableType) {
        String name;
        if (jsVariable == null) {
            JSTypeEvaluator.$$$reportNull$$$0(59);
        }
        if (expression != null && JSTypeGuardChecker.isAvailable((PsiElement)expression, variableType) && (name = jsVariable.getName()) != null) {
            variableType = JSTypeGuardChecker.createGuard(expression, variableType, this.myContext.getSource()).getNarrowedType();
        }
        return variableType;
    }

    public void addTypeFromInitializer(JSExpression initializer, boolean isDestructuringType) {
        boolean inCall;
        boolean bl = inCall = !this.myContext.isJSElementsToApplyEmpty();
        if (!inCall && JSSymbolUtil.isNullLiteral(initializer)) {
            this.addType(JSAnyType.get((PsiElement)initializer, false), (PsiElement)initializer);
        } else {
            this.myContext.setTypeIsGuessed(!isDestructuringType);
            this.evaluateCachedTypes(initializer);
        }
    }

    public void evaluateDestructuringContainer(@NotNull JSDestructuringContainer destructuringContainer) {
        JSInitializerOwner initializerOwner;
        JSExpression initializer;
        if (destructuringContainer == null) {
            JSTypeEvaluator.$$$reportNull$$$0(60);
        }
        JSExpression jSExpression = initializer = (initializerOwner = JSDestructuringUtil.findDestructuringParent((JSElement)destructuringContainer, this.myContext, (Condition<JSInitializerOwner>)((Condition)e -> e.getInitializer() != null))) != null ? initializerOwner.getInitializer() : null;
        if (initializer != null) {
            this.addTypeFromInitializer(initializer, true);
        }
    }

    protected JSType substituteThisType(JSType type, JSFieldVariable jsVariable) {
        return type;
    }

    protected boolean addTypeFromAmdModuleReference(@NotNull JSParameter parameter) {
        if (parameter == null) {
            JSTypeEvaluator.$$$reportNull$$$0(61);
        }
        boolean result = false;
        JSLiteralExpression amdModuleReference = JSSymbolUtil.getParameterInitializationIfRequireArgument(parameter);
        if (amdModuleReference != null) {
            PsiReference[] references = amdModuleReference.getReferences();
            Collection<PsiElement> modules = JSFileReferencesUtil.getMostPriorityModules((PsiElement)parameter, references);
            for (PsiElement resolve : modules) {
                if (resolve instanceof JSFile) {
                    this.addTypeFromModuleFile((JSFile)resolve);
                    result = true;
                    continue;
                }
                if (!(resolve instanceof JSImplicitElement) || !JSAmdPsiUtil.isAmdModuleName((JSImplicitElement)resolve)) continue;
                PsiElement parent = resolve.getParent();
                assert (parent instanceof JSLiteralExpression);
                String moduleName = ((JSImplicitElement)resolve).getName();
                JSType type = JSNamedType.createType(moduleName, JSTypeSourceFactory.createTypeSource(resolve, true), JSContext.STATIC);
                this.addType(type, EXPLICIT_TYPE_MARKER_ELEMENT);
                result = true;
            }
        }
        return result;
    }

    protected boolean useVariableType(JSType type) {
        return type != null;
    }

    public boolean isFromCurrentFile(@NotNull PsiElement element) {
        JSReferenceExpression context;
        if (element == null) {
            JSTypeEvaluator.$$$reportNull$$$0(62);
        }
        if ((context = this.myContext.getProcessedExpression()) == null) {
            context = this.myContext.targetFile;
        }
        return context != null && context.getContainingFile().isEquivalentTo((PsiElement)element.getContainingFile());
    }

    private void evaluateCachedTypes(@NotNull JSExpression expression) {
        if (expression == null) {
            JSTypeEvaluator.$$$reportNull$$$0(63);
        }
        if (!this.myContext.isJSElementsToApplyEmpty()) {
            this.doEvaluateTypes(expression, JSEvaluateContext.JSEvaluationPlace.DEFAULT);
            return;
        }
        JSTypeEvaluationResult result = JSTypeEvaluator.getExpressionType(expression);
        if (result != null) {
            List<JSTypeEvaluationResult.JSTypeEvaluationResultElement> results = result.getResults();
            for (JSTypeEvaluationResult.JSTypeEvaluationResultElement element : results) {
                this.addTypeEvaluationResultElement(element);
            }
        }
    }

    protected boolean processInstanceContextForClass(@NotNull JSClass jsClass, boolean hasSomeType) {
        if (jsClass == null) {
            JSTypeEvaluator.$$$reportNull$$$0(64);
        }
        JSApplyContextElement peek = this.myContext.peekJSElementToApply();
        assert (peek instanceof JSApplyInstanceContextElement);
        JSFunction function = this.getClassConstructor(jsClass);
        this.addTypeFromClassCandidate((PsiElement)jsClass, (PsiElement)function);
        return true;
    }

    protected boolean addTypeFromElementResolveResult(PsiElement resolveResult, boolean hasSomeType) {
        if (resolveResult instanceof JSImplicitElement) {
            JSImplicitElement implicitElement = (JSImplicitElement)resolveResult;
            boolean typeAdded = false;
            if (resolveResult instanceof JSLocalImplicitElementImpl) {
                this.addType(((JSLocalImplicitElementImpl)resolveResult).getJSType(), resolveResult.getParent());
                return true;
            }
            String typeString = implicitElement.getTypeString();
            if (typeString != null) {
                JSType type = JSTypeUtils.createType(typeString, JSTypeSourceFactory.createTypeSource(resolveResult, true));
                this.addType(type, resolveResult);
                typeAdded = true;
            }
            if (!typeAdded && implicitElement.getType().providesNamespace()) {
                JSTypeSource typeSource = JSTypeSourceFactory.createTypeSource(resolveResult, implicitElement.isNamespaceExplicitlyDeclared());
                JSType jsType = JSNamedType.createType(implicitElement.getQualifiedName(), typeSource, JSContext.STATIC);
                this.addType(jsType, resolveResult);
            } else {
                JSNamespaceImpl namespace = new JSNamespaceImpl(JSQualifiedNameImpl.fromQualifiedNamedElement((JSElementBase)implicitElement), JSContext.STATIC, implicitElement.isNamespaceExplicitlyDeclared());
                this.addNamespace(namespace, resolveResult);
            }
            return true;
        }
        if (resolveResult instanceof JSProperty) {
            hasSomeType |= this.addTypeFromProperty((JSProperty)resolveResult);
        } else if (resolveResult instanceof JSClass && this.myContext.peekJSElementToApply() instanceof JSApplyInstanceContextElement) {
            hasSomeType = this.processInstanceContextForClass((JSClass)resolveResult, hasSomeType);
        } else if (resolveResult instanceof JSClass || resolveResult instanceof JSFunction && ((JSFunction)resolveResult).isConstructor() && resolveResult.getParent() instanceof JSClass) {
            this.addTypeFromClassCandidate(resolveResult, null);
            hasSomeType = true;
        } else if (resolveResult instanceof JSObjectLiteralExpression) {
            this.addTypeFromObjectLiteralExpression((JSObjectLiteralExpression)resolveResult, false);
        } else if (resolveResult instanceof JSDefinitionExpression) {
            JSType parameterType = null;
            PsiElement resolveResultParent = resolveResult.getParent();
            if (resolveResultParent instanceof JSForInStatement && resolveResult == ((JSForInStatement)resolveResultParent).getVariableExpression()) {
                parameterType = this.addLoopVariable(this.myContext.getProcessedExpression(), resolveResult, (JSForInStatement)resolveResultParent);
            }
            if (parameterType == null) {
                this.addTypeFromDefExpr((JSDefinitionExpression)resolveResult);
            }
            hasSomeType = true;
        } else if (this.addTypeFromDialectSpecificElements(resolveResult)) {
            hasSomeType = true;
        } else if (resolveResult instanceof JSFunction) {
            if (this.processFunction((JSFunction)resolveResult)) {
                hasSomeType = true;
            }
        } else if (resolveResult instanceof JSNamedElement) {
            String name = JSTypeEvaluator.getElementQName((JSNamedElement)resolveResult);
            if (name != null) {
                JSType jsType = JSNamedType.createType(name, JSTypeSourceFactory.createTypeSource(resolveResult), JSContext.STATIC);
                this.addType(jsType, resolveResult);
            }
        } else if (resolveResult instanceof JSLiteralExpression) {
            this.addTypeFromLiteralExpression((JSExpression)resolveResult);
            hasSomeType = true;
        } else if (resolveResult instanceof JSExpressionStatement) {
            String type;
            String s = JSDocumentationUtils.findType(resolveResult);
            if (BaseJSSymbolProcessor.isValidType(s) && (type = JSImportHandlingUtil.resolveTypeName(s, resolveResult)) != null) {
                this.addType(type, null);
                hasSomeType = true;
            }
        } else if (resolveResult instanceof JsonElement) {
            this.applyContextAndProcessResolvedElement(resolveResult);
            hasSomeType = true;
        } else if (resolveResult instanceof JSFile) {
            this.addTypeFromModuleFile((JSFile)resolveResult);
            hasSomeType = true;
        }
        if (!hasSomeType && resolveResult != null) {
            this.myTypeProcessor.setUnknownElement(resolveResult);
        }
        return hasSomeType;
    }

    private boolean addTypeFromProperty(@NotNull JSProperty property) {
        if (property == null) {
            JSTypeEvaluator.$$$reportNull$$$0(65);
        }
        boolean typeAdded = false;
        boolean skipEvaluatingProps = false;
        JSType jsType = property.getType();
        if (jsType != null) {
            this.addType(jsType, (PsiElement)property);
            typeAdded = true;
            skipEvaluatingProps = !(jsType instanceof JSRecordType);
        } else if (this.tryAddTypeFromInitializerReference((PsiElement)property)) {
            typeAdded = true;
            skipEvaluatingProps = true;
        }
        if (!skipEvaluatingProps) {
            JSExpression value;
            String qualifiedName;
            JSFunction functionInitializer = property.tryGetFunctionInitializer();
            JSObjectLiteralExpression objectLiteralExpression = property.getObjectLiteralExpressionInitializer();
            boolean providesNamespace = functionInitializer != null && !functionInitializer.isGetProperty() && !functionInitializer.isSetProperty() || objectLiteralExpression != null;
            boolean isTypeScript = DialectDetector.isTypeScript((PsiElement)property);
            if (!isTypeScript && providesNamespace && (qualifiedName = property.getQualifiedName()) != null) {
                JSType type = JSNamedType.createType(qualifiedName, JSTypeSourceFactory.createTypeSource((PsiElement)property, false), JSContext.STATIC);
                this.addType(type, (PsiElement)property);
                typeAdded = true;
            }
            if (functionInitializer != null || objectLiteralExpression != null) {
                boolean wasGuessed = this.myContext.isTypeGuessed();
                this.myContext.setTypeIsGuessed(!isTypeScript);
                if (functionInitializer != null) {
                    typeAdded |= this.processFunction(functionInitializer);
                } else {
                    this.addTypeFromObjectLiteralExpression(objectLiteralExpression, false);
                }
                this.myContext.setTypeIsGuessed(wasGuessed);
            } else if (this.isFromCurrentFile((PsiElement)property) && (value = property.getValue()) != null) {
                this.evaluateCachedTypes(value);
            }
        }
        return typeAdded;
    }

    protected void addNamespaceFromQualifiedNamedElement(@NotNull JSQualifiedNamedElement element) {
        if (element == null) {
            JSTypeEvaluator.$$$reportNull$$$0(66);
        }
        boolean isLocal = element instanceof JSVariable && ((JSVariable)element).isLocal();
        JSNamespaceImpl namespace = new JSNamespaceImpl(JSQualifiedNameImpl.fromQualifiedNamedElement((JSElementBase)element), JSContext.STATIC, false, isLocal);
        this.addNamespace(namespace, (PsiElement)element);
    }

    protected void addTypeFromClassCandidate(@NotNull PsiElement resolveResult, @Nullable PsiElement constructor) {
        if (resolveResult == null) {
            JSTypeEvaluator.$$$reportNull$$$0(67);
        }
    }

    @Nullable
    protected JSFunction getClassConstructor(@NotNull JSClass resolveResult) {
        if (resolveResult == null) {
            JSTypeEvaluator.$$$reportNull$$$0(68);
        }
        return resolveResult.getConstructor();
    }

    @Nullable
    private JSType addLoopVariable(@Nullable JSReferenceExpression expression, @NotNull PsiElement element, @Nullable JSForInStatement forInStatement) {
        if (element == null) {
            JSTypeEvaluator.$$$reportNull$$$0(69);
        }
        if (forInStatement == null) {
            return null;
        }
        if (forInStatement.isForEach()) {
            List<JSType> types = this.getComponentTypeFromArrayExpression((JSExpression)expression, forInStatement.getCollectionExpression());
            JSReferenceExpression processedExpression = this.myContext.getProcessedExpression();
            for (JSType type : types) {
                this.addVariableTypeWithTypeGuard(element, processedExpression, type, (PsiElement)expression);
            }
            return (JSType)ContainerUtil.getFirstItem(types);
        }
        JSForInStringType parameterType = new JSForInStringType(JSTypeSourceFactory.createTypeSource(element, DialectDetector.isTypeScript(element)), JSTypeContext.INSTANCE);
        this.addVariableTypeWithTypeGuard(element, this.myContext.getProcessedExpression(), parameterType, element);
        return parameterType;
    }

    protected boolean addTypeFromDialectSpecificElements(PsiElement resolveResult) {
        return false;
    }

    @Nullable
    public final JSType addComponentTypeFromArrayExpression(@Nullable JSExpression rawqualifier, @Nullable JSExpression collectionExpression) {
        List<JSType> types = this.getComponentTypeFromArrayExpression(rawqualifier, collectionExpression);
        for (JSType type : types) {
            this.addType(type, (PsiElement)rawqualifier);
        }
        return types.size() == 1 ? (JSType)ContainerUtil.getFirstItem(types) : null;
    }

    @NotNull
    protected List<JSType> getComponentTypeFromArrayExpression(@Nullable JSExpression rawqualifier, @Nullable JSExpression collectionExpression) {
        if (collectionExpression == null) {
            List list = ContainerUtil.emptyList();
            if (list == null) {
                JSTypeEvaluator.$$$reportNull$$$0(70);
            }
            return list;
        }
        JSTypeEvaluationResult result = JSTypeEvaluator.getExpressionType(collectionExpression);
        if (result == null) {
            List list = ContainerUtil.emptyList();
            if (list == null) {
                JSTypeEvaluator.$$$reportNull$$$0(71);
            }
            return list;
        }
        List<JSTypeEvaluationResult.JSTypeEvaluationResultElement> results = result.getResults();
        JSType type = JSTypeUtils.getValuableType(result.getType());
        if (this.myTypeProcessor instanceof ResolveProcessor) {
            JSExpression indexExpression;
            int index = -1;
            if (rawqualifier instanceof JSIndexedPropertyAccessExpression && (indexExpression = ((JSIndexedPropertyAccessExpression)rawqualifier).getIndexExpression()) instanceof JSLiteralExpression && ((JSLiteralExpression)indexExpression).isNumericLiteral()) {
                Object value = ((JSLiteralExpression)indexExpression).getValue();
                assert (value instanceof Double || value instanceof Long) : indexExpression.getText();
                if (value instanceof Long && (Long)value >= 0L && (Long)value <= Integer.MAX_VALUE) {
                    index = Math.toIntExact((Long)value);
                }
            }
            boolean processed = false;
            for (JSTypeEvaluationResult.JSTypeEvaluationResultElement element : results) {
                PsiElement source = element.getSource();
                if (source instanceof JsonFile) {
                    source = ((JsonFile)source).getTopLevelValue();
                }
                if (source instanceof JSArrayLiteralExpression) {
                    JSExpression[] expressions = ((JSArrayLiteralExpression)source).getExpressions();
                    if (index >= 0 && index < expressions.length) {
                        this.addTypeFromElementResolveResult((PsiElement)expressions[index], false);
                        processed = true;
                        continue;
                    }
                    for (JSExpression expr : expressions) {
                        if (!(expr instanceof JSObjectLiteralExpression)) continue;
                        this.addTypeFromObjectLiteralExpression((JSObjectLiteralExpression)expr, false);
                        processed = true;
                    }
                    continue;
                }
                if (!(source instanceof JsonArray)) continue;
                List values = ((JsonArray)source).getValueList();
                if (index < 0 || index >= values.size()) continue;
                this.applyContextAndProcessResolvedElement((PsiElement)values.get(index));
                processed = true;
            }
            if (!processed && type instanceof JSTupleTypeImpl) {
                List<JSType> types = ((JSTupleTypeImpl)type).getTypes();
                if (index >= 0 && index < types.size()) {
                    List<JSType> list = Collections.singletonList(types.get(index));
                    if (list == null) {
                        JSTypeEvaluator.$$$reportNull$$$0(72);
                    }
                    return list;
                }
            }
        }
        List<JSType> list = this.getComponentTypeFromProcessor(rawqualifier, type);
        if (list == null) {
            JSTypeEvaluator.$$$reportNull$$$0(73);
        }
        return list;
    }

    @Nullable
    public final JSType addComponentTypeFromProcessor(@Nullable JSExpression rawqualifier, @Nullable JSType type) {
        List<JSType> types = this.getComponentTypeFromProcessor(rawqualifier, type);
        for (JSType jsType : types) {
            if (type == null) continue;
            this.addType(jsType, (PsiElement)rawqualifier);
        }
        return types.size() == 1 ? (JSType)ContainerUtil.getFirstItem(types) : null;
    }

    @NotNull
    protected List<JSType> getComponentTypeFromProcessor(@Nullable JSExpression rawqualifier, @Nullable JSType type) {
        if ((type = JSTypeUtils.getValuableType(type)) != null) {
            if (type instanceof JSCompositeTypeImpl) {
                ArrayList result = ContainerUtil.newArrayList();
                for (JSType typeOption : ((JSCompositeTypeImpl)type).getTypes()) {
                    result.addAll(this.getComponentTypeFromProcessor(rawqualifier, typeOption));
                }
                ArrayList arrayList = result;
                if (arrayList == null) {
                    JSTypeEvaluator.$$$reportNull$$$0(74);
                }
                return arrayList;
            }
            JSTypeSource source = type.getSource();
            if ((type = JSTypeUtils.getIndexableComponentType(type)) == null) {
                type = JSAnyType.get((PsiElement)rawqualifier, false);
            }
            type = JSTypeUtils.copyWithStrict(type, source.isStrict() && type.getSource().isStrict());
            List<JSType> list = Collections.singletonList(type);
            if (list == null) {
                JSTypeEvaluator.$$$reportNull$$$0(75);
            }
            return list;
        }
        List list = ContainerUtil.emptyList();
        if (list == null) {
            JSTypeEvaluator.$$$reportNull$$$0(76);
        }
        return list;
    }

    protected void addTypeFromLiteralExpression(@NotNull JSExpression rawqualifier) {
        JSType type;
        if (rawqualifier == null) {
            JSTypeEvaluator.$$$reportNull$$$0(77);
        }
        if ((type = JSTypeEvaluator.getTypeFromConstant(rawqualifier)) != null) {
            this.addType(type, (PsiElement)rawqualifier);
        } else {
            this.myTypeProcessor.setUnknownElement((PsiElement)rawqualifier);
        }
    }

    @Nullable
    public static JSType getTypeFromConstant(@NotNull JSExpression rawqualifier) {
        String literalText;
        String text;
        String type;
        ASTNode childNode;
        IElementType constantType;
        if (rawqualifier == null) {
            JSTypeEvaluator.$$$reportNull$$$0(78);
        }
        String string = (constantType = (childNode = rawqualifier.getNode().getFirstChildNode()).getElementType()) == JSTokenTypes.STRING_LITERAL || constantType == JSTokenTypes.SINGLE_QUOTE_STRING_LITERAL || constantType == JSTokenTypes.BACKQUOTE ? "string" : (constantType == JSTokenTypes.NUMERIC_LITERAL ? "number" : (constantType == JSTokenTypes.REGEXP_LITERAL ? "RegExp" : (constantType == JSTokenTypes.XML_START_TAG_START ? "XML" : (constantType == JSTokenTypes.XML_START_TAG_LIST ? "XMLList" : (constantType == JSTokenTypes.TRUE_KEYWORD || constantType == JSTokenTypes.FALSE_KEYWORD ? "boolean" : (constantType == JSTokenTypes.NULL_KEYWORD && !DialectDetector.isActionScript((PsiElement)rawqualifier) ? "null" : (type = constantType == JSTokenTypes.UNDEFINED_KEYWORD && !DialectDetector.isActionScript((PsiElement)rawqualifier) ? "undefined" : null)))))));
        if (type == "number" && DialectDetector.isActionScript((PsiElement)rawqualifier) && (text = childNode.getText()).indexOf(46) == -1) {
            type = "int";
        }
        if (type == "number" && rawqualifier instanceof JSLiteralExpression && ((JSLiteralExpression)rawqualifier).isBigInteger() && DialectDetector.hasFeature((PsiElement)rawqualifier, JSLanguageFeature.BIG_INT)) {
            type = "BigInt";
        }
        if ((type == "XMLList" || type == "XML") && (DialectDetector.isTypeScript((PsiElement)rawqualifier) || DialectDetector.isJSX((PsiElement)rawqualifier))) {
            type = null;
        }
        JSTypeSource typeSource = JSTypeSourceFactory.createTypeSource((PsiElement)rawqualifier, true, false);
        if (type == "string" && (literalText = childNode.getText()).length() >= 2) {
            return new JSStringLiteralTypeImpl(literalText.substring(1, literalText.length() - 1), false, typeSource);
        }
        if (type == "number" && (literalText = childNode.getText()).length() > 0 && DialectDetector.isTypeScript((PsiElement)rawqualifier)) {
            Double literal = JSNumberParser.tryParseNumericValue(literalText, true);
            if (literal != null) {
                return new JSNumberLiteralTypeImpl(literal, false, typeSource, literalText);
            }
        } else if (type == "boolean" && ("true".equals(literalText = childNode.getText()) || "false".equals(literalText)) && DialectDetector.isTypeScript((PsiElement)rawqualifier)) {
            return new JSBooleanLiteralTypeImpl("true".equals(literalText), false, typeSource);
        }
        if (type != null) {
            return JSNamedType.createType(type, typeSource, JSContext.INSTANCE);
        }
        return null;
    }

    private boolean addAdditionalTypes(@NotNull JSReferenceExpression localQualifier, @NotNull JSReferenceExpression qualifier) {
        Runnable addTypeRunnable;
        JSApplyContextElement peek;
        if (localQualifier == null) {
            JSTypeEvaluator.$$$reportNull$$$0(79);
        }
        if (qualifier == null) {
            JSTypeEvaluator.$$$reportNull$$$0(80);
        }
        if (DialectDetector.isTypeScript((PsiElement)localQualifier)) {
            return false;
        }
        boolean hasSomeType = false;
        String localQualifierText = localQualifier.getText();
        if ("$".equals(localQualifierText) || "jQuery.$".equals(localQualifierText)) {
            peek = this.myContext.peekJSElementToApply();
            addTypeRunnable = () -> {
                if (localQualifier == null) {
                    JSTypeEvaluator.$$$reportNull$$$0(103);
                }
                JSTypeSource typeSource = JSTypeSourceFactory.createTypeSource((PsiElement)localQualifier, false);
                this.addType(JSNamedType.createType("jQuery", typeSource, JSContext.UNKNOWN), (PsiElement)localQualifier);
            };
            if (peek instanceof JSApplyCallElement) {
                this.myContext.processWithoutTopJSElementToApply(addTypeRunnable);
            } else {
                addTypeRunnable.run();
            }
            hasSomeType = true;
        }
        if ("$".equals(qualifier.getText())) {
            peek = this.myContext.peekJSElementToApply();
            addTypeRunnable = () -> {
                if (localQualifier == null) {
                    JSTypeEvaluator.$$$reportNull$$$0(102);
                }
                JSTypeSource typeSource = JSTypeSourceFactory.createTypeSource((PsiElement)localQualifier, false);
                this.addType(JSNamedType.createType("HTMLElement", typeSource, JSContext.UNKNOWN), (PsiElement)localQualifier);
            };
            if (peek instanceof JSApplyCallElement) {
                this.myContext.processWithoutTopJSElementToApply(addTypeRunnable);
            } else {
                addTypeRunnable.run();
            }
            hasSomeType = true;
        } else if ("getComponentById".equals(qualifier.getReferencedName())) {
            hasSomeType |= this.tryAddBindowsType(qualifier);
        }
        return hasSomeType;
    }

    private boolean tryAddBindowsType(JSReferenceExpression qualifier) {
        JSIndexContent content;
        Collection<JSImplicitElementsIndex.JSElementProxy> proxies;
        PsiFile containingFile;
        PsiElement element = qualifier.getParent();
        if (!(element instanceof JSCallExpression)) {
            return false;
        }
        JSArgumentList argumentList = ((JSCallExpression)element).getArgumentList();
        if (argumentList == null) {
            return false;
        }
        JSExpression[] expressions = argumentList.getArguments();
        if (expressions.length == 0 || !(expressions[0] instanceof JSLiteralExpression)) {
            return false;
        }
        String val = StringUtil.unquoteString((String)expressions[0].getText());
        PsiElement contextElement = qualifier.getContainingFile().getContext();
        if (contextElement != null && JSTagContextBuilder.isBindowsXml(containingFile = contextElement.getContainingFile()) && (proxies = (content = JSIndexContent.get(containingFile)).getImplicitElements().get(val)) != null) {
            for (JSImplicitElementsIndex.JSElementProxy proxy : proxies) {
                XmlTag tag;
                PsiElement elementAtOffset = proxy.toOffsetBasedImplicitElement(containingFile).getElementAtOffset();
                if (elementAtOffset == null || (tag = (XmlTag)PsiTreeUtil.getParentOfType((PsiElement)elementAtOffset, XmlTag.class)) == null) continue;
                JSType type = JSNamedType.createType(JSTagContextBuilder.getTypeName(tag), JSTypeSourceFactory.createTypeSource(elementAtOffset), JSContext.UNKNOWN);
                this.myTypeProcessor.process(type, this.myContext, elementAtOffset);
                return true;
            }
        }
        return false;
    }

    @Nullable
    private static String getElementQName(JSNamedElement psiElement) {
        String name = null;
        if (psiElement instanceof JSQualifiedNamedElement) {
            name = ((JSQualifiedNamedElement)psiElement).getQualifiedName();
        }
        if (name == null) {
            name = psiElement.getName();
        }
        return name;
    }

    private void addTypeFromObjectLiteralExpression(JSObjectLiteralExpression expression, boolean evaluatePropertyTypes) {
        JSApplyContextElement peek = this.myContext.peekJSElementToApply();
        if (peek instanceof JSApplyPropertyElement) {
            this.myContext.processWithoutTopJSElementToApply(() -> {
                JSDestructuringProperty destructuringProperty = ((JSApplyPropertyElement)peek).getProperty();
                if (destructuringProperty.isRest()) {
                    JSType recordType = this.getObjectLiteralType(expression, evaluatePropertyTypes);
                    JSApplyContextUtil.processDestructuringProperty((JSApplyPropertyElement)peek, recordType, (newType, newElement) -> this.addType((JSType)newType, (PsiElement)newElement));
                } else {
                    JSProperty property = expression.findProperty(destructuringProperty.getName());
                    if (property != null) {
                        this.addTypeFromProperty(property);
                    }
                }
            });
            return;
        }
        JSType recordType = this.getObjectLiteralType(expression, evaluatePropertyTypes);
        this.myTypeProcessor.process(recordType, this.myContext, (PsiElement)expression);
        for (String extendedType : expression.getExtendedTypes()) {
            JSNamespace namespace = JSNamespaceImpl.fromNamepath(extendedType, true);
            this.addNamespace(namespace, (PsiElement)expression);
        }
    }

    @NotNull
    protected JSType getObjectLiteralType(JSObjectLiteralExpression expression, boolean evaluatePropertyTypes) {
        if (DialectDetector.isActionScript((PsiElement)expression)) {
            JSObjectType jSObjectType = new JSObjectType(JSTypeSourceFactory.createTypeSource((PsiElement)expression, false), JSTypeContext.UNKNOWN);
            if (jSObjectType == null) {
                JSTypeEvaluator.$$$reportNull$$$0(81);
            }
            return jSObjectType;
        }
        JSElement[] properties = expression.getPropertiesIncludingSpreads();
        JSTypeSource typeSource = JSTypeSourceFactory.createTypeSource((PsiElement)expression, DialectDetector.isTypeScript((PsiElement)expression));
        ArrayList<JSRecordType.TypeMember> typeMembers = new ArrayList<JSRecordType.TypeMember>();
        for (JSElement property : properties) {
            JSType spreadType;
            if (property instanceof JSProperty) {
                JSRecordType.TypeMember type = this.getTypeFromSimplePropertyValue((JSProperty)property, evaluatePropertyTypes);
                if (type == null) continue;
                typeMembers.add(type);
                continue;
            }
            if (!(property instanceof JSSpreadExpression) || !evaluatePropertyTypes || (spreadType = this.getObjectLiteralPropertyValueType(((JSSpreadExpression)property).getExpression())) == null) continue;
            typeMembers.addAll(spreadType.asRecordType().getTypeMembers());
        }
        JSFreshObjectLiteralTypeImpl jSFreshObjectLiteralTypeImpl = new JSFreshObjectLiteralTypeImpl(typeSource, typeMembers);
        if (jSFreshObjectLiteralTypeImpl == null) {
            JSTypeEvaluator.$$$reportNull$$$0(82);
        }
        return jSFreshObjectLiteralTypeImpl;
    }

    @Nullable
    private JSRecordType.TypeMember getTypeFromSimplePropertyValue(@NotNull JSProperty property, boolean evaluatePropertyTypes) {
        String name;
        if (property == null) {
            JSTypeEvaluator.$$$reportNull$$$0(83);
        }
        if ((name = property.getName()) == null && property instanceof JSComputedPropertyNameOwner) {
            name = JSPsiImplUtils.getComputedPropertyNameWithoutBrackets((JSComputedPropertyNameOwner)property);
        }
        if (name == null) {
            return null;
        }
        JSType type = null;
        if (evaluatePropertyTypes) {
            type = property instanceof ES6FunctionProperty ? TypeScriptTypeParser.buildFunctionType((JSFunction)property) : this.getObjectLiteralPropertyValueType(property.getValue());
        }
        return new JSRecordTypeImpl.PropertySignatureImpl(name, type, false, (PsiElement)property);
    }

    private JSType getObjectLiteralPropertyValueType(@Nullable JSExpression expression) {
        return this.getExpressionTypeWithGuard(expression, JSEvaluateContext.JSEvaluationPlace.OBJECT_LITERAL_PROPERTY_VALUE, true);
    }

    private boolean findDef(@NotNull JSReferenceExpression qualifier, @NotNull SinkResolveProcessor processor) {
        if (qualifier == null) {
            JSTypeEvaluator.$$$reportNull$$$0(84);
        }
        if (processor == null) {
            JSTypeEvaluator.$$$reportNull$$$0(85);
        }
        PsiElement parent = qualifier.getParent();
        JSResolveUtil.treeWalkUp(processor, (PsiElement)qualifier, parent, (PsiElement)qualifier);
        PsiElement jsElement = processor.getResult();
        if (jsElement instanceof JSDefinitionExpression) {
            this.addTypeFromDefExpr((JSDefinitionExpression)jsElement);
            return true;
        }
        return false;
    }

    private void addTypeFromDefExpr(@NotNull JSDefinitionExpression psiElement) {
        boolean evaluateInitializer;
        JSFunctionExpression initializer;
        boolean canHaveType;
        JSType jsType;
        if (psiElement == null) {
            JSTypeEvaluator.$$$reportNull$$$0(86);
        }
        if ((jsType = psiElement.getType()) != null) {
            this.addType(jsType, (PsiElement)psiElement);
            if (jsType.getSource().isStrict()) {
                return;
            }
        }
        boolean bl = canHaveType = (initializer = psiElement.tryGetFunctionExpressionInitializer()) != null && !this.myContext.isJSElementsToApplyEmpty();
        if (canHaveType && this.processFunction((JSFunction)initializer)) {
            return;
        }
        boolean bl2 = evaluateInitializer = !this.myContext.isTypeGuessed();
        if (evaluateInitializer) {
            JSExpression expr;
            boolean initializerProcessed = false;
            if (this.isFromCurrentFile((PsiElement)psiElement) && (expr = JSPsiImplUtils.getRightmostOperand(psiElement)) != null) {
                this.evaluateCachedTypes(expr);
                initializerProcessed = true;
            }
            if (!initializerProcessed) {
                this.tryAddTypeFromInitializerReference((PsiElement)psiElement);
            }
        }
        if (!canHaveType && jsType == null) {
            this.myTypeProcessor.setUnknownElement((PsiElement)psiElement);
        }
        String type = psiElement.getQualifiedName();
        if (psiElement.isNamespaceExplicitlyDeclared() && type != null) {
            JSContext jsContext = this.myContext.peekJSElementToApply() instanceof JSApplyInstanceContextElement ? JSContext.INSTANCE : JSContext.STATIC;
            JSDocComment comment = JSStubBasedPsiTreeUtil.findDocComment((PsiElement)psiElement);
            boolean explicitType = comment != null && comment.hasNamespaceTag();
            JSNamespaceImpl namespace = new JSNamespaceImpl(JSQualifiedNameImpl.fromQualifiedName(type), jsContext, explicitType);
            this.addNamespace(namespace, (PsiElement)(explicitType ? EXPLICIT_TYPE_MARKER_ELEMENT : psiElement));
        }
    }

    private boolean tryAddTypeFromInitializerReference(@NotNull PsiElement resolveResult) {
        String initializerReference;
        if (resolveResult == null) {
            JSTypeEvaluator.$$$reportNull$$$0(87);
        }
        String string = resolveResult instanceof JSDefinitionExpression ? ((JSDefinitionExpression)resolveResult).getInitializerReference() : (resolveResult instanceof JSProperty ? ((JSProperty)resolveResult).getInitializerReference() : (initializerReference = resolveResult instanceof JSVariable ? ((JSVariable)resolveResult).getLiteralOrReferenceInitializerText() : null));
        if (initializerReference == null || StringUtil.isQuotedString((String)initializerReference)) {
            return false;
        }
        PsiElement localResolve = JSStubBasedPsiTreeUtil.resolveLocally(initializerReference, resolveResult);
        if (localResolve instanceof JSNamedElement) {
            this.processItem(localResolve, JSEvaluateContext.JSEvaluationPlace.DEFAULT, e -> this.addTypeFromResolveResult((PsiElement)e, false));
            return true;
        }
        return false;
    }

    private void simpleEvalType(JSExpression rawqualifier, JSExpression lOperand) {
        JSType evaluatedType = JSResolveUtil.getExpressionJSType(lOperand);
        if (evaluatedType != null) {
            this.addType(evaluatedType, (PsiElement)rawqualifier);
        } else {
            this.myTypeProcessor.setUnknownElement((PsiElement)rawqualifier);
        }
    }

    protected <T extends PsiElement> boolean processItem(@NotNull T element, @NotNull JSEvaluateContext.JSEvaluationPlace place, @NotNull Consumer<T> runnable) {
        if (element == null) {
            JSTypeEvaluator.$$$reportNull$$$0(88);
        }
        if (place == null) {
            JSTypeEvaluator.$$$reportNull$$$0(89);
        }
        if (runnable == null) {
            JSTypeEvaluator.$$$reportNull$$$0(90);
        }
        if (!JSTypeEvaluator.processWithEvaluationGuard(element, place, runnable)) {
            if (this.myTypeProcessor instanceof QualifiedItemProcessor) {
                ((QualifiedItemProcessor)this.myTypeProcessor).resolved = QualifiedItemProcessor.TypeResolveState.Undefined;
            }
            return false;
        }
        return true;
    }

    public static boolean canEvaluateTypeOfType(@NotNull PsiElement element) {
        if (element == null) {
            JSTypeEvaluator.$$$reportNull$$$0(91);
        }
        return JSTypeEvaluator.canProcessWithEvaluationGuard(element, JSEvaluateContext.JSEvaluationPlace.TYPEOF_TYPE);
    }

    public static boolean canProcessWithEvaluationGuard(@NotNull PsiElement element, @NotNull JSEvaluateContext.JSEvaluationPlace place) {
        JSRecursionGuard context;
        if (element == null) {
            JSTypeEvaluator.$$$reportNull$$$0(92);
        }
        if (place == null) {
            JSTypeEvaluator.$$$reportNull$$$0(93);
        }
        return (context = recursionGuardHolder.get()) == null || !context.isAlreadyProcessingItem(element, place);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <T extends PsiElement> boolean processWithEvaluationGuard(@NotNull T element, @NotNull JSEvaluateContext.JSEvaluationPlace place, @NotNull Consumer<T> runnable) {
        if (element == null) {
            JSTypeEvaluator.$$$reportNull$$$0(94);
        }
        if (place == null) {
            JSTypeEvaluator.$$$reportNull$$$0(95);
        }
        if (runnable == null) {
            JSTypeEvaluator.$$$reportNull$$$0(96);
        }
        JSRecursionGuard context = recursionGuardHolder.get();
        boolean created = false;
        if (context == null) {
            context = new JSRecursionGuard();
            recursionGuardHolder.set(context);
            created = true;
        }
        if (!created && context.isAlreadyProcessingItem(element, place)) {
            return false;
        }
        try {
            context.addProcessingItem(element, place);
            runnable.accept(element);
            boolean bl = true;
            return bl;
        }
        finally {
            context.removeProcessingItem(element, place);
            if (created) {
                recursionGuardHolder.set(null);
            }
        }
    }

    @Nullable
    public JSType getExpressionTypeWithGuard(@Nullable JSExpression expression, @NotNull JSEvaluateContext.JSEvaluationPlace place, boolean widenIfNeeded) {
        if (place == null) {
            JSTypeEvaluator.$$$reportNull$$$0(97);
        }
        if (expression == null) {
            return null;
        }
        Ref ref = Ref.create();
        JSTypeEvaluator.processWithEvaluationGuard(expression, place, el -> {
            JSType expressionJSType = JSResolveUtil.getExpressionJSType(expression);
            ref.set((Object)(widenIfNeeded ? this.widenExpressionTypeByContextualType((JSExpression)el, DialectDetector.isTypeScript((PsiElement)el), expressionJSType) : expressionJSType));
        });
        return (JSType)ref.get();
    }

    private void applyContextAndProcessResolvedElement(@NotNull PsiElement resolve) {
        JSApplyContextElement peek;
        if (resolve == null) {
            JSTypeEvaluator.$$$reportNull$$$0(98);
        }
        if ((peek = this.myContext.peekJSElementToApply()) instanceof JSApplyPropertyElement) {
            Ref result = Ref.create((Object)true);
            this.myContext.processWithoutTopJSElementToApply(() -> {
                if (resolve == null) {
                    JSTypeEvaluator.$$$reportNull$$$0(101);
                }
                result.set((Object)this.applyDestructuringPropertyAndProcessResolvedElement(resolve, (JSApplyPropertyElement)peek));
            });
            if (!((Boolean)result.get()).booleanValue()) {
                return;
            }
        }
        this.myTypeProcessor.processResolvedElement(resolve, this.myContext);
    }

    private boolean applyDestructuringPropertyAndProcessResolvedElement(@NotNull PsiElement resolve, @NotNull JSApplyPropertyElement property) {
        if (resolve == null) {
            JSTypeEvaluator.$$$reportNull$$$0(99);
        }
        if (property == null) {
            JSTypeEvaluator.$$$reportNull$$$0(100);
        }
        final String name = property.getName();
        JSResolveProcessorBase processor = new JSResolveProcessorBase(name){

            public boolean execute(@NotNull PsiElement element, @NotNull ResolveState state) {
                if (element == null) {
                    2.$$$reportNull$$$0(0);
                }
                if (state == null) {
                    2.$$$reportNull$$$0(1);
                }
                if (!(element instanceof JSPsiNamedElementBase) || name.equals(((JSPsiNamedElementBase)element).getName())) {
                    JSTypeEvaluator.this.myTypeProcessor.processResolvedElement(element, JSTypeEvaluator.this.myContext);
                }
                return true;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[0] = "element";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[0] = "state";
                        break;
                    }
                }
                objectArray[1] = "com/intellij/lang/javascript/psi/resolve/JSTypeEvaluator$2";
                objectArray[2] = "execute";
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        };
        JSReferenceExpression place = this.myContext.getProcessedExpression();
        if (place == null) {
            place = resolve;
        }
        return QualifiedItemProcessor.processResolvedElement(resolve, this.myContext, processor, (PsiElement)place);
    }

    private /* synthetic */ void lambda$addTypeFromModuleFile$17(PsiElement finalExportedElement, @NotNull JSFile jsFile, JSType newType, JSEvaluationResultContext newContext) {
        if (jsFile == null) {
            JSTypeEvaluator.$$$reportNull$$$0(105);
        }
        JSTypeUtils.processExpandedType((Processor<JSType>)((Processor)typeComponent -> {
            if (jsFile == null) {
                JSTypeEvaluator.$$$reportNull$$$0(106);
            }
            if (!(typeComponent instanceof JSNamedType && finalExportedElement instanceof JSElementBase && typeComponent.getTypeText().equals(((JSElementBase)finalExportedElement).getQualifiedName()))) {
                this.myContext.withLocalScope((PsiElement)jsFile, () -> this.addType((JSType)typeComponent, null));
            }
            return true;
        }), newType);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 29: 
            case 31: 
            case 32: 
            case 33: 
            case 51: 
            case 70: 
            case 71: 
            case 72: 
            case 73: 
            case 74: 
            case 75: 
            case 76: 
            case 81: 
            case 82: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 29: 
            case 31: 
            case 32: 
            case 33: 
            case 51: 
            case 70: 
            case 71: 
            case 72: 
            case 73: 
            case 74: 
            case 75: 
            case 76: 
            case 81: 
            case 82: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "expr";
                break;
            }
            case 1: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "targetFile";
                break;
            }
            case 2: 
            case 6: 
            case 18: 
            case 19: 
            case 34: 
            case 36: 
            case 89: 
            case 93: 
            case 95: 
            case 97: 
            case 110: 
            case 111: {
                objectArray2 = objectArray3;
                objectArray3[0] = "place";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "typeProcessor";
                break;
            }
            case 5: 
            case 8: 
            case 9: 
            case 62: 
            case 66: 
            case 69: 
            case 88: 
            case 91: 
            case 92: 
            case 94: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 7: 
            case 49: 
            case 52: 
            case 63: {
                objectArray2 = objectArray3;
                objectArray3[0] = "expression";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "_type";
                break;
            }
            case 11: 
            case 16: 
            case 46: 
            case 112: 
            case 114: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 12: 
            case 17: 
            case 47: 
            case 85: 
            case 113: 
            case 115: {
                objectArray2 = objectArray3;
                objectArray3[0] = "processor";
                break;
            }
            case 13: 
            case 57: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
            case 14: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "namespace";
                break;
            }
            case 20: 
            case 22: 
            case 23: 
            case 77: 
            case 78: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rawqualifier";
                break;
            }
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "importCall";
                break;
            }
            case 24: 
            case 64: {
                objectArray2 = objectArray3;
                objectArray3[0] = "jsClass";
                break;
            }
            case 25: 
            case 26: {
                objectArray2 = objectArray3;
                objectArray3[0] = "staticOrInstance";
                break;
            }
            case 27: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 28: {
                objectArray2 = objectArray3;
                objectArray3[0] = "typeSource";
                break;
            }
            case 29: 
            case 31: 
            case 32: 
            case 33: 
            case 51: 
            case 70: 
            case 71: 
            case 72: 
            case 73: 
            case 74: 
            case 75: 
            case 76: 
            case 81: 
            case 82: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/javascript/psi/resolve/JSTypeEvaluator";
                break;
            }
            case 30: {
                objectArray2 = objectArray3;
                objectArray3[0] = "thisQualifier";
                break;
            }
            case 35: 
            case 37: 
            case 38: 
            case 41: 
            case 108: {
                objectArray2 = objectArray3;
                objectArray3[0] = "callExpression";
                break;
            }
            case 39: {
                objectArray2 = objectArray3;
                objectArray3[0] = "methodExpression";
                break;
            }
            case 40: 
            case 42: 
            case 109: {
                objectArray2 = objectArray3;
                objectArray3[0] = "invoked";
                break;
            }
            case 43: 
            case 105: 
            case 106: 
            case 107: {
                objectArray2 = objectArray3;
                objectArray3[0] = "jsFile";
                break;
            }
            case 44: {
                objectArray2 = objectArray3;
                objectArray3[0] = "source";
                break;
            }
            case 45: {
                objectArray2 = objectArray3;
                objectArray3[0] = "jsContext";
                break;
            }
            case 48: 
            case 104: {
                objectArray2 = objectArray3;
                objectArray3[0] = "function";
                break;
            }
            case 50: 
            case 80: 
            case 84: {
                objectArray2 = objectArray3;
                objectArray3[0] = "qualifier";
                break;
            }
            case 53: 
            case 54: {
                objectArray2 = objectArray3;
                objectArray3[0] = "resolveResults";
                break;
            }
            case 55: 
            case 67: 
            case 68: 
            case 87: {
                objectArray2 = objectArray3;
                objectArray3[0] = "resolveResult";
                break;
            }
            case 56: 
            case 58: 
            case 59: {
                objectArray2 = objectArray3;
                objectArray3[0] = "jsVariable";
                break;
            }
            case 60: {
                objectArray2 = objectArray3;
                objectArray3[0] = "destructuringContainer";
                break;
            }
            case 61: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parameter";
                break;
            }
            case 65: 
            case 83: 
            case 100: {
                objectArray2 = objectArray3;
                objectArray3[0] = "property";
                break;
            }
            case 79: 
            case 102: 
            case 103: {
                objectArray2 = objectArray3;
                objectArray3[0] = "localQualifier";
                break;
            }
            case 86: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiElement";
                break;
            }
            case 90: 
            case 96: {
                objectArray2 = objectArray3;
                objectArray3[0] = "runnable";
                break;
            }
            case 98: 
            case 99: 
            case 101: {
                objectArray2 = objectArray3;
                objectArray3[0] = "resolve";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/javascript/psi/resolve/JSTypeEvaluator";
                break;
            }
            case 29: {
                objectArray = objectArray2;
                objectArray2[1] = "createTypeForThisExpression";
                break;
            }
            case 31: {
                objectArray = objectArray2;
                objectArray2[1] = "replaceTypeSourceByNotStrict";
                break;
            }
            case 32: {
                objectArray = objectArray2;
                objectArray2[1] = "getArrayTypeFromExpressions";
                break;
            }
            case 33: {
                objectArray = objectArray2;
                objectArray2[1] = "createNullType";
                break;
            }
            case 51: {
                objectArray = objectArray2;
                objectArray2[1] = "getResolveResultsFromQualifier";
                break;
            }
            case 70: 
            case 71: 
            case 72: 
            case 73: {
                objectArray = objectArray2;
                objectArray2[1] = "getComponentTypeFromArrayExpression";
                break;
            }
            case 74: 
            case 75: 
            case 76: {
                objectArray = objectArray2;
                objectArray2[1] = "getComponentTypeFromProcessor";
                break;
            }
            case 81: 
            case 82: {
                objectArray = objectArray2;
                objectArray2[1] = "getObjectLiteralType";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "evaluateTypes";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "evaluateExpressionOrElementTypes";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "getExpressionType";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "getElementType";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "addTypeEvaluationResultElement";
                break;
            }
            case 10: 
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "applyContextAndProcess";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "addType";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "addNamespace";
                break;
            }
            case 15: 
            case 16: 
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "applyContextAndProcessNamespace";
                break;
            }
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "doEvaluateTypes";
                break;
            }
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "getIndexedPropertyAccessType";
                break;
            }
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "evaluateES6ImportCall";
                break;
            }
            case 22: 
            case 23: 
            case 24: 
            case 25: {
                objectArray = objectArray;
                objectArray[2] = "processThisQualifierExpression";
                break;
            }
            case 26: 
            case 27: 
            case 28: {
                objectArray = objectArray;
                objectArray[2] = "createTypeForThisExpression";
                break;
            }
            case 29: 
            case 31: 
            case 32: 
            case 33: 
            case 51: 
            case 70: 
            case 71: 
            case 72: 
            case 73: 
            case 74: 
            case 75: 
            case 76: 
            case 81: 
            case 82: {
                break;
            }
            case 30: {
                objectArray = objectArray;
                objectArray[2] = "processThisQualifierInExecutionScope";
                break;
            }
            case 34: {
                objectArray = objectArray;
                objectArray[2] = "evaluateNewExpressionTypes";
                break;
            }
            case 35: 
            case 36: {
                objectArray = objectArray;
                objectArray[2] = "evaluateCallExpressionTypes";
                break;
            }
            case 37: {
                objectArray = objectArray;
                objectArray[2] = "addTypeFromGclRequireCall";
                break;
            }
            case 38: {
                objectArray = objectArray;
                objectArray[2] = "processRequireMethodCall";
                break;
            }
            case 39: 
            case 40: {
                objectArray = objectArray;
                objectArray[2] = "processApplyOrCallMethodCall";
                break;
            }
            case 41: 
            case 42: {
                objectArray = objectArray;
                objectArray[2] = "processCreateMethodCall";
                break;
            }
            case 43: {
                objectArray = objectArray;
                objectArray[2] = "addTypeFromModuleFile";
                break;
            }
            case 44: 
            case 45: 
            case 46: 
            case 47: {
                objectArray = objectArray;
                objectArray[2] = "addDefaultExportNamespaces";
                break;
            }
            case 48: {
                objectArray = objectArray;
                objectArray[2] = "processFunction";
                break;
            }
            case 49: {
                objectArray = objectArray;
                objectArray[2] = "processRefExpr";
                break;
            }
            case 50: {
                objectArray = objectArray;
                objectArray[2] = "getResolveResultsFromQualifier";
                break;
            }
            case 52: {
                objectArray = objectArray;
                objectArray[2] = "evaluateNamespaceLocally";
                break;
            }
            case 53: {
                objectArray = objectArray;
                objectArray[2] = "shouldSkipProcessing";
                break;
            }
            case 54: {
                objectArray = objectArray;
                objectArray[2] = "isTypeScriptDeclarationMerging";
                break;
            }
            case 55: {
                objectArray = objectArray;
                objectArray[2] = "addTypeFromResolveResult";
                break;
            }
            case 56: {
                objectArray = objectArray;
                objectArray[2] = "addTypeFromVariableResolveResult";
                break;
            }
            case 57: 
            case 58: {
                objectArray = objectArray;
                objectArray[2] = "modifyTypeForEnumType";
                break;
            }
            case 59: {
                objectArray = objectArray;
                objectArray[2] = "getTypeFromTypeGuard";
                break;
            }
            case 60: {
                objectArray = objectArray;
                objectArray[2] = "evaluateDestructuringContainer";
                break;
            }
            case 61: {
                objectArray = objectArray;
                objectArray[2] = "addTypeFromAmdModuleReference";
                break;
            }
            case 62: {
                objectArray = objectArray;
                objectArray[2] = "isFromCurrentFile";
                break;
            }
            case 63: {
                objectArray = objectArray;
                objectArray[2] = "evaluateCachedTypes";
                break;
            }
            case 64: {
                objectArray = objectArray;
                objectArray[2] = "processInstanceContextForClass";
                break;
            }
            case 65: {
                objectArray = objectArray;
                objectArray[2] = "addTypeFromProperty";
                break;
            }
            case 66: {
                objectArray = objectArray;
                objectArray[2] = "addNamespaceFromQualifiedNamedElement";
                break;
            }
            case 67: {
                objectArray = objectArray;
                objectArray[2] = "addTypeFromClassCandidate";
                break;
            }
            case 68: {
                objectArray = objectArray;
                objectArray[2] = "getClassConstructor";
                break;
            }
            case 69: {
                objectArray = objectArray;
                objectArray[2] = "addLoopVariable";
                break;
            }
            case 77: {
                objectArray = objectArray;
                objectArray[2] = "addTypeFromLiteralExpression";
                break;
            }
            case 78: {
                objectArray = objectArray;
                objectArray[2] = "getTypeFromConstant";
                break;
            }
            case 79: 
            case 80: {
                objectArray = objectArray;
                objectArray[2] = "addAdditionalTypes";
                break;
            }
            case 83: {
                objectArray = objectArray;
                objectArray[2] = "getTypeFromSimplePropertyValue";
                break;
            }
            case 84: 
            case 85: {
                objectArray = objectArray;
                objectArray[2] = "findDef";
                break;
            }
            case 86: {
                objectArray = objectArray;
                objectArray[2] = "addTypeFromDefExpr";
                break;
            }
            case 87: {
                objectArray = objectArray;
                objectArray[2] = "tryAddTypeFromInitializerReference";
                break;
            }
            case 88: 
            case 89: 
            case 90: {
                objectArray = objectArray;
                objectArray[2] = "processItem";
                break;
            }
            case 91: {
                objectArray = objectArray;
                objectArray[2] = "canEvaluateTypeOfType";
                break;
            }
            case 92: 
            case 93: {
                objectArray = objectArray;
                objectArray[2] = "canProcessWithEvaluationGuard";
                break;
            }
            case 94: 
            case 95: 
            case 96: {
                objectArray = objectArray;
                objectArray[2] = "processWithEvaluationGuard";
                break;
            }
            case 97: {
                objectArray = objectArray;
                objectArray[2] = "getExpressionTypeWithGuard";
                break;
            }
            case 98: {
                objectArray = objectArray;
                objectArray[2] = "applyContextAndProcessResolvedElement";
                break;
            }
            case 99: 
            case 100: {
                objectArray = objectArray;
                objectArray[2] = "applyDestructuringPropertyAndProcessResolvedElement";
                break;
            }
            case 101: {
                objectArray = objectArray;
                objectArray[2] = "lambda$applyContextAndProcessResolvedElement$29";
                break;
            }
            case 102: {
                objectArray = objectArray;
                objectArray[2] = "lambda$addAdditionalTypes$24";
                break;
            }
            case 103: {
                objectArray = objectArray;
                objectArray[2] = "lambda$addAdditionalTypes$23";
                break;
            }
            case 104: {
                objectArray = objectArray;
                objectArray[2] = "lambda$processFunction$18";
                break;
            }
            case 105: {
                objectArray = objectArray;
                objectArray[2] = "lambda$addTypeFromModuleFile$17";
                break;
            }
            case 106: {
                objectArray = objectArray;
                objectArray[2] = "lambda$null$16";
                break;
            }
            case 107: {
                objectArray = objectArray;
                objectArray[2] = "lambda$addTypeFromModuleFile$14";
                break;
            }
            case 108: {
                objectArray = objectArray;
                objectArray[2] = "lambda$processCreateMethodCall$11";
                break;
            }
            case 109: {
                objectArray = objectArray;
                objectArray[2] = "lambda$processApplyOrCallMethodCall$10";
                break;
            }
            case 110: {
                objectArray = objectArray;
                objectArray[2] = "lambda$evaluateCallExpressionTypes$9";
                break;
            }
            case 111: {
                objectArray = objectArray;
                objectArray[2] = "lambda$evaluateNewExpressionTypes$8";
                break;
            }
            case 112: 
            case 113: {
                objectArray = objectArray;
                objectArray[2] = "lambda$applyContextAndProcess$4";
                break;
            }
            case 114: 
            case 115: {
                objectArray = objectArray;
                objectArray[2] = "lambda$applyContextAndProcess$3";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 29: 
            case 31: 
            case 32: 
            case 33: 
            case 51: 
            case 70: 
            case 71: 
            case 72: 
            case 73: 
            case 74: 
            case 75: 
            case 76: 
            case 81: 
            case 82: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

