/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.refactoring.introduceField;

import com.intellij.lang.ASTNode;
import com.intellij.lang.ecmascript6.psi.JSClassExpression;
import com.intellij.lang.javascript.DialectDetector;
import com.intellij.lang.javascript.DialectOptionHolder;
import com.intellij.lang.javascript.JSBundle;
import com.intellij.lang.javascript.JSLanguageDialect;
import com.intellij.lang.javascript.JSTokenTypes;
import com.intellij.lang.javascript.JavaScriptSupportLoader;
import com.intellij.lang.javascript.formatter.JSCodeStyleSettings;
import com.intellij.lang.javascript.psi.JSElement;
import com.intellij.lang.javascript.psi.JSExpression;
import com.intellij.lang.javascript.psi.JSExpressionStatement;
import com.intellij.lang.javascript.psi.JSFile;
import com.intellij.lang.javascript.psi.JSFunction;
import com.intellij.lang.javascript.psi.JSReferenceExpression;
import com.intellij.lang.javascript.psi.JSSourceElement;
import com.intellij.lang.javascript.psi.JSStatement;
import com.intellij.lang.javascript.psi.JSVarStatement;
import com.intellij.lang.javascript.psi.JSVariable;
import com.intellij.lang.javascript.psi.ecmal4.JSAttributeList;
import com.intellij.lang.javascript.psi.ecmal4.JSClass;
import com.intellij.lang.javascript.psi.ecmal4.JSReferenceListMember;
import com.intellij.lang.javascript.psi.ecmal4.XmlBackedJSClassFactory;
import com.intellij.lang.javascript.psi.impl.JSChangeUtil;
import com.intellij.lang.javascript.psi.resolve.JSResolveUtil;
import com.intellij.lang.javascript.psi.util.JSClassUtils;
import com.intellij.lang.javascript.psi.util.JSUtils;
import com.intellij.lang.javascript.refactoring.introduce.BasicIntroducedEntityInfoProvider;
import com.intellij.lang.javascript.refactoring.introduce.JSBaseIntroduceHandler;
import com.intellij.lang.javascript.refactoring.introduceField.JSFieldInplaceInplaceIntroducer;
import com.intellij.lang.javascript.refactoring.introduceField.JSIntroduceFieldDialog;
import com.intellij.lang.javascript.refactoring.introduceField.JSIntroduceFieldSettings;
import com.intellij.lang.javascript.refactoring.introduceVariable.InplaceSettings;
import com.intellij.lang.javascript.validation.fixes.BaseCreateMethodsFix;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.codeStyle.CodeStyleManager;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.xml.XmlFile;
import com.intellij.refactoring.introduce.inplace.OccurrencesChooser;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.containers.ContainerUtil;
import java.util.Collection;
import java.util.EnumSet;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JSIntroduceFieldHandler
extends JSBaseIntroduceHandler<JSElement, JSIntroduceFieldSettings, JSIntroduceFieldDialog> {
    @Override
    protected String getRefactoringName() {
        return JSBundle.message((String)"javascript.introduce.field.title", (Object[])new Object[0]);
    }

    @Override
    protected String getCannotIntroduceMessagePropertyKey() {
        return "javascript.introduce.field.error.no.expression.selected";
    }

    @Override
    protected String getCannotIntroduceVoidExpressionTypeMessagePropertyKey() {
        return "javascript.introduce.field.error.expression.has.void.type";
    }

    @Override
    protected JSIntroduceFieldDialog createDialog(Project project, JSExpression expression, JSExpression[] occurrences, PsiElement scope) {
        Collection<JSIntroduceFieldSettings.InitializationPlace> places = JSIntroduceFieldHandler.calculateAvailableInitializationPlaces(expression);
        return new JSIntroduceFieldDialog(project, occurrences, expression, scope, places);
    }

    @Override
    protected JSElement findAnchor(JSBaseIntroduceHandler.BaseIntroduceContext<JSIntroduceFieldSettings> context, boolean replaceAllOccurences) {
        return JSIntroduceFieldHandler.findClassAnchor((PsiElement)context.expressionDescriptor.first);
    }

    @Override
    protected JSVariable addStatementBefore(JSElement anchor, JSVarStatement declaration) throws IncorrectOperationException {
        return JSIntroduceFieldHandler.addToClassAnchor(anchor, declaration);
    }

    @Override
    protected String getDeclText(JSBaseIntroduceHandler.BaseIntroduceContext<JSIntroduceFieldSettings> baseIntroduceContext, JSElement anchor) {
        String type;
        String textField = DialectDetector.isActionScript((PsiElement)anchor) ? "var" : "";
        String baseDeclText = this.calcDeclText(baseIntroduceContext, textField, anchor);
        JSIntroduceFieldSettings settings = (JSIntroduceFieldSettings)baseIntroduceContext.settings;
        if (settings.getInitializationPlace() != JSIntroduceFieldSettings.InitializationPlace.FieldDeclaration && DialectDetector.isTypeScript((PsiElement)anchor) && (type = settings.getVariableType()) != null) {
            baseDeclText = baseDeclText + ":" + type;
        }
        return JSIntroduceFieldHandler.prependAccessModifier(baseIntroduceContext, baseDeclText);
    }

    @Override
    @Nullable
    protected List<Pair<JSExpression, TextRange>> getCandidateExpressions(@NotNull Editor editor, @NotNull PsiFile file, int start, int end) {
        JSElement element;
        PsiElement elementAt;
        JSClass containingClass;
        if (editor == null) {
            JSIntroduceFieldHandler.$$$reportNull$$$0(0);
        }
        if (file == null) {
            JSIntroduceFieldHandler.$$$reportNull$$$0(1);
        }
        if ((containingClass = JSResolveUtil.getClassOfContext(elementAt = file.findElementAt(start))) == null) {
            this.showErrorHint(editor, file, JSBundle.message((String)"javascript.introduce.field.error.no.enclosing.class", (Object[])new Object[0]));
            return null;
        }
        PsiElement directParent = elementAt.getParent();
        if (elementAt instanceof PsiWhiteSpace && directParent instanceof JSClass) {
            this.showDefaultErrorHint(editor, file);
            return null;
        }
        if (directParent instanceof JSVariable) {
            ASTNode elementAtNode = elementAt.getNode();
            if (elementAtNode != null && elementAtNode.getElementType() == JSTokenTypes.COLON) {
                elementAt = elementAt.getPrevSibling();
            }
            if (elementAt instanceof PsiWhiteSpace) {
                elementAt = elementAt.getPrevSibling();
            }
            if (elementAt instanceof JSReferenceExpression) {
                directParent = elementAt;
            }
        } else if (directParent instanceof JSReferenceExpression && ((element = (JSElement)PsiTreeUtil.getParentOfType((PsiElement)directParent, (Class[])new Class[]{JSReferenceListMember.class, JSAttributeList.class, JSClass.class})) instanceof JSAttributeList || element instanceof JSReferenceListMember)) {
            this.showDefaultErrorHint(editor, file);
            return null;
        }
        if (JSIntroduceFieldHandler.introduceOverVariableNameRef(directParent)) {
            return ContainerUtil.list((Object[])new Pair[]{new Pair((Object)((JSReferenceExpression)directParent), null)});
        }
        return super.getCandidateExpressions(editor, file, start, end);
    }

    @Override
    protected boolean validateSelectedExpression(@NotNull PsiFile file, @NotNull Editor editor, @NotNull Pair<JSExpression, TextRange> introducedExpression) {
        if (file == null) {
            JSIntroduceFieldHandler.$$$reportNull$$$0(2);
        }
        if (editor == null) {
            JSIntroduceFieldHandler.$$$reportNull$$$0(3);
        }
        if (introducedExpression == null) {
            JSIntroduceFieldHandler.$$$reportNull$$$0(4);
        }
        if (!super.validateSelectedExpression(file, editor, introducedExpression)) {
            return false;
        }
        JSClass containingClass = JSResolveUtil.getClassOfContext((PsiElement)introducedExpression.first);
        if (containingClass == null && introducedExpression.first instanceof JSClassExpression) {
            this.showDefaultErrorHint(editor, file);
            return false;
        }
        return true;
    }

    @Override
    protected JSExpression getReplacementExpression(Pair<JSExpression, TextRange> expressionDescriptor) {
        if (JSIntroduceFieldHandler.introduceOverVariableNameRef((PsiElement)expressionDescriptor.first)) {
            return ((JSVariable)((JSExpression)expressionDescriptor.first).getParent()).getInitializer();
        }
        return super.getReplacementExpression(expressionDescriptor);
    }

    @Override
    protected JSExpression createRefExpr(Project project, JSIntroduceFieldSettings settings, JSLanguageDialect languageDialect) {
        if (languageDialect.isKindOf(JavaScriptSupportLoader.ECMA_SCRIPT_L4)) {
            return super.createRefExpr(project, settings, languageDialect);
        }
        return (JSExpression)JSChangeUtil.createExpressionFromText(project, "this." + settings.getVariableName(), languageDialect).getPsi();
    }

    @Override
    protected Pair<JSVarStatement, Boolean> prepareDeclaration(String varDeclText, JSBaseIntroduceHandler.BaseIntroduceContext<JSIntroduceFieldSettings> context, Project project, @Nullable JSLanguageDialect languageDialect, JSElement anchorStatement, Editor editor, JSExpression introducedExpression) throws IncorrectOperationException {
        JSExpression initializer;
        JSIntroduceFieldSettings.InitializationPlace place = ((JSIntroduceFieldSettings)context.settings).getInitializationPlace();
        if (place == JSIntroduceFieldSettings.InitializationPlace.FieldDeclaration) {
            JSExpression initializerReplacementExpression = this.getReplacementExpression(context.expressionDescriptor);
            JSVarStatement declaration = (JSVarStatement)JSIntroduceFieldHandler.createField(varDeclText + (initializerReplacementExpression != null ? " = 0" : ""), project, languageDialect, anchorStatement);
            this.replaceInitializer(initializerReplacementExpression, declaration);
            return Pair.create((Object)declaration, (Object)Boolean.FALSE);
        }
        boolean replacedOriginal = false;
        String introducedExpressionText = JSIntroduceFieldHandler.introduceOverVariableNameRef((PsiElement)context.expressionDescriptor.first) ? ((initializer = this.getReplacementExpression(context.expressionDescriptor)) != null ? initializer.getText() : null) : this.getIntroducedExpressionText(context.expressionDescriptor);
        String nameAccess = StringUtil.notNullize((String)JSClassUtils.getDefaultFieldQualifier((PsiElement)anchorStatement, true)) + ((JSIntroduceFieldSettings)context.settings).getVariableName();
        String assignmentText = nameAccess + (introducedExpressionText != null ? "=" + introducedExpressionText : "") + JSCodeStyleSettings.getSemicolon((PsiElement)anchorStatement.getContainingFile());
        PsiElement psiToInsert = JSChangeUtil.createStatementFromTextWithContext(assignmentText, (PsiElement)context.expressionDescriptor.first).getPsi();
        if (place == JSIntroduceFieldSettings.InitializationPlace.CurrentMethod) {
            replacedOriginal = this.addValueAssignmentInCurrentMethod(context, project, psiToInsert);
        } else if (place == JSIntroduceFieldSettings.InitializationPlace.Constructor) {
            JSIntroduceFieldHandler.createConstructorAndAddValueAssignment(context, project, languageDialect, psiToInsert);
        }
        PsiElement field = JSIntroduceFieldHandler.createField(varDeclText, project, languageDialect, anchorStatement);
        Pair result = Pair.create((Object)((JSVarStatement)field), (Object)(replacedOriginal ? Boolean.TRUE : Boolean.FALSE));
        if (replacedOriginal) {
            JSVariable jsStatement = this.addStatementBefore(anchorStatement, (JSVarStatement)result.first);
            JSIntroduceFieldHandler.fixFormat(project, (PsiElement)jsStatement);
        }
        return result;
    }

    private boolean addValueAssignmentInCurrentMethod(JSBaseIntroduceHandler.BaseIntroduceContext<JSIntroduceFieldSettings> context, Project project, PsiElement psiToInsert) {
        PsiElement addedElement;
        boolean replacedOriginal = false;
        JSElement element = this.getAnchorToAddMethod(context);
        PsiElement parent = element.getParent();
        if (JSIntroduceFieldHandler.isExprStatementWithUnneededRef((JSIntroduceFieldSettings)context.settings, element, context.expressionDescriptor)) {
            addedElement = element.replace(psiToInsert);
            replacedOriginal = true;
            parent = addedElement.getParent();
        } else if (JSIntroduceFieldHandler.introduceOverVariableNameRef((PsiElement)context.expressionDescriptor.first)) {
            JSVariable[] variables = ((JSVarStatement)element).getVariables();
            if (variables.length == 1) {
                addedElement = element.replace(psiToInsert);
            } else {
                addedElement = element.getParent().addBefore(psiToInsert, (PsiElement)element);
                ((JSExpression)context.expressionDescriptor.first).getParent().delete();
            }
            replacedOriginal = true;
            parent = addedElement.getParent();
        } else {
            addedElement = parent.addBefore(psiToInsert, (PsiElement)element);
        }
        CodeStyleManager.getInstance((Project)project).reformatNewlyAddedElement(parent.getNode(), addedElement.getNode());
        return replacedOriginal;
    }

    private JSElement getAnchorToAddMethod(JSBaseIntroduceHandler.BaseIntroduceContext<JSIntroduceFieldSettings> context) {
        JSExpression expression = (JSExpression)context.expressionDescriptor.first;
        if (DialectDetector.isActionScript((PsiElement)expression)) {
            return super.findAnchor(context, ((JSIntroduceFieldSettings)context.settings).isReplaceAllOccurrences());
        }
        return JSUtils.findSourceAnchor((PsiElement)expression, true);
    }

    private static void createConstructorAndAddValueAssignment(JSBaseIntroduceHandler.BaseIntroduceContext<JSIntroduceFieldSettings> context, Project project, JSLanguageDialect languageDialect, PsiElement psiToInsert) {
        JSSourceElement body;
        JSStatement statement;
        PsiElement parent = PsiTreeUtil.getParentOfType((PsiElement)((PsiElement)context.expressionDescriptor.first), (Class[])new Class[]{JSClass.class, JSFile.class});
        if (parent instanceof JSFile) {
            PsiFile containingFile = parent.getContext().getContainingFile();
            assert (containingFile instanceof XmlFile);
            parent = XmlBackedJSClassFactory.getXmlBackedClass((XmlFile)containingFile);
        }
        assert (parent instanceof JSClass);
        JSClass clazz = (JSClass)parent;
        JSFunction fun = clazz.getConstructor();
        if (fun == null) {
            boolean isPublic = clazz.getAttributeList() != null && clazz.getAttributeList().getAccessType() == JSAttributeList.AccessType.PUBLIC;
            String constr = JSClassUtils.createConstructorSignatureForClass(clazz, isPublic) + "() {}";
            ASTNode member = JSChangeUtil.createClassMemberFromText(project, constr, languageDialect);
            fun = (JSFunction)BaseCreateMethodsFix.addMethodToClassWithoutAnchor(clazz, languageDialect, member.getPsi(), null);
        }
        if ((statement = (JSStatement)PsiTreeUtil.getChildOfType((PsiElement)(body = fun.getBody()[0]), JSStatement.class)) != null) {
            JSStatement jsStatement = statement.addStatementBefore((JSStatement)psiToInsert);
            JSIntroduceFieldHandler.fixFormat(project, (PsiElement)jsStatement);
        } else {
            body.add(psiToInsert);
        }
    }

    private static PsiElement createField(String varDeclText, Project project, JSLanguageDialect languageDialect, JSElement anchorStatement) {
        String newValue = varDeclText + JSCodeStyleSettings.getSemicolon((PsiElement)anchorStatement.getContainingFile());
        return JSChangeUtil.createClassMemberFromText(project, newValue, languageDialect).getPsi();
    }

    private static boolean isExprStatementWithUnneededRef(JSIntroduceFieldSettings settings, JSElement introduceContext, Pair<JSExpression, TextRange> expressionDescriptor) {
        if (settings.getInitializationPlace() == JSIntroduceFieldSettings.InitializationPlace.CurrentMethod) {
            return introduceContext instanceof JSExpressionStatement && expressionDescriptor.second == null && ((JSExpression)expressionDescriptor.first).getParent() instanceof JSExpressionStatement;
        }
        return false;
    }

    public static Collection<JSIntroduceFieldSettings.InitializationPlace> calculateAvailableInitializationPlaces(JSExpression mainOccurrence) {
        DialectOptionHolder optionHolder = DialectDetector.dialectOfElement((PsiElement)mainOccurrence);
        EnumSet<JSIntroduceFieldSettings.InitializationPlace> values = EnumSet.allOf(JSIntroduceFieldSettings.InitializationPlace.class);
        boolean localContextDependent = JSIntroduceFieldHandler.isLocalContextDependent(mainOccurrence);
        boolean canHaveInitializeFieldInConstructor = JSIntroduceFieldHandler.canHaveInitializerInConstructor(mainOccurrence);
        boolean canHaveInitializerInMethod = JSIntroduceFieldHandler.canHaveInitializerInMethod(mainOccurrence, optionHolder);
        if (!canHaveInitializeFieldInConstructor) {
            values.remove((Object)JSIntroduceFieldSettings.InitializationPlace.Constructor);
        }
        if (!canHaveInitializerInMethod) {
            values.remove((Object)JSIntroduceFieldSettings.InitializationPlace.CurrentMethod);
        }
        if (localContextDependent) {
            values.remove((Object)JSIntroduceFieldSettings.InitializationPlace.Constructor);
            values.remove((Object)JSIntroduceFieldSettings.InitializationPlace.FieldDeclaration);
        }
        return values;
    }

    private static boolean isLocalContextDependent(JSExpression mainOccurence) {
        JSExpression elementToCheckDependence = JSBaseIntroduceHandler.introduceOverVariableNameRef((PsiElement)mainOccurence) ? mainOccurence.getParent() : mainOccurence;
        return JSBaseIntroduceHandler.calcDependsOnContext((PsiElement)elementToCheckDependence, true, true);
    }

    private static boolean canHaveInitializerInMethod(JSExpression mainOccurrence, DialectOptionHolder dialectOptionHolder) {
        return dialectOptionHolder == null || dialectOptionHolder.isECMA4 || !(JSUtils.findSourceAnchor((PsiElement)mainOccurrence, false) instanceof JSClass);
    }

    private static boolean canHaveInitializerInConstructor(JSExpression mainOccurrence) {
        return ((PsiFile)PsiTreeUtil.getParentOfType((PsiElement)mainOccurrence, PsiFile.class)).getContext() == null && !JSResolveUtil.calculateStaticFromContext((PsiElement)mainOccurrence) && !JSIntroduceFieldHandler.containsAwaitExpressions(mainOccurrence);
    }

    @Override
    protected boolean isInplaceIntroduce(Editor editor, PsiFile file) {
        return false;
    }

    @Override
    protected InplaceSettings<JSIntroduceFieldSettings> getInplaceSettings(Pair<JSExpression, TextRange> expr, JSExpression[] occurrences, PsiElement scope, final OccurrencesChooser.ReplaceChoice choice) {
        BasicIntroducedEntityInfoProvider entityInfoProvider = new BasicIntroducedEntityInfoProvider((JSExpression)expr.first, occurrences, scope);
        final String[] candidateNames = entityInfoProvider.suggestCandidateNames();
        final String myIntroducedName = candidateNames.length > 0 ? candidateNames[0].trim() : "newVar";
        return new InplaceSettings<JSIntroduceFieldSettings>(){

            @Override
            public String[] getSuggestedNames() {
                return candidateNames;
            }

            @Override
            public JSIntroduceFieldSettings getSettings() {
                return new JSIntroduceFieldSettings(){

                    @Override
                    public JSAttributeList.AccessType getAccessType() {
                        return JSAttributeList.AccessType.PACKAGE_LOCAL;
                    }

                    @Override
                    public JSIntroduceFieldSettings.InitializationPlace getInitializationPlace() {
                        return JSIntroduceFieldSettings.InitializationPlace.FieldDeclaration;
                    }

                    @Override
                    public boolean isReplaceAllOccurrences() {
                        return choice == OccurrencesChooser.ReplaceChoice.ALL;
                    }

                    @Override
                    public String getVariableName() {
                        return myIntroducedName;
                    }

                    @Override
                    public String getVariableType() {
                        return null;
                    }
                };
            }
        };
    }

    protected JSFieldInplaceInplaceIntroducer createInplaceIntroducer(JSBaseIntroduceHandler.BaseIntroduceContext<JSIntroduceFieldSettings> context, JSElement scope, Editor editor, Project project, JSExpression[] occurences) {
        return new JSFieldInplaceInplaceIntroducer(project, editor, occurences, this, context);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
            case 1: 
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "introducedExpression";
                break;
            }
        }
        objectArray2[1] = "com/intellij/lang/javascript/refactoring/introduceField/JSIntroduceFieldHandler";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "getCandidateExpressions";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "validateSelectedExpression";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

