/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.dsm.model.classes;

import com.intellij.dsm.model.DsmModelImpl;
import com.intellij.dsm.model.DsmTreeStructure;
import com.intellij.dsm.model.classes.DependencyVisitor;
import com.intellij.dsm.model.classes.TopToBottomTreeStructure;
import com.intellij.dsm.settings.DsmViewSettings;
import com.intellij.dsm.ui.DsmView;
import com.intellij.openapi.util.IconLoader;
import java.awt.BorderLayout;
import java.awt.Container;
import java.io.File;
import java.io.IOException;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import javax.swing.JFrame;
import org.gga.graph.Edge;
import org.gga.graph.Graph;
import org.gga.graph.Morph;
import org.gga.graph.flow.PushRelabelMaxFlow;
import org.gga.graph.maps.DataGraph;
import org.gga.graph.search.bfs.BreadthFirstSearch;
import org.gga.graph.search.bfs.ParentRecorder;
import org.jetbrains.annotations.NotNull;

public class DsmTableTest {
    private static final String JAR_NAME = "/Applications/IntelliJ IDEA 16.2.app/Contents/lib/idea.jar";
    private static final String DIR_NAME = "/Users/mike/Depot/IDEA/out/classes/production/";

    private DsmTableTest() {
    }

    public static void main(String[] args) throws IOException {
        IconLoader.activate();
        long time = System.currentTimeMillis();
        DataGraph<String, Integer> graph = DsmTableTest.buildJarDeps();
        System.out.println("Analysis took: " + (double)(System.currentTimeMillis() - time) / 1000.0);
        time = System.currentTimeMillis();
        DsmViewSettings settings = new DsmViewSettings();
        TopToBottomTreeStructure<String> treeStructure = new TopToBottomTreeStructure<String>(graph){

            @Override
            protected String getLeafShortName(String s) {
                return s;
            }

            @Override
            protected String getLeafFullName(String s) {
                return s;
            }

            @Override
            @NotNull
            public DsmTreeStructure<String> createNewStructure(DataGraph<String, Integer> dataGraph) {
                throw new UnsupportedOperationException("Method createNewStructure not implemented in " + this.getClass());
            }
        };
        DsmModelImpl<String> dsmModel = new DsmModelImpl<String>(graph, treeStructure, String.class);
        System.out.println("Model built in:" + (double)(System.currentTimeMillis() - time) / 1000.0 + " - model size: " + dsmModel.getSize());
        time = System.currentTimeMillis();
        JFrame frame = new JFrame();
        Container contentPane = frame.getContentPane();
        contentPane.setLayout(new BorderLayout());
        contentPane.add(new DsmView<String>(dsmModel, settings));
        frame.setSize(1024, 768);
        frame.setLocation(200, 200);
        frame.setDefaultCloseOperation(3);
        frame.setVisible(true);
        System.out.println("Frame prepared in:" + (double)(System.currentTimeMillis() - time) / 1000.0);
    }

    private static DataGraph<String, Integer> calcPackages(DataGraph<String, Integer> graph) {
        graph = Morph.morph(graph, s -> {
            int index = s.lastIndexOf("/");
            if (index < 0) {
                return "*";
            }
            return s.substring(0, index) + "/*";
        }, l -> l.stream().mapToInt(Integer::intValue).sum());
        return graph;
    }

    private static Set<Edge> findWeakLinks(Graph componentGraph, int[] capacity, Graph rComponentGraph, int src) {
        HashSet<Edge> result = new HashSet<Edge>();
        int isFacade = 0;
        block0: for (int dst = 0; dst < componentGraph.V() && isFacade < 50; ++dst) {
            int flow;
            if (dst == src || (flow = PushRelabelMaxFlow.maxFlow(componentGraph, rComponentGraph, capacity, src, dst)) != 1) continue;
            int[] parents = new int[componentGraph.V()];
            BreadthFirstSearch.breadthFirstSearch(componentGraph, new ParentRecorder(parents), src);
            int w = dst;
            int v = parents[w];
            while (v != src) {
                int f1 = PushRelabelMaxFlow.maxFlow(componentGraph, rComponentGraph, capacity, src, v);
                if (f1 > 1) {
                    Edge e = componentGraph.edge(v, w);
                    assert (e != null);
                    result.add(e);
                    continue block0;
                }
                w = v;
                v = parents[v];
            }
            ++isFacade;
            Edge e = componentGraph.edge(v, w);
            assert (e != null);
            result.add(e);
        }
        return result;
    }

    private static DataGraph<String, Integer> buildDirDeps(File file) throws IOException {
        File[] files;
        DependencyVisitor v = new DependencyVisitor();
        HashMap<String, String> prefixes = new HashMap<String, String>();
        for (File f : files = file.listFiles()) {
            if (!f.isDirectory()) continue;
            System.out.print(".");
            DsmTableTest._buildDirDeps(v, f, f.getName() + ":", prefixes);
        }
        System.out.println("");
        return v.getDependencies().toSimpleGraph();
    }

    private static void _buildDirDeps(DependencyVisitor v, File file, String prefix, Map<String, String> prefixes) throws IOException {
        File[] files;
        for (File f : files = file.listFiles()) {
            if (f.isDirectory()) {
                DsmTableTest._buildDirDeps(v, f, prefix, prefixes);
                continue;
            }
            if (!f.getName().endsWith(".class")) continue;
            v.processFile(f);
            prefixes.put(v.getCurrentClassName(), prefix);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static DataGraph<String, Integer> buildJarDeps() throws IOException {
        DependencyVisitor v = new DependencyVisitor();
        try (ZipFile f = new ZipFile(JAR_NAME);){
            Enumeration<? extends ZipEntry> en = f.entries();
            while (en.hasMoreElements()) {
                ZipEntry e = en.nextElement();
                String name = e.getName();
                if (!name.endsWith(".class")) continue;
                v.processStream(f.getInputStream(e));
            }
            DataGraph<String, Integer> dataGraph = v.getDependencies().toSimpleGraph();
            return dataGraph;
        }
    }
}

