/*
 * Decompiled with CFR 0.152.
 */
package org.lobobrowser.gui;

import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.lobobrowser.ua.NavigationEntry;
import org.lobobrowser.util.Urls;

public class NavigationEngine {
    private static final Logger logger = Logger.getLogger(NavigationEngine.class.getName());
    private final ArrayList<NavigationEntry> history = new ArrayList();
    private int currentIndex = -1;

    public NavigationEntry getCurrentEntry() {
        try {
            return this.history.get(this.currentIndex);
        }
        catch (IndexOutOfBoundsException iob) {
            return null;
        }
    }

    public void addNavigationEntry(NavigationEntry entry) {
        int newIndex;
        if (logger.isLoggable(Level.INFO)) {
            logger.info("addNavigationEntry(): entry=" + entry);
        }
        if ((newIndex = this.currentIndex + 1) == this.history.size()) {
            this.history.add(entry);
        } else {
            if (newIndex > this.history.size()) {
                throw new IllegalStateException("currentIndex=" + this.currentIndex + ",size=" + this.history.size());
            }
            this.history.set(newIndex, entry);
        }
        this.currentIndex = newIndex;
        int nextIndex = newIndex + 1;
        while (nextIndex < this.history.size()) {
            this.history.remove(nextIndex);
        }
    }

    public boolean hasNext() {
        return this.currentIndex + 1 < this.history.size();
    }

    public boolean hasPrev() {
        return this.currentIndex > 0;
    }

    public boolean hasNextWithGET() {
        return this.hasNewEntryWithGET(1);
    }

    public boolean hasPrevWithGET() {
        return this.hasNewEntryWithGET(-1);
    }

    public boolean hasNewEntryWithGET(int offset) {
        int nextIndex = this.currentIndex;
        while ((nextIndex += offset) >= 0 && nextIndex < this.history.size()) {
            NavigationEntry entry = this.history.get(nextIndex);
            if (!"GET".equals(entry.getMethod())) continue;
            return true;
        }
        return false;
    }

    public NavigationEntry back() {
        return this.move(-1);
    }

    public NavigationEntry forward() {
        return this.move(1);
    }

    public NavigationEntry move(int offset) {
        int nextIndex = this.currentIndex + offset;
        if (nextIndex >= 0 && nextIndex < this.history.size()) {
            this.currentIndex = nextIndex;
            return this.history.get(this.currentIndex);
        }
        return null;
    }

    public boolean moveTo(NavigationEntry entry) {
        int newIndex = this.history.indexOf(entry);
        if (newIndex == -1) {
            return false;
        }
        this.currentIndex = newIndex;
        return true;
    }

    public NavigationEntry[] getForwardNavigationEntries() {
        ArrayList<NavigationEntry> entries = new ArrayList<NavigationEntry>();
        int size = this.history.size();
        for (int index = this.currentIndex + 1; index < size; ++index) {
            entries.add(this.history.get(index));
        }
        return entries.toArray(new NavigationEntry[0]);
    }

    public NavigationEntry[] getBackNavigationEntries() {
        ArrayList<NavigationEntry> entries = new ArrayList<NavigationEntry>();
        for (int index = this.currentIndex - 1; index >= 0; --index) {
            entries.add(this.history.get(index));
        }
        return entries.toArray(new NavigationEntry[0]);
    }

    public NavigationEntry findEntry(String absoluteURL) {
        try {
            URL targetURL = Urls.guessURL(absoluteURL);
            for (NavigationEntry entry : this.history) {
                if (!Urls.sameNoRefURL(targetURL, entry.getUrl())) continue;
                return entry;
            }
            return null;
        }
        catch (MalformedURLException mfu) {
            if (logger.isLoggable(Level.INFO)) {
                logger.log(Level.INFO, "findEntry(): URL is malformed: " + absoluteURL, mfu);
            }
            return null;
        }
    }

    public int getLength() {
        return this.history.size();
    }
}

