/*
 * Decompiled with CFR 0.152.
 */
package org.lobobrowser.http;

import java.io.StringWriter;
import java.util.Properties;
import java.util.logging.Logger;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpression;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;
import org.lobobrowser.http.XPathFunctionResolverImpl;
import org.w3c.dom.Document;
import org.w3c.dom.Node;

public class XPathUtils {
    private static final Logger logger = Logger.getLogger(XPathUtils.class.getName());
    private static final XPath xpath = XPathFactory.newInstance().newXPath();
    private static final XPathFunctionResolverImpl functionResolver = new XPathFunctionResolverImpl();

    private XPathUtils() {
    }

    public static synchronized Node getElement(String expression, Node node) throws XPathExpressionException {
        Node n = (Node)xpath.evaluate(expression, node, XPathConstants.NODE);
        return n;
    }

    public static synchronized String getString(String expression, Node node) throws XPathExpressionException {
        Node n = (Node)xpath.evaluate(expression, node, XPathConstants.NODE);
        return n == null ? null : n.getTextContent();
    }

    public static synchronized String getString(String expression, Node node, String namespace, String namespacePrefix) throws XPathExpressionException {
        functionResolver.addNamespaceMapping(namespacePrefix, namespace);
        Node n = (Node)xpath.evaluate(expression, node, XPathConstants.NODE);
        functionResolver.removeNamespaceMapping(namespacePrefix);
        return n == null ? null : n.getTextContent();
    }

    public static synchronized Node getElement(XPathExpression expression, Node node) throws XPathExpressionException {
        Node n = (Node)expression.evaluate(node, XPathConstants.NODE);
        return n;
    }

    public static synchronized String getString(XPathExpression expression, Node node) throws XPathExpressionException {
        Node n = (Node)expression.evaluate(node, XPathConstants.NODE);
        return n == null ? null : n.getTextContent();
    }

    public static synchronized XPathExpression compile(String expression) throws XPathExpressionException {
        return xpath.compile(expression);
    }

    public static String toXML(Document dom) {
        return XPathUtils.toXML(dom, null);
    }

    public static String toXML(Document dom, Properties outputProperties) {
        try {
            DOMSource source = new DOMSource(dom);
            StringWriter writer = new StringWriter();
            StreamResult result = new StreamResult(writer);
            Transformer tx = TransformerFactory.newInstance().newTransformer();
            if (outputProperties != null) {
                tx.setOutputProperties(outputProperties);
            }
            tx.transform(source, result);
            String s = writer.toString();
            writer.close();
            return s;
        }
        catch (Exception e) {
            logger.severe(e.getMessage());
            return null;
        }
    }

    static {
        xpath.setNamespaceContext(functionResolver);
        xpath.setXPathFunctionResolver(functionResolver);
    }
}

