/*
 * Decompiled with CFR 0.152.
 */
package org.lobobrowser.request;

import java.net.URL;
import org.lobobrowser.clientlet.ClientletRequest;
import org.lobobrowser.http.Header;
import org.lobobrowser.request.UserAgentImpl;
import org.lobobrowser.ua.ParameterInfo;
import org.lobobrowser.ua.RequestType;
import org.lobobrowser.ua.UserAgent;

public class ClientletRequestImpl
implements ClientletRequest {
    private final String method;
    private final URL url;
    private final ParameterInfo paramInfo;
    private final Header[] extraHeaders;
    private final boolean forNewWindow;
    private final String referrer;
    private final String altPostData;
    private final RequestType requestType;

    public ClientletRequestImpl(boolean forNewWindow, URL url, String method, ParameterInfo paramInfo, Header[] extraHeaders, String referrer, String altPostData, RequestType requestType) {
        this.method = method;
        this.url = url;
        this.paramInfo = paramInfo;
        this.extraHeaders = extraHeaders;
        this.forNewWindow = forNewWindow;
        this.referrer = referrer;
        this.altPostData = altPostData;
        this.requestType = requestType;
    }

    public ClientletRequestImpl(boolean forNewWindow, URL url, String method, ParameterInfo paramInfo, RequestType requestType) {
        this(forNewWindow, url, method, paramInfo, null, null, null, requestType);
    }

    public ClientletRequestImpl(URL url, RequestType requestType) {
        this(false, url, "GET", null, null, null, null, requestType);
    }

    public ClientletRequestImpl(boolean forNewWindow, URL url, RequestType requestType) {
        this(forNewWindow, url, "GET", null, null, null, null, requestType);
    }

    public ClientletRequestImpl(URL url, String method, String altPostData, RequestType requestType) {
        this(false, url, method, null, null, null, altPostData, requestType);
    }

    @Override
    public Header[] getExtraHeaders() {
        return this.extraHeaders;
    }

    @Override
    public String getMethod() {
        return this.method;
    }

    @Override
    public ParameterInfo getParameterInfo() {
        return this.paramInfo;
    }

    @Override
    public URL getRequestURL() {
        return this.url;
    }

    @Override
    public UserAgent getUserAgent() {
        return UserAgentImpl.getInstance();
    }

    @Override
    public boolean isGetRequest() {
        return "GET".equalsIgnoreCase(this.method);
    }

    @Override
    public boolean isNewWindowRequest() {
        return this.forNewWindow;
    }

    @Override
    public boolean isPostRequest() {
        return "POST".equalsIgnoreCase(this.method);
    }

    @Override
    public String getReferrer() {
        return this.referrer;
    }

    @Override
    public String getAltPostData() {
        return this.altPostData;
    }

    @Override
    public RequestType getRequestType() {
        return this.requestType;
    }
}

