/*
 * Decompiled with CFR 0.152.
 */
package org.lobobrowser.request;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public class MultipartFormDataWriter {
    private static final byte[] LINE_BREAK_BYTES = "\r\n".getBytes();
    private final OutputStream out;
    private final String boundary;

    public MultipartFormDataWriter(OutputStream out, String boundary) {
        this.out = out;
        this.boundary = boundary;
    }

    public final void writeFileData(String name, String fileName, String contentType, InputStream in) throws IOException {
        int numRead;
        String headers = "--" + this.boundary + "\r\n" + "Content-Disposition: form-data; name=\"" + name + "\"; filename=\"" + fileName + "\"\r\n" + "Content-Type: " + contentType + "\r\n" + "\r\n";
        OutputStream out = this.out;
        out.write(headers.getBytes("ISO-8859-1"));
        byte[] buffer = new byte[4096];
        while ((numRead = in.read(buffer)) != -1) {
            out.write(buffer, 0, numRead);
        }
        out.write(LINE_BREAK_BYTES);
    }

    public final void writeText(String name, String value, String charset) throws IOException {
        String headers = "--" + this.boundary + "\r\n" + "Content-Disposition: form-data; name=\"" + name + "\"\r\n" + "Content-Type: text/plain; charset=\"" + charset + "\"\r\n" + "\r\n";
        OutputStream out = this.out;
        out.write(headers.getBytes("ISO-8859-1"));
        out.write(value.getBytes(charset));
        out.write(LINE_BREAK_BYTES);
    }

    public final void send() throws IOException {
        String finalDelimiter = "--" + this.boundary + "--\r\n";
        OutputStream out = this.out;
        out.write(finalDelimiter.getBytes("ISO-8859-1"));
        out.flush();
    }
}

