/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.graph.builder.actions.printing;

import com.intellij.openapi.graph.GraphManager;
import com.intellij.openapi.graph.builder.actions.printing.PrintOptionsDialog;
import com.intellij.openapi.graph.builder.actions.printing.PrintUtil;
import com.intellij.openapi.graph.option.OptionHandler;
import com.intellij.openapi.graph.view.Graph2DPrinter;
import com.intellij.openapi.graph.view.PrintPreviewPanel;
import com.intellij.openapi.project.Project;
import java.awt.event.ActionEvent;
import java.awt.print.PageFormat;
import java.awt.print.PrinterJob;
import javax.swing.AbstractAction;
import javax.swing.JButton;

public class Graph2DPrintPreviewPanel {
    private Graph2DPrintPreviewPanel() {
    }

    public static PrintPreviewPanel createPanel(final Project project, PrinterJob printJob, final Graph2DPrinter gp, PageFormat pf) {
        final PrintPreviewPanel panel = GraphManager.getGraphManager().createPrintPreviewPanel(printJob, gp, gp.getPosterColumns(), gp.getPosterColumns() * gp.getPosterRows(), pf);
        final OptionHandler options = PrintUtil.createPrintOptions();
        AbstractAction optionAction = new AbstractAction("Options..."){

            @Override
            public void actionPerformed(ActionEvent ev) {
                PrintOptionsDialog dialog = new PrintOptionsDialog(project, options);
                if (!dialog.showAndGet()) {
                    return;
                }
                PrintUtil.initGraph2DPrinter(gp, options);
                panel.setPages(0, gp.getPosterColumns(), gp.getPosterColumns() * gp.getPosterRows());
            }
        };
        panel.addControlComponent(new JButton(optionAction));
        return panel;
    }
}

