/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.testFramework;

import com.intellij.openapi.module.ModuleType;
import com.intellij.openapi.module.StdModuleTypes;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.roots.LanguageLevelProjectExtension;
import com.intellij.pom.java.LanguageLevel;
import com.intellij.psi.impl.JavaPsiFacadeEx;
import com.intellij.testFramework.IdeaTestUtil;
import com.intellij.testFramework.LightPlatformCodeInsightTestCase;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jetbrains.annotations.NotNull;

public abstract class LightCodeInsightTestCase
extends LightPlatformCodeInsightTestCase {
    private static final Pattern JDK_SELECT_PATTERN = Pattern.compile("Java([\\d.]+)(\\.java)?$");

    public static JavaPsiFacadeEx getJavaFacade() {
        return JavaPsiFacadeEx.getInstanceEx((Project)ourProject);
    }

    protected void setUp() throws Exception {
        super.setUp();
        this.setLanguageLevel(this.getLanguageLevel());
    }

    protected LanguageLevel getLanguageLevel() {
        LanguageLevel level;
        Matcher matcher = JDK_SELECT_PATTERN.matcher(this.getTestName(false));
        if (matcher.find() && (level = LanguageLevel.parse(matcher.group(1))) != null) {
            return level;
        }
        return this.getDefaultLanguageLevel();
    }

    protected LanguageLevel getDefaultLanguageLevel() {
        return LanguageLevel.HIGHEST;
    }

    protected void setLanguageLevel(LanguageLevel level) {
        LanguageLevelProjectExtension.getInstance(LightCodeInsightTestCase.getProject()).setLanguageLevel(level);
    }

    protected Sdk getProjectJDK() {
        return IdeaTestUtil.getMockJdk18();
    }

    @NotNull
    protected ModuleType getModuleType() {
        ModuleType moduleType = StdModuleTypes.JAVA;
        if (moduleType == null) {
            LightCodeInsightTestCase.$$$reportNull$$$0(0);
        }
        return moduleType;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/testFramework/LightCodeInsightTestCase", "getModuleType"));
    }
}

