/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.compiler.ast;

import org.eclipse.jdt.internal.compiler.ASTVisitor;
import org.eclipse.jdt.internal.compiler.ast.ASTNode;
import org.eclipse.jdt.internal.compiler.ast.BranchStatement;
import org.eclipse.jdt.internal.compiler.ast.SubRoutineStatement;
import org.eclipse.jdt.internal.compiler.ast.TryStatement;
import org.eclipse.jdt.internal.compiler.flow.FlowContext;
import org.eclipse.jdt.internal.compiler.flow.FlowInfo;
import org.eclipse.jdt.internal.compiler.lookup.BlockScope;

public class ContinueStatement
extends BranchStatement {
    public ContinueStatement(char[] label, int sourceStart, int sourceEnd) {
        super(label, sourceStart, sourceEnd);
    }

    public FlowInfo analyseCode(BlockScope currentScope, FlowContext flowContext, FlowInfo flowInfo) {
        FlowContext targetContext;
        FlowContext flowContext2 = targetContext = this.label == null ? flowContext.getTargetContextForDefaultContinue() : flowContext.getTargetContextForContinueLabel(this.label);
        if (targetContext == null) {
            if (this.label == null) {
                currentScope.problemReporter().invalidContinue(this);
            } else {
                currentScope.problemReporter().undefinedLabel(this);
            }
            return flowInfo;
        }
        if (targetContext == FlowContext.NotContinuableContext) {
            currentScope.problemReporter().invalidContinue(this);
            return flowInfo;
        }
        this.targetLabel = targetContext.continueLabel();
        FlowContext traversedContext = flowContext;
        int subIndex = 0;
        int maxSub = 5;
        this.subroutines = new SubRoutineStatement[maxSub];
        do {
            SubRoutineStatement sub;
            if ((sub = traversedContext.subRoutine()) != null) {
                if (subIndex == maxSub) {
                    this.subroutines = new SubRoutineStatement[maxSub *= 2];
                    System.arraycopy(this.subroutines, 0, this.subroutines, 0, subIndex);
                }
                this.subroutines[subIndex++] = sub;
                if (sub.isSubRoutineEscaping()) break;
            }
            traversedContext.recordReturnFrom(flowInfo.unconditionalInits());
            ASTNode node = traversedContext.associatedNode;
            if (node instanceof TryStatement) {
                TryStatement tryStatement = (TryStatement)node;
                flowInfo.addInitializationsFrom(tryStatement.subRoutineInits);
                continue;
            }
            if (traversedContext != targetContext) continue;
            targetContext.recordContinueFrom(flowInfo);
            break;
        } while ((traversedContext = traversedContext.parent) != null);
        if (subIndex != maxSub) {
            this.subroutines = new SubRoutineStatement[subIndex];
            System.arraycopy(this.subroutines, 0, this.subroutines, 0, subIndex);
        }
        return FlowInfo.DEAD_END;
    }

    public StringBuffer printStatement(int tab, StringBuffer output) {
        ContinueStatement.printIndent(tab, output).append("continue ");
        if (this.label != null) {
            output.append(this.label);
        }
        return output.append(';');
    }

    public void traverse(ASTVisitor visitor, BlockScope blockScope) {
        visitor.visit(this, blockScope);
        visitor.endVisit(this, blockScope);
    }
}

