/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javaee.ui.packaging;

import com.intellij.javaee.application.facet.JavaeeApplicationFacetType;
import com.intellij.javaee.ejb.facet.EjbFacet;
import com.intellij.javaee.facet.JavaeeFacet;
import com.intellij.javaee.ui.packaging.ChooseFacetsDialog;
import com.intellij.javaee.ui.packaging.JavaeeFacetClassesPackagingElement;
import com.intellij.javaee.web.facet.WebFacet;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ModuleRootModel;
import com.intellij.openapi.roots.ui.configuration.ModulesProvider;
import com.intellij.packaging.artifacts.Artifact;
import com.intellij.packaging.elements.CompositePackagingElement;
import com.intellij.packaging.elements.PackagingElementType;
import com.intellij.packaging.ui.ArtifactEditorContext;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import javax.swing.Icon;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public class JavaeeFacetClassesElementType
extends PackagingElementType<JavaeeFacetClassesPackagingElement> {
    @NonNls
    public static final String TYPE_ID = "javaee-facet-classes";

    public static JavaeeFacetClassesElementType getInstance() {
        return (JavaeeFacetClassesElementType)JavaeeFacetClassesElementType.getInstance(JavaeeFacetClassesElementType.class);
    }

    public JavaeeFacetClassesElementType() {
        super(TYPE_ID, "JavaEE Facet Classes");
    }

    @NotNull
    public List<? extends JavaeeFacetClassesPackagingElement> chooseAndCreate(@NotNull ArtifactEditorContext context, @NotNull Artifact artifact, @NotNull CompositePackagingElement<?> parent) {
        if (context == null) {
            JavaeeFacetClassesElementType.$$$reportNull$$$0(0);
        }
        if (artifact == null) {
            JavaeeFacetClassesElementType.$$$reportNull$$$0(1);
        }
        if (parent == null) {
            JavaeeFacetClassesElementType.$$$reportNull$$$0(2);
        }
        List<JavaeeFacet> facets = JavaeeFacetClassesElementType.getJavaeeFacetsWithModifiedSourceRoots(context);
        ChooseFacetsDialog dialog = new ChooseFacetsDialog(context.getProject(), new ArrayList<JavaeeFacet>(facets), "Choose Facets", "");
        dialog.show();
        ArrayList<JavaeeFacetClassesPackagingElement> elements = new ArrayList<JavaeeFacetClassesPackagingElement>();
        if (dialog.isOK()) {
            for (JavaeeFacet facet : dialog.getChosenElements()) {
                elements.add(new JavaeeFacetClassesPackagingElement(facet));
            }
        }
        ArrayList<JavaeeFacetClassesPackagingElement> arrayList = elements;
        if (arrayList == null) {
            JavaeeFacetClassesElementType.$$$reportNull$$$0(3);
        }
        return arrayList;
    }

    private static List<JavaeeFacet> getJavaeeFacetsWithModifiedSourceRoots(ArtifactEditorContext context) {
        ArrayList<JavaeeFacet> facets = new ArrayList<JavaeeFacet>();
        ModulesProvider modulesProvider = context.getModulesProvider();
        for (Module module : modulesProvider.getModules()) {
            List<String> moduleSourceRoots = JavaeeFacetClassesElementType.getModuleProductionSourceRootUrls(modulesProvider.getRootModel(module));
            Collection webFacets = context.getFacetsProvider().getFacetsByType(module, WebFacet.ID);
            for (WebFacet webFacet : webFacets) {
                if (webFacet.getWebSourceRootUrls().containsAll(moduleSourceRoots)) continue;
                facets.add((JavaeeFacet)webFacet);
            }
            for (EjbFacet ejbFacet : context.getFacetsProvider().getFacetsByType(module, EjbFacet.ID)) {
                if (ejbFacet.getEjbSourceRootUrls().containsAll(moduleSourceRoots)) continue;
                facets.add((JavaeeFacet)ejbFacet);
            }
        }
        return facets;
    }

    @NotNull
    public static List<String> getModuleProductionSourceRootUrls(ModuleRootModel rootModel) {
        List<String> list = Arrays.asList(rootModel.getSourceRootUrls(false));
        if (list == null) {
            JavaeeFacetClassesElementType.$$$reportNull$$$0(4);
        }
        return list;
    }

    @NotNull
    public JavaeeFacetClassesPackagingElement createEmpty(@NotNull Project project) {
        if (project == null) {
            JavaeeFacetClassesElementType.$$$reportNull$$$0(5);
        }
        JavaeeFacetClassesPackagingElement javaeeFacetClassesPackagingElement = new JavaeeFacetClassesPackagingElement(project);
        if (javaeeFacetClassesPackagingElement == null) {
            JavaeeFacetClassesElementType.$$$reportNull$$$0(6);
        }
        return javaeeFacetClassesPackagingElement;
    }

    public Icon getCreateElementIcon() {
        return JavaeeApplicationFacetType.getInstance().getIcon();
    }

    public boolean canCreate(@NotNull ArtifactEditorContext context, @NotNull Artifact artifact) {
        if (context == null) {
            JavaeeFacetClassesElementType.$$$reportNull$$$0(7);
        }
        if (artifact == null) {
            JavaeeFacetClassesElementType.$$$reportNull$$$0(8);
        }
        return !JavaeeFacetClassesElementType.getJavaeeFacetsWithModifiedSourceRoots(context).isEmpty();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: 
            case 4: 
            case 6: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: 
            case 4: 
            case 6: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 1: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "artifact";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parent";
                break;
            }
            case 3: 
            case 4: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/javaee/ui/packaging/JavaeeFacetClassesElementType";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/javaee/ui/packaging/JavaeeFacetClassesElementType";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "chooseAndCreate";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getModuleProductionSourceRootUrls";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "createEmpty";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "chooseAndCreate";
                break;
            }
            case 3: 
            case 4: 
            case 6: {
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "createEmpty";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "canCreate";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: 
            case 4: 
            case 6: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

