/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.jpa.highlighting;

import com.intellij.codeInspection.LocalInspectionTool;
import com.intellij.jam.model.util.JamCommonUtil;
import com.intellij.jpa.JpaMessages;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.compiler.CompileContext;
import com.intellij.openapi.compiler.CompileScope;
import com.intellij.openapi.compiler.util.InspectionValidator;
import com.intellij.openapi.compiler.util.InspectionValidatorUtil;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.StdFileTypes;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtil;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.persistence.facet.PersistenceFacet;
import com.intellij.persistence.model.PersistenceMappings;
import com.intellij.persistence.model.PersistencePackage;
import com.intellij.persistence.util.PersistenceCommonUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.util.PairProcessor;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.descriptors.ConfigFile;
import com.intellij.util.xml.DomElement;
import com.intellij.util.xml.GenericValue;
import gnu.trove.THashSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public abstract class JpaValidatorBase
extends InspectionValidator {
    public JpaValidatorBase(String description) {
        super(description, JpaMessages.message((String)"progress.validating.persistence.model.text", (Object[])new Object[0]));
    }

    protected abstract boolean acceptsFacet(PersistenceFacet var1);

    public boolean isAvailableOnScope(@NotNull CompileScope scope) {
        if (scope == null) {
            JpaValidatorBase.$$$reportNull$$$0(0);
        }
        return !this.processScopeFacets(scope.getAffectedModules(), (PairProcessor<Module, PersistenceFacet>)((PairProcessor)(module, facet) -> false));
    }

    private boolean processScopeFacets(Module[] modules, PairProcessor<Module, PersistenceFacet> processor) {
        for (Module module : modules) {
            for (PersistenceFacet facet : PersistenceCommonUtil.getAllPersistenceFacetsWithDependencies((Module)module)) {
                if (!this.acceptsFacet(facet) || ((Boolean)ReadAction.compute(() -> facet.getPersistenceUnits().isEmpty())).booleanValue() || processor.process((Object)module, (Object)facet)) continue;
                return false;
            }
        }
        return true;
    }

    public Collection<VirtualFile> getFilesToProcess(Project project, CompileContext context) {
        VirtualFile[] javaFiles;
        THashSet enabledModules = new THashSet();
        THashSet enabledFacets = new THashSet();
        this.processScopeFacets(context.getCompileScope().getAffectedModules(), (PairProcessor<Module, PersistenceFacet>)((PairProcessor)(module, facet) -> {
            enabledFacets.add(facet);
            enabledModules.add(module);
            return true;
        }));
        ArrayList<VirtualFile> result = new ArrayList<VirtualFile>();
        for (VirtualFile javaFile : javaFiles = context.getCompileScope().getFiles((FileType)StdFileTypes.JAVA, true)) {
            Module module2 = context.getModuleByFile(javaFile);
            if (module2 == null || !enabledModules.contains((Object)module2)) continue;
            result.add(javaFile);
        }
        THashSet descriptorFiles = new THashSet();
        for (PersistenceFacet facet2 : enabledFacets) {
            for (ConfigFile configFile : facet2.getDescriptors()) {
                InspectionValidatorUtil.addDescriptor((Collection)descriptorFiles, (ConfigFile)configFile);
            }
            for (PersistencePackage unit : facet2.getPersistenceUnits()) {
                for (GenericValue value : unit.getModelHelper().getMappingFiles(PersistenceMappings.class)) {
                    PersistenceMappings mappings = (PersistenceMappings)value.getValue();
                    if (mappings == null) continue;
                    InspectionValidatorUtil.addFile((Collection)descriptorFiles, (PsiFile)mappings.getContainingFile());
                }
            }
        }
        result.addAll(InspectionValidatorUtil.expandCompileScopeIfNeeded((Collection)descriptorFiles, (CompileContext)context));
        return result;
    }

    @NotNull
    public Collection<PsiElement> getDependencies(PsiFile psiFile) {
        Module module;
        if (!JamCommonUtil.isPlainJavaFile((PsiElement)psiFile) || (module = ModuleUtil.findModuleForPsiElement((PsiElement)psiFile)) == null) {
            List<PsiElement> list = Collections.emptyList();
            if (list == null) {
                JpaValidatorBase.$$$reportNull$$$0(1);
            }
            return list;
        }
        Collection collection = (Collection)ReadAction.compute(() -> {
            ArrayList result = new ArrayList();
            for (PersistenceFacet facet : PersistenceCommonUtil.getAllPersistenceFacetsWithDependencies((Module)module)) {
                if (!this.acceptsFacet(facet)) continue;
                for (PersistencePackage unit : facet.getPersistenceUnits()) {
                    for (GenericValue value : unit.getModelHelper().getMappingFiles(PersistenceMappings.class)) {
                        PersistenceMappings mappings = (PersistenceMappings)value.getValue();
                        if (mappings == null || !(mappings instanceof DomElement)) continue;
                        ContainerUtil.addIfNotNull(result, (Object)mappings.getContainingFile());
                    }
                }
                for (ConfigFile configFile : facet.getDescriptors()) {
                    ContainerUtil.addIfNotNull(result, (Object)configFile.getPsiFile());
                }
            }
            return result;
        });
        if (collection == null) {
            JpaValidatorBase.$$$reportNull$$$0(2);
        }
        return collection;
    }

    @NotNull
    public Class<? extends LocalInspectionTool>[] getInspectionToolClasses(CompileContext context) {
        THashSet result = new THashSet();
        this.processScopeFacets(context.getCompileScope().getAffectedModules(), (PairProcessor<Module, PersistenceFacet>)((PairProcessor)(module, facet) -> {
            ContainerUtil.addAll((Collection)result, (Object[])facet.getInspectionToolClasses());
            return true;
        }));
        Iterator it = result.iterator();
        while (it.hasNext()) {
            String inspectionName = ((Class)it.next()).getSimpleName();
            if (!"JpaQueryApiInspection".equals(inspectionName) && !"CriteriaApiResolveInspection".equals(inspectionName)) continue;
            it.remove();
        }
        Class[] classArray = (Class[])result.toArray((Object[])new Class[result.size()]);
        if (classArray == null) {
            JpaValidatorBase.$$$reportNull$$$0(3);
        }
        return classArray;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "scope";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/jpa/highlighting/JpaValidatorBase";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/jpa/highlighting/JpaValidatorBase";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getDependencies";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getInspectionToolClasses";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "isAvailableOnScope";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

