/*
 * Decompiled with CFR 0.152.
 */
package org.coffeescript.compiler;

import com.intellij.lang.javascript.JavaScriptFileType;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.PlainTextFileType;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiFileFactory;
import java.io.IOException;
import org.coffeescript.CsBundle;
import org.coffeescript.compiler.CoffeeScriptCompiledForm;
import org.coffeescript.compiler.CoffeeScriptCompiler;
import org.coffeescript.file.CoffeeScriptFileType;
import org.coffeescript.file.CoffeeScriptLiterateFileType;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CompileCoffeeScriptAction
extends AnAction {
    private static final Logger LOG = Logger.getInstance((String)CompileCoffeeScriptAction.class.getName());

    @Nullable
    private static String getTextToCompile(DataContext dataContext) {
        Editor editor = (Editor)CommonDataKeys.EDITOR.getData(dataContext);
        if (editor != null) {
            if (editor.getSelectionModel().hasSelection()) {
                return editor.getSelectionModel().getSelectedText();
            }
            return editor.getDocument().getText();
        }
        PsiFile psiFile = (PsiFile)CommonDataKeys.PSI_FILE.getData(dataContext);
        if (psiFile != null) {
            return psiFile.getText();
        }
        return null;
    }

    public void actionPerformed(AnActionEvent actionEvent) {
        final String textToCompile = CompileCoffeeScriptAction.getTextToCompile(actionEvent.getDataContext());
        if (textToCompile != null) {
            PsiFile javaScriptFile;
            Project project = actionEvent.getProject();
            final Ref compileCodeRef = new Ref();
            final Ref canceled = new Ref((Object)false);
            Task.Modal task = new Task.Modal(project, CsBundle.message("compile.progressbar.message", new Object[0]), true){

                public void run(@NotNull ProgressIndicator indicator) {
                    if (indicator == null) {
                        1.$$$reportNull$$$0(0);
                    }
                    try {
                        String compiledCode = CoffeeScriptCompiler.compile(textToCompile);
                        compileCodeRef.set((Object)compiledCode);
                    }
                    catch (IOException e) {
                        LOG.error((Throwable)e);
                    }
                }

                public void onCancel() {
                    canceled.set((Object)true);
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indicator", "org/coffeescript/compiler/CompileCoffeeScriptAction$1", "run"));
                }
            };
            ProgressManager.getInstance().run((Task)task);
            if (((Boolean)canceled.get()).booleanValue()) {
                return;
            }
            String csFileName = "_Dummy_." + CoffeeScriptFileType.COFFEE_SCRIPT_FILE_TYPE.getDefaultExtension();
            PsiFile coffeeScriptFile = PsiFileFactory.getInstance((Project)project).createFileFromText((FileType)CoffeeScriptFileType.COFFEE_SCRIPT_FILE_TYPE, csFileName, (CharSequence)textToCompile, 0, textToCompile.length());
            String jsFileName = "_Dummy_." + JavaScriptFileType.INSTANCE.getDefaultExtension();
            if (compileCodeRef.isNull()) {
                javaScriptFile = PsiFileFactory.getInstance((Project)project).createFileFromText((FileType)PlainTextFileType.INSTANCE, jsFileName, (CharSequence)CsBundle.message("compile.error.message", new Object[0]), 0, CsBundle.message("compile.error.message", new Object[0]).length());
            } else {
                String compiledText = ((String)compileCodeRef.get()).replaceAll("\r", "");
                javaScriptFile = PsiFileFactory.getInstance((Project)project).createFileFromText((FileType)JavaScriptFileType.INSTANCE, jsFileName, (CharSequence)compiledText, 0, compiledText.length());
            }
            Editor editor = (Editor)CommonDataKeys.EDITOR.getData(actionEvent.getDataContext());
            CoffeeScriptCompiledForm compiledCodeForm = new CoffeeScriptCompiledForm(project, editor, coffeeScriptFile, javaScriptFile);
            compiledCodeForm.show();
        }
    }

    public void update(AnActionEvent e) {
        VirtualFile vFile;
        PsiFile psiFile = (PsiFile)CommonDataKeys.PSI_FILE.getData(e.getDataContext());
        FileType fileType = null;
        if (psiFile != null && (vFile = psiFile.getVirtualFile()) != null) {
            fileType = vFile.getFileType();
        }
        boolean visible = fileType == CoffeeScriptFileType.COFFEE_SCRIPT_FILE_TYPE || fileType == CoffeeScriptLiterateFileType.INSTANCE;
        e.getPresentation().setVisible(visible);
    }
}

