/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.grails.pluginSupport.webflow;

import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiVariable;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.grails.config.GrailsStructure;
import org.jetbrains.plugins.grails.util.GrailsUtils;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrField;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.blocks.GrClosableBlock;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrCall;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrMethodCall;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrReferenceExpression;
import org.jetbrains.plugins.groovy.lang.psi.impl.synthetic.GrLightVariable;
import org.jetbrains.plugins.groovy.lang.psi.util.PsiUtil;
import org.jetbrains.plugins.groovy.util.LightCacheKey;

public class WebFlowUtils {
    public static final String FLOW_SUFFIX = "Flow";
    public static final String WEBFLOW = "webflow";
    private static final LightCacheKey<Map<String, PsiVariable>> CACHED_STATES_KEY = LightCacheKey.create();

    private WebFlowUtils() {
    }

    public static boolean isWebFlowEnabled(@Nullable GrailsStructure structure) {
        if (structure == null) {
            return false;
        }
        if (structure.isAtLeastGrails("1.2")) {
            return structure.isPluginInstalled(WEBFLOW);
        }
        return true;
    }

    public static boolean isFlowActionField(GrField field) {
        String name = field.getName();
        if (name == null || !name.endsWith(FLOW_SUFFIX)) {
            return false;
        }
        if (GrailsUtils.getActionName((PsiElement)field) == null) {
            return false;
        }
        return WebFlowUtils.isWebFlowEnabled(GrailsStructure.getInstance((PsiElement)field));
    }

    @NotNull
    public static GrField getActionByStateDeclaration(GrMethodCall stateDeclaration) {
        PsiElement actionClosure = stateDeclaration.getParent();
        assert (actionClosure instanceof GrClosableBlock);
        GrField res = (GrField)actionClosure.getParent();
        assert (res.getName().endsWith(FLOW_SUFFIX));
        GrField grField = res;
        if (grField == null) {
            WebFlowUtils.$$$reportNull$$$0(0);
        }
        return grField;
    }

    @NotNull
    public static String getStateNameByStateDeclaration(@NotNull GrMethodCall stateDeclaration) {
        if (stateDeclaration == null) {
            WebFlowUtils.$$$reportNull$$$0(1);
        }
        String string = ((GrReferenceExpression)stateDeclaration.getInvokedExpression()).getReferenceName();
        if (string == null) {
            WebFlowUtils.$$$reportNull$$$0(2);
        }
        return string;
    }

    public static boolean isStateDeclaration(GrMethodCall methodCall, boolean checkParentField) {
        GrExpression[] allArguments;
        if (checkParentField) {
            PsiElement initClosure = methodCall.getParent();
            if (!(initClosure instanceof GrClosableBlock)) {
                return false;
            }
            PsiElement field = initClosure.getParent();
            if (!(field instanceof GrField)) {
                return false;
            }
            if (!WebFlowUtils.isFlowActionField((GrField)field)) {
                return false;
            }
        }
        if ((allArguments = PsiUtil.getAllArguments((GrCall)methodCall)).length > 1 || allArguments.length == 1 && !(allArguments[0] instanceof GrClosableBlock)) {
            return false;
        }
        GrExpression ie = methodCall.getInvokedExpression();
        if (!(ie instanceof GrReferenceExpression)) {
            return false;
        }
        return !((GrReferenceExpression)ie).isQualified();
    }

    @NotNull
    public static Map<String, PsiVariable> getWebFlowStates(@NotNull GrField field) {
        Map cachedValue;
        if (field == null) {
            WebFlowUtils.$$$reportNull$$$0(3);
        }
        if ((cachedValue = (Map)CACHED_STATES_KEY.getCachedValue((PsiElement)field)) == null) {
            GrExpression initializer = field.getInitializerGroovy();
            if (initializer instanceof GrClosableBlock) {
                cachedValue = new HashMap();
                for (PsiElement e = initializer.getFirstChild(); e != null; e = e.getNextSibling()) {
                    GrReferenceExpression ie;
                    String stateName;
                    GrMethodCall methodCall;
                    if (!(e instanceof GrMethodCall) || !WebFlowUtils.isStateDeclaration(methodCall = (GrMethodCall)e, false) || (stateName = (ie = (GrReferenceExpression)methodCall.getInvokedExpression()).getReferenceName()) == null) continue;
                    GrLightVariable var = new GrLightVariable(field.getManager(), stateName, (PsiType)PsiType.INT, (PsiElement)ie);
                    cachedValue.put(stateName, var);
                }
            } else {
                cachedValue = Collections.emptyMap();
            }
            cachedValue = (Map)CACHED_STATES_KEY.putCachedValue((PsiElement)field, cachedValue);
        }
        Map map2 = cachedValue;
        if (map2 == null) {
            WebFlowUtils.$$$reportNull$$$0(4);
        }
        return map2;
    }

    public static boolean isFlowInfoCapturerMethod(@Nullable PsiElement element) {
        PsiClass containingClass;
        if (element instanceof PsiMethod && (containingClass = ((PsiMethod)element).getContainingClass()) != null) {
            return "org.codehaus.groovy.grails.webflow.engine.builder.FlowInfoCapturer".equals(containingClass.getQualifiedName());
        }
        return false;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: 
            case 3: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: 
            case 3: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/plugins/grails/pluginSupport/webflow/WebFlowUtils";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "stateDeclaration";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "field";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getActionByStateDeclaration";
                break;
            }
            case 1: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/plugins/grails/pluginSupport/webflow/WebFlowUtils";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getStateNameByStateDeclaration";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getWebFlowStates";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "getStateNameByStateDeclaration";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "getWebFlowStates";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: 
            case 3: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

