/*
 * Decompiled with CFR 0.152.
 */
package cucumber.runtime.io;

import cucumber.runtime.io.Resource;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;

public class FileResource
implements Resource {
    private final File root;
    private final File file;

    public FileResource(File root, File file) {
        this.root = root;
        this.file = file;
        if (!file.getAbsolutePath().startsWith(root.getAbsolutePath())) {
            throw new IllegalArgumentException(file.getAbsolutePath() + " is not a parent of " + root.getAbsolutePath());
        }
    }

    @Override
    public String getPath() {
        if (this.file.equals(this.root)) {
            return this.file.getPath();
        }
        return this.file.getAbsolutePath().substring(this.root.getAbsolutePath().length() + 1);
    }

    @Override
    public String getAbsolutePath() {
        return this.file.getAbsolutePath();
    }

    @Override
    public InputStream getInputStream() throws IOException {
        return new FileInputStream(this.file);
    }

    @Override
    public String getClassName(String extension) {
        String path = this.getPath();
        return path.substring(0, path.length() - extension.length()).replace(File.separatorChar, '.');
    }

    public File getFile() {
        return this.file;
    }
}

