/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.struts.highlighting;

import com.intellij.codeHighlighting.HighlightDisplayLevel;
import com.intellij.javaee.facet.JavaeeFacetUtil;
import com.intellij.javaee.web.WebUtil;
import com.intellij.javaee.web.facet.WebFacet;
import com.intellij.openapi.compiler.CompileContext;
import com.intellij.openapi.compiler.CompileScope;
import com.intellij.openapi.compiler.CompilerMessageCategory;
import com.intellij.openapi.compiler.util.InspectionValidator;
import com.intellij.openapi.compiler.util.InspectionValidatorUtil;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.xml.XmlFile;
import com.intellij.struts.facet.StrutsFacet;
import com.intellij.struts.facet.StrutsFacetConfiguration;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.xml.model.impl.DomModelFactory;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;

public abstract class StrutsValidatorBase
extends InspectionValidator {
    protected StrutsValidatorBase(@NotNull String description, @NotNull String progressIndicatorText) {
        if (description == null) {
            StrutsValidatorBase.$$$reportNull$$$0(0);
        }
        if (progressIndicatorText == null) {
            StrutsValidatorBase.$$$reportNull$$$0(1);
        }
        super(description, progressIndicatorText);
    }

    protected abstract DomModelFactory getFactory(Project var1);

    @NotNull
    protected Set<XmlFile> getConfigFiles(@NotNull Module module) {
        if (module == null) {
            StrutsValidatorBase.$$$reportNull$$$0(2);
        }
        Set set = this.getFactory(module.getProject()).getAllConfigFiles((UserDataHolder)module);
        if (set == null) {
            StrutsValidatorBase.$$$reportNull$$$0(3);
        }
        return set;
    }

    public boolean isAvailableOnScope(@NotNull CompileScope scope) {
        if (scope == null) {
            StrutsValidatorBase.$$$reportNull$$$0(4);
        }
        Module[] modules = scope.getAffectedModules();
        return !JavaeeFacetUtil.getInstance().getJavaeeFacets(WebFacet.ID, modules).isEmpty();
    }

    protected abstract boolean isAvailableOnFacet(StrutsFacet var1);

    public Collection<VirtualFile> getFilesToProcess(Project project, CompileContext context) {
        ArrayList<VirtualFile> list = new ArrayList<VirtualFile>();
        for (Module module : ModuleManager.getInstance((Project)project).getModules()) {
            Collection webFacets = WebFacet.getInstances((Module)module);
            boolean containsStruts = false;
            for (WebFacet webFacet : webFacets) {
                StrutsFacet strutsFacet = StrutsFacet.getInstance(webFacet);
                if (strutsFacet == null || !this.isAvailableOnFacet(strutsFacet)) continue;
                containsStruts = true;
            }
            if (!containsStruts) continue;
            Set<XmlFile> psiFiles = this.getConfigFiles(module);
            for (PsiFile psiFile : psiFiles) {
                ContainerUtil.addIfNotNull(list, (Object)psiFile.getVirtualFile());
            }
        }
        InspectionValidatorUtil.expandCompileScopeIfNeeded(list, (CompileContext)context);
        return list;
    }

    @NotNull
    public Collection<? extends PsiElement> getDependencies(PsiFile psiFile) {
        Module module = ModuleUtilCore.findModuleForPsiElement((PsiElement)psiFile);
        if (module == null) {
            List list = Collections.emptyList();
            if (list == null) {
                StrutsValidatorBase.$$$reportNull$$$0(5);
            }
            return list;
        }
        Set<XmlFile> psiFiles = this.getConfigFiles(module);
        psiFiles.remove(psiFile);
        Set<XmlFile> set = psiFiles;
        if (set == null) {
            StrutsValidatorBase.$$$reportNull$$$0(6);
        }
        return set;
    }

    public CompilerMessageCategory getCategoryByHighlightDisplayLevel(@NotNull HighlightDisplayLevel severity, @NotNull VirtualFile virtualFile, @NotNull CompileContext context) {
        StrutsFacet facet;
        WebFacet webFacet;
        Module module;
        CompilerMessageCategory level;
        if (severity == null) {
            StrutsValidatorBase.$$$reportNull$$$0(7);
        }
        if (virtualFile == null) {
            StrutsValidatorBase.$$$reportNull$$$0(8);
        }
        if (context == null) {
            StrutsValidatorBase.$$$reportNull$$$0(9);
        }
        if ((level = super.getCategoryByHighlightDisplayLevel(severity, virtualFile, context)) == CompilerMessageCategory.ERROR && (module = context.getModuleByFile(virtualFile)) != null && (webFacet = WebUtil.getWebFacet((VirtualFile)virtualFile, (Project)module.getProject())) != null && (facet = StrutsFacet.getInstance(webFacet)) != null && ((StrutsFacetConfiguration)facet.getConfiguration()).getValidationConfiguration().myReportErrorsAsWarnings) {
            return CompilerMessageCategory.WARNING;
        }
        return level;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: 
            case 5: 
            case 6: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: 
            case 5: 
            case 6: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "description";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "progressIndicatorText";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "module";
                break;
            }
            case 3: 
            case 5: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/struts/highlighting/StrutsValidatorBase";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "scope";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "severity";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "virtualFile";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/struts/highlighting/StrutsValidatorBase";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getConfigFiles";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getDependencies";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "getConfigFiles";
                break;
            }
            case 3: 
            case 5: 
            case 6: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "isAvailableOnScope";
                break;
            }
            case 7: 
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "getCategoryByHighlightDisplayLevel";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: 
            case 5: 
            case 6: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

