/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javaee.oss.glassfish.server;

import com.intellij.javaee.oss.glassfish.server.GlassfishDomainConfig;
import com.intellij.javaee.oss.util.ConfigBase;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.JDOMUtil;
import java.io.File;
import java.io.IOException;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.JDOMException;

public abstract class GlassfishDomainConfigProcessor
extends ConfigBase {
    private static final Logger LOG = Logger.getInstance(GlassfishDomainConfigProcessor.class);
    private final File myFile;

    public GlassfishDomainConfigProcessor(GlassfishDomainConfig domainConfig) {
        this.myFile = domainConfig.getFile();
    }

    public void processConfig() {
        if (!this.myFile.exists()) {
            return;
        }
        try {
            Document doc = JDOMUtil.loadDocument((File)this.myFile);
            Element root = doc.getRootElement();
            Element serverConfig = GlassfishDomainConfigProcessor.getChild((Element)root.getChild("configs"), (String)"config", (String)"name", (String)"server-config");
            if (serverConfig == null) {
                return;
            }
            this.doProcessConfig(this.myFile, doc, serverConfig);
        }
        catch (JDOMException e) {
            LOG.error((Throwable)e);
        }
        catch (IOException e) {
            LOG.error((Throwable)e);
        }
    }

    protected abstract void doProcessConfig(File var1, Document var2, Element var3) throws IOException, JDOMException;
}

