/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.css.actions.smartenter.fixers;

import com.intellij.openapi.editor.Editor;
import com.intellij.psi.PsiElement;
import com.intellij.psi.css.CssDeclaration;
import com.intellij.psi.css.CssOneLineStatement;
import com.intellij.psi.css.actions.smartenter.fixers.CssFixer;
import com.intellij.psi.css.impl.util.CssUtil;
import com.intellij.psi.util.PsiTreeUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CssMissingSemicolonFixer
implements CssFixer {
    @Override
    public boolean isApplicable(@NotNull PsiElement psiElement) {
        if (psiElement == null) {
            CssMissingSemicolonFixer.$$$reportNull$$$0(0);
        }
        return CssMissingSemicolonFixer.getClosestOneLineStatement(psiElement) != null;
    }

    @Nullable
    private static PsiElement getClosestOneLineStatement(@Nullable PsiElement psiElement) {
        CssOneLineStatement element = CssUtil.findOneLineStatement(psiElement);
        if (element == null) {
            element = PsiTreeUtil.getChildOfType((PsiElement)psiElement, CssOneLineStatement.class);
        }
        return element;
    }

    @Override
    public boolean apply(@NotNull Editor editor, @NotNull PsiElement psiElement) {
        CssOneLineStatement editedElement;
        if (editor == null) {
            CssMissingSemicolonFixer.$$$reportNull$$$0(1);
        }
        if (psiElement == null) {
            CssMissingSemicolonFixer.$$$reportNull$$$0(2);
        }
        if ((editedElement = CssUtil.appendStatementWithSemicolonIfNeeded(psiElement.getProject(), psiElement)) != null) {
            if (editedElement instanceof CssDeclaration) {
                editor.getCaretModel().moveToOffset(editedElement.getTextRange().getEndOffset() + 1);
            } else {
                editor.getCaretModel().moveToOffset(editedElement.getTextRange().getEndOffset());
            }
        }
        return editedElement != null;
    }

    @Override
    @Nullable
    public PsiElement getElementToReformat(@Nullable PsiElement currentElement) {
        return CssUtil.findOneLineStatement(currentElement);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiElement";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
        }
        objectArray2[1] = "com/intellij/psi/css/actions/smartenter/fixers/CssMissingSemicolonFixer";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "isApplicable";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "apply";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

