/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.css.impl.structure;

import com.google.common.collect.Lists;
import com.intellij.icons.AllIcons;
import com.intellij.ide.IdeBundle;
import com.intellij.ide.structureView.StructureViewTreeElement;
import com.intellij.ide.structureView.impl.common.PsiTreeElementBase;
import com.intellij.navigation.ItemPresentation;
import com.intellij.navigation.NavigationItem;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.css.CssAtRule;
import com.intellij.psi.css.CssBlock;
import com.intellij.psi.css.CssCustomMixin;
import com.intellij.psi.css.CssDeclaration;
import com.intellij.psi.css.CssElementVisitor;
import com.intellij.psi.css.CssImport;
import com.intellij.psi.css.CssImportList;
import com.intellij.psi.css.CssNamedElement;
import com.intellij.psi.css.CssNamespace;
import com.intellij.psi.css.CssNamespaceList;
import com.intellij.psi.css.CssRuleset;
import com.intellij.psi.css.CssRulesetList;
import com.intellij.psi.css.CssSelector;
import com.intellij.psi.css.CssSelectorSuffix;
import com.intellij.psi.css.CssSelectorSuffixType;
import com.intellij.psi.css.CssSimpleSelector;
import com.intellij.psi.css.CssStylesheet;
import com.intellij.psi.css.impl.structure.CssCustomPropertyStructureViewElement;
import com.intellij.psi.css.impl.structure.CssImportStructureViewElement;
import com.intellij.psi.css.impl.structure.CssStructureViewElementsProvider;
import com.intellij.psi.util.PsiTreeUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CssStructureViewElement
extends PsiTreeElementBase<PsiElement> {
    @NotNull
    private final String myPresentableText;
    @NotNull
    protected final PsiElement myOriginalElement;
    @Nullable
    private final Icon myIcon;

    @NotNull
    public static CssStructureViewElement create(@NotNull PsiElement element) {
        if (element == null) {
            CssStructureViewElement.$$$reportNull$$$0(0);
        }
        CssStructureViewElement cssStructureViewElement = CssStructureViewElement.create(element, null, null);
        if (cssStructureViewElement == null) {
            CssStructureViewElement.$$$reportNull$$$0(1);
        }
        return cssStructureViewElement;
    }

    @NotNull
    public static CssStructureViewElement create(@NotNull PsiElement element, @Nullable Icon icon, @Nullable String defaultPresentableText) {
        if (element == null) {
            CssStructureViewElement.$$$reportNull$$$0(2);
        }
        CssStructureViewElement cssStructureViewElement = CssStructureViewElement.create(element, element, icon, defaultPresentableText);
        if (cssStructureViewElement == null) {
            CssStructureViewElement.$$$reportNull$$$0(3);
        }
        return cssStructureViewElement;
    }

    @NotNull
    public static CssStructureViewElement create(@NotNull PsiElement element, @NotNull PsiElement originalElement, @Nullable Icon icon, @Nullable String defaultPresentableText) {
        CssSelectorSuffix singleSuffix;
        if (element == null) {
            CssStructureViewElement.$$$reportNull$$$0(4);
        }
        if (originalElement == null) {
            CssStructureViewElement.$$$reportNull$$$0(5);
        }
        if (element instanceof CssRuleset && (singleSuffix = CssStructureViewElement.retrieveSingleSelectorPrefixFromRuleset((CssRuleset)element)) != null) {
            element = singleSuffix;
            Icon elementIcon = element.getIcon(0);
            icon = elementIcon != null ? elementIcon : icon;
        }
        CssStructureViewElement cssStructureViewElement = new CssStructureViewElement(element, originalElement, icon, defaultPresentableText != null ? defaultPresentableText : IdeBundle.message((String)"node.structureview.invalid", (Object[])new Object[0]));
        if (cssStructureViewElement == null) {
            CssStructureViewElement.$$$reportNull$$$0(6);
        }
        return cssStructureViewElement;
    }

    protected CssStructureViewElement(@NotNull PsiElement element, @NotNull PsiElement originalElement, @Nullable Icon icon, @NotNull String defaultPresentableText) {
        if (element == null) {
            CssStructureViewElement.$$$reportNull$$$0(7);
        }
        if (originalElement == null) {
            CssStructureViewElement.$$$reportNull$$$0(8);
        }
        if (defaultPresentableText == null) {
            CssStructureViewElement.$$$reportNull$$$0(9);
        }
        super(element);
        this.myOriginalElement = originalElement;
        this.myIcon = icon;
        this.myPresentableText = defaultPresentableText;
    }

    @NotNull
    public PsiElement getOriginalElement() {
        PsiElement psiElement = this.myOriginalElement;
        if (psiElement == null) {
            CssStructureViewElement.$$$reportNull$$$0(10);
        }
        return psiElement;
    }

    @NotNull
    public Collection<StructureViewTreeElement> getChildrenBase() {
        PsiElement element = CssStructureViewElement.getNodeElement(this.getElement());
        if (element != null) {
            final ArrayList appropriateProviders = Lists.newArrayList();
            for (CssStructureViewElementsProvider provider : (CssStructureViewElementsProvider[])CssStructureViewElementsProvider.EXTENSION_POINT_NAME.getExtensions()) {
                if (!provider.isMyContext(element)) continue;
                appropriateProviders.add(provider);
            }
            final ArrayList children = Lists.newArrayList();
            element.acceptChildren((PsiElementVisitor)new CssElementVisitor(){

                public void visitCssStylesheet(CssStylesheet stylesheet) {
                    stylesheet.acceptChildren((PsiElementVisitor)this);
                }

                public void visitCssBlock(CssBlock block) {
                    block.acceptChildren((PsiElementVisitor)this);
                }

                public void visitCssRulesetList(CssRulesetList rulesetList) {
                    rulesetList.acceptChildren((PsiElementVisitor)this);
                }

                public void visitNamespaceList(CssNamespaceList namespaceList) {
                    namespaceList.acceptChildren((PsiElementVisitor)this);
                }

                public void visitNamespace(CssNamespace namespace) {
                    this.visitAtRule((CssAtRule)namespace);
                }

                public void visitCssImportList(CssImportList importList) {
                    importList.acceptChildren((PsiElementVisitor)this);
                }

                public void visitCssImport(CssImport _import) {
                    for (PsiElement uriElement : _import.getUriElements()) {
                        String uriString = StringUtil.unquoteString((String)uriElement.getText());
                        if (StringUtil.isEmptyOrSpaces((String)uriString)) continue;
                        children.add(CssImportStructureViewElement.create(uriString, uriElement));
                    }
                }

                public void visitAtRule(CssAtRule atRule) {
                    children.add(CssStructureViewElement.create((PsiElement)atRule, AllIcons.Css.Atrule, "at rule"));
                }

                public void visitCssRuleset(CssRuleset ruleset) {
                    String presentableText = ruleset.getPresentableText();
                    if (!presentableText.isEmpty()) {
                        children.add(CssStructureViewElement.create((PsiElement)ruleset, AllIcons.Xml.Css_class, presentableText));
                    }
                }

                public void visitCssDeclaration(CssDeclaration declaration) {
                    if (declaration.isCustomProperty()) {
                        children.add(new CssCustomPropertyStructureViewElement((CssNamedElement)declaration));
                    }
                }

                public void visitCustomMixin(@NotNull CssCustomMixin customMixin) {
                    if (customMixin == null) {
                        1.$$$reportNull$$$0(0);
                    }
                    children.add(new CssCustomPropertyStructureViewElement((CssNamedElement)customMixin));
                }

                public void visitElement(PsiElement element) {
                    for (CssStructureViewElementsProvider provider : appropriateProviders) {
                        children.addAll(provider.createStructureViewElements(element));
                        if (!provider.hasInnerStructure(element)) continue;
                        element.acceptChildren((PsiElementVisitor)this);
                    }
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "customMixin", "com/intellij/psi/css/impl/structure/CssStructureViewElement$1", "visitCustomMixin"));
                }
            });
            ArrayList arrayList = children;
            if (arrayList == null) {
                CssStructureViewElement.$$$reportNull$$$0(11);
            }
            return arrayList;
        }
        List<StructureViewTreeElement> list = Collections.emptyList();
        if (list == null) {
            CssStructureViewElement.$$$reportNull$$$0(12);
        }
        return list;
    }

    @Nullable
    public static CssSelectorSuffix retrieveSingleSelectorPrefixFromRuleset(CssRuleset ruleset) {
        CssSelectorSuffix suffix;
        CssSelectorSuffix[] suffixes;
        CssSimpleSelector simpleSelector;
        CssSimpleSelector[] elements;
        CssSelector[] selectors = ruleset.getSelectors();
        if (selectors.length == 1 && (elements = selectors[0].getSimpleSelectors()).length == 1 && (simpleSelector = elements[0]) != null && StringUtil.isEmpty((String)simpleSelector.getElementName()) && (suffixes = simpleSelector.getSelectorSuffixes()).length == 1 && (suffix = suffixes[0]).getType() != CssSelectorSuffixType.UNKNOWN) {
            return suffix;
        }
        return null;
    }

    public Icon getIcon(boolean open) {
        ItemPresentation presentation;
        PsiElement element = this.getElement();
        if (element != null && element instanceof NavigationItem && (presentation = ((NavigationItem)element).getPresentation()) != null) {
            return presentation.getIcon(false);
        }
        return this.myIcon;
    }

    @Nullable
    public static PsiElement getNodeElement(@Nullable PsiElement element) {
        if (element instanceof CssSelectorSuffix) {
            return PsiTreeUtil.getParentOfType((PsiElement)element, CssRuleset.class);
        }
        CssStylesheet stylesheet = (CssStylesheet)PsiTreeUtil.findChildOfType((PsiElement)element, CssStylesheet.class, (boolean)false);
        return stylesheet != null ? stylesheet : element;
    }

    public String getPresentableText() {
        ItemPresentation presentation;
        PsiElement element = this.getElement();
        if (element != null && element instanceof NavigationItem && (presentation = ((NavigationItem)element).getPresentation()) != null) {
            return presentation.getPresentableText();
        }
        return this.myPresentableText;
    }

    public boolean isAlwaysLeaf() {
        return false;
    }

    public int getMemberKindWeight() {
        return 100;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 3: 
            case 6: 
            case 10: 
            case 11: 
            case 12: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 3: 
            case 6: 
            case 10: 
            case 11: 
            case 12: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 1: 
            case 3: 
            case 6: 
            case 10: 
            case 11: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/psi/css/impl/structure/CssStructureViewElement";
                break;
            }
            case 5: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "originalElement";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "defaultPresentableText";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/psi/css/impl/structure/CssStructureViewElement";
                break;
            }
            case 1: 
            case 3: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "create";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "getOriginalElement";
                break;
            }
            case 11: 
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "getChildrenBase";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "create";
                break;
            }
            case 1: 
            case 3: 
            case 6: 
            case 10: 
            case 11: 
            case 12: {
                break;
            }
            case 7: 
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 3: 
            case 6: 
            case 10: 
            case 11: 
            case 12: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

