/*
 * Decompiled with CFR 0.152.
 */
package git4idea.util;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.vcs.changes.Change;
import git4idea.GitCommit;
import git4idea.repo.GitRepository;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;

public class GitCommitCompareInfo {
    private static final Logger LOG = Logger.getInstance(GitCommitCompareInfo.class);
    private final Map<GitRepository, Pair<List<GitCommit>, List<GitCommit>>> myInfo;
    private final Map<GitRepository, Collection<Change>> myTotalDiff;
    private final InfoType myInfoType;

    public GitCommitCompareInfo() {
        this(InfoType.BOTH);
    }

    public GitCommitCompareInfo(@NotNull InfoType infoType) {
        if (infoType == null) {
            GitCommitCompareInfo.$$$reportNull$$$0(0);
        }
        this.myInfo = new HashMap<GitRepository, Pair<List<GitCommit>, List<GitCommit>>>();
        this.myTotalDiff = new HashMap<GitRepository, Collection<Change>>();
        this.myInfoType = infoType;
    }

    public void put(@NotNull GitRepository repository, @NotNull Pair<List<GitCommit>, List<GitCommit>> commits2) {
        if (repository == null) {
            GitCommitCompareInfo.$$$reportNull$$$0(1);
        }
        if (commits2 == null) {
            GitCommitCompareInfo.$$$reportNull$$$0(2);
        }
        this.myInfo.put(repository, commits2);
    }

    public void put(@NotNull GitRepository repository, @NotNull Collection<Change> totalDiff) {
        if (repository == null) {
            GitCommitCompareInfo.$$$reportNull$$$0(3);
        }
        if (totalDiff == null) {
            GitCommitCompareInfo.$$$reportNull$$$0(4);
        }
        this.myTotalDiff.put(repository, totalDiff);
    }

    @NotNull
    public List<GitCommit> getHeadToBranchCommits(@NotNull GitRepository repo) {
        if (repo == null) {
            GitCommitCompareInfo.$$$reportNull$$$0(5);
        }
        List list = (List)this.getCompareInfo(repo).getFirst();
        if (list == null) {
            GitCommitCompareInfo.$$$reportNull$$$0(6);
        }
        return list;
    }

    @NotNull
    public List<GitCommit> getBranchToHeadCommits(@NotNull GitRepository repo) {
        if (repo == null) {
            GitCommitCompareInfo.$$$reportNull$$$0(7);
        }
        List list = (List)this.getCompareInfo(repo).getSecond();
        if (list == null) {
            GitCommitCompareInfo.$$$reportNull$$$0(8);
        }
        return list;
    }

    @NotNull
    private Pair<List<GitCommit>, List<GitCommit>> getCompareInfo(@NotNull GitRepository repo) {
        Pair<List<GitCommit>, List<GitCommit>> pair;
        if (repo == null) {
            GitCommitCompareInfo.$$$reportNull$$$0(9);
        }
        if ((pair = this.myInfo.get(repo)) == null) {
            LOG.error("Compare info not found for repository " + repo);
            Pair pair2 = Pair.create(Collections.emptyList(), Collections.emptyList());
            if (pair2 == null) {
                GitCommitCompareInfo.$$$reportNull$$$0(10);
            }
            return pair2;
        }
        Pair<List<GitCommit>, List<GitCommit>> pair3 = pair;
        if (pair3 == null) {
            GitCommitCompareInfo.$$$reportNull$$$0(11);
        }
        return pair3;
    }

    @NotNull
    public Collection<GitRepository> getRepositories() {
        Set<GitRepository> set = this.myInfo.keySet();
        if (set == null) {
            GitCommitCompareInfo.$$$reportNull$$$0(12);
        }
        return set;
    }

    public boolean isEmpty() {
        return this.myInfo.isEmpty();
    }

    public InfoType getInfoType() {
        return this.myInfoType;
    }

    @NotNull
    public List<Change> getTotalDiff() {
        ArrayList<Change> changes = new ArrayList<Change>();
        for (Collection<Change> changeCollection : this.myTotalDiff.values()) {
            changes.addAll(changeCollection);
        }
        ArrayList<Change> arrayList = changes;
        if (arrayList == null) {
            GitCommitCompareInfo.$$$reportNull$$$0(13);
        }
        return arrayList;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 6: 
            case 8: 
            case 10: 
            case 11: 
            case 12: 
            case 13: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 6: 
            case 8: 
            case 10: 
            case 11: 
            case 12: 
            case 13: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "infoType";
                break;
            }
            case 1: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "repository";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "commits";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "totalDiff";
                break;
            }
            case 5: 
            case 7: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "repo";
                break;
            }
            case 6: 
            case 8: 
            case 10: 
            case 11: 
            case 12: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "git4idea/util/GitCommitCompareInfo";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "git4idea/util/GitCommitCompareInfo";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getHeadToBranchCommits";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getBranchToHeadCommits";
                break;
            }
            case 10: 
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "getCompareInfo";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "getRepositories";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "getTotalDiff";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "put";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "getHeadToBranchCommits";
                break;
            }
            case 6: 
            case 8: 
            case 10: 
            case 11: 
            case 12: 
            case 13: {
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "getBranchToHeadCommits";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "getCompareInfo";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 6: 
            case 8: 
            case 10: 
            case 11: 
            case 12: 
            case 13: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static enum InfoType {
        BOTH,
        HEAD_TO_BRANCH,
        BRANCH_TO_HEAD;

    }
}

