/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.idea.lang.javascript.intention.bool;

import com.intellij.lang.javascript.JSTokenTypes;
import com.intellij.lang.javascript.psi.JSBinaryExpression;
import com.intellij.lang.javascript.psi.JSElement;
import com.intellij.lang.javascript.psi.JSExpression;
import com.intellij.lang.javascript.psi.impl.JSElementPredicate;
import com.intellij.psi.PsiElement;
import com.intellij.psi.tree.IElementType;
import com.intellij.util.IncorrectOperationException;
import org.intellij.idea.lang.javascript.intention.JSMutablyNamedIntention;
import org.intellij.idea.lang.javascript.intention.bool.ConjunctionPredicate;
import org.intellij.idea.lang.javascript.psiutil.BoolUtils;
import org.intellij.idea.lang.javascript.psiutil.JSElementFactory;
import org.jetbrains.annotations.NotNull;

public class JSDeMorgansLawIntention
extends JSMutablyNamedIntention {
    private static final String AND_OPERATOR = "&&";
    private static final String OR_OPERATOR = "||";
    private static final String AND_SUFFIX = "ANDAND";
    private static final String OR_SUFFIX = "OROR";

    @Override
    protected String getTextForElement(PsiElement element) {
        IElementType tokenType = ((JSBinaryExpression)element).getOperationSign();
        return this.getSuffixedDisplayName(tokenType.equals(JSTokenTypes.ANDAND) ? AND_SUFFIX : OR_SUFFIX, new Object[0]);
    }

    @Override
    @NotNull
    public JSElementPredicate getElementPredicate() {
        ConjunctionPredicate conjunctionPredicate = new ConjunctionPredicate();
        if (conjunctionPredicate == null) {
            JSDeMorgansLawIntention.$$$reportNull$$$0(0);
        }
        return conjunctionPredicate;
    }

    @Override
    public void processIntention(@NotNull PsiElement element) throws IncorrectOperationException {
        if (element == null) {
            JSDeMorgansLawIntention.$$$reportNull$$$0(1);
        }
        JSBinaryExpression exp = (JSBinaryExpression)element;
        IElementType tokenType = exp.getOperationSign();
        JSElement parent = (JSElement)exp.getParent();
        while (JSDeMorgansLawIntention.isConjunctionExpression(parent, tokenType)) {
            exp = (JSBinaryExpression)parent;
            parent = (JSElement)exp.getParent();
        }
        String newExpression = this.convertConjunctionExpression(exp, tokenType);
        JSElementFactory.replaceExpressionWithNegatedExpressionString((JSExpression)exp, newExpression);
    }

    private String convertConjunctionExpression(JSBinaryExpression exp, IElementType tokenType) {
        IElementType flippedOperator = tokenType.equals(JSTokenTypes.ANDAND) ? JSTokenTypes.OROR : JSTokenTypes.ANDAND;
        int precedence = flippedOperator.equals(JSTokenTypes.ANDAND) ? 13 : 14;
        String leftText = this.getOperandText(exp.getLOperand(), tokenType, precedence);
        String rightText = this.getOperandText(exp.getROperand(), tokenType, precedence);
        String flippedConjunction = flippedOperator.equals(JSTokenTypes.ANDAND) ? AND_OPERATOR : OR_OPERATOR;
        return leftText + flippedConjunction + rightText;
    }

    private String getOperandText(JSExpression operand, IElementType tokenType, int precedence) {
        return JSDeMorgansLawIntention.isConjunctionExpression((JSElement)operand, tokenType) ? this.convertConjunctionExpression((JSBinaryExpression)operand, tokenType) : BoolUtils.getNegatedExpressionText(operand, precedence);
    }

    private static boolean isConjunctionExpression(JSElement exp, IElementType conjunctionType) {
        if (!(exp instanceof JSBinaryExpression)) {
            return false;
        }
        JSBinaryExpression binaryExpression = (JSBinaryExpression)exp;
        IElementType tokenType = binaryExpression.getOperationSign();
        return tokenType.equals(conjunctionType);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/intellij/idea/lang/javascript/intention/bool/JSDeMorgansLawIntention";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getElementPredicate";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "org/intellij/idea/lang/javascript/intention/bool/JSDeMorgansLawIntention";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "processIntention";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

