/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.javaFX.css.refs;

import com.intellij.openapi.application.QueryExecutorBase;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiReference;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.search.searches.ReferencesSearch;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.psi.xml.XmlAttributeValue;
import com.intellij.util.Processor;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.javaFX.css.refs.JavaFxCssIdSelectorReference;
import org.jetbrains.plugins.javaFX.fxml.JavaFxPsiUtil;
import org.jetbrains.plugins.javaFX.indexing.JavaFxControllerClassIndex;

public class JavaFxIdCssReferenceSearcher
extends QueryExecutorBase<PsiReference, ReferencesSearch.SearchParameters> {
    public void processQuery(@NotNull ReferencesSearch.SearchParameters queryParameters, @NotNull Processor<PsiReference> consumer) {
        block4: {
            String containingClassQN;
            PsiElement elementToSearch;
            if (queryParameters == null) {
                JavaFxIdCssReferenceSearcher.$$$reportNull$$$0(0);
            }
            if (consumer == null) {
                JavaFxIdCssReferenceSearcher.$$$reportNull$$$0(1);
            }
            if (!((elementToSearch = queryParameters.getElementToSearch()) instanceof PsiField)) break block4;
            PsiField field = (PsiField)elementToSearch;
            String fieldName = (String)ReadAction.compute(() -> ((PsiField)field).getName());
            if (fieldName != null && (containingClassQN = (String)ReadAction.compute(() -> {
                PsiClass aClass = field.getContainingClass();
                return aClass != null ? aClass.getQualifiedName() : null;
            })) != null) {
                PsiFile fxml;
                boolean goOn;
                Project project = PsiUtilCore.getProjectInReadAction((PsiElement)field);
                List<PsiFile> fxmls = JavaFxControllerClassIndex.findFxmlWithController(project, containingClassQN);
                Iterator<PsiFile> iterator = fxmls.iterator();
                while (iterator.hasNext() && (goOn = ((Boolean)ReadAction.compute(() -> JavaFxIdCssReferenceSearcher.lambda$processQuery$1(queryParameters, fxml = iterator.next(), fieldName, consumer))).booleanValue())) {
                }
            }
        }
    }

    private static /* synthetic */ Boolean lambda$processQuery$1(@NotNull ReferencesSearch.SearchParameters queryParameters, PsiFile fxml, String fieldName, @NotNull Processor consumer) throws RuntimeException {
        PsiReference[] references;
        SearchScope searchScope;
        if (queryParameters == null) {
            JavaFxIdCssReferenceSearcher.$$$reportNull$$$0(2);
        }
        if (consumer == null) {
            JavaFxIdCssReferenceSearcher.$$$reportNull$$$0(3);
        }
        if (!(searchScope = queryParameters.getEffectiveSearchScope()).contains(fxml.getVirtualFile())) {
            return true;
        }
        Map<String, XmlAttributeValue> fxIds = JavaFxPsiUtil.collectFileIds(fxml, true);
        XmlAttributeValue fxIdValue = fxIds.get(fieldName);
        if (fxIdValue == null) {
            return true;
        }
        for (PsiReference reference : references = fxIdValue.getReferences()) {
            if (!(reference instanceof JavaFxCssIdSelectorReference)) continue;
            if (consumer.process((Object)reference)) break;
            return false;
        }
        return true;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "queryParameters";
                break;
            }
            case 1: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "consumer";
                break;
            }
        }
        objectArray2[1] = "org/jetbrains/plugins/javaFX/css/refs/JavaFxIdCssReferenceSearcher";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "processQuery";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "lambda$processQuery$1";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

